<?
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

//실행되는 동안 종료 되지 않도록 사용메모리와 실행가능 시간을 늘려준다.
@set_time_limit (0);
@ini_set ("memory_limit", "20M");

//모든 에러를 출력하도록 설정한다.
//error_reporting(E_ALL);

//기본 함수 모음을 인클루드
include_once($board_skin_path . "/Yfunction.php");

//처리시간 측정시작
$Ystarttime = Yget_microtime();

//썸네일 이미지 사이즈 결정하여 썸네일 생성
//$src_file_size, $dest_file_size 이미지 정보를 담은 배열 0은 너비 1은 높이
function Ysumnail_rule($src_file, $dest_file, $src_file_size, $dest_file_size, $image_quality=90, $lib='gd'){

  //생성도중 에러가 날수 있는 것들을 체크 하여 return false
  if (!is_array($src_file_size) || !is_array($dest_file_size) || empty($src_file_size[0]) || empty($src_file_size[1]) || empty($dest_file_size[0]) || empty($dest_file_size[0])) {

    return false;
  }

  //$lib 확인후 조건에 맞지 않으면 기본값 세팅
  if (empty($lib) || ($lib != 'gd' && $lib != 'netpbm')) $lib = 'gd';

  $rate = $src_file_size[1] / $src_file_size[0];
  $temp[1] = (int)($dest_file_size[0] * $rate);

  if ($dest_file_size[1] < $temp[1]) {

    $rate = $src_file_size[0] / $src_file_size[1];
    $dest_file_size[0] = (int)($dest_file_size[1] * $rate);
  }
  else{

    $dest_file_size[1] = $temp[1];
  }

  //썸네일의 너비나 높이가 10 미만인것은 만들지 않는다.
  if ($dest_file_size[0] < 10 || $dest_file_size[1] < 10) {

    return false;
  }

  //썸네일 이미지가 원본이미지 크기보다 크게 설정되었을 경우, 원본이미지와 동일하게
  if ($dest_file_size[0] > $src_file_size[0]) {

    $dest_file_size = $src_file_size;
  }

  if ($lib == 'netpbm') return Ymake_sumnail_netpbm($src_file, $dest_file, $src_file_size, $dest_file_size, $image_quality);
  else return Ymake_sumnail_gd($src_file, $dest_file, $src_file_size, $dest_file_size, $image_quality);
} 

//섬네일 생성
function Ymake_sumnail_gd($src_file, $dest_file, $src_file_size, $dest_file_size, $image_quality=90){

  //생성도중 에러가 날수 있는 것들을 체크 하여 return false
  if (empty($src_file) || empty($dest_file) || !is_file($src_file) || !is_array($src_file_size) || !is_array($dest_file_size) || empty($src_file_size[0]) || empty($src_file_size[1]) || empty($src_file_size[2]) || empty($dest_file_size[0]) || empty($dest_file_size[0])) {

    return false;
  }

  //$image_quality 확인후 조건에 맞지 않으면 기본값 세팅
  if(!is_numeric($image_quality) || empty($image_quality)) $image_quality = 90;

  //원본사이즈보다 썸네일 사이즈가 더 크면 원본사이즈와 같게 썸네일을 생성
  if ($dest_file_size[0] > $src_file_size[0]) {

    $dest_file_size = $src_file_size;
  }

  switch($src_file_size[2]) {

    case 1: // GIF image
      @exec( "gifsicle -I " . $src_file, $tempinfo);
      $info = @join(" " , $tempinfo);

      //gifsicle rpm이 설치되었을 경우 움직인는 gif도 썸네일 가능하다.
      if (preg_match("'(loop forever|loop count)'", $info)) {
        
        @exec( "gifsicle -O " . $image_quality . " --resize " . $dest_file_size[0] . "x" . $dest_file_size[1] . " " . $src_file . " > " . $dest_file );

        //퍼미션 변경가능 여부를 가지고 썸네일 생성 실패 판단
        return @chmod($dest_file, 0777);
      }
      else {

        $src = @ImageCreateFromGIF($src_file); 
      }
      break;

    case 2: // JPEG image
      $src = @ImageCreateFromJPEG($src_file); break;

    case 3: // PNG image
      $src = @ImageCreateFromPNG($src_file); break;

    default: // 정해진 이외의 포맷은 return false
      return false;
  }

  if (function_exists("imagecreatetruecolor")) {

    // This function requires GD 2.0.1 or later.
    $dst = @ImageCreateTrueColor($dest_file_size[0], $dest_file_size[1]);
  } 
  else {

    $dst = @ImageCreate($dest_file_size[0], $dest_file_size[1]);
  }

  // 1.00.05 gd 버전에 따라
  if (function_exists("imagecopyresampled")) {

    @imagecopyresampled($dst, $src, 0, 0, 0, 0, $dest_file_size[0], $dest_file_size[1], $src_file_size[0], $src_file_size[1]);
  } 
  else {

    // 1.00.02 imagecopyresized -> imagecopyresampled 로 교체
    @imagecopyresized($dst, $src, 0, 0, 0, 0, $dest_file_size[0], $dest_file_size[1], $src_file_size[0], $src_file_size[1]);
  }

  @ImageJPEG($dst, $dest_file, $image_quality);
  @ImageDestroy($src);
  @ImageDestroy($dst);

  //퍼미션 변경가능 여부를 가지고 썸네일 생성 실패 판단
  return @chmod($dest_file, 0777);
}

//원격이미지 정보 가져오는 함수
function Ymake_sumnail_remoteimage($url, $save_dir, $w, $h, $referer=''){

  global $dest_file;

  $src_file = $save_dir . '/' . base64_encode($url);

  $read_url = iconv('utf-8', 'euc-kr', $url);//utf-8 사용자만 필요한 라인
  $read_url = preg_replace("`( )`e", "rawurlencode('\\1')", $read_url);
    $text = Yreadfile($read_url, $referer);
  if (empty($text)) return Array();

    $fp = @fopen ($src_file, "w");
    @fwrite($fp, $text);//유일한 파일이므로 파일에 락을 걸지 않는다.
    @fclose($fp);
    @chmod ($src_file, 0777);

  $src_file_size = @getimagesize($src_file);  
  $dest_file = $save_dir . '/s_' . base64_encode($url);
  $dest_file_size = Array($w, $h);
  $result = Ysumnail_rule($src_file, $dest_file, $src_file_size, $dest_file_size, 90, 'gd');

  @unlink($src_file);

  return $result;
}
?>