<?
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 
//유창화님 썸네일 엔진 - http://sir.co.kr/bbs/tb.php/g4_tiptech/10075
//get_smallimg_in_list($board['bo_table'], $list[$i]['file'], 0, 75, 50, '/img/errorimg.gif', 'style="border:1px solid #000000;"', 'width', '1')
//원본이미지의 경로, 크기, 높이, 타입을 알 경우에 사용가능
function make_smallimg ($src, $src_w, $src_h, $src_t, $copy, $copy_w, $copy_h, $copy_rule='width', $copy_pos='1'){

  if ($src_t == 1)
    $src = @imagecreatefromgif($src);
  else if ($src_t == 2)
    $src = @imagecreatefromjpeg($src);
  else if ($src_t == 3)
    $src = @imagecreatefrompng($src);
  else
    return false;

  if (empty($src)) return false;
  if (empty($copy) || $copy_w < 10 || $copy_h < 10) return false;

  $src_x = 0;
  $src_y = 0;
  $copy_x = 0;
  $copy_y = 0;

  if ($copy_rule == 'width' || empty($copy_rule)) {//너비에 맞춤

    $rate = $src_h / $src_w;
    $new_w = $copy_w;
    $new_h = (int) ($rate * $copy_w);

    if ($new_h < $copy_h){//만들어질 썸네일 높이가 비율대로 줄여진 높이보다 클경우 가운데 위치시킴

      $copy_y = (int) (($copy_h - $new_h) / 2);
    }
    else {

      if ($copy_pos == '1' || empty($copy_pos)) {//원본에서 상단을 기준으로 가져옴

        //기본값 그대로
      }
      else if ($copy_pos == '2') {//원본에서 중앙을 기준으로 가져옴

        $temp_h = (int) ($copy_h / $copy_w * $src_w);
        $src_y = (int) (($src_h - $temp_h) / 2);
      }
      else if ($copy_pos == '3') {//원본에서 하단을 기준으로 가져옴

        $temp_h = (int) ($copy_h / $copy_w * $src_w);
        $src_y = $src_h - $temp_h;
      }
    }
  }
  else {//높이에 맞춤

    $rate = $src_w / $src_h;
    $new_h = $copy_h;
    $new_w = (int) ($rate * $copy_h);

    if ($new_w < $copy_w){//만들어질 썸네일 너비가 비율대로 줄여진 너비보다 클경우 가운데 위치시킴

      $copy_x = (int) (($copy_w - $new_w) / 2);
    }
    else {

      if ($copy_pos == '1' || empty($copy_pos)) {//원본에서 왼쪽을 기준으로 가져옴

        //기본값 그대로
      }
      else if ($copy_pos == '2') {//원본에서 중앙을 기준으로 가져옴

        $temp_w = (int) ($copy_w / $copy_h * $src_h);
        $src_x = (int) (($src_w - $temp_w) / 2);
      }
      else if ($copy_pos == '3') {//원본에서 오른쪽을 기준으로 가져옴

        $temp_w = (int) ($copy_w / $copy_h * $src_h);
        $src_x = $src_w - $temp_w;
      }
    }
  }

  $dst = @imagecreatetruecolor($copy_w, $copy_h);
  if (empty($dst)) return false;

  $background_color = @imagecolorallocate($dst, 255, 255, 255);
  if (empty($background_color)) return false;

  imagefilledrectangle($dst, 0, 0, $copy_w, $copy_h, $background_color);    
  imagecopyresampled($dst, $src, $copy_x, $copy_y, $src_x, $src_y, $new_w, $new_h, $src_w, $src_h);

  imagepng($dst, $copy);
  chmod($copy, 0606);
  return true;
}

//리스트스킨에서 썸네일을 보여줄때 사용
function get_smallimg_in_list($bo_table, $file, $num, $w, $h, $error_img, $style='', $copy_rule='width', $copy_pos='1'){

  global $g4;

  $temp_origine_img = "$g4[path]/data/file/$bo_table/" . urlencode($file[$num]['file']);

  if (empty($bo_table) || empty($file[$num]) || !is_file($temp_origine_img) || $w < 10 || $h < 10) {

    $temp_small = false;
  }
  else {

    if (empty($file[$num]['image_width']) || empty($file[$num]['image_height']) || empty($file[$num]['image_type'])) {

      $temp = getimagesize($temp_origine_img);
      $temp_origine_img_w = $temp[0];
      $temp_origine_img_h = $temp[1];
      $temp_origine_img_t = $temp[2];
    }
    else {

      $temp_origine_img_w = $file[$num]['image_width'];
      $temp_origine_img_h = $file[$num]['image_height'];
      $temp_origine_img_t = $file[$num]['image_type'];
    }

    $temp_small_img_w = $w;
    $temp_small_img_h = $h;
    $temp_small_dir = "$g4[path]/data/file/$bo_table/thumb";

    if (!is_dir($temp_small_dir)){

      mkdir($temp_small_dir) or die('썸네일을 저장할 디렉토리를 생성할수 없습니다.');
    }

    $temp_small_img = "$temp_small_dir/s_{$temp_small_img_w}_{$temp_small_img_h}_" . urlencode($file[$num][file]);

    if (is_file($temp_origine_img) && !is_file($temp_small_img)) {

      $temp_small = make_smallimg ($temp_origine_img, $temp_origine_img_w, $temp_origine_img_h, $temp_origine_img_t, $temp_small_img, $temp_small_img_w, $temp_small_img_h, $copy_rule, $copy_pos);
    }
    else if (is_file($temp_origine_img) && is_file($temp_small_img)){

      $temp_small = true;
    }
    else {

      $temp_small = false;
    }
  }

  if ($temp_small) {

    //return "<img src='$temp_small_img' width='$temp_small_img_w' height='$temp_small_img_h' border=0 $style onError=\"this.src='$error_img';\">";
    return $temp_small_img;
  }
  else {

    return "<img src='$error_img' width='$w' height='$h' border=0 $style>";
  }
}
?>