<?
if (!defined('_GNUBOARD_')) exit;

// 비율에 따라 생성할 경우
//create_thumb(500, 0, 소스이미지파일명, 썸네일이미지파일명);
 
// 고정방식을 사용할 경우
//create_thumb(500, 500, 소스이미지파일명, 썸네일이미지파일명);
 
//*** 위의 경우 모두 500 보다 넓이가 작은 이미지는 무시한다.

// 원본 이미지를 넘기면 비율에 따라 썸네일 이미지를 생성함
function create_thumb($width, $height, $source, $thumb="")
{
    // 썸네일의 넓이가 넘어오지 않으면 에러
    if (!$width)
        return -1;
    if (!$thumb)
        $thumb = $source;
    $size = getimagesize($source);
    if ($size[2] == 1)
        $source = imagecreatefromgif($source);
    else if ($size[2] == 2)
        $source = imagecreatefromjpeg($source);
    else if ($size[2] == 3)
        $source = imagecreatefrompng($source);
    else
        return -2;
    // 썸네일 이미지 넓이 보다 원본이미지의 넓이가 작다면 그냥 원본이미지가 썸네일이 됨
    if ($width > $size[0])
    {
        $target = imagecreatetruecolor($size[0], $size[1]);
        imagecopyresampled($target, $source, 0, 0, 0, 0, $size[0], $size[1], $size[0], $size[1]);
    }
    else
    {
        // 썸네일 높이가 넘어왔다면 비율에 의해 이미지를 생성하지 않음
        if ($height)
        {
            // 원본이미지를 썸네일로 복사
            // 1000x1500 -> 500x500 으로 복사되는 형식이므로 이미지가 일그러진다.
            $comp_height = $height;
        }
        else
        {
            // 원래 이미지와 썸네일 이미지와의 비율
            $rate = round($width / $size[0], 2); // 소수점 2자리 , 소수점 3자리에서 반올림됨
            // 비율에 의해 계산된 높이
            $comp_height = floor($size[1] * $rate); // 소수점 이하 버림
        }
        $target = imagecreatetruecolor($width, $comp_height);
        imagecopyresampled($target, $source, 0, 0, 0, 0, $width, $comp_height, $size[0], $size[1]);
    }
    @imagejpeg($target, $thumb, 100);
    @chmod($thumb, 0666); // 추후 삭제를 위하여 파일모드 변경
    return 1;
}
?>