<?
if (!defined('_GNUBOARD_')) exit;

// 썸네일 생성 : $thumb_img 반환
// 휴온(2016)
function hn_thumb($org_img, $thumb_img, $dst_width, $dst_height) { 
	
	if (!is_file($org_img) || !$thumb_img || !$dst_width || !$dst_height ) {		
	 	return false;
	}

	// 원본 이미지 체크
	$info = getImageSize($org_img); 
	$org_width = $info[0]; 
	$org_height = $info[1]; 
	
	if($info[2] == 1) { 
		$src_img = ImageCreateFromGif($org_img); 
	} else if($info[2] == 2) { 
		$src_img = ImageCreateFromJPEG($org_img); 
	} else if($info[2] == 3) { 
		$src_img = ImageCreateFromPNG($org_img); 
	} else { 
		return 0; 
	} 
	
	// 썸네일 사이즈
	if (($org_width/$dst_width) == ($org_height/$dst_height)) {
		$dst_width = $dst_width; 
		$dst_height = $dst_height;
	} else if (($org_width/$dst_width) > ($org_height/$dst_height)) {
		$dst_width = $dst_width; 
		$dst_height = $dst_width*($org_height/$org_width); 
	} else {
		$dst_width = $dst_height*($org_width/$org_height); 
		$dst_height = $dst_height; 
	}	
	
	$dst_img = imagecreatetruecolor($dst_width, $dst_height); 	
	ImageCopyResampled($dst_img, $src_img, 0, 0, 0, 0, $dst_width, $dst_height, $org_width, $org_height); 

	// 이미지 저장
	$thumb_dir = dirname($thumb_img);
	if (!is_dir($thumb_dir)) {
		$oldmask = umask(0);
		mkdir($thumb_dir, 0777);
		umask($oldmask);
	}
	
	ImageInterlace($dst_img); 
	ImageJPEG($dst_img, $thumb_img); 	
	chmod($thumb_img, 0755);
	
	ImageDestroy($dst_img); 
	ImageDestroy($src_img); 
	
	return $thumb_img;
} 
?>