<?php
// swiper_coverflow
// Author: 휴온(2016)
// URL: www.hnbuilder.net
/* -------------------------------------------------------------
[사용법]
// 옵션으로 이미지 width, height를 지정할 수 있습니다.
// 기본 사이즈는 width:50%, height:500px 입니다.
echo latest("swiper_coverflow", "gallery", 10, 0, "600|400");

[plugin]
Swiper: http://idangero.us/swiper/
------------------------------------------------------------- */
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once($g4[path].'/lib/hn_thumb.lib.php');

// 이미지 크기
if ($options) {
	$tmp = explode("|", $options);
	$thumb_width = $tmp[0];
	$thumb_height = $tmp[1];
} 
if (!is_numeric($thumb_width) || $thumb_width <= 1) 
	$thumb_width = 600;
if (!is_numeric($thumb_height) || $thumb_height <= 1) 
	$thumb_height = 400;

//thumb 이미지 경로
$thumb_path = $g4[path]."/data/file/".$bo_table."/swiper_thumb";
?>
<link href="<?=$latest_skin_path?>/swiper_coverflow.css" rel="stylesheet" type="text/css">
<link href="<?=$g4[path]?>/plugin/swiper/css/swiper.min.css" rel="stylesheet" >
<?php if ($options) { ?>
<style>
.swiper-coverflow .swiper-slide {
	width: <?php echo $thumb_width; ?>px;
	height: <?php echo $thumb_height; ?>px;
}
</style>
<?php } ?>

<!-- Swiper -->
<div class="swiper-container swiper-coverflow">
	<div class="swiper-wrapper">
<?php 
for ($i=0; $i<count($list); $i++) {  
	//원본 이미지
	$org_img = "$g4[path]/data/file/$bo_table/".urlencode($list[$i][file][0][file]); 
	
	//썸네일 이미지
	$thumb_img = $thumb_path."/".$list[$i][wr_id]."_{$thumb_width}x{$thumb_height}.jpg";
	
	if (is_file($org_img) && !file_exists ($thumb_img)) {
		// 원본 이미지를 지정 크기의 이미지로 저장합니다.
		$thumb_img = hn_thumb($org_img, $thumb_img, $thumb_width, $thumb_height);
	}
	
	if(is_file($thumb_img)) {
		$thumb_url = $thumb_img;
	} else {
		$thumb_url = $latest_skin_url."/img/no-image.gif";
	}
	
	echo "		<div class=\"swiper-slide\"  style=\"background-image:url($thumb_url)\"></div>\n";
} 
?>
	</div>
	<div class="swiper-pagination"></div>
	<div class="swiper-button-prev"></div>
	<div class="swiper-button-next"></div>
</div>

<script src="<?=$g4[path]?>/plugin/swiper/js/swiper.min.js"></script>
<script>
var swiper_coverflow = new Swiper('.swiper-coverflow', {
	pagination: '.swiper-pagination',
	nextButton: '.swiper-button-next',
	prevButton: '.swiper-button-prev',
	effect: 'coverflow',
	grabCursor: true,
	centeredSlides: true,
	slidesPerView: 'auto',
	loop: true,
	coverflow: {
		rotate: 50,
		stretch: 0,
		depth: 100,
		modifier: 1,
		slideShadows : true
	}
});
</script><!-- /Swiper -->