
/*	============================================================================
	============================================================================
	==
	==		kplayer_album.js
	==
	==		앨범 관련 script
	==
	============================================================================
	============================================================================*/

// id 객체
function getID(objName){
	//return document.getElementById(objName);
	if (document.getElementById && document.getElementById(objName)){
		return document.getElementById(objName);
	}else if (document.all && document.all[objName]){
		return document.all[objName];
	}
}

// 윈도우 리사이즈
var win_height = 460;
var win_width = 342;
var winw = 7;
var winh = 26;
window.resizeTo(win_width + winw, win_height + winh);
window.focus();

// 번호 생성
function add_num(){
	var album_table = getID("album_list_table");
	var tr_len = album_table.rows.length;
	if (tr_len <= 0){
		error_notice(album_table, tr_len);
	}else{
		for (var i = 0; i < tr_len; i++){
			for (var k = 0; k < album_table.rows[i].cells[1].childNodes.length; k++){
				if (album_table.rows[i].cells[1].childNodes[k].nodeType != 1) continue;
				album_table.rows[i].cells[1].childNodes[k].innerHTML = tr_len - i;
			}
		}
	}
	if (getID("album_count").firstChild.nodeType == 3){
		getID("album_count").firstChild.nodeValue = tr_len;
	}
}

// 삭제
function del(obj){
	var album_row = obj.parentNode.parentNode;
	var album_table = getID("album_list_table");
	var tr_len = album_table.rows.length;
	for (var i = 0; i < tr_len; i++){
		if (album_table.rows[i] == album_row){
			album_table.deleteRow(i);
		}
	}
	add_num();
}

// 선택 삭제
function all_del(){
	var album_table = getID("album_list_table");
	var tr_len = album_table.rows.length;

	this.del_row = function(){
		for (var i = tr_len-1; i > -1; i--){
			for (var j = 0; j < album_table.rows[i].cells[0].childNodes.length; j++){
				if (album_table.rows[i].cells[0].childNodes[j].nodeType != 1) continue;
				if (album_table.rows[i].cells[0].childNodes[j].type == "checkbox"){
					if (album_table.rows[i].cells[0].childNodes[j].checked){
						album_table.deleteRow(i);
						break;
					}
				}
			}
		}
	}

	this.del_row();
	add_num();
}

function error_notice(album_table, tr_len){
	var insert_row = album_table.insertRow(tr_len);
	var insert_cell = insert_row.insertCell(0);
	var insert_span = document.createElement('span');
	insert_span.appendChild( document.createTextNode('등록된 곡이 없습니다.') );
	insert_cell.height = '340';
	insert_cell.colSpan = '4';
	insert_cell.align = 'center';
	insert_cell.className = 'list_item_error';
	insert_cell.appendChild( insert_span );
}

// 목록 위로 이동
function up(obj){
	var album_row = obj.parentNode.parentNode;
	var album_table = getID("album_list_table");
	for (var i = 0; i < album_row.cells[0].childNodes.length; i++){
		if (album_row.cells[0].childNodes[i].nodeType != 1) continue;
		if (album_row.cells[0].childNodes[i].type == "checkbox"){
			var album_row_child1 = album_row.cells[0].childNodes[i].value;
			var album_row_checked = album_row.cells[0].childNodes[i].checked;
		}
	}
	var album_row_child2 = album_row.cells[2].innerHTML;
	var tr_len = album_table.rows.length;
	for (var i = 0; i < tr_len; i++){
		if (album_table.rows[i] == album_row){
			if (i != 0){
				for (var j = 0; j < album_table.rows[i-1].cells[0].childNodes.length; j++){
					if (album_table.rows[i-1].cells[0].childNodes[j].nodeType != 1) continue;
					if (album_table.rows[i-1].cells[0].childNodes[j].type == "checkbox"){
						var oalbum_row_child1 = album_table.rows[i-1].cells[0].childNodes[j].value;
						var oalbum_row_checked = album_table.rows[i-1].cells[0].childNodes[j].checked;
					}
				}
				var oalbum_row_child2 = album_table.rows[i-1].cells[2].innerHTML;
				for (var k = 0; k < album_table.rows[i-1].cells[0].childNodes.length; k++){
					if (album_table.rows[i-1].cells[0].childNodes[k].nodeType != 1) continue;
					if (album_table.rows[i-1].cells[0].childNodes[k].type == "checkbox"){
						album_table.rows[i-1].cells[0].childNodes[k].value = album_row_child1;
						album_table.rows[i-1].cells[0].childNodes[k].checked = album_row_checked;
					}
				}
				album_table.rows[i-1].cells[2].innerHTML = album_row_child2;
				for (var h = 0; h < album_table.rows[i].cells[0].childNodes.length; h++){
					if (album_table.rows[i].cells[0].childNodes[h].nodeType != 1) continue;
					if (album_table.rows[i].cells[0].childNodes[h].type == "checkbox"){
						album_table.rows[i].cells[0].childNodes[h].value = oalbum_row_child1;
						album_table.rows[i].cells[0].childNodes[h].checked = oalbum_row_checked;
					}
				}
				album_table.rows[i].cells[2].innerHTML = oalbum_row_child2;
				break;
			}
		}
	}
}

// 목록 아래로 이동
function down(obj){
	var album_row = obj.parentNode.parentNode;
	var album_table = getID("album_list_table");
	for (var i = 0; i < album_row.cells[0].childNodes.length; i++){
		if (album_row.cells[0].childNodes[i].nodeType != 1) continue;
		if (album_row.cells[0].childNodes[i].type == "checkbox"){
			var album_row_child1 = album_row.cells[0].childNodes[i].value;
			var album_row_checked = album_row.cells[0].childNodes[i].checked;
		}
	}
	var album_row_child2 = album_row.cells[2].innerHTML;
	var tr_len = album_table.rows.length;
	for (var i = 0; i < tr_len; i++){
		if (album_table.rows[i] == album_row){
			if (i != (tr_len - 1)){
				for (var j = 0; j < album_table.rows[i+1].cells[0].childNodes.length; j++){
					if (album_table.rows[i+1].cells[0].childNodes[j].nodeType != 1) continue;
					if (album_table.rows[i+1].cells[0].childNodes[j].type == "checkbox"){
						var oalbum_row_child1 = album_table.rows[i+1].cells[0].childNodes[j].value;
						var oalbum_row_checked = album_table.rows[i+1].cells[0].childNodes[j].checked;
					}
				}
				var oalbum_row_child2 = album_table.rows[i+1].cells[2].innerHTML;
				for (var h = 0; h < album_table.rows[i+1].cells[0].childNodes.length; h++){
					if (album_table.rows[i+1].cells[0].childNodes[h].nodeType != 1) continue;
					if (album_table.rows[i+1].cells[0].childNodes[h].type == "checkbox"){
						album_table.rows[i+1].cells[0].childNodes[h].value = album_row_child1;
						album_table.rows[i+1].cells[0].childNodes[h].checked = album_row_checked;
					}
				}
				album_table.rows[i+1].cells[2].innerHTML = album_row_child2;
				for (var k = 0; k < album_table.rows[i].cells[0].childNodes.length; k++){
					if (album_table.rows[i].cells[0].childNodes[k].nodeType != 1) continue;
					if (album_table.rows[i].cells[0].childNodes[k].type == "checkbox"){
						album_table.rows[i].cells[0].childNodes[k].value = oalbum_row_child1;
						album_table.rows[i].cells[0].childNodes[k].checked = oalbum_row_checked;
					}
				}
				album_table.rows[i].cells[2].innerHTML = oalbum_row_child2;
				break;
			}
		}
	}
}

var check = false;
// 전체 선택/해제
function all_checked(){
	check = !check;
	var objform = document.forms['album_form'];
	
	for (var i = 0; i < objform.length; i++){
		if (objform.elements[i].name == 'chk_wr_id[]') objform.elements[i].checked = check;
	}
}

// 체크박스 선택
function selectCheck(){
	var buffer = '';
	var objform = document.forms['album_form'];
		
	for (var i = 0; i < objform.length; i++){
		if (objform.elements[i].name == 'chk_wr_id[]' && objform.elements[i].checked){
			buffer += objform.elements[i].value + ',';
		}
	}
	return buffer;
}

function check_confirm(str){
	alert(str + '할 게시물을 하나 이상 선택하세요.');
	return false;
}

function link_url(link){
	window.location = link;
}

function mOver(obj){
	obj.style.color = '#e9cf81';
}

function mOut(obj){
	obj.style.color = '#d9e7e7';
}

function WinReSize(){
	if (window.innerHeight || window.innerWidth){
		if (win_height > window.innerHeight || win_width > window.innerWidth){
			var win_width2 = win_width + (window.outerWidth - window.innerWidth);
			var win_height2 = win_height + (window.outerHeight - window.innerHeight);
			window.resizeTo(win_width2, win_height2);
			window.focus();
		}
	}else{
		if (document.body && (document.body.clientHeight || document.body.clientWidth)){
			if (win_height > document.body.clientHeight || win_width > document.body.clientWidth){
				var win_width2 = win_width + winw + (document.body.scrollWidth - document.body.clientWidth);
				var win_height2 = win_height + winh + (document.body.scrollHeight - document.body.clientHeight);
				window.resizeTo(win_width2, win_height2);
				window.focus();
			}
		}else if (document.documentElement && (document.documentElement.clientHeight || document.documentElement.clientWidth)){
			if (win_height > document.documentElement.clientHeight || win_width > document.documentElement.clientWidth){
				var win_width2 = win_width + winw + (document.documentElement.scrollWidth - document.documentElement.clientWidth);
				var win_height2 = win_height + winh + (document.documentElement.scrollHeight - document.documentElement.clientHeight);
				window.resizeTo(win_width2, win_height2);
				window.focus();
			}
		}
	}
}

window.onerror = function(){return true;};
