
/*	============================================================================
	============================================================================
	==
	==		kplayer_audio_event.js
	==
	==		오디오 kplayer event 관련 script
	==
	============================================================================
	============================================================================*/

// 버퍼링 이벤트
function OnBufferingChange(Start){
	bIsBufferMode = Start;

	if (bIsBufferMode){
		DisplayState(KP_PlayState);
		DisPlayBuffer();
	}else{
		DisplayState(KP_PlayState);
	}
}


// PlayState 이벤트
function OnPlayStateChange(NewState){
	KP_PlayState = NewState;

	switch (KP_PlayState){
	case 0:
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(0);
		break;

	case 1:   /// '정지됨'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;

			if (bIsTwoLyrics) bTwoLyricsLoaded = false;

			if (disPlayState != null ) clearTimeout(disPlayState);
			if (disPlayBuff != null ) clearTimeout(disPlayBuff);
			Ticks = 0;
			RotSecs = 0;

			nCurrentPosition = 0;
			nCurrentDuration = 0;
			nPreTrackPosX = 0;
			nPosValue = 0;
			PlayText = '';

			DisplayState(1);
			DisplayInit();
			DisplayTrack();
			OpenListChange();
		break;

	case 2:   /// '일시 정지됨'
			bIsPlayMode = false;
			bIsPauseMode = true;
			bIsStopMode = false;

			if (disPlayState != null ) clearTimeout(disPlayState);
			if (disPlayBuff != null ) clearTimeout(disPlayBuff);
			Ticks = 0;
			RotSecs = 0;

			DisplayState(2);
			DisplaySong();
		break;

	case 3:   /// '재생 중'
			bIsPlayMode = true;
			bIsPauseMode = false;
			bIsStopMode = false;

			DisplayDuration();
			DisplayState(3);
			DisplaySong();
			DisplayTrack();
			ShowMediaKBPS(GetBitRate(1));
			ShowMediaType(GetMediaType());
		break;

	case 4:
		break;

	case 5:
		break;

	case 6:    /// '버퍼링'
		break;

	case 7:    ///  '대기 중...'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(7);
			//DisplayInit();
		break;

	case 8:   /// '마침'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			bIsEndOfStream = true;
			DisplayInit();

			if (bIsTwoLyrics){bTwoLyricsLoaded = false; GetTwoLyricsInit();}
			if (OnPlay != null ) clearTimeout(OnPlay);
			if (disPlayState != null ) clearTimeout(disPlayState);
			if (disPlayBuff != null ) clearTimeout(disPlayBuff);

			if (bIsEndOfStream) StreamChange();
		break;

	case 9:   /// '전환 중'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(9);
			//DisplayInit();
		break;

	case 10:  /// '준비'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(10);
			//DisplayInit();
		break;

	case 11:   /// '다시 연결 시도 중'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(11);
		break;
	}
}



// OpenState 이벤트
function OnOpenStateChange(NewState){
	KP_OpenState = NewState;
	switch (KP_OpenState){
	case 0:
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
		break;

	case 1:
		break;

	case 2:  /// '재생 목록 찾는 중...'
		break;

	case 3:  /// '재생 목록에 연결 중...'
		break;

	case 4:   /// '재생 목록 로드 중...'
		break;

	case 5:   /// '재생 목록 여는 중...'
		break;

	case 6:
		break;

	case 7:
		break;

	case 8:  /// '미디어 변경 중...'
		break;

	case 9:   /// '미디어 찾는 중...'
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		ImageShow(KP_PLAY_STATE_IMAGE.childNodes[0], MediaSearch);
		ShowState('미디어 찾는 중....');
		break;

	case 10:   /// '미디어에 연결 중...'
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		ImageShow(KP_PLAY_STATE_IMAGE.childNodes[0], MediaSearch);
		ShowState('미디어에 연결 중....');
		break;

	case 11:   /// '미디어 로드 중...'
		break;

	case 12:   /// '미디어 여는 중...'
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		ImageShow(KP_PLAY_STATE_IMAGE.childNodes[0], MediaOpening);
		ShowState('미디어 여는 중....');
		break;

	case 13:   /// '미디어 열기'

		bIsLiveBroadcast = (GetMediaInfo('Type') == 'broadcast');
		nCurrentDuration = parseInt(KP_KPlayer.CurrentMedia.Duration);
		if (nCurrentDuration > 0){
			PlayText = '[' + TotalTime(nCurrentDuration) + ']';
		}else{
			PlayText = '';
		}

		DisplayTrack();
		ShowMediaKBPS(GetBitRate(1));
		ShowMediaType(GetMediaType());
		break;

	case 14:   /// '코덱 취득 중...'
		break;

	case 15:   /// '코덱 취득'
		break;

	case 16:   /// '라이센스 취득 중...'
		break;

	case 17:   /// '라이센스 취득'
		break;

	case 18:   /// '개별화 시작 중...'
		break;

	case 19:   /// '개별화 완료'
		break;

	case 20:  /// '대기 중'
		break;

	default:
		break;
	}
}


// Error 이벤트
function OnError(){

	if(KP_Error.errorCount > 0){
		KP_Controls.Stop();

		errCount++;

		bIsBufferMode = false;
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		DisplayState(99);
		DisplayInit();
		DisplaySong();
		DisplayTrack();

		if (errCount <= 4){
			if (bIsTwoLyrics){
				ShowTwoLyrics1('서버에 접속 시도(' + errCount + ') 중입니다.');
				ShowTwoLyrics2('잠시만 기다려주세요.');
			}else{
				ShowState('서버에 접속 시도(' + errCount + ') 중입니다.');
			}
			OnErrPlay = setTimeout('PlayMusic(' + nCurrentTrack + ');', 3000);
		}else{
			OnErrorNext();
		}
		KP_Error.clearErrorQueue();
	}
}


function OnErrorNext(){
	if ((nTotalTrack - 1) == 0 && (strLoopMode == 'one' || strLoopMode == 'none') && !bIsRandomMode){
		if (bIsTwoLyrics){
			ShowTwoLyrics1('음악파일을 로딩 할 수 없습니다.');
			ShowTwoLyrics2('서버에러. 다른곡을 선택하세요.');
			ShowState('미디어에 연결 안됨');
		}else{
			ShowState('서버에러. 다른곡을 선택하세요.');
		}
		errCount = 0;
	}else if ((nTotalTrack - 1) > 0 && strLoopMode == 'one' && !bIsRandomMode){
		if (bIsTwoLyrics){
			ShowTwoLyrics1('음악파일을 로딩 할 수 없습니다.');
			ShowTwoLyrics2('다른 곡을 재생합니다.');
		}else{
			ShowState('서버에러. 다른곡을 재생합니다.');
		}
		OnErrRandom = setTimeout('RandomNext();', 3000);
		errCount = 0;
	}else if ((nTotalTrack - 1) > 0 && strLoopMode == 'none' && nCurrentTrack == (nTotalTrack - 1) && !bIsRandomMode){
		if (bIsTwoLyrics){
			ShowTwoLyrics1('음악파일을 로딩 할 수 없습니다.');
			ShowTwoLyrics2('서버에러. 다른곡을 선택하세요.');
			ShowState('미디어에 연결 안됨');
		}else{
			ShowState('서버에러. 다른곡을 선택하세요.');
		}
		errCount = 0;
	}else{
		if (bIsTwoLyrics){
			ShowTwoLyrics1('음악파일을 로딩 할 수 없습니다.');
			ShowTwoLyrics2('다음 곡을 재생합니다.');
		}else{
			ShowState('서버에러. 다음곡을 재생합니다.');
		}
		OnErrStream = setTimeout('StreamChange();', 3000);
		errCount = 0;
	}
}

function OnErrTimer(){
	if (OnErrPlay != null ) clearTimeout(OnErrPlay);
	if (OnErrRandom != null ) clearTimeout(OnErrRandom);
	if (OnErrStream != null ) clearTimeout(OnErrStream);
}
