
/*	============================================================================
	============================================================================
	==
	==		kplayer_audio_twolyrics.js
	==
	==		두줄가사 관련 script (시간|가사|색상@)
	==		XML 파일 <lyrics time = "시간" gasa = "가사" color = "색상" />
	==
	==		<div><div><nobr><span> #text : 두줄 가사</span></nobr></div></div>
	==
	============================================================================
	============================================================================*/

/// 두줄 가사 처리 ////////////////////////////////////////////////////////////////////////////////
function GetTwolyrics(){
	GetTwoLyricsInit();
	if (MediaInfo[nCurrentTrack].getIsFile() == 'NO-DATA'){
		bTwoLyricsLoaded = false;
		ShowTwoLyrics1(MediaInfo[nCurrentTrack].getSinger() + ' - ' + MediaInfo[nCurrentTrack].getTitle());
		ShowTwoLyrics2('두줄가사는 준비 중....');
	}else{
		GetTwoLyricsMetaData(two_lyrics[nCurrentTrack]);		
	}
}

function GetTwoLyricsInit(){
	arrTwoLyricsTime = new Array();
	arrTwoLyrics = new Array();
	arrColor = new Array();
	nTwoLyricsCnt = 0;
	nCurrTime = 0;
	nNextTime = 0;
	nCurr = -1;
	nNext = -1;
	sFadeDark1 = null;
	sFadeDark2 = null;
}

function GetTwoLyricsMetaData(metadata){

	if (!metadata || metadata == '' || metadata == 'NO-DATA'){
		bTwoLyricsLoaded = false;
		ShowTwoLyrics1(MediaInfo[nCurrentTrack].getSinger() + ' - ' + MediaInfo[nCurrentTrack].getTitle());
		ShowTwoLyrics2('두줄가사는 준비 중....');
	}else{
		var arrTwoLyricsTemp = new Array();
		var arrTwoLyricsData = new Array();
		var strTwoLyrics = new String;

		strTwoLyrics = metadata;
		arrTwoLyricsTemp = strTwoLyrics.split("@");
		nTwoLyricsCnt = arrTwoLyricsTemp.length;

		for(var i = 0; i < nTwoLyricsCnt; i++){
			arrTwoLyricsData[i] = arrTwoLyricsTemp[i].split("|");

			var arrData1 = arrTwoLyricsData[i][0];
			var arrData2 = arrTwoLyricsData[i][1];
			var arrData3 = arrTwoLyricsData[i][2];
			if (typeof(arrTwoLyricsData[i][0]) == 'undefined' || arrTwoLyricsData[i][0] == '' || isNaN(parseInt(arrTwoLyricsData[i][0]))) continue;
			if (typeof(arrTwoLyricsData[i][1]) == 'undefined' || arrTwoLyricsData[i][1] == '') arrData2 = '';
			if (typeof(arrTwoLyricsData[i][2]) == 'undefined' || arrTwoLyricsData[i][2] == '') arrData3 = '';
			
			arrTwoLyricsTime[i] = arrData1;
			arrTwoLyrics[i] = arrData2;
			arrColor[i] = arrData3;
		}

		bTwoLyricsLoaded = true;
	}
}

function PlayTwoLyrics(nCurrPosition){
	if(nCurrPosition > 0){
		if (TwoLyricsMode != 1){
			for (var i = 0; i < nTwoLyricsCnt; i++){
				nCurrTime = arrTwoLyricsTime[i];
				nNextTime = arrTwoLyricsTime[(i+1)];
				if ((nCurrPosition >= nCurrTime) && (nCurrPosition < nNextTime)){
					if (!bSetTrackPos){
						if ((i%2) == 0){
							FadeIn1(arrTwoLyrics[i], arrColor[i], i);
						}else if ((i%2) == 1){
							FadeIn2(arrTwoLyrics[i], arrColor[i], i);
						}
					}else{
						if ((i%2) == 0){
							nCurr = nCurr + i;
							nNext = nNext + i;
							FadeInDrag1(arrTwoLyrics[i], arrColor[i]);
						}else if ((i%2) == 1){
							nCurr = nCurr + i;
							nNext = nNext + i;
							FadeInDrag2(arrTwoLyrics[i], arrColor[i]);
						}
					}
					break;
				}
			}
		}else{
			for (var i = 0; i < nTwoLyricsCnt; i++){
				nCurrTime = arrTwoLyricsTime[i];
				nNextTime = arrTwoLyricsTime[(i+1)];
				if ((nCurrPosition >= nCurrTime) && (nCurrPosition < nNextTime)){
					if (!bSetTrackPos){
						FadeIn1(arrTwoLyrics[i], arrColor[i], i);
						FadeIn2(arrTwoLyrics[(i+1)], arrColor[(i+1)], (i+1));
					}else{
						nCurr = nCurr + i;
						nNext = nNext + (i+1);
						FadeInDrag1(arrTwoLyrics[i], arrColor[i]);
						FadeInDrag2(arrTwoLyrics[(i+1)], arrColor[(i+1)]);
					}
					break;
				}
			}
		}
	}
}


//  실제 가사 출력
function FadeInDrag1(Lyrics, sColor){
	ShowColor1(sColor);
	if (BrInfo.ie5){
		if (TwoLyricsMode == 4){
			if (KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.status != 2){
				KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.stop();
				ShowTwoLyrics1(Lyrics);
				ShowTwoLyrics2('');
			}
		}else{
			ShowTwoLyrics1(Lyrics);
			if (TwoLyricsMode != 1) ShowTwoLyrics2('');
		}
	}else if (BrInfo.ns6){
		ShowTwoLyrics1(Lyrics);
		if (TwoLyricsMode != 1) ShowTwoLyrics2('');
	}
}

function FadeInDrag2(Lyrics, sColor){
	ShowColor2(sColor);
	if (BrInfo.ie5){
		if (TwoLyricsMode == 4){
			if (KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.status != 2){
				KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.stop();
				ShowTwoLyrics2(Lyrics);
				ShowTwoLyrics1('');
			}
		}else{
			ShowTwoLyrics2(Lyrics);
			if (TwoLyricsMode != 1) ShowTwoLyrics1('');
		}
	}else if (BrInfo.ns6){
		ShowTwoLyrics2(Lyrics);
		if (TwoLyricsMode != 1) ShowTwoLyrics1('');
	}
}

function FadeIn1(Lyrics, sColor, nNum){
	if (TwoLyricsMode != 1){if (sFadeDark2 != null) clearTimeout(sFadeDark2);}
	if (nCurr != nNum){
		nCurr = nNum;
		ShowColor1(sColor);
		if (BrInfo.ie5){
			if (TwoLyricsMode == 4){
				KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].style.filter = 'blendTrans(duration = 0.5)';
				if (KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.status != 2){
					KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.apply();
					ShowTwoLyrics1(Lyrics);
					KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.play();
					sFadeDark1 = setTimeout('FadeOut1()', 700);
				}
			}else{
				ShowTwoLyrics1(Lyrics);
				if (TwoLyricsMode != 1){sFadeDark1 = setTimeout('FadeOut1()', 1000);}
			}
		}else if (BrInfo.ns6){
			ShowTwoLyrics1(Lyrics);
			if (TwoLyricsMode != 1){sFadeDark1 = setTimeout('FadeOut1()', 1000);}
		}
	}
}

function FadeOut1(){
	if (TwoLyricsMode != 1){if (sFadeDark1 != null) clearTimeout(sFadeDark1);}
	if (BrInfo.ie5){
		if (TwoLyricsMode == 4){
			KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].style.filter = 'blendTrans(duration = 1.0)';
			if (KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.status != 2){
				KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.apply();
				ShowTwoLyrics2('');
				KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.play();
			}
		}else{
			ShowTwoLyrics2('');
		}
	}else if (BrInfo.ns6){
		ShowTwoLyrics2('');
	}
}

function FadeIn2(Lyrics, sColor, nNum){
	if (TwoLyricsMode != 1){if (sFadeDark1 != null) clearTimeout(sFadeDark1);}
	if (nNext != nNum){
		nNext = nNum;
		ShowColor2(sColor);
		if (BrInfo.ie5){
			if (TwoLyricsMode == 4){
				KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].style.filter = 'blendTrans(duration = 0.5)';
				if (KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.status != 2){
					KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.apply();
					ShowTwoLyrics2(Lyrics);
					KP_TWO_LYRICS2.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.play();
					sFadeDark2 = setTimeout('FadeOut2()', 700);
				}
			}else{
				ShowTwoLyrics2(Lyrics);
				if (TwoLyricsMode != 1){sFadeDark2 = setTimeout('FadeOut2()', 1000);}
			}
		}else if (BrInfo.ns6){
			ShowTwoLyrics2(Lyrics);
			if (TwoLyricsMode != 1){sFadeDark2 = setTimeout('FadeOut2()', 1000);}
		}
	}
}

function FadeOut2(){
	if (TwoLyricsMode != 1){if (sFadeDark2 != null) clearTimeout(sFadeDark2);}
	if (BrInfo.ie5){
		if (TwoLyricsMode == 4){
			KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].style.filter = 'blendTrans(duration = 1.0)';
			if (KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.status != 2){
				KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.apply();
				ShowTwoLyrics1('');
				KP_TWO_LYRICS1.childNodes[0].childNodes[0].childNodes[0].filters.blendTrans.play();
			}
		}else{
			ShowTwoLyrics1('');
		}
	}else if (BrInfo.ns6){
		ShowTwoLyrics1('');
	}
}
