<?
/*	============================================================================
	============================================================================
	==
	==		kplayer_common_lib.php
	==
	==		audio, video, radio 공용
	==
	============================================================================
	============================================================================*/

if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

// 플레이어 설정 체크(에러 출력) audio, video, radio
// $type = ("\\n\\n", <br />), $mode = (audio, video, radio)
// $value = (저장된 값 : $board, post로 넘어온 값(플레이어 설정) : $_POST), $is_type = ($board : 1, $_POST : 2)
function kplayer_board_check($type, $mode, $value, $is_type){
	$alert_str = "";
	$mode_type = strtolower(trim($mode));
	$media_type = strtolower(trim(($is_type == 1) ? $value['bo_1'] : $value['bo_media_type']));
	$kplayer_skin = trim(($is_type == 1) ? $value['bo_2'] : $value['bo_skin_dir']);
	if ($is_type == 1){
		$album_array = strtolower(trim($value['bo_3']));
	}
	$is_album = ($is_type == 1) ? kplayer_array_value($album_array, 0) : strtolower(trim($value['bo_album']));
	$is_album_level = ($is_type == 1) ? kplayer_array_value($album_array, 1) : strtolower(trim($value['bo_album_level']));
	if ($is_type == 1){
		$kplayer_array = strtolower(trim($value['bo_4']));
	}
	$is_player_level = ($is_type == 1) ? kplayer_array_value($kplayer_array, 0) : strtolower(trim($value['bo_player_level']));
	$is_auto_start = ($is_type == 1) ? kplayer_array_value($kplayer_array, 1) : strtolower(trim($value['bo_auto_start']));
	if ($mode_type == "audio" || $mode_type == "video"){
		$is_media_mode = ($is_type == 1) ? kplayer_array_value($kplayer_array, 2) : strtolower(trim($value['bo_media_mode']));
		$is_open_list = ($is_type == 1) ? kplayer_array_value($kplayer_array, 3) : strtolower(trim($value['bo_open_list']));
		$is_view_type = ($is_type == 1) ? kplayer_array_value($kplayer_array, 4) : strtolower(trim($value['bo_view_type']));
		$is_timer_image = ($is_type == 1) ? kplayer_array_value($kplayer_array, 5) : strtolower(trim($value['bo_timer_image']));
		$is_laptime = ($is_type == 1) ? kplayer_array_value($kplayer_array, 6) : strtolower(trim($value['bo_laptime']));
	}else if ($mode_type == "radio"){
		$is_open_list = ($is_type == 1) ? kplayer_array_value($kplayer_array, 2) : strtolower(trim($value['bo_open_list']));
		$is_view_type = ($is_type == 1) ? kplayer_array_value($kplayer_array, 3) : strtolower(trim($value['bo_view_type']));
		$is_timer_image = ($is_type == 1) ? kplayer_array_value($kplayer_array, 4) : strtolower(trim($value['bo_timer_image']));
		$is_timer_stop = ($is_type == 1) ? kplayer_array_value($kplayer_array, 5) : strtolower(trim($value['bo_timer_stop']));
		$is_timer_value = ($is_type == 1) ? kplayer_array_value($kplayer_array, 6) : strtolower(trim($value['bo_timer_value']));
	}
	if ($mode_type == "audio"){
		$is_two_lyrics = ($is_type == 1) ? kplayer_array_value($kplayer_array, 7) : strtolower(trim($value['bo_two_lyrics']));
		$two_lyrics_Mode = ($is_type == 1) ? kplayer_array_value($kplayer_array, 8) : strtolower(trim($value['bo_lyrics_mode']));
		$two_lyrics_color1 = ($is_type == 1) ? kplayer_array_value($kplayer_array, 9) : strtolower(trim($value['bo_lyrics_color1']));
		$two_lyrics_color2 = ($is_type == 1) ? kplayer_array_value($kplayer_array, 10) : strtolower(trim($value['bo_lyrics_color2']));
	}else if ($mode_type == "video"){
		$is_video_resize = ($is_type == 1) ? kplayer_array_value($kplayer_array, 7) : strtolower(trim($value['bo_video_resize']));
	}
	
	if (!$media_type || !($media_type && $media_type == $mode_type)){
		$alert_str .= "[플레이어 미디어 타입]{$type}";
	}
	if (!$kplayer_skin){
		$alert_str .= "[플레이어 스킨]{$type}";
	}
	if (!$is_album || !($is_album && ($is_album == "y" || $is_album == "n"))){
		$alert_str .= "[플레이어 앨범 사용]{$type}";
	}
	if (!$is_album_level || !($is_album_level && ($is_album_level == "2" || $is_album_level == "3" || $is_album_level == "4" || $is_album_level == "5" ||
		$is_album_level == "6" || $is_album_level == "7" || $is_album_level == "8" || $is_album_level == "9" || $is_album_level == "10"))){
		$alert_str .= "[플레이어 앨범 레벨]{$type}";
	}
	if (!$is_player_level || !($is_player_level && ($is_player_level == "1" || $is_player_level == "2" || $is_player_level == "3" || $is_player_level == "4" || $is_player_level == "5" ||
		$is_player_level == "6" || $is_player_level == "7" || $is_player_level == "8" || $is_player_level == "9" || $is_player_level == "10"))){
		$alert_str .= "[플레이어 재생 실행 레벨]{$type}";
	}
	if (!$is_auto_start || !($is_auto_start && ($is_auto_start == "y" || $is_auto_start == "n"))){
		$alert_str .= "[플레이어 자동 재생]{$type}";
	}
	if ($mode_type == "audio" || $mode_type == "video"){
		if (!$is_media_mode || !($is_media_mode && ($is_media_mode == "1" || $is_media_mode == "2" || $is_media_mode == "3" || $is_media_mode == "4"))){
			$alert_str .= "[플레이어 재생 모드]{$type}";
		}
	}
	if (!$is_open_list || !($is_open_list && ($is_open_list == "y" || $is_open_list == "n"))){
		$alert_str .= "[플레이어 목록/" . ($mode_type == "radio" ? "방송국 설명" : "가사") . " OPEN 상태]{$type}";
	}
	if (!$is_view_type || !($is_view_type && ($is_view_type == "y" || $is_view_type == "n"))){
		$alert_str .= "[플레이어 목록/" . ($mode_type == "radio" ? "방송국 설명" : "가사") . " 보이기]{$type}";
	}
	if (!$is_timer_image || !($is_timer_image && ($is_timer_image == "y" || $is_timer_image == "n"))){
		$alert_str .= "[플레이어 시간 출력]{$type}";
	}
	if ($mode_type == "audio" || $mode_type == "video"){
		if (!$is_laptime || !($is_laptime && ($is_laptime == "y" || $is_laptime == "n"))){
			$alert_str .= "[플레이어 랩타임]{$type}";
		}
	}
	if ($mode_type == "radio"){
		if (!$is_timer_stop || !($is_timer_stop && ($is_timer_stop == "y" || $is_timer_stop == "n"))){
			$alert_str .= "[플레이어 시간 출력 멈추기]{$type}";
		}
		if (!$is_timer_value || !($is_timer_value && ($is_timer_value == "6001" || $is_timer_value == "60001" || $is_timer_value == "599941"))){
			$alert_str .= "[플레이어 시간 출력 멈추기 값]{$type}";
		}
	}	
	if ($mode_type == "audio"){
		if (!$is_two_lyrics || !($is_two_lyrics && ($is_two_lyrics == "y" || $is_two_lyrics == "n"))){
			$alert_str .= "[플레이어 두줄 가사 사용]{$type}";
		}
		if (!$two_lyrics_Mode || !($two_lyrics_Mode && ($two_lyrics_Mode == "1" || $two_lyrics_Mode == "2" || $two_lyrics_Mode == "3" || $two_lyrics_Mode == "4"))){
			$alert_str .= "[플레이어 두줄 가사 모드]{$type}";
		}
		if (!$two_lyrics_color1){
			$alert_str .= "[플레이어 두줄 가사 색상1]{$type}";
		}
		if (!$two_lyrics_color2){
			$alert_str .= "[플레이어 두줄 가사 색상2]{$type}";
		}
	}
	if ($mode_type == "video"){
		if (!$is_video_resize || !($is_video_resize && ($is_video_resize == "1" || $is_video_resize == "2" || $is_video_resize == "3"))){
			$alert_str .= "[플레이어 동여상 사이즈]{$type}";
		}
	}

	return $alert_str;
}


// 플레이어 스킨 디렉토리
function kplayer_skin_dir_set($skin){
	$result_array = array();

	$dirname = "./{$skin}/";
	$handle = opendir($dirname);
	while ($file = readdir($handle)){
		if($file == "."||$file == "..") continue;
		if (is_dir($dirname.$file)) $result_array[] = $file;
	}
	closedir($handle);
	sort($result_array);
	return $result_array;
}


// 설정 : 모드 - select
function kplayer_mode_select_set($name, $start_id, $end_id, $selected='1'){
	$str = "<select name=\"{$name}\">";
	for ($i = $start_id; $i < $end_id; $i++){
		$str .= "<option value=\"{$i}\"";
		if ($i == $selected) $str .= " selected";
		$str .= "> {$i} </option>";
	}
	$str .= "</select>";
	return $str;
}

// 설정 : 모드2 - select
function kplayer_mode_select2_set($name, $type, $value, $value2, $selected='1'){
	$str = "<select name=\"{$name}\">";
	$value_var = explode(",", $value);
	$value_var2 = explode(",", $value2);
	$end_id = count($value_var);

	for ($i = 0; $i < $end_id; $i++){
		$str .= "<option value=\"" . trim($value_var[$i]) . "\"";
		if (trim($value_var[$i]) == $selected) $str .= " selected";
		if ($type == 1){
			$str .= "> " . trim($value_var[$i]) . trim($value_var2[$i]) . " </option>";
		}else if ($type == 2){
			$str .= "> " . trim($value_var2[$i]) . " </option>";
		}

	}
	$str .= "</select>";
	return $str;
}


// 설정 : Y, N - select
function kplayer_bool_select_set($name, $selected='n'){
	$str = "<select name=\"{$name}\">";
	for ($i = 0; $i < 2; $i++){
		$str2 = ($i == 0) ? "n" : "y";
		$str .= "<option value=\"{$str2}\"";
		if ($str2 == strtolower($selected)) $str .= " selected";
		$str .= "> " . strtoupper($str2) . " </option>";
	}
	$str .= "</select>";
	return $str;
}


// 플레이어 설정 변수 값
function kplayer_array_value($value, $idx){
	$var_array = array();
	$var_str = "";
	if ($value){
		$var_array = explode(",", trim($value));
		$var_str = $var_array[$idx];
	}
	return $var_str;
}


// 앨범 관련
// 멤버 아이디 유, 무 체크
function kplayer_member_check($bo_table, $member){
	$row = sql_fetch(" select mb_id from g4_music_album where mb_id = '{$member}' and bo_table = '{$bo_table}' ");
	if (!$row['mb_id']){
		return false;
	}else{
		return true;
	}
}


// 멤버 아이디 없다면 등록
function kplayer_insert_member($bo_table, $member){
	sql_query(" insert into g4_music_album set mb_id = '{$member}', bo_table = '{$bo_table}', music_album = '' ");
}


// 앨범곡 인덱스 번호 등록
function kplayer_insert_album($bo_table, $write_table, $member, $checked_song){
	global $alert_count;
	$list_array = array();
	$list_array2 = array();
	$list_count = 0;
	$list_count2 = 0;
	$list_str = "";
	$list_str2 = "";
	$list_str3 = "";

	if ($checked_song){
		// 등록된 곡 유, 무 체크
		$row = sql_fetch(" select music_album from g4_music_album where mb_id = '{$member}' and bo_table = '{$bo_table}' ");
		$list = trim($row['music_album']);
		$list_array = explode(",", $list);
		$list_array2 = explode(",", $checked_song);
		$list_count = count($list_array2) - 1;

		$i = 0;
		for ($i = 0; $i < $list_count; $i++){
			if (!in_array((int)$list_array2[$i], $list_array)){
				$list_str .= $list_array2[$i] . ",";
			}else{
				$list_str2 .= $list_array2[$i] . ",";
				$list_count2++;
			}
		}

		if ($list_str){
			kplayer_update_album($bo_table, $member, $list_str . $list);
		}
		if ($list_str2){
			$list_str3 = kplayer_alert_data($list_str2, $write_table);
			$alert_count = $list_count2;
		}
	}
	return $list_str3;
}


// 등록된 곡이 있다면 에러(등록된 곡 리스트 창 출력)
function kplayer_alert_data($checked_song, $write_table){
	$list_array = array();
	$list_count = 0;
	$list_str = "";

	if($checked_song){
		$list_array = explode(",", trim($checked_song));
		$list_count = count($list_array)-1;
		$i = 0;
		for ($i = 0; $i < $list_count; $i++){
			$row = sql_fetch(" select wr_subject from {$write_table} where wr_id = {$list_array[$i]} ");
			if (!$row) continue;
			$subject = trim(stripslashes($row['wr_subject']));
			$list_str .= $subject . "<br />";
		}
	}
	return $list_str;
}


// 앨범 리스트
function kplayer_album_list($bo_table, $member, $write_table){
	$list_array = array();
	$list = array();
	$list_count = 0;

	$row = sql_fetch(" select music_album from g4_music_album where mb_id = '{$member}' and bo_table = '{$bo_table}' ");
	if($row['music_album']){
		$list_array = explode(",", trim($row['music_album']));
		$list_count = count($list_array) - 1;
		$i = 0;
		for ($i = 0; $i < $list_count; $i++){
			$row2 = sql_fetch(" select wr_subject from {$write_table} where wr_id = {$list_array[$i]} ");
			$list[$i]['wr_id'] = $list_array[$i];
			$list[$i]['subject'] = trim(stripslashes($row2['wr_subject']));
			$list[$i]['num'] = ($list_count - $i);
		}
	}
	return $list;
}


// 앨범 업데이트
function kplayer_update_album($bo_table, $member, $checked_song){
	sql_query(" update g4_music_album set music_album = '{$checked_song}' where mb_id = '{$member}' and bo_table = '{$bo_table}' ");
}


// 같은 그룹의 다른 게시판/앨범 이동(select)
// $type = 1 (게시판), 2 (앨범)
function kplayer_select_board($gr_id, $bo_table, $type, $event=''){
	global $g4, $member;
	$total_count = 0;
	$select_str = "";
	if ($gr_id){
		$sql = " select bo_table, bo_subject" . (($type == 1) ? ", bo_list_level" : ", bo_3, bo_4") . " from {$g4['board_table']} where gr_id = '{$gr_id}' order by bo_table desc ";
		$result = sql_query($sql);
	
		$select_str = "<form name=\"select_form\" method=\"get\">" . (($type == 1) ? "&nbsp;&nbsp;" : "") . "<select name=\"select_table\" {$event}>";
		while ($row = sql_fetch_array($result)){
			if ($type == 1){
				if (!($member['mb_level'] >= $row['bo_list_level'])){
					continue;
				}
			}else if ($type == 2){
				if (!$row['bo_3'] || !kplayer_array_value(strtolower(trim($row['bo_3'])), 0) || !kplayer_array_value(strtolower(trim($row['bo_3'])), 1) || 
					!$row['bo_4'] || !kplayer_array_value(strtolower(trim($row['bo_4'])), 0)){
					continue;
				}else{
					$is_album = kplayer_array_value(strtolower(trim($row['bo_3'])), 0);
					$is_album_level = kplayer_array_value(strtolower(trim($row['bo_3'])), 1);
					$is_player_level = kplayer_array_value(strtolower(trim($row['bo_4'])), 0);
					if ($is_album == "n") continue;
					if (!(($member['mb_id'] && $member['mb_level'] >= $is_album_level) && ($member['mb_level'] >= $is_player_level))){
						continue;
					}
				}
			}
			$select_str .= " <option value=\"{$row['bo_table']}\" " . (($row['bo_table'] == $bo_table) ? "selected" : "") . ">{$row['bo_subject']}</option>\n";
			$total_count++;
		}
		$select_str .= "</select></form>";

		if ($total_count <= 1) $select_str = "";
	}
	return $select_str;
}

// 두줄가사 기본색상 값
$default_color = "d9e7e7";
$bottom_color = "6f7f9b";

// 두줄 가사 table row list
function lyrics_list_row($two_lyrics){
	$lyrics_count = 0;
	$lyrics_array = array();
	$lyrics_temp = array();
	$lyrics = array();
	$lyrics_time = "";
	$lyrics_gasa = "";
	$lyrics_color = "";
	$lyrics_array = explode("@", $two_lyrics);
	$lyrics_count = count($lyrics_array) - 1;
	$i = 0;
	for ($i = 0; $i < $lyrics_count; $i++){
		$lyrics_temp[$i] = explode("|", $lyrics_array[$i]);
		$lyrics_time = $lyrics_temp[$i][0];
		$lyrics_gasa = $lyrics_temp[$i][1];
		$lyrics_color = $lyrics_temp[$i][2];
		if (!$lyrics_time || !is_numeric($lyrics_time)) continue;
		if (!$lyrics_gasa) $lyrics_gasa = "";
		if (!$lyrics_color) $lyrics_color = "";
		$lyrics_color = str_replace("#", "", $lyrics_color);

		$lyrics[$i]['time'] = $lyrics_time;
		$lyrics[$i]['gasa'] = $lyrics_gasa;
		$lyrics[$i]['color'] = $lyrics_color;
	}
	return $lyrics;
}


// 두줄 가사 data
function kplayer_lyrics_data($lyrics_time, $lyrics_gasa, $lyrics_color){
	$time = "";
	$gasa = "";
	$color = "";
	$lyrics_count = 0;
	$lyrics_str = "";
	$lyrics_count = count($lyrics_time);
	$i = 0;
	for ($i = 0; $i < $lyrics_count; $i++){
		if (!$lyrics_time[$i] || !is_numeric($lyrics_time[$i])) continue;
		$time = $lyrics_time[$i]. "|";
		$gasa = $lyrics_gasa[$i]. "|";
		$color = (!$lyrics_color[$i] ? "" : "#".$lyrics_color[$i]) . "@\n";
		
		$lyrics_str .= $time . $gasa . $color;
	}
	return $lyrics_str;
}


// 두줄 가사 업데이트
function kplayer_update_lyrics($write_table, $wr_id, $lyrics_str){
	sql_query(" update {$write_table} set wr_10 = '{$lyrics_str}' where wr_id = '{$wr_id}' ");
}


// 플레이어 플레이 리스트
// audio, video, radio
function kplayer_play_list($bo_table, $write_table, $checked_song, $media_type, $is_two_lyrics=false){
	$source = array("/\n/", "/\r/", "/\"/", "/\'/");
	$source2 = array("\n", "\r");
	$target = array("", "", "&#034;", "&#039;");
	$list_array = array();
	$list_count = 0;
	$file = array();
	$content = "";
	$link1 = "";
	$title = "";
	$url = "";
	$lyrcis = "";
	$file_path = "";
	$file_check = "";
	$link_check = 0;
	$html = 0;
	if($checked_song){
		$list_array = explode(",", trim($checked_song));
		$list_count = count($list_array)-1;
		$k = 0;
		$i = 0;
		for ($k = 0; $k < $list_count; $k++){
			if ($media_type == "audio"){
				$sql = " select wr_content, wr_link1, wr_1, wr_subject" . (($is_two_lyrics) ? ", wr_10" : "") . " from {$write_table} where wr_id = {$list_array[$k]} ";
			}else if ($media_type == "video"){
				$sql = " select wr_content, wr_link1, wr_1, wr_2 from {$write_table} where wr_id = {$list_array[$k]} ";
			}else if ($media_type == "radio"){
				$sql = " select wr_subject, wr_content, wr_link1, wr_1 from {$write_table} where wr_id = {$list_array[$k]} ";
			}
			$row = sql_fetch($sql);
			if (!$row) continue;
			if ($media_type == "audio" || $media_type == "video"){
				$content = preg_replace($source, $target, conv_content(trim(stripslashes($row['wr_content'])), $html));
				$link1 = trim(addslashes($row['wr_link1']));
				$singer = trim(addslashes($row['wr_1']));
				$title = trim(addslashes($row['wr_subject']));
			}else if ($media_type == "radio"){
				$title = trim(addslashes($row['wr_subject']));
				$content = preg_replace($source, $target, conv_content(trim(stripslashes($row['wr_content'])), $html));
				$link1 = trim(addslashes($row['wr_link1']));
				$url = trim(addslashes($row['wr_1']));
			}
			
			if ($media_type == "audio"){
				if ($is_two_lyrics){
					$lyrics = str_replace($source2, "", trim(addslashes($row['wr_10'])));
				}
			}
			$file = music_get_file($bo_table, $list_array[$k]);

			if($link1 && !$file){
				$file_path = $link1;
				$link_check = 2;
			}else if(!$link1 && $file){
				$file_path = $file;
				$link_check = 1;
			}else{
				$file_path = "";
				$link_check = 0;
			}
			
			if ($media_type == "audio"){
				if ($is_two_lyrics){
					if ($lyrics){
						$file_check = "DATA";
					}else{
						$file_check = "NO-DATA";
						$lyrics = $file_check;
					}
				}else{
					$file_check = "NO-DATA";
				}
			}

			if ($file_path){
				if ($media_type == "audio"){
					echo "SetMetaData('{$file_path}', '{$title}', '{$singer}', {$link_check}, '{$file_check}');\n";
					if ($is_two_lyrics) echo "two_lyrics[{$i}] = \"{$lyrics}\";\n";
				}else if ($media_type == "video"){
					echo "SetMetaData('{$file_path}', '{$title}', '{$singer}', {$link_check});\n";
				}else if ($media_type == "radio"){
					echo "SetMetaData('{$file_path}', '{$title}', {$link_check}, '{$url}');\n";
				}
				echo "lyrics[{$i}] = \"{$content}\";\n";
				$i++;
			}
		}
	}
}


// 업로드 파일
function music_get_file($bo_table, $checked_song){
	global $g4;
	$file = "";
	$row = sql_fetch(" select bf_file from {$g4['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$checked_song}' and bf_no = 0 ");
	$file = $row['bf_file'];
	return $file;
}


// kplayer 최신글 추출
function kplayer_latest($skin_dir='', $bo_table, $media, $rows=10, $subject_len=40){
	global $config;
	global $g4;
	global $member;

	if ($skin_dir && (strtolower($media) && (strtolower($media) == "audio" || strtolower($media) == "video" || strtolower($media) == "radio"))){
		$latest_skin_path = "{$g4['path']}/skin/latest/{$skin_dir}";
	}else{
		$latest_skin_path = "{$g4['path']}/skin/latest/basic";
	}

	$list = array();

	$sql = " select * from {$g4['board_table']} where bo_table = '{$bo_table}' ";
	$board = sql_fetch($sql);

	$tmp_write_table = $g4['write_prefix'] . $bo_table; // 게시판 테이블 전체이름
	$sql = " select * from {$tmp_write_table} where wr_is_comment = 0 order by wr_id desc limit 0, {$rows} ";

	$result = sql_query($sql);
	for ($i=0; $row = sql_fetch_array($result); $i++){
		$list[$i] = get_list($row, $board, $latest_skin_path, $subject_len);
	}
	
	ob_start();
	include "{$latest_skin_path}/latest.skin.php";
	$content = ob_get_contents();
	ob_end_clean();

	return $content;
}

// g4_music_album 앨범 테이블 생성
function kplayer_album_table($mysql_db){

	$result = sql_query(" SHOW TABLES FROM {$mysql_db} ");
	$result2 = "";
	$table = "Tables_in_" . $mysql_db;
	while ($row = sql_fetch_array($result)){
		if ($row[$table] == "g4_music_album"){
			$result2 = $row[$table];
			break;
		}
	}

	sql_free_result($result);

	if ($result2 != "g4_music_album"){
		$sql = " CREATE TABLE g4_music_album ( "
			 . " wr_num bigint(20) NOT NULL auto_increment, "
			 . " mb_id varchar(20) NOT NULL, "
			 . " bo_table varchar(20) NOT NULL, "
			 . " music_album TEXT NOT NULL, "
			 . " PRIMARY KEY  (wr_num), "
			 . " KEY index1 (mb_id, bo_table) "
			 . " ) TYPE=MyISAM ";
		sql_query($sql, FALSE);

		echo "<script language='javascript' type='text/javascript'> alert('앨범 테이블이 생성됩니다.\\n\\n확인 버튼을 클릭하세요.');</script>";
	}
}

// audio(음악) 게시판 여분필드(wr_10) type(varchar(255) ==> text) 변경
function kplayer_board_type_check($write_table){

	$result = sql_query(" SHOW FIELDS FROM {$write_table} ");
	$result2 = false;
	while ($row = sql_fetch_array($result)){
		if ($row['Field'] == "wr_10" && $row['Type'] == "varchar(255)"){
			$result2 = true;
			break;
		}
	}

	sql_free_result($result);

	if ($result2){
		sql_query(" ALTER TABLE {$write_table} CHANGE wr_10 wr_10 TEXT NOT NULL ", FALSE);
		echo "<script language='javascript' type='text/javascript'> alert('wr_10 필드가 type(varchar(255) ==> text)로 변경됩니다.\\n\\n확인 버튼을 클릭하세요.');</script>";
	}
}

?>