import mx.utils.Delegate;
import mx.controls.TextArea;

/*
This is an ActionScript2 class to load, process and format XML documents
in the rss 1 and 2 format.
Author: Steve Nelson
sn@thegoldenmean.com
January 2005
To work around Flash's security restrictions the
URL of any feed is passed to a PHP proxy script.
*/

class ProcessRSS {

	//declare public properties:
	//the TextArea component which will display the information
	public var target_txt:TextArea;
	//the address of the PHP proxy script
	public var proxyURL:String;
	
	//declare private properties:
	private var _xml:XML;
	private var items:Array;
	private var senderObj:LoadVars;
	private var loaderID:Number;
	

	//constructor
	function ProcessRSS (target:TextArea, proxy:String) {
		target_txt = target;
		proxyURL = proxy;
		_xml = new XML();
		_xml.ignoreWhite = true;
		_xml.onLoad = Delegate.create(this, onLoadEvent);
	}

	private function onLoadEvent(success:Boolean):Void {
		if (success) {
		
			//terminate any running intervals
			clearInterval(loaderID);
			
			target_txt.text = "<p>Click a headline to open that entry in a new window.</p><br>";

			//populate "items" array
			items = getNodes(_xml, "item");
			displayContent(items);
		} else {
		target_txt.text = "<p>XML failed to load.</p>";
		}
	}


	private function loadFeed(feedURL:String):Void {
	//initialization:
		//terminate any running intervals
		clearInterval(loaderID);
		
		//start with an empty array - replace any previous content
		items = new Array();
		
		//clear any previous text
		target_txt.text = "";
		
		//reset scroll position of TextArea component
		target_txt.vPosition = 0;
		
		//create LoadVars Object
		senderObj = new LoadVars();
		
		//assign a value to a property of the LoadVars Object
		senderObj.rss = feedURL;
		
		/*
		The LoadVars.sendAndLoad method conveniently accepts an XML Object as
		its target. We can send a string (url) to the PHP proxy script and
		get an XML document back. 
		*/
		senderObj.sendAndLoad(proxyURL, _xml, "GET");
		
		/*
		Use setInterval to monitor load progress every 25 milliseconds. Pass
		the XML document whose download progress you wish to monitor as the 4th
		argument. Ue of "this" in "this.loaderID" is critical for telling
		the loadingFeedback() method in what scope to find the XML object.
		Thanks to Colin Moock for the code this is based loosely on.
		*/
		this.loaderID = setInterval(this, "loadingFeedback", 25, _xml);
	}

	/*
	getNodes(): a recursive method for "walking" the XML tree searching for a
	match to a node name. This is based on an ActionScript 1 XML prototype by
	Peter Hall. The method returns an array of all XML nodes that match "name".
	It is used to populate the "items" array with all nodes in the rss document
	named "item". Note that a node of nodeType 3 is a text node (a string). We
	don't want to waste time with that now, so the script skips them.
	*/
	private function getNodes(node:XMLNode, name:String):Array {
		var nodes:Array = new Array();
		var c:XMLNode = node.firstChild;
		while (c) {
			if (c.nodeType != 3) {
				if (c.nodeName	== name) {
					nodes.push(c);
				}
			nodes = nodes.concat(getNodes(c, name));
			}
		c = c.nextSibling;
		}
	return nodes;
	}

	/*
	displayContent() is the method responsible for extracting the data I am
	interested in (the text content of title, link and description) and
	formatting it for the TextArea component.
	*/
	private function displayContent(source:Array):Void {
		var entries:Number = source.length;
		var currentNode:XMLNode;
		var tempTitle:String;
		var tempLink:String;
		var tempDescription:String;
		for (var i:Number = 0; i<entries; i++){
			currentNode = source[i];
			tempTitle = extractContent(currentNode, "title");
			tempLink = extractContent(currentNode, "link");
			tempDescription = extractContent(currentNode, "description");
			var oneEntry:String = "<headline><a href='"+
								tempLink+"' target='_blank'>"+tempTitle+
								"</a></headline><p>"+
								tempDescription+"</p><br>";
			target_txt.text += oneEntry;
		}
	}

	/*
	extractContent() is a modified version of getNodes(). Like getNodes(),
	it searches the source node recursively for a match to "name", but what it
	returns when it does find a match is the text content of that node.
	*/
	private function extractContent (source:XMLNode, name:String):String {
		var nodeTxt:String = "";
		var c:XMLNode = source.firstChild;
	
		while (c) {
			if (c.nodeType != 3) {
				if (c.nodeName == name) {
					nodeTxt = c.firstChild.nodeValue;		
				}
				nodeTxt += extractContent(c, name);
			}
			c = c.nextSibling;
		}
		return nodeTxt;
	}
	
	//the progress monitor called by setInterval
	private function loadingFeedback(xmlObj:XML):Void {
		var amtLoaded:Number = xmlObj.getBytesLoaded();
		if (amtLoaded <= 4){
		target_txt.text = "<p>Requesting Data...</p>";
		} else {
		target_txt.text = "<p>Loaded: "+
						Math.floor(amtLoaded/1024)+
						" kilobytes</p>";
		}
	}

}
