<h3>Image Tracker code</h3>

The Simple Image Tracker code can be used when Javascript is disallowed. 
<br/><div class='toggleHelp' id='imageTracker' style='display:none'><a name='image'>› Display Image Tracker code </a></div>

<div class='imageTracker'>
<p>Some websites like MySpace or eBay will not allow users to add Javascript to their profile but accept HTML. In this case, you can still track visits with Piwik using the simple Image Tracker.
<br/>
<b>Note</b>: the code doesn't use Javascript so <b>Piwik will not be able to track some user information</b>
 such as search keywords, referrer websites, screen resolutions, plugin support and page titles.
</p>
<code>
&lt;!-- Piwik Image Tracker --&gt;<br/>
&lt;img src="{$piwikUrl}piwik.php?idsite={$idSite}&rec=1" style="border:0" alt="" /&gt;<br/>
&lt;!-- End Piwik --&gt;<br/>
</code>
<br/>
The following parameters can also be passed to the image URL:
<ul> 
	<li><i>rec</i> - (required) The parameter &rec=1 is required to force the request to be recorded</li>
	<li><i>idsite</i> - (required) Defines the Website ID being tracked</li>
	<li><i>action_name</i> - Defines the custom Page Title for this page view</li>
	<li><i>idgoal</i> - The request will trigger the given Goal</li>
	<li><i>urlref</i> - The Referrer URL: must be set to the referrer URL used before landing on the page containing the Image tracker. For example, in PHP this value is accessible via <pre>$_SERVER['HTTP_REFERER']</pre></li>
	<li><i>revenue</i> - Used with idgoal, defines the custom revenue for this conversion</li>
</ul>
</div>

<h3>Piwik Tracking API (Advanced users)</h3>
It is also possible to call the Piwik Tracking API using your favorite programming language. 
<br/><div class='toggleHelp' id='trackingAPI' style='display:none'><a name='image'>› Display Piwik Tracking API documentation </a></div>
<div class='trackingAPI'>
<p>
The Piwik Tracking API allows to trigger visits (page views and Goal conversions) from any environment (Desktop App, iPhone or Android app, Mobile website, etc.).
</p>

<p>We currently provide a <b>PHP client</b> to call the API from your PHP projects. 
If you would like to contribute a version of the client in another programming language (Python, Java, Ruby, Perl, etc.) please <a target='_blank' href='{$currentUrlWithoutFilename}?module=Proxy&action=redirect&url=http://dev.piwik.org/'>create a ticket</a> in our developer area (please attach the client code to the ticket).
</p><p>Follow these instructions to get started with the Tracking API:
<ul style='list-style-type:decimal;'>
<li><a href='{$currentUrlWithoutFilename}{url action=downloadPiwikTracker}' target='_blank'>Click here to download the file PiwikTracker.php</a>
</li><li>Upload the PiwikTracker.php file in the same path as your project files
</li><li>Copy the following code, then paste it onto every page you want to track.
<code>
&lt;?php <br/>
// -- Piwik Tracking API init -- <br/>
require_once "/path/to/PiwikTracker.php";<br/>
PiwikTracker::$URL = '{$piwikUrl}';<br/>
 ?&gt;
</code>
</li><li>Choose a Tracking method, then paste the code onto every page you want to track.

<ul>
<li><b>Method 1: Advanced Image Tracker</b>
<br/>
<p>The client is used to generate the tracking URL that is wrapped inside a HTML &lt;img src=''&gt; code. 
<br/>Paste this code before the &lt;/body&gt; code in your pages.
<code>
&lt;?php <br/>
// Example 1: Tracks a pageview for Website id = {$idSite}<br/>
echo '&lt;img src="'. Piwik_getUrlTrackPageView( $idSite = {$idSite}, $customTitle = 'This title will appear in the report Actions > Page titles') . '" alt="" /&gt;';<br/>
// Example 2: Triggers a Goal conversion for Website id = {$idSite} and Goal id = 2<br/>
//            $customRevenue is optional and is set to the amount generated by the current transaction (in online shops for example)<br/>
echo '&lt;img src="'. Piwik_getUrlTrackGoal( $idSite = {$idSite}, $idGoal = 2, $customRevenue = 39) . '" alt="" /&gt;';<br/>
 ?&gt;
</code>
<br/>
The Advanced Image Tracker method is similar to using the standard Javascript Tracking code. However, some user settings are not detected (resolution, local time, plugins and cookie support).
</p>
 
 </li>
 <li><b>Method 2: HTTP Request</b>
 <br/>
<p>You can also query the Piwik Tracker API remotely via HTTP. 
This is useful for environment where you can't execute HTML nor Javascript.
<br/>Paste this code anywhere in your code where you wish to track a user interaction.
 
<code>
&lt;?php <br/>
$piwikTracker = new PiwikTracker( $idSite = {$idSite} );<br/>
// You can manually set the visitor details (resolution, time, plugins, etc.)  <br/>
// See all other ->set* functions available in the PiwikTracker.php file<br/>
$piwikTracker->setResolution(1600, 1400);<br/><br/>
// Sends Tracker request via http<br/>
$piwikTracker->doTrackPageView('Document title of current page view');<br/><br/>
// You can also track Goal conversions<br/>
$piwikTracker->doTrackGoal($idGoal = 1, $revenue = 42);<br/>
 ?&gt;
</code>
</p>
</li></ul>
</li>
</ul>
</p>
{if !isset($calledExternally) || !$calledExternally}
	<p>
	Read more about the Piwik Tracking API <a href='{$currentUrlWithoutFilename}?module=Proxy&action=redirect&url=http://piwik.org/docs/tracking-api/' target='_blank'>in the documentation</a>
	</p>
{/if}
</div>
