<?
/**
 * Bechu-Basic Skin for Gnuboard4
 *
 * Copyright (c) 2008 Choi Jae-Young <www.miwit.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

include_once("$board_skin_path/mw.lib/mw.skin.basic.lib.php");

// 실명인증 & 성인인증
if (($mw_basic[cf_kcb_read] || $write[wr_kcb_use]) && !is_okname()) {
    check_okname();
} else {

$mw_membership = array();
$mw_membership_icon = array();

if ($mw_basic[cf_read_level] && $write[wr_read_level] && $write[wr_read_level] > $member[mb_level]) {
    alert("글을 읽을 권한이 없습니다.");
}

// 호칭
if (strlen(trim($mw_basic[cf_name_title]))) {
    $view[name] = str_replace("<span class='member'>{$view[wr_name]}</span>", "<span class='member'>{$view[wr_name]} {$mw_basic[cf_name_title]}</span>", $view[name]);
}

// 링크로그
if ($mw_basic[cf_link_log])  {
    for ($i=1; $i<=$g4['link_count']; $i++)
    {
        $view['link'][$i] = set_http(get_text($view["wr_link{$i}"]));
        $view['link_href'][$i] = "$board_skin_path/link.php?bo_table=$board[bo_table]&wr_id=$view[wr_id]&no=$i" . $qstr;
        $view['link_hit'][$i] = (int)$view["wr_link{$i}_hit"];
    }
}

// 멤버쉽 아이콘
if (function_exists("mw_cash_membership_icon"))
{
    if (!in_array($view[mb_id], $mw_membership)) {
        $mw_membership[] = $view[mb_id];
        $mw_membership_icon[$view[mb_id]] = mw_cash_membership_icon($view[mb_id]);
        $view[name] = $mw_membership_icon[$view[mb_id]].$view[name];
    } else {
        $view[name] = $mw_membership_icon[$view[mb_id]].$view[name];
    }
}

if ($view[wr_anonymous]) {
    $view[name] = "익명";
    $view[wr_name] = $view[name];
}

// is_notice 그누보드 버그 보완
$view[is_notice] = preg_match("/(^|[\r\n]){$wr_id}($|[\r\n])/",$board[bo_notice]); 

if ($mw_basic[cf_must_notice] && $view[is_notice]) // 공지 읽기 필수
{
    sql_query("insert into $mw[must_notice_table] set bo_table = '$bo_table', wr_id = '$wr_id', mb_id = '$member[mb_id]', mu_datetime = '$g4[time_ymdhis]'", false);
}

// 파일 출력
ob_start();
$cf_img_1_noview = $mw_basic[cf_img_1_noview];
for ($i=0; $i<=$view[file][count]; $i++) {
    if ($cf_img_1_noview && $view[file][$i][view]) {
        $cf_img_1_noview = false;
        continue;
    }
    if ($view[file][$i][view])
    {
        // 원본 강제 리사이징
        if ($mw_basic[cf_original_width] && $mw_basic[cf_original_height]) {
            if ($view[file][$i][image_width] > $mw_basic[cf_original_width] || $view[file][$i][image_height] > $mw_basic[cf_original_height]) {
                $file = "$file_path/{$view[file][$i][file]}";
                mw_make_thumbnail($mw_basic[cf_original_width], $mw_basic[cf_original_height], $file, $file, true);
                if ($mw_basic[cf_watermark_use]) mw_watermark_file($file);
                $size = getImageSize($file);
                $view[file][$i][image_width] = $size[0];
                $view[file][$i][image_height] = $size[1];
                sql_query("update $g4[board_file_table] set bf_width = '$size[0]', bf_height = '$size[1]',
                    bf_filesize = '".filesize($file)."'
                    where bo_table = '$bo_table' and wr_id = '$wr_id' and bf_file = '{$view[file][$i][file]}'");
            }
        }
         // 이미지 크기 조절
        if ($board[bo_image_width] < $view[file][$i][image_width]) {
            $img_width = $board[bo_image_width];
        } else {
            $img_width = $view[file][$i][image_width];
        }
        $view[file][$i][view] = str_replace("<img", "<img width=\"{$img_width}\"", $view[file][$i][view]);

        // 워터마크 이미지 출력
        if ($mw_basic[cf_watermark_use]) {
            preg_match("/src='([^']+)'/iUs", $view[file][$i][view], $match);
            $watermark_file = mw_watermark_file($match[1]);
            $view[file][$i][view] = str_replace($match[1], $watermark_file, $view[file][$i][view]);
        }

	if ($mw_basic[cf_exif]) {
	    $view[file][$i][view] = str_replace("image_window(this)", "show_exif($i, this, event)", $view[file][$i][view]);
	    $view[file][$i][view] = str_replace("title=''", "title='클릭하면 메타데이터를 보실 수 있습니다.'", $view[file][$i][view]);
        } else if($mw_basic[cf_no_img_ext]) { // 이미지 확대 사용 안함
	    $view[file][$i][view] = str_replace("onclick='image_window(this);'", "", $view[file][$i][view]);
	    $view[file][$i][view] = str_replace("style='cursor:pointer;'", "", $view[file][$i][view]);
	} else {
	    $view[file][$i][view] = str_replace("onclick='image_window(this);'", 
		"onclick='mw_image_window(this, {$view[file][$i][image_width]}, {$view[file][$i][image_height]});'", $view[file][$i][view]);
	    // 제나빌더용 (그누보드 원본수정으로 인해 따옴표' 가 없음;)
	    $view[file][$i][view] = str_replace("onclick=image_window(this);", 
		"onclick='mw_image_window(this, {$view[file][$i][image_width]}, {$view[file][$i][image_height]});'", $view[file][$i][view]); 
	}
        echo $view[file][$i][view] . "<br/><br/>";
    }
}
$file_viewer = ob_get_contents();
ob_end_clean();

// 웹에디터 첨부 이미지 워터마크 처리
if ($mw_basic[cf_watermark_use])
    $view[content] = mw_create_editor_image_watermark($view[content]);

if (!$mw_basic[cf_zzal] && !strstr($view[content], "{이미지:"))// 파일 출력  
    $view[content] = $file_viewer . $view[content]; 

if ($write[wr_singo] && $write[wr_singo] >= $mw_basic[cf_singo_number] && $mw_basic[cf_singo_write_block]) {
    $content = " <div class='singo_info'> 신고가 접수된 게시물입니다. (신고수 : $write[wr_singo]회)<br/>";
    $content.= " <span onclick=\"btn_singo_view({$view[wr_id]})\" class='btn_singo_block'>여기</span>를 클릭하시면 내용을 볼 수 있습니다.";
    if ($is_admin == "super")
        $content.= " <span class='btn_singo_block' onclick=\"btn_singo_clear({$view[wr_id]})\">[신고 초기화]</span> ";
    $content.= " </div>";
    $content.= " <div id='singo_block_{$view[wr_id]}' class='singo_block'> {$view[content]} </div>";

    $view[content] = $content;
}

@include($mw_basic[cf_include_view_top]);

// 컨텐츠샵 멤버쉽
if (function_exists("mw_cash_is_membership")) {
    $is_membership = @mw_cash_is_membership($member[mb_id], $bo_table, "mp_view");
    if ($is_membership == "no")
        ;
    else if ($is_membership != "ok")
        mw_cash_alert_membership($is_membership);
        //alert("$is_membership 회원만 이용 가능합니다.");
}

// 관리자라면 CheckBox 보임
$is_checkbox = false;
if ($member[mb_id] && ($is_admin == "super" || $group[gr_admin] == $member[mb_id] || $board[bo_admin] == $member[mb_id])) 
    $is_checkbox = true;

// 링크게시판
if ($mw_basic[cf_link_board] && !$is_admin && $view[mb_id] != $member[mb_id]) {
    goto_url("board.php?bo_table=$bo_table$qstr");
}

$prev_wr_subject = str_replace("\"", "'", $prev_wr_subject);
$next_wr_subject = str_replace("\"", "'", $next_wr_subject);

if ($is_admin && strstr($write[wr_option], "secret")) {
    // 잠금 해제 버튼
    $nosecret_href = "javascript:btn_nosecret();";
} else if ($is_admin) {
    // 잠금 버튼
    $secret_href = "javascript:btn_secret();";
}

// 파일로그
if ($mw_basic[cf_download_log] && $is_admin) {
    $download_log_href = "javascript:btn_download_log()";
}

// 링크로그
if ($mw_basic[cf_link_log] && $is_admin) {
    $link_log_href = "javascript:btn_link_log()";
}


// 로그버튼
if ($mw_basic[cf_post_history] && $member[mb_level] >= $mw_basic[cf_post_history_level]) {
    $history_href = "javascript:btn_history($wr_id)";
}

// 신고 버튼
if ($mw_basic[cf_singo]) {
    $singo_href = "javascript:btn_singo($wr_id, $wr_id)";
}

// 인쇄 버튼
if ($mw_basic[cf_print]) {
    $print_href = "javascript:btn_print()";
}

// 쓰기버튼 항상 출력
if ($mw_basic[cf_write_button])
    $write_href = "./write.php?bo_table=$bo_table";

// 글쓰기 버튼에 분류저장
if ($sca && $write_href)
    $write_href .= "&sca=".urlencode($sca);

// 글쓰기 버튼 공지
if ($write_href && $mw_basic[cf_write_notice]) {
    $write_href = "javascript:btn_write_notice('$write_href');";
}

// 스킨설정버튼
$config_href = "javascript:mw_config()";

// RSS 버튼
$rss_href = "";
if ($board[bo_use_rss_view])
    $rss_href = "./rss.php?bo_table=$bo_table";

$view[rich_content] = preg_replace("/{이미지\:([0-9]+)[:]?([^}]*)}/ie", "view_image(\$view, '\\1', '\\2')", $view[content]);

if ($mw_basic[cf_no_img_ext]) { // 이미지 확대 사용 안함
    $view[rich_content] = preg_replace("/name='target_resize_image\[\]' onclick='image_window\(this\)'/iUs", "", $view[rich_content]);
} else {
    // 웹에디터 이미지 클릭시 원본 사이즈 조정
    $data = $view[rich_content];
    $path = $size = null;
    preg_match_all("/<img\s+name='target_resize_image\[\]' onclick='image_window\(this\)'.*src=\"(.*)\"/iUs", $data, $matchs);
    for ($i=0; $i<count($matchs[1]); $i++) {
        $match = $matchs[1][$i];
        $no_www = str_replace("www.", "", $g4[url]);
        if (strstr($match, $g4[url])) {
            $path = str_replace($g4[url], $g4[path], $match);
        } elseif (strstr($match, $no_www)) {
            $path = str_replace($no_www, $g4[path], $match);
        } elseif (substr($match, 0, 1) == "/") {
            $path = $_SERVER[DOCUMENT_ROOT].$match;
        //} else { $path = $match;
        }
        if ($path)
            $size = @getimagesize($path);
        if ($size[0] && $size[1]) {
            $match = str_replace("/", "\/", $match);
            $match = str_replace(".", "\.", $match);
            $match = str_replace("+", "\+", $match);
            $pattern = "/(onclick=[\'\"]{0,1}image_window\(this\)[\'\"]{0,1}) (.*)(src=\"$match\")/iU";
            $replacement = "onclick='mw_image_window(this, $size[0], $size[1])' $2$3";
            if ($size[0] > $board[bo_image_width])
                $replacement .= " width=\"$board[bo_image_width]\"";
            $data = @preg_replace($pattern, $replacement, $data);
        }
    }
    $view[rich_content] = $data;
}

// 추천링크 방지
$view[rich_content] = preg_replace("/bbs\/good\.php\?/i", "#", $view[rich_content]);

$view[rich_content] = mw_set_sync_tag($view[rich_content]);

// 조회수, 추천수, 비추천수 컴마
if ($mw_basic[cf_comma]) {
    $view[wr_hit] = number_format($view[wr_hit]);
    $view[wr_good] = number_format($view[wr_good]);
    $view[wr_nogood] = number_format($view[wr_nogood]);
}

// 컨텐츠샵
$mw_price = "";
if ($mw_basic[cf_contents_shop] == "1") {
    if (!$view[wr_contents_price])
	$mw_price = "무료";
    else
	$mw_price = $mw_cash[cf_cash_name] . " " . number_format($view[wr_contents_price]).$mw_cash[cf_cash_unit];
}

// 전체목록보이기 사용 에서도 이전글, 다음글 버튼 출력
if (!$prev_href || !$next_href)
{
   if ($sql_search) {
        if (trim(substr($sql_search, 0, 4)) != "and") {
            $sql_search = " and " . $sql_search;
        }
    }

    // 윗글을 얻음
    $sql = " select wr_id, wr_subject from $write_table where wr_is_comment = 0 and wr_num = '$write[wr_num]' and wr_reply < '$write[wr_reply]' $sql_search order by wr_num desc, wr_reply desc limit 1 ";
    $prev = sql_fetch($sql);
    // 위의 쿼리문으로 값을 얻지 못했다면
    if (!$prev[wr_id])     {
        $sql = " select wr_id, wr_subject from $write_table where wr_is_comment = 0 and wr_num < '$write[wr_num]' $sql_search order by wr_num desc, wr_reply desc limit 1 ";
        $prev = sql_fetch($sql);
    }

    // 아래글을 얻음
    $sql = " select wr_id, wr_subject from $write_table where wr_is_comment = 0 and wr_num = '$write[wr_num]' and wr_reply > '$write[wr_reply]' $sql_search order by wr_num, wr_reply limit 1 ";
    $next = sql_fetch($sql);
    // 위의 쿼리문으로 값을 얻지 못했다면
    if (!$next[wr_id]) {
        $sql = " select wr_id, wr_subject from $write_table where wr_is_comment = 0 and wr_num > '$write[wr_num]' $sql_search order by wr_num, wr_reply limit 1 ";
        $next = sql_fetch($sql);
    }

    // 이전글 링크
    $prev_href = "";
    if ($prev[wr_id]) {
        $prev_wr_subject = get_text(cut_str($prev[wr_subject], 255));
        $prev_href = "./board.php?bo_table=$bo_table&wr_id=$prev[wr_id]&page=$page" . $qstr;
    }

    // 다음글 링크
    $next_href = "";
    if ($next[wr_id]) {
        $next_wr_subject = get_text(cut_str($next[wr_subject], 255));
        $next_href = "./board.php?bo_table=$bo_table&wr_id=$next[wr_id]&page=$page" . $qstr;
    }
}

$view[rich_content] = preg_replace_callback("/\[code\](.*)\[\/code\]/iU", "_preg_callback", $view[rich_content]);

// 리워드
if ($mw_basic[cf_reward]) {
    $reward = sql_fetch("select * from $mw[reward_table] where bo_table = '$bo_table' and wr_id = '$wr_id'");
    if ($reward[re_edate] != "0000-00-00" && $reward[re_edate] < $g4[time_ymd]) { // 날짜 지나면 종료
        sql_query("update $mw[reward_table] set re_status = '' where bo_table = '$bo_table' and wr_id = '$wr_id'");
        $reward[re_status] = '';
    }
    else
        //$reward[url] = mw_get_reward_url($reward);
        $reward[url] = "$g4[path]/plugin/reward/go.php?bo_table=$bo_table&wr_id=$wr_id";

    if ($is_member)
        $reward[script] = "window.open('$reward[url]');";
    else
        $reward[script] = "alert('로그인 후 이용해주세요.');";
}

// 분류 사용 여부
$is_category = false;
if ($board[bo_use_category]) 
{
    $is_category = true;
    $category_location = "./board.php?bo_table=$bo_table&sca=";
    $category_option = get_category_option($bo_table); // SELECT OPTION 태그로 넘겨받음
}

// 분류 선택 또는 검색어가 있다면
if (!$total_count && ($sca || $stx))
{
    $sql_search = get_sql_search($sca, $sfl, $stx, $sop);

    // 가장 작은 번호를 얻어서 변수에 저장 (하단의 페이징에서 사용)
    $sql = " select MIN(wr_num) as min_wr_num from $write_table ";
    $row = sql_fetch($sql);
    $min_spt = $row[min_wr_num];

    if (!$spt) $spt = $min_spt;

    $sql_search .= " and (wr_num between '".$spt."' and '".($spt + $config[cf_search_part])."') ";

    // 원글만 얻는다. (코멘트의 내용도 검색하기 위함)
    $sql = " select distinct wr_parent from $write_table where $sql_search ";
    $result = sql_query($sql);
    $total_count = mysql_num_rows($result);
} 
else 
{
    $sql_search = "";

    $total_count = $board[bo_count_write];
}

// 자동치환
$view[rich_content] = mw_reg_str($view[rich_content]);
$view[wr_subject] = mw_reg_str($view[wr_subject]);

// IP보이기 사용 여부
$ip = "";
$is_ip_view = $board[bo_use_ip_view];
if ($is_admin) {
    $is_ip_view = true;
    $ip = $write[wr_ip];
} else if ($view[wr_anonymous]) {
    $ip = "";
} else // 관리자가 아니라면 IP 주소를 감춘후 보여줍니다.
    $ip = preg_replace("/([0-9]+).([0-9]+).([0-9]+).([0-9]+)/", "\\1.♡.\\3.\\4", $write[wr_ip]);

// 짧은 글주소 사용 - 자체도메인
$shorten = '';
if ($mw_basic[cf_shorten])
    $shorten = "$g4[url]/$bo_table/$wr_id";

$new_time = date("Y-m-d H:i:s", $g4[server_time] - ($board[bo_new] * 3600));
$row = sql_fetch(" select count(*) as cnt from $write_table where wr_is_comment = 0 and wr_datetime >= '$new_time' ");
$new_count = $row[cnt];
?>

<link type="text/css" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.4/themes/ui-lightness/jquery-ui.css" rel="stylesheet" />
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.4/jquery-ui.min.js"></script>
<script type="text/javascript" src="<?=$board_skin_path?>/mw.js/tooltip.js"></script>

<script type="text/javascript" src="<?=$board_skin_path?>/mw.js/syntaxhighlighter/scripts/shCore.js"></script>
<script type="text/javascript" src="<?=$board_skin_path?>/mw.js/syntaxhighlighter/scripts/shBrushPhp.js"></script>
<link type="text/css" rel="stylesheet" href="<?=$board_skin_path?>/mw.js/syntaxhighlighter/styles/shCore.css"/>
<link type="text/css" rel="stylesheet" href="<?=$board_skin_path?>/mw.js/syntaxhighlighter/styles/shThemeDefault.css"/>
<script type="text/javascript">
SyntaxHighlighter.config.clipboardSwf = '<?=$board_skin_path?>/mw.js/syntaxhighlighter/scripts/clipboard.swf';
SyntaxHighlighter.all();
</script>

<link rel="stylesheet" href="<?=$board_skin_path?>/style.common.css?<?=time()?>" type="text/css">

<? if ($mw_basic[cf_source_copy]) { // 출처 자동 복사 ?>
<? $copy_url = $shorten ? $shorten : set_http("{$g4[url]}/{$g4[bbs]}/board.php?bo_table={$bo_table}&wr_id={$wr_id}"); ?>
<script type="text/javascript" src="<?=$board_skin_path?>/mw.js/autosourcing.open.compact.js"></script>
<style type="text/css">
DIV.autosourcing-stub { display:none }
DIV.autosourcing-stub-extra { position:absolute; opacity:0 }
</style>
<script type="text/javascript">
AutoSourcing.setTemplate("<p style='margin:11px 0 7px 0;padding:0'> <a href='{link}' target='_blank'> [출처] {title} - {link}</a> </p>");
AutoSourcing.setString(<?=$wr_id?> ,"<?=$config[cf_title];//$view[wr_subject]?>", "<?=$view[wr_name]?>", "<?=$copy_url?>");
AutoSourcing.init( 'view_%id%' , true);
</script>
<? } ?>

<!-- 게시글 보기 시작 -->
<table width="<?=$width?>" align="center" cellpadding="0" cellspacing="0"><tr><td id=mw_basic>

<? @include_once($mw_basic[cf_include_head]); ?>

<? include_once("$board_skin_path/mw.proc/mw.list.hot.skin.php"); ?>

<!-- 분류 셀렉트 박스, 게시물 몇건, 관리자화면 링크 -->
<table width="100%">
<tr height="25">
    <td width="30%">
        <form name="fcategory_view" method="get" style="margin:0;">
        <? if ($is_category && !$mw_basic[cf_category_tab]) { ?>
            <select name=sca onchange="location='<?=$category_location?>'+this.value;">
            <option value=''>전체</option>
            <?=$category_option?>
            </select>
        <? } ?>
        </form>
    </td>
    <td align="right">
        <span class=mw_basic_total>총 게시물 <?=number_format($total_count)?>건, 최근 <?=number_format($new_count)?> 건</span>
        <a style="cursor:pointer" class="tooltip"
            title="읽기:<?=$board[bo_read_point]?>,
            쓰기:<?=$board[bo_write_point]?><?
            if ($mw_basic[cf_contents_shop_write]) { echo " ($mw_cash[cf_cash_name]$mw_basic[cf_contents_shop_write_cash]$mw_cash[cf_cash_unit])"; } ?>,
            댓글:<?=$board[bo_comment_point]?>,
            다운:<?=$board[bo_download_point]?>"><!--
        --><img src='<?=$board_skin_path?>/img/btn_info.gif' border=0 align=absmiddle></a>
        <? if ($rss_href) { ?><a href='<?=$rss_href?>'><img src='<?=$board_skin_path?>/img/btn_rss.gif' border=0 align=absmiddle></a><?}?>
        <? if ($is_admin == "super") { ?><a href="<?=$config_href?>"><img src="<?=$board_skin_path?>/img/btn_config.gif" title="스킨설정" border="0" align="absmiddle"></a><?}?>
        <? if ($admin_href) { ?><a href="<?=$admin_href?>"><img src="<?=$board_skin_path?>/img/btn_admin.gif" title="관리자" border="0" align="absmiddle"></a><?}?>
    </td>
</tr>
<tr><td height=5></td></tr>
</table>

<script type="text/javascript">
<?  if (!$mw_basic[cf_category_tab]) { ?>
if ('<?=$sca?>') document.fcategory_view.sca.value = '<?=urlencode($sca)?>';
<? } ?>
</script>

<? include_once("$board_skin_path/mw.proc/mw.notice.top.php") ?>

<? include_once("$board_skin_path/mw.proc/mw.search.top.php") ?>

<? include_once("$board_skin_path/mw.proc/mw.cash.membership.skin.php") ?>

<!-- 링크 버튼 -->
<?
ob_start();
?>
<table width=100%>
<tr height=35>
    <td>
        <? if ($search_href) { echo "<a href=\"$search_href\"><img src='$board_skin_path/img/btn_search_list.gif' border='0' align='absmiddle'></a> "; } ?>
        <? echo "<a href=\"$list_href\"><img src='$board_skin_path/img/btn_list.gif' border='0' align='absmiddle'></a> "; ?>

        <? if ($write_href) { echo "<a href=\"$write_href\"><img src='$board_skin_path/img/btn_write.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($reply_href) { echo "<a href=\"$reply_href\"><img src='$board_skin_path/img/btn_reply.gif' border='0' align='absmiddle'></a> "; } ?>

        <? if ($update_href) { echo "<a href=\"$update_href\"><img src='$board_skin_path/img/btn_update.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($delete_href) { echo "<a href=\"$delete_href\"><img src='$board_skin_path/img/btn_delete.gif' border='0' align='absmiddle'></a> "; } ?>

        <? //if ($good_href) { echo "<a href=\"$good_href\" target='hiddenframe'><img src='$board_skin_path/img/btn_good.gif' border='0' align='absmiddle'></a> "; } ?>
        <? //if ($nogood_href) { echo "<a href=\"$nogood_href\" target='hiddenframe'><img src='$board_skin_path/img/btn_nogood.gif' border='0' align='absmiddle'></a> "; } ?>

        <? if ($scrap_href) { echo "<a href=\"javascript:;\" onclick=\"win_scrap('$scrap_href');\"><img src='$board_skin_path/img/btn_scrap.gif' border='0' align='absmiddle'></a> "; } ?>

    </td>
    <td align=right>
        <? if ($prev_href) { echo "<input type=image src=\"$board_skin_path/img/btn_prev.gif\" onclick=\"location.href='$prev_href'\" title=\"$prev_wr_subject\" accesskey='b'>&nbsp;"; } ?>
        <? if ($next_href) { echo "<input type=image src=\"$board_skin_path/img/btn_next.gif\" onclick=\"location.href='$next_href'\" title=\"$next_wr_subject\" accesskey='n'>&nbsp;"; } ?>
    </td>
</tr>
</table>

<?
$link_buttons = ob_get_contents();
ob_end_flush();
?>

<?
if ($is_category && $mw_basic[cf_category_tab]) {
    $category_list = explode("|", $board[bo_category_list]);
?>
<div class="category_tab">
<ul>
    <li <? if (!$sca) echo "class='selected'";?>><div><a href="<?=$g4[bbs_path]?>/board.php?bo_table=<?=$bo_table?>">전체</a></div></li>
    <? for ($i=0, $m=sizeof($category_list); $i<$m; $i++) { ?>
    <li <? if (urldecode($sca) == $category_list[$i]) echo "class='selected'";?>><div><a 
        href="<?=$g4[bbs_path]?>/board.php?bo_table=<?=$bo_table?>&sca=<?=urlencode($category_list[$i])?>"><?=$category_list[$i]?></a></div></li>
    <? } ?>
</ul>
</div>
<? } ?>

<!-- 제목, 글쓴이, 날짜, 조회, 추천, 비추천 -->
<table width="100%" cellspacing="0" cellpadding="0">
<tr><td height=1 bgcolor=#2a2a2a></td></tr>
<tr>
    <td style="background-image:url(<?=$board_skin_path?>/img/board_bar.gif); background-repeat:repeat-x; height:30px; width:100%" class=mw_basic_view_subject>
        <? if ($is_category) { echo ($category_name ? "[$view[ca_name]] " : ""); } ?>
        <?=cut_hangul_last(get_text($view[wr_subject]))?> <?=$view[icon_secret]?>
        <? if ($mw_basic[cf_reward]) echo "&nbsp;<img src='$board_skin_path/img/btn_reward_$reward[re_status].gif' align='absmiddle'>"; ?>
    </td>
</tr>
<tr><td height=1 bgcolor=#2a2a2a></td></tr>
<tr>
    <td height=30 class=mw_basic_view_title>
	<? if ($mw_basic[cf_contents_shop] == "1") { // 배추 컨텐츠샵 ?>
	<strong>가격</strong> : 
	<span class="mw_basic_contents_price"><?=$mw_price?></span>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	<? } ?>
        <? if ($mw_basic[cf_attribute] != "anonymous") { ?>
        글쓴이 : 
	<span class=mw_basic_view_name> <?=$view[name]?>
        <? if ($mw_basic[cf_icon_level] && !$view[wr_anonymous]) { ?>
        <span class="icon_level<?=mw_get_level($write[mb_id])?>" style="border:1px solid #ddd;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
        <? } ?>
	<? if ($is_ip_view) { ?>
	&nbsp;(<?=$ip?>)
        <? if ($is_admin) { ?>
            <img src="<?=$board_skin_path?>/img/btn_ip.gif" align=absmiddle title='IP조회' style="cursor:pointer" onclick="btn_ip('<?=$view[wr_ip]?>')">
            <img src="<?=$board_skin_path?>/img/btn_ip_search.gif" align=absmiddle title='IP검색' style="cursor:pointer" onclick="btn_ip_search('<?=$view[wr_ip]?>')">
        <? } ?>
	<? } ?>
	</span>
        <? } ?>
        날짜 : <span class=mw_basic_view_datetime><?=substr($view[wr_datetime],0,10)." (".get_yoil($view[wr_datetime]).") ".substr($view[wr_datetime],11,5)?></span>
        조회 : <span class=mw_basic_view_hit><?=$view[wr_hit]?></span>
        <? /*if ($is_good) { ?>추천 : <span class=mw_basic_view_good><?=$view[wr_good]?></span><?}*/?>
        <? /*if ($is_nogood) { ?>비추천 : <span class=mw_basic_view_nogood><?=$view[wr_nogood]?></span><?}*/?>
        <? if ($singo_href) { ?><a href="<?=$singo_href?>"><img src="<?=$board_skin_path?>/img/btn_singo2.gif" align=absmiddle title='신고'></a><?}?>
        <? if ($print_href) { ?><a href="<?=$print_href?>"><img src="<?=$board_skin_path?>/img/btn_print.gif" align=absmiddle title='인쇄'></a><?}?>
    </td>
</tr>
<?
if ($mw_basic[cf_umz]) { // 짧은 글주소 사용 
    //if ($write[wr_umz] == "") {
    if (substr(trim($write[wr_umz]), 0, 10) != "http://umz") {
	$url = "$g4[url]/$g4[bbs]/board.php?bo_table=$bo_table&wr_id=$wr_id";
	$umz = umz_get_url($url);
	sql_query("update $write_table set wr_umz = '$umz' where wr_id = '$wr_id'");
	$view[wr_umz] = $umz;
    }
?>
<tr><td height=1 bgcolor=#2a2a2a></td></tr>
<tr>
    <td height=30 class=mw_basic_view_title>
        글주소 : <input type="text" class="umz_url" onclick="get_umz_url(this)" value="<?=$view[wr_umz]?>">
	<script type="text/javascript">
	function get_umz_url(obj) {
	    obj.select();
	    if (g4_is_ie) {
		document.selection.createRange().execCommand("copy");
		alert("글주소가 복사되었습니다.");
	    }
	}
	</script>
    </td>
</tr>

<? } ?>

<? if ($mw_basic[cf_shorten]) { ?>
<tr><td height=1 bgcolor=#2a2a2a></td></tr>
<tr>
    <td height=30 class=mw_basic_view_title>
        글주소 : <input type="text" class="shorten" onclick="get_shorten(this)" value="<?=$shorten?>">
	<script type="text/javascript">
	function get_shorten(obj) {
	    obj.select();
	    if (g4_is_ie) {
		document.selection.createRange().execCommand("copy");
		alert("글주소가 복사되었습니다.");
	    }
	}
	</script>
    </td>
</tr>
<? } ?>


<? if ($mw_basic[cf_include_file_head]) { echo "<tr><td>"; @include_once($mw_basic[cf_include_file_head]); echo "</td></tr>"; } ?>

<? if ($mw_basic[cf_file_head]) { echo "<tr><td>$mw_basic[cf_file_head]</td></tr>"; } ?>
<?
// 가변 파일
$cnt = 0;
for ($i=0; $i<count($view[file]); $i++) {
    if ($view[file][$i][source] && !$view[file][$i][view]) {
        $cnt++;
?>
<tr><td height=1 bgcolor=#2a2a2a></td></tr>
<tr>
    <td class=mw_basic_view_file>
        <a href="javascript:file_download('<?=$view[file][$i][href]?>', '<?=addslashes($view[file][$i][source])?>', '<?=$i?>');" title="<?=$view[file][$i][content]?>">
        <img src="<?=$board_skin_path?>/img/icon_file_down.gif" align=absmiddle>
        <?=$view[file][$i][source]?></a>
        <span class=mw_basic_view_file_info> (<?=$view[file][$i][size]?>), Down : <?=$view[file][$i][download]?>, <?=$view[file][$i][datetime]?></span>
    </td>
</tr>
<?
    }
}

// 링크
$cnt = 0;
for ($i=1; $i<=$g4[link_count]; $i++) {
    if ($view[link][$i]) {
        $cnt++;
        $link = cut_str($view[link][$i], 70);
?>
<tr><td height=1 bgcolor=#2a2a2a></td></tr>
<tr>
    <td class=mw_basic_view_link>
        <img src='<?=$board_skin_path?>/img/icon_link.gif' align=absmiddle>
        <a href='<?=$view[link_href][$i]?>' target=_blank><?=$link?></a>
        <span class=mw_basic_view_link_info>(<?=$view[link_hit][$i]?>)</span>
    </td>
</tr>
<?
    }
}
?>

<? if ($mw_basic[cf_file_tail]) { echo "<tr><td>$mw_basic[cf_file_tail]</td></tr>"; } ?>

<? if ($mw_basic[cf_include_file_tail]) { echo "<tr><td>"; @include_once($mw_basic[cf_include_file_tail]); echo "</td></tr>"; } ?>

<? if ($is_admin || $mw_basic[cf_contents_shop] == "1" || $history_href) { ?>
<tr><td height=1 bgcolor=#2a2a2a></td></tr>
<tr>
    <td height=40>
	<? if ($mw_basic[cf_contents_shop] == "1") { // 배추컨텐츠샵 ?>
	<script type="text/javascript" src="<?=$mw_cash[path]?>/cybercash.js"></script>
	<script type="text/javascript">
	var mw_cash_path = "<?=$mw_cash[path]?>";
	</script>
	<img src="<?=$board_skin_path?>/img/icon_cash2.gif" style="cursor:pointer;" onclick="buy_contents('<?=$bo_table?>', '<?=$wr_id?>')" align="absmiddle">
	<? } ?>

        <? ob_start(); ?>
        <? if ($history_href) { echo "<a href=\"$history_href\"><img src='$board_skin_path/img/btn_history.gif' border='0' align='absmiddle'></a> "; } ?>
	<? if ($is_admin) { ?>
        <? if ($download_log_href) { echo "<a href=\"$download_log_href\"><img src='$board_skin_path/img/btn_download_log.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($link_log_href) { echo "<a href=\"$link_log_href\"><img src='$board_skin_path/img/btn_link_log.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($copy_href) { echo "<a href=\"$copy_href\"><img src='$board_skin_path/img/btn_copy.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($move_href) { echo "<a href=\"$move_href\"><img src='$board_skin_path/img/btn_move.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($is_category) { echo "<a href=\"javascript:mw_move_cate_one();\"><img src=\"$board_skin_path/img/btn_select_cate.gif\" border=\"0\" align='absmiddle'></a> "; } ?>
        <? if ($nosecret_href) { echo "<a href=\"$nosecret_href\"><img src='$board_skin_path/img/btn_nosecret.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($secret_href) { echo "<a href=\"$secret_href\"><img src='$board_skin_path/img/btn_secret.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($is_admin) { echo "<a href=\"javascript:btn_now()\"><img src='$board_skin_path/img/btn_now.gif' border='0' align='absmiddle'></a> "; } ?>
        <? if ($is_admin && $view[mb_id] != $member[mb_id]) { 
            echo "<a href=\"javascript:btn_intercept('$view[mb_id]')\"><img src='$board_skin_path/img/btn_intercept.gif' border='0' align='absmiddle'></a> "; 
        } ?>
        <? if ($is_admin) { 
            if ($view[is_notice]) $btn_notice = '_off'; else $btn_notice = ''; 
            echo "<a href=\"javascript:btn_notice()\"><img src='$board_skin_path/img/btn_notice{$btn_notice}.gif' border='0' align='absmiddle'></a> "; 
        } ?>
	<? } ?>
        <!--<? if ($is_admin) {
            if ($view[wr_comment_hide]) $btn_comment_hide = '_no'; else $btn_comment_hide = ''; 
            echo "<img src='$board_skin_path/img/btn_comment_hide{$btn_comment_hide}.gif' onclick='btn_comment_hide()' style='cursor:pointer' align='absmiddle'>"; } ?>-->
        <? if ($is_admin == "super") { ?>
            <img src="<?=$board_skin_path?>/img/btn_member_email.gif" style="Cursor:pointer;" onclick="mw_member_email()" align="absmiddle">
        <? } ?>
        <? if ($is_admin) { 
            $row = sql_fetch("select * from $mw[popup_notice_table] where bo_table = '$bo_table' and wr_id = '$wr_id'", false);
            if ($row) { $btn_popup = '_off'; $is_popup = true; } else { $btn_popup = ''; $is_popup = false; }
            echo "<a href=\"javascript:btn_popup()\"><img src='$board_skin_path/img/btn_popup{$btn_popup}.png' border='0' align='absmiddle'></a> "; 
        } ?>
        <? $mw_admin_button = ob_get_contents(); ob_end_flush(); ?>
    </td>
</tr>
<? } ?>

<tr>
    <td class=mw_basic_view_content>
        <div id=view_<?=$wr_id?>>

        <? @include_once($mw_basic[cf_include_view_head])?>

        <?=$mw_basic[cf_content_head]?>

        <div id=view_content>

        <? if ($mw_basic[cf_reward] && $reward[url]) { // 리워드 ?>
        <style type="text/css">
        .reward_button { background:url(<?=$board_skin_path?>/img/btn_reward_click.jpg) no-repeat; width:140px; height:60px; cursor:pointer; margin:0 0 10px 0; }
        .reward_click { margin:10px 0 10px 0; font-weight:bold; }
        .reward_info { margin:0 0 30px 0; }
        </style>
        <div class="reward_button" onclick="<?=$reward[script]?>"></div>
        <div class="reward_click">↑ 위 배너를 클릭하시면 됩니다 </div>
        <div class="reward_info">
        <div class="point">적립 : <?=number_format($reward[re_point])?> P</div>
        <div class="edate">마감 : <?=$reward[re_edate]?></div>
        </div>
        <? } ?>

        <?echo $view[rich_content]; // {이미지:0} 과 같은 코드를 사용할 경우?>

        <? @include_once($mw_basic[cf_include_view])?>

        </div>

        <? if ($mw_basic[cf_zzal] && $file_viewer) { ?>
        <div class=mw_basic_view_zzal>
            <input type=button id=zzbtn value="<?=$view[wr_zzal]?> 보기" onclick="zzalview()" class=mw_basic_view_zzal_button>

            <script language=javascript>
            function zzalview()
            {
                var zzb = document.getElementById("zzb");
                var btn = document.getElementById("zzbtn");
                if (zzb.style.display == "none")
                {
                    zzb.style.display = "block";
                    btn.value = "<?=$view[wr_zzal]?> 가리기";
                    //resizeBoardImage(650);
                }
                else
                {
                    zzb.style.display = "none";
                    btn.value = "<?=$view[wr_zzal]?> 보기";
                }
            }
            </script>

            <div id=zzb style="display:none; margin-top:20px;"><?=$file_viewer?></div>
        </div>
        <? } ?>

        <!-- 테러 태그 방지용 --></xml></xmp><a href=""></a><a href=''></a>

        <? if ($mw_basic[cf_ccl] && $view[wr_ccl][by]) { ?>
        <div class=mw_basic_ccl>
        <a rel="license" href="<?=$view[wr_ccl][link]?>" title="<?=$view[wr_ccl][msg]?>" target=_blank>
        <img src="<?=$board_skin_path?>/mw.ccl/ccls_by.gif">
        <? if ($view[wr_ccl][nc] == "nc") { ?><img src="<?=$board_skin_path?>/mw.ccl/ccls_nc.gif"><? } ?>
        <? if ($view[wr_ccl][nd] == "nd") { ?><img src="<?=$board_skin_path?>/mw.ccl/ccls_nd.gif"><? } ?>
        <? if ($view[wr_ccl][nd] == "sa") { ?><img src="<?=$board_skin_path?>/mw.ccl/ccls_sa.gif"><? } ?>
        </a>
        </div>
        <? } ?>

        <? if ($good_href || $nogood_href) { // 추천, 비추천?>
            <div id="mw_good"></div>

            <script type="text/javascript">
            function mw_good_load() {
                $.get("<?=$board_skin_path?>/mw.proc/mw.good.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>", function (data) {
                    $("#mw_good").html(data);
                });
            }
            function mw_good_act(good) {
                $.get("<?=$board_skin_path?>/mw.proc/mw.good.act.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>&good="+good, function (data) {
                    alert(data);
                    mw_good_load();
                });
            }
            mw_good_load();
            </script>
        <? } ?>

        <?=$mw_basic[cf_content_tail]?>

        <? @include_once($mw_basic[cf_include_view_tail])?>

        </div>
    </td>
</tr>
<?
if ($is_signature && $signature) // 서명출력
{ 
    $is_comment_image = false;
    $comment_image = "$board_skin_path/img/noimage.gif";
    if ($mw_basic[cf_attribute] != "anonymous" && !$view[wr_anonymous] && $view[mb_id] && file_exists("$comment_image_path/{$view[mb_id]}")) {
        $comment_image = "$comment_image_path/{$view[mb_id]}";
        $is_comment_image = true;
    }

    $signature = preg_replace("/<a[\s]+href=[\'\"](http:[^\'\"]+)[\'\"][^>]+>(.*)<\/a>/i", "[$1 $2]", $signature);
    $signature = nl2br(strip_tags($signature));
    $signature = preg_replace("/\[([^\s]+) ([^\]]+)\]/i", "<a href='$1'>$2</a>", $signature);
    //$signature = htmlspecialchars($signature);
?>
<tr>
    <td class="mw_basic_view_signature">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <tr>
            <td width="70">
                <div class="line">
                <? if ($is_member && $view[mb_id] == $member[mb_id]) { ?><!--
                --><a href="javascript:mw_member_photo()" onfocus="this.blur()"><? } ?><img src="<?=$comment_image?>" 
                    style="width:58px; height:58px; border:3px solid #f2f2f2; margin:0 10px 5px 0;"></a>
                <? if ($is_member && $view[mb_id] == $member[mb_id] && !$is_comment_image && !$view[wr_anonymous]) { ?>
                <div style="margin:0 0 0 10px;"><a href="javascript:mw_member_photo()" style="font-size:11px; color:#aaa; text-decoration:none;">사진등록</a></div>
                <? } ?>
                <script type="text/javascript">
                function mw_member_photo() {
                    win_open('<?=$board_skin_path?>/mw.proc/mw.comment.image.php?bo_table=<?=$bo_table?>','comment_image','width=500,height=280');
                }
                </script>
                <?
                if ($mw_basic[cf_icon_level] && !$view[wr_anonymous] && $mw_basic[cf_attribute] != "anonymous") { 
                    $level = mw_get_level($view[mb_id]);
                    echo "<div class=\"icon_level$level\">&nbsp;</div>";
                    $exp = $icon_level_mb_point[$view[mb_id]] - $level*$mw_basic[cf_icon_level_point];
                    $per = round($exp/$mw_basic[cf_icon_level_point]*100);
                    echo "<div style=\"background:url($board_skin_path/img/level_exp_bg.gif); width:61px; height:3px; font-size:1px; line-height:1px; margin:5px 0 0 3px;\">";
                    echo "<div style=\"background:url($board_skin_path/img/level_exp_dot.gif); width:$per%; height:3px;\">&nbsp;</div>";
                    echo "</div>";
                }
                ?>
                </div>
            </td>
            <td class="content">
                <div id="signature"><table border="0" cellpadding="0" cellspacing="0"><tr><td>
                <?=$signature?>
                </td></tr></table></div>
            </td>
        </tr>
        </table>
    </td>
</tr>
<? } ?>
<?  if ($mw_basic[cf_vote]) { // 설문 ?>
<tr>
    <td class=mw_basic_view_vote>
        <div id="mw_vote"></div>

        <script type="text/javascript">
        function mw_vote_load() {
            $.get("<?=$board_skin_path?>/mw.proc/mw.vote.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>", function (data) {
                $("#mw_vote").html(data);
            });
        }
        function mw_vote_result() {
            $.get("<?=$board_skin_path?>/mw.proc/mw.vote.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>&result_view=1", function (data) {
                $("#mw_vote").html(data);
            });
        }
        function mw_vote_join() {
            var is_check = false;
            var vt_num = $("input[name='vt_num']");
            for (i=0; i<vt_num.length; i++)  {
                if (vt_num[i].checked) {
                    is_check = true;
                    break;
                }
            }
            if (!is_check) {
                alert("설문항목을 선택해주세요.");
                return;
            }
            $.get("<?=$board_skin_path?>/mw.proc/mw.vote.join.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>&vt_num="+i, function (data) {
                alert(data);
                mw_vote_load();
            });
        }
        mw_vote_load();
        </script>

    </td>
</tr>
<? } ?>

<?
if ($mw_basic[cf_sns])
{
    $view_url = "$g4[url]/$g4[bbs]/board.php?bo_table=$bo_table&wr_id=$wr_id";

    if ($mw_basic[cf_umz] && $view[wr_umz]) $sns_url = $view[wr_umz];
    else if ($mw_basic[cf_shorten]) $sns_url = $shorten;
    else $sns_url = $trackback_url;

    $sns_url = trim($sns_url);

    $me2day_url = "http://me2day.net/posts/new?new_post[body]=".urlencode(set_utf8($view[wr_subject])." - \"$sns_url\":$sns_url");
    //$twitter_url = "http://twitter.com/home?status=".urlencode(set_utf8($view[wr_subject])." - $sns_url");
    $twitter_url = "http://twitter.com/?status=".str_replace("+", " ", urlencode(set_utf8($view[wr_subject])." - $sns_url"));
    $facebook_url = "http://www.facebook.com/share.php?u=".urlencode($view_url);
    $yozm_url = "http://yozm.daum.net/api/popup/prePost?sourceid=41&link={$sns_url}&prefix=".urlencode(set_utf8($view[wr_subject]));
    $cy_url = "javascript:window.open('http://csp.cyworld.com/bi/bi_recommend_pop.php?url={$sns_url}', ";
    $cy_url.= "'recom_icon_pop', 'width=400,height=364,scrollbars=no,resizable=no');";

    $facebook_like_href = urlencode($view_url);
?>
<tr>
    <td>
        <div class="sns">
            <iframe src="http://www.facebook.com/plugins/like.php?href=<?=$facebook_like_href?>&amp;layout=button_count&amp;show_faces=true&amp;width=450&amp;action=like&amp;colorscheme=light&amp;height=21" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:100px; height:21px;" allowTransparency="true"></iframe>
            <!--<a href="http://twitter.com/share" class="twitter-share-button" data-count="horizontal">Tweet</a><script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>-->
            <a href="<?=$me2day_url?>" target="_blank" title="이 글을 미투데이로 보내기"><img 
                src="<?=$board_skin_path?>/img/send_me2day.png" border="0"></a>
            <a href="<?=$twitter_url?>" target="_blank" title="이 글을 트위터로 보내기"><img
                src="<?=$board_skin_path?>/img/send_twitter.png" border="0"></a>
            <a href="<?=$facebook_url?>" target="_blank" title="이 글을 페이스북으로 보내기"><img
                src="<?=$board_skin_path?>/img/send_facebook.png" border="0"></a>
            <a href="<?=$yozm_url?>" target="_blank" title="이 글을 요즘으로 보내기"><img
                src="<?=$board_skin_path?>/img/send_yozm.png" border="0"></a>
            <img src="<?=$board_skin_path?>/img/send_cy.png" border="0" onclick="<?=$cy_url?>" style="cursor:pointer" title="싸이월드 공감">
        </div>
    </td>
</tr>
<? } ?>

<? if ($mw_basic[cf_related] && $view[wr_related]) { ?>
<? $rels = mw_related($view[wr_related]); ?>
<? if (count($rels)) {?>
<? if ($mw_basic[cf_related_table]) $bo_table2 = $mw_basic[cf_related_table]; else $bo_table2 = $bo_table; ?>
<tr>
    <td class=mw_basic_view_related>
        <h3>
            관련글
            <a href="board.php?bo_table=<?=$bo_table2?>&sfl=wr_subject||wr_content,1&stx=<?=str_replace(",", " ", $view[wr_related])?>">[더보기]</a>
        </h3>
    </td>
</tr>
<tr>
    <td class="mw_basic_view_content mw_basic_view_related">
        <ul>
        <? for ($i=0; $i<count($rels); $i++) { ?>
        <li> <a href="<?=$rels[$i][href]?>">[<?=substr($rels[$i][wr_datetime], 0, 10)?>] <?=$rels[$i][subject]?> <?=$rels[$i][comment]?></a> </li>
        <? } ?>
        </ul>
    </td>
</tr>
<? } ?>
<? } ?>

<? if ($mw_basic[cf_latest]) { ?>
<? $latest = mw_view_latest(); ?>
<? if (count($latest)) {?>
<tr>
    <td class=mw_basic_view_latest>
        <h3>
            <?=$view[name]?> 님의 <?=$board[bo_subject]?> 최신글
            <a href="board.php?bo_table=<?=$bo_table?>&sfl=mb_id,1&stx=<?=$write[mb_id]?>">[더보기]</a>
        </h3>
    </td>
</tr>
<tr>
    <td class="mw_basic_view_content mw_basic_view_latest">
        <ul>
        <? for ($i=0; $i<count($latest); $i++) { ?>
        <li> <a href="<?=$latest[$i][href]?>">[<?=substr($latest[$i][wr_datetime], 0, 10)?>] <?=$latest[$i][subject]?> <?=$latest[$i][comment]?></a> </li>
        <? } ?>
        </ul>
    </td>
</tr>
<? } ?>
<? } ?>



</table>
<? if ($is_admin) { ?>
<div style="padding:10px 0 0 0;">
<?=$mw_admin_button?>
</div>
<? } ?>
<br>

<!-- if (!$view[wr_comment_hide]) include_once("./view_comment.php"); // 코멘트 입출력 -->

<?=$link_buttons?>

<? @include_once($mw_basic[cf_include_tail]); ?>

</td></tr></table><br>

<? if ($mw_basic[cf_exif]) { ?>
<script type="text/javascript">
function show_exif(no, obj, event) {
    var url = "<?=$board_skin_path?>/mw.proc/mw.exif.show.php";

    if (g4_is_ie) {
	x = window.event.clientX; 
	y = window.event.clientY + document.body.scrollTop;
    } else {
	x = event.clientX;
	y = event.clientY + document.body.scrollTop;
    }

    $.post (url, { bo_table:'<?=$bo_table?>', wr_id:'<?=$wr_id?>', bf_no:no }, function (req) {
            var exif = document.getElementById("exif-info");
            exif.style.left = x;
            exif.style.top = y;
            exif.style.display = "block";
            exif.innerHTML = req;
            exif.onclick = function () { this.style.display = "none"; }
	}
    );
}
</script>
<style type="text/css">
#exif-info { display:none; position:absolute; width:350px; height:200px; }
#exif-info { cursor:pointer; color:#bfbfbf;  }
#exif-info { background:url(<?=$board_skin_path?>/img/exif.png) no-repeat; }
*html #exif-info { background:; filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='<?=$board_skin_path?>/img/exif.png',sizingMethod='crop'); }
#exif-info table { margin:55px 0 0 20px; }
#exif-info td { color:#ddd; height:18px;  }
</style>

<div id="exif-info" title='클릭하면 창이 닫힙니다.'></div>
<? } ?>

<? if ($download_log_href) { ?>
<script type="text/javascript">
function btn_download_log() {
    win_open("<?=$board_skin_path?>/mw.proc/mw.download.log.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>", "mw_download_log", "width=500, height=300, scrollbars=yes");
}
</script>
<? } ?>

<? if ($link_log_href) { ?>
<script type="text/javascript">
function btn_link_log() {
    win_open("<?=$board_skin_path?>/mw.proc/mw.link.log.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>", "mw_link_log", "width=500, height=300, scrollbars=yes");
}
</script>
<? } ?>

<? if ($history_href) { ?>
<script type="text/javascript">
function btn_history(wr_id) {
    win_open("<?=$board_skin_path?>/mw.proc/mw.history.list.php?bo_table=<?=$bo_table?>&wr_id=" + wr_id, "mw_history", "width=500, height=300, scrollbars=yes");
}
</script>
<? } ?>

<? if ($singo_href) { ?>
<script type="text/javascript">
function btn_singo(wr_id, parent_id) {
    //if (confirm("이 게시물을 정말 신고하시겠습니까?")) {
    //hiddenframe.location.href = "<?=$board_skin_path?>/mw.proc/mw.btn.singo.php?bo_table=<?=$bo_table?>&wr_id=" + wr_id + "&parent_id=" + parent_id;
    win_open("<?=$board_skin_path?>/mw.proc/mw.btn.singo.php?bo_table=<?=$bo_table?>&wr_id=" + wr_id + "&parent_id=" + parent_id, "win_singo", "width=500,height=300,scrollbars=yes");
    //}
}
function btn_singo_view(wr_id) {
    var id = "singo_block_" + wr_id;

    if (document.getElementById(id).style.display == 'block')
        document.getElementById(id).style.display = 'none';
    else
        document.getElementById(id).style.display = 'block';
}

function btn_singo_clear(wr_id) {
    if (confirm("정말 초기화 하시겠습니까?")) {
        $.get("<?=$board_skin_path?>/mw.proc/mw.btn.singo.clear.php?bo_table=<?=$bo_table?>&wr_id="+wr_id, function(msg) {
            alert(msg);
        });
    }
}
</script>
<? } ?>

<? if ($print_href) { ?>
<script type="text/javascript">
function btn_print() {
    win_open("<?=$board_skin_path?>/mw.proc/mw.print.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>", "print", "width=800,height=600,scrollbars=yes");
}
</script>
<? } ?>



<? if ($secret_href || $nosecret_href) { ?>
<script type="text/javascript">
function btn_secret() {
    if (confirm("이 게시물을 비밀글로 설정하시겠습니까?")) {
        hiddenframe.location.href = "<?=$board_skin_path?>/mw.proc/mw.btn.secret.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>";
    }
}
function btn_nosecret() {
    if (confirm("이 게시물의 비밀글 설정을 해제하시겠습니까?")) {
        hiddenframe.location.href = "<?=$board_skin_path?>/mw.proc/mw.btn.secret.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>&flag=no";
    }
}

</script>
<? } ?>

<? if ($is_admin) { ?>
<script type="text/javascript">
function btn_now() {
    var renum = 0;
    if (confirm("이 게시물의 작성시간을 현재로 변경하시겠습니까?")) {
        if (confirm("날짜순으로 정렬 하시겠습니까?")) renum = 1;

        $.get("<?=$board_skin_path?>/mw.proc/mw.time.now.php", { "bo_table":"<?=$bo_table?>", "wr_id":"<?=$wr_id?>", "renum":renum }, function () {
            location.reload();
        });
    }
}
function btn_intercept(mb_id) {
    win_open("<?=$board_skin_path?>/mw.proc/mw.intercept.php?mb_id=" + mb_id, "intercept", "width=500,height=300,scrollbars=yes");
}
function btn_ip(ip) {
    win_open("<?=$board_skin_path?>/mw.proc/mw.whois.php?ip=" + ip, "whois", "width=700,height=600,scrollbars=yes");
}
function btn_ip_search(ip) {
    location.href = "<?=$g4[bbs_path]?>/board.php?bo_table=<?=$bo_table?>&sfl=wr_ip&stx=" + ip;
}
function btn_notice() {
    var is_off = 0;
    <? if ($view[is_notice]) { ?>
    if (!confirm("이 공지를 내리시겠습니까?")) return;
    is_off = 1; 
    <? } else { ?>
    if (!confirm("이 글을 공지로 등록하시겠습니까?")) return;
    <? } ?>
    $.get("<?=$board_skin_path?>/mw.proc/mw.notice.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>&is_off="+is_off, function(data) {
        alert(data);
    });
}
function btn_popup() {
    var is_off = 0;
    <? if ($is_popup) { ?>
    if (!confirm("이 팝업공지를 내리시겠습니까?")) return;
    is_off = 1; 
    <? } else { ?>
    if (!confirm("이 글을 팝업공지로 등록하시겠습니까?")) return;
    <? } ?>
    $.get("<?=$board_skin_path?>/mw.proc/mw.popup.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>", function(data) {
        alert(data);
    });
}
function btn_comment_hide() {
    var is_off = 0;
    <? if (!$view[wr_comment_hide]) { ?>
    if (!confirm("이 글의 댓글을 감추시겠습니까?")) return;
    is_off = 1; 
    <? } else { ?>
    if (!confirm("이 글의 댓글을 보이시겠습니까?")) return;
    <? } ?>
    $.get("<?=$board_skin_path?>/mw.proc/mw.comment.hide.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>&is_off="+is_off, function(data) {
        alert(data);
        location.reload();
    });
}
</script>
<? } ?>

<script type="text/javascript">
function file_download(link, file, no) {
    <? if ($board[bo_download_point] < 0) { ?>if (confirm("'"+file+"' 파일을 다운로드 하시면 포인트가 차감(<?=number_format($board[bo_download_point])?>점)됩니다.\n\n포인트는 게시물당 한번만 차감되며 다음에 다시 다운로드 하셔도 중복하여 차감하지 않습니다.\n\n그래도 다운로드 하시겠습니까?"))<?}?>

    if (<?=$mw_basic[cf_download_popup]?>)
        win_open("<?=$board_skin_path?>/mw.proc/download.popup.skin.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>&no="+no, "download_popup", "width=<?=$mw_basic[cf_download_popup_w]?>,height=<?=$mw_basic[cf_download_popup_h]?>,scrollbars=yes");
    else
        document.location.href=link;
}
</script>

<script type="text/javascript" src="<?="$g4[path]/js/board.js"?>"></script>
<script type="text/javascript" src="<?="$board_skin_path/mw.js/mw_image_window.js"?>"></script>

<script type="text/javascript">
// 서명 링크를 새창으로
if (document.getElementById('signature')) {
    var target = '_blank';
    var link = document.getElementById('signature').getElementsByTagName("a");
    for(i=0;i<link.length;i++) {
        link[i].target = target;
    }
}
</script>

<? if ($mw_basic[cf_write_notice]) { ?>
<script type="text/javascript">
// 글쓰기버튼 공지
function btn_write_notice(url) {
    var msg = "<?=$mw_basic[cf_write_notice]?>";
    if (confirm(msg))
	location.href = url;
}
</script>
<? } ?>

<? if ($mw_basic[cf_link_blank]) { // 본문 링크를 새창으로 ?>
<script type="text/javascript">
if (document.getElementById('view_content')) {
    var target = '_blank';
    var link = document.getElementById('view_content').getElementsByTagName("a");
    for(i=0;i<link.length;i++) {
        link[i].target = target;
    }
}
</script>
<? } ?>

<? if ($mw_basic[cf_source_copy]) { // 출처 자동 복사 ?>
<script type="text/javascript">
function mw_copy()
{
    if (window.event)
    {
        window.event.returnValue = true;
        window.setTimeout('mw_add_source()', 10);
    }
}
function mw_add_source()
{
    if (window.clipboardData) {
        txt = window.clipboardData.getData('Text');
        txt = txt + "\r\n[출처 : <?=$g4[url]?>]\r\n";
        window.clipboardData.setData('Text', txt);
    }
}
//document.getElementById("view_content").oncopy = mw_copy;

</script>
<? } ?>

<? if ($is_admin == "super") { ?>
<script type="text/javascript">
function mw_config() {
    win_open("<?=$board_skin_path?>/mw.adm/mw.config.php?bo_table=<?=$bo_table?>", "config", "width=960, height=700, scrollbars=yes");
}
function mw_member_email() {
    if (!confirm("이 글을 회원메일로 등록하시겠습니까?")) return false;
    $.get("<?=$board_skin_path?>/mw.proc/mw.member.email.php?bo_table=<?=$bo_table?>&wr_id=<?=$wr_id?>", function (data) {
        if (confirm(data)) location.href = "<?=$g4[admin_path]?>/mail_list.php";
    });
}
</script>
<? } ?>

<? if ($is_category) { ?>
<script type="text/javascript">
// 선택한 게시물 분류 변경
function mw_move_cate_one() {
    var sub_win = window.open("<?=$board_skin_path?>/mw.proc/mw.move.cate.php?bo_table=<?=$bo_table?>&chk_wr_id[0]=<?=$wr_id?>",
        "move", "left=50, top=50, width=500, height=550, scrollbars=1");
}
</script>
<? } ?>

<script type="text/javascript">
$(document).ready (function() {
    resizeBoardImage(<?=$board[bo_image_width]?>);
});
</script>

<style type="text/css">
<?=$mw_basic[cf_css]?>
</style>

<?
// 팝업공지
$sql = "select * from $mw[popup_notice_table] where bo_table = '$bo_table' order by wr_id desc";
$qry = sql_query($sql, false);
while ($row = sql_fetch_array($qry)) {
    $row2 = sql_fetch("select wr_subject, wr_content, wr_option from $write_table where wr_id = '$row[wr_id]'");

    $html = 0;
    if (strstr($row2[wr_option], "html1"))
        $html = 1;
    else if (strstr($row2[wr_option], "html2"))
        $html = 2;

    mw_board_popup($row2[wr_subject], $row2[wr_content], $row[wr_id], $html);
}

} // 실명인증
?>
