<?
// 이 썸네일소스는 유창화님자료.
// 첨부그림화일은 물론, 링크된 그림의 섬네일도 가능하게 함
// http://sir.co.kr/bbs/board.php?bo_table=tip_php&wr_id=985
// http://sir.co.kr/bbs/board.php?bo_table=tip_php&wr_id=1087

//유창화섬네일에 필요한 디렉토리생성
$data_path = $g4['path'] . "/data/file/" . $bo_table;
$lt_path = $data_path . "/lt_file";
$thumb_path = $data_path . "/thumb";

if (!is_dir($lt_path)){
  @mkdir($lt_path, 0707);
  @chmod($lt_path, 0707);
}
if (!is_dir($thumb_path)){
  @mkdir($thumb_path, 0707);
  @chmod($thumb_path, 0707);
}

// 최신글,리스트에 필요한 소스
function extract_img($src) {

	$re = '/src[ =]+[\'"]([^\'"]+\.(?:gif|jpg|png|bmp))[\'"]/i';
	preg_match_all($re, $src, &$match, PREG_PATTERN_ORDER);
	return $match[1];
}

function get_smallimg_in_list($bo_table, $file, $num, $w, $h, $error_img, $style='', $copy_rule='width', $copy_pos='2'){

	global $g4;
	
	$temp_origine_img = "$g4[path]/data/file/$bo_table/" . urlencode($file[$num]['file']);
	
	if (empty($bo_table) || empty($file[$num]) || !is_file($temp_origine_img) || $w < 10 || $h < 10) {
	
		$temp_small = false;
	}
	else {
	
		if (empty($file[$num]['image_width']) || empty($file[$num]['image_height']) || empty($file[$num]['image_type'])) {
		
			$temp = getimagesize($temp_origine_img);
			$temp_origine_img_w = $temp[0];
			$temp_origine_img_h = $temp[1];
			$temp_origine_img_t = $temp[2];
		}
		else {
	
			$temp_origine_img_w = $file[$num]['image_width'];
			$temp_origine_img_h = $file[$num]['image_height'];
			$temp_origine_img_t = $file[$num]['image_type'];
		}
			$temp_small_img_w = $w;
			$temp_small_img_h = $h;
			$temp_small_dir = "$g4[path]/data/file/$bo_table/thumb";
	
		if (!is_dir($temp_small_dir)){

			mkdir($temp_small_dir) or die('썸네일을 저장할 디렉토리를 생성할수 없습니다.');
		}
	
		$temp_small_img = "$temp_small_dir/s_{$temp_small_img_w}_{$temp_small_img_h}_{$copy_rule}_{$copy_pos}_" . urlencode($file[$num][file]);
	
		if (is_file($temp_origine_img) && !is_file($temp_small_img)) {
	
			$temp_small = make_smallimg ($temp_origine_img, $temp_origine_img_w, $temp_origine_img_h, $temp_origine_img_t, $temp_small_img, $temp_small_img_w, $temp_small_img_h, $copy_rule, $copy_pos);
		}
	
		else if (is_file($temp_origine_img) && is_file($temp_small_img)){
	
			$temp_small = true;
		}
		else {
	
			$temp_small = false;
		}
	}

	if ($temp_small) {
	
		//return "<img src='$temp_small_img' width='$temp_small_img_w' height='$temp_small_img_h' border=0 $style onError=\"this.src='$error_img';\">";
		return $temp_small_img;
	}
	else {
	
		return "<img src='$error_img' width='$w' height='$h' border=0 $style>";
	}
}


//변수가 정의 되었으면 해당 값을 반환하고 정의 되어있지 않으면 지정된 기본값을 반환합니다.
function Yvar_check(&$var, $return=''){

	return (isset($var)) ? $var : $return;
}

//변수가 정의되지 않았거나 값이 NULL값 이거나, 값이 0, false 일경우 지정된 기본값을 반환합니다.
function Yvar_empty_check(&$var, $return=''){

	return (!empty($var)) ? $var : $return;
}

//http, GET 방식의 소켓연결
function Ysockopen($url, $referer='', $accept='*/*', $contenttype='application/x-www-form-urlencoded', $cachecontrol='private', $pragma='no-cache', $connection='close'){

	if (!empty($url) && preg_match("`^http://.+`i", $url)) {
	
		$array = parse_url($url);
		$url_scheme = Yvar_check($array['scheme']);
		$url_server = Yvar_check($array['host']);
		$url_path = Yvar_check($array['path']);
		$url_query= Yvar_check($array['query']);
		$url_port = Yvar_empty_check($array['port'], 80);
	
		$fp = fsockopen($url_server, $url_port);
	
		if (empty($fp)) {
		
			return false;
		}

		fputs($fp, "GET " . $url_path . "?" . $url_query . " HTTP/1.0\n");
		if (!empty($accept)) fputs($fp, "Accept: " . $accept . "\n");
		if (!empty($contenttype)) fputs($fp, "Content-Type: " . $contenttype . "\n");
		fputs($fp, "Host: $url_server:$url_port\n");
		if (!empty($referer)) fputs($fp, "Referer: " . $referer . "\n");
		if (!empty($cachecontrol)) fputs($fp, "Cache-control: " . $cachecontrol . "\n");
		if (!empty($pragma)) fputs($fp, "Pragma: " . $pragma . "\n");
		if (!empty($connection)) fputs($fp, "Connection: " . $connection . "\n\n");
		
		return $fp;
	}
	else {
	
		return false;
	}
}

function Ysockclose(&$fp){

	if (!empty($fp)) fclose($fp);
	
		return true;
	}


//소켓으로 외부파일 통째로 텍스트로 읽어옴
function Yreadfile($url, $referer='', $accept='*/*', $contenttype='application/x-www-form-urlencoded', $cachecontrol='private', $pragma='no-cache', $connection='close') {

$fp = Ysockopen($url, $referer, $accept, $contenttype, $cachecontrol, $pragma, $connection);

	if (!empty($fp)) {
	
		$text = '';
		$check_header = false;
		
		while (!feof($fp)){
		
		$temp = fgets($fp, 1024);
		
			if ($check_header == false){
			
			
        //실제 파일이 아닌 헤더 정보인지 체크 하여 추가하지 않는다.
				if (preg_match("'^(\r)?\n$'", $temp)) {
				
					$check_header = true;
					
					continue;
				}
			}
			
			else{

        //헤더 정보가 아닌 경우에만 추가한다.
				$text .= $temp;
			}
		}
		
		Ysockclose($fp);
		
		return $text;
	}
	
	else {
	
		return '';
	}
}


//원본이미지의 경로, 크기, 높이, 타입을 알 경우에 사용가능
function make_smallimg ($src, $src_w, $src_h, $src_t, $copy, $copy_w, $copy_h, $copy_rule='width', $copy_pos='2', $force='0'){

	$src = trim($src);
	$copy = trim($copy);
	$copy_rule = trim($copy_rule);
	if (empty($copy_rule) || ($copy_rule != 'width' && $copy_rule != 'height' && $copy_rule != 'both+' && $copy_rule != 'both-')) $copy_rule = 'width';
	$copy_pos = trim($copy_pos);
	if (empty($copy_pos) || ($copy_pos != '1' && $copy_pos != '2' && $copy_pos != '3' && $copy_pos != '4' && $copy_pos != '5')) $copy_rule = '2';
	
	if (is_file($copy) && $force != '1') return true;//썸네일이 이미 생성된 상태라면 새로 만들지 않음

	if ($src_t == 1)
		$src = @imagecreatefromgif($src);
	else if ($src_t == 2)
		$src = @imagecreatefromjpeg($src);
	else if ($src_t == 3)
		$src = @imagecreatefrompng($src);
	else
		return false; // gif, jpg, png 이미지가 아님
	if (empty($src)) return false;//이미지를 읽어올수 없음
	if (empty($copy) || $copy_w < 10 || $copy_h < 10) return false; //썸네일 경로가 없거나 너비나 높이가 10보다 작음

	$src_x = 0;
	$src_y = 0;
	$copy_x = 0;
	$copy_y = 0;
	
	if ($copy_pos == '5'){//크롭없이 강제로 크기 맞춤
	
		$new_w =  $copy_w;
		$new_h = $copy_h;
	}
	else {
	
		if ($copy_rule == 'both+') {//긴쪽을 기준
		
			if ($src_w >= $src_h) $copy_rule = 'width';
			else $copy_rule = 'height';
		}
		
		else if ($copy_rule == 'both-') {//짧은쪽을 기준
	
			if ($src_w <= $src_h) $copy_rule = 'width';
			else $copy_rule = 'height';
		}

		if ($copy_rule == 'width') {//너비에 맞춤

			$rate = $src_h / $src_w;
			$new_w = $copy_w;
			$new_h = (int) ($rate * $copy_w);
		}
		else {//높이에 맞춤
	
		$rate = $src_w / $src_h;
		$new_h = $copy_h;
		$new_w = (int) ($rate * $copy_h);
		}
	
		if ($copy_rule == 'width') {//너비에 맞춤
	
			if ($copy_pos == '4') {//비율대로
		
				$copy_h = $new_h;
			}
			else {
		
				if ($new_h < $copy_h){//만들어질 썸네일 높이가 비율대로 줄여진 높이보다 클경우 가운데 위치시킴
			
					$copy_y = (int) (($copy_h - $new_h) / 2);
				}
				else {
			
					if ($copy_pos == '1' || empty($copy_pos)) {//원본에서 상단을 기준으로 가져옴
				
					 //기본값 그대로
					 }
				 
					else if ($copy_pos == '2') {//원본에서 중앙을 기준으로 가져옴
				 
						$temp_h = (int) ($copy_h / $copy_w * $src_w);
					
						$src_y = (int) (($src_h - $temp_h) / 2);
					}
					else if ($copy_pos == '3') {//원본에서 하단을 기준으로 가져옴
				
						$temp_h = (int) ($copy_h / $copy_w * $src_w);
						$src_y = $src_h - $temp_h;
					}
				}
			}
		}
		else {//높이에 맞춤
	
			if ($copy_pos == '4') {//비율대로
		
				$copy_w = $new_w;
			}
			else {
		
				if ($new_w < $copy_w){//만들어질 썸네일 너비가 비율대로 줄여진 너비보다 클경우 가운데 위치시킴
				
				$copy_x = (int) (($copy_w - $new_w) / 2);
				}
				else {
			
					if ($copy_pos == '1' || empty($copy_pos)) {//원본에서 왼쪽을 기준으로 가져옴
				
					 //기본값 그대로
					}
				 
					else if ($copy_pos == '2') {//원본에서 중앙을 기준으로 가져옴
				 
						$temp_w = (int) ($copy_w / $copy_h * $src_h);
						$src_x = (int) (($src_w - $temp_w) / 2);	
					}
				 
					else if ($copy_pos == '3') {//원본에서 오른쪽을 기준으로 가져옴
				
						$temp_w = (int) ($copy_w / $copy_h * $src_h);
						$src_x = $src_w - $temp_w;
					}
				}
			}
		}
	}

	$dst = @imagecreatetruecolor($copy_w, $copy_h);
	if (empty($dst)) return false;
	
	$background_color = @imagecolorallocate($dst, 255, 255, 255);
	if (empty($background_color)) return false;
	
	imagefilledrectangle($dst, 0, 0, $copy_w, $copy_h, $background_color);
	imagecopyresampled($dst, $src, $copy_x, $copy_y, $src_x, $src_y, $new_w, $new_h, $src_w, $src_h);
	
	imagepng($dst, $copy);
	chmod($copy, 0777);
	return true;
}



//로컬의 이미지의 섬네일을 저장, 반환값 성공 실패 여부
function make_small($src, $copy, $copy_w, $copy_h, $copy_rule='width', $copy_pos='2', $force='0'){

	$src = trim($src);
	$copy = trim($copy);
	$copy_rule = trim($copy_rule);
	if (empty($copy_rule) || ($copy_rule != 'width' && $copy_rule != 'height' && $copy_rule != 'both+' && $copy_rule != 'both-')) $copy_rule = 'width';
	$copy_pos = trim($copy_pos);
	if (empty($copy_pos) || ($copy_pos != '1' && $copy_pos != '2' && $copy_pos != '3' && $copy_pos != '4' && $copy_pos != '5')) $copy_rule = '2';
	
	if (is_file($copy) && $force != '1') return true;//썸네일이 이미 생성된 상태라면 새로 만들지 않음
	
	if (empty($src) || !is_file($src)) return false;//원본 이미지 없음
	
	$temp = @getimagesize($src);
	$src_w = $temp[0];
	$src_h = $temp[1];
	$src_t = $temp[2];
	
	if ($src_t != 1 && $src_t != 2 && $src_t != 3) return false;//읽어온 파일 타입이 gif, jpg, png 아님
	
	//썸네일 규칙에 따라 썸네일 생성
	
	$return = make_smallimg ($src, $src_w, $src_h, $src_t, $copy, $copy_w, $copy_h, $copy_rule, $copy_pos, $force);
	
	return $return;
}


//원격의 이미지의 섬네일을 저장, 반환값 성공 실패 여부
function make_small_remoteimage($image_url, $referer, $save_path, $copy, $copy_w, $copy_h, $copy_rule='width', $copy_pos='2', $force='0'){

	$image_url = trim($image_url);
	$referer = trim($referer);
	$save_path = preg_replace("`/+$`", '', trim($save_path));
	$copy = trim($copy);
	$copy_rule = trim($copy_rule);
	if (empty($copy_rule) || ($copy_rule != 'width' && $copy_rule != 'height' && $copy_rule != 'both+' && $copy_rule != 'both-')) $copy_rule = 'width';
	$copy_pos = trim($copy_pos);
	if (empty($copy_pos) || ($copy_pos != '1' && $copy_pos != '2' && $copy_pos != '3' && $copy_pos != '4' && $copy_pos != '5')) $copy_rule = '2';
	
	if (is_file($copy) && $force != '1') return true;//썸네일이 이미 생성된 상태라면 새로 만들지 않음
	
	if (empty($image_url) || !preg_match("`^http`i", $image_url)) return false;//원격이미지 주소 없음
	
	//원격이미지 주소에서 이미지 이름 뽑아냄
	preg_match("`/([^/]+)$`i", $image_url, $m);
	$image_name = trim($m[1]);
	
	if (empty($save_path)) return false;//임시저장 디렉토리 값 없음
	
	if (!is_dir($save_path)) {
	
		@mkdir($save_path);
		@chmod($save_path, 0777);
		
		if (!is_dir($save_path)) return false;//임시저장 디렉토리 생성할수 없음
	}

	if (empty($referer) || !preg_match("`^http`i", $referer)) {//리퍼러가 없을 경우에는 이미지 기본 경로를 리퍼러로 잡음
	
		preg_match("`(https?://[^/]+)/`i", $image_url, $m);
		$referer = $m[1];
	}
	
	//원격이미지 가져와서 임시저장 디렉토리에 저장
	$text = Yreadfile($image_url, $referer);
	if (empty($text)) return false;//이미지 읽어오기 실패
	
	$temp_file = $save_path . '/' . uniqid('') . '_' . $image_name;//중복되지 않는 임시파일 경로 생성
	
	$fp = @fopen ($temp_file, "w");
	@fwrite($fp, $text);
	@fclose($fp);
	@chmod ($temp_file, 0777);
	
	if (!is_file($temp_file)) return false;//파일 생성 실패
	
	$temp = @getimagesize($temp_file);
	$src_w = $temp[0];
	$src_h = $temp[1];
	$src_t = $temp[2];
	
	if ($src_t != 1 && $src_t != 2 && $src_t != 3) return false;//읽어온 파일 타입이 gif, jpg, png 아님
	
	//썸네일 규칙에 따라 썸네일 생성
	$return = make_smallimg ($temp_file, $src_w, $src_h, $src_t, $copy, $copy_w, $copy_h, $copy_rule, $copy_pos, $force);
	
	@unlink($temp_file);//섬네일 생성후 임시 파일 삭제
	
	return $return;
}


//사용법은
//make_small_remoteimage($image_url, $referer, $save_path, $copy, $copy_w, $copy_h, $copy_rule='width', $copy_pos='1', $force='0');
//순서대로
//이미지url
//리퍼러
//임시저장경로(./temp)
//썸네일 저장경로(./temp/abc.png)
//썸네일 너비
//썸네일 높이
//썸네일 생성기준 width 나 height 나 both+(너비나 높이중 긴쪽기준) 나 both-(너비나 높이중 짧은쪽기준)
//썸네일 생성 방법 1에서 5까지, 1은 상단이나 왼쪽, 2는 가운데, 3은 하단이나 오른쪽, 4는 비율대로, 5는 강제로
//기존 썸네일 있거나 없거나 강제로 생성할 경우 1
?>