<?
 //**********************************************************/
//** http://lure.oolim.net     
//** E-mail: yogialji@yahoo.co.kr
//* copyright(c) LURE　all rights reserved.
//**********************************************************/
// -------------------------------------------------------------------
// 캐시파일을 생성시 이 function이용 
// -------------------------------------------------------------------
function lure ($url) {

define("LURE_DIR", "../data/"); //경로정의	
define('CACHE_AGE', $cache_time); // 캐시타임
//=========== setup ====================================================
   $cache_time = 1800;   //초
   $cache_dir = 'LURE_CA';   
//======================================================================    
		// attempt to make the cache directory
		if ( ! file_exists( LURE_DIR . $cache_dir ) ) {
			$result = @mkdir( LURE_DIR . $cache_dir, 0707 );
           			  @chmod( LURE_DIR . $cache_dir, 0707);

			// if make failed 
			if ( ! $result ) {

			echo "디렉토리를 만들수 없습니다.'" . LURE_DIR .  $cache_dir . "'.";				
									
			}
		
		}		
								
		if ( LURE_DIR . $cache_dir != '') {
			$cache_file =  LURE_DIR . $cache_dir . '/cache_' . md5($url);
			$timedif = @(time() - filemtime($cache_file));
			if ($timedif < $cache_time) {
				// cached file is fresh enough, return cached array
				$result = unserialize(join('', file($cache_file)));
				// set 'cached' to 1 only if cached file is correct
				if ($result) $result['cached'] == 'HIT';
			} else {
		// cached file is too old, create new               
				$result =  rss_array($url);
				$serialized = serialize($result);
				if ($f = @fopen($cache_file, 'w')) {
					fwrite ($f, $serialized, strlen($serialized));
					fclose($f);
				}
				if ($result) $result['cached'] == 'STALE';
			}
		}
		// If CACHE DISABLED >> load and parse the file directly
		else {
			$result = rss_array($url);

			if ($result) $result['cached'] == 'STALE';
		}
		return $result;

	}
//===================================================================	
      //global vars
        global $g_rss_array;
      //fetch_feed
    function rss_array($url){
        global $g_rss_array;
      // empty our global array
        $g_rss_array = array();
      // if the URL looks ok
        if(preg_match("/^http:\/\/([^\/]+)(.*)$/", $url, $matches)){
            $host = $matches[1];
            $uri = $matches[2];
            $request = "GET $uri HTTP/1.0\r\n";
            $request .= "Host: $host\r\n";
			$request .= "Connection: close\r\n\r\n";
           // open the connection
              // 소켓 연결,  최대연결시간 10초로설정
			if($http = @fsockopen($host, 80, $errno, $errstr, 10)){     
          // make the request
                fwrite($http, $request);
          // read in for max 10 seconds
                $timeout = time() + 10;
                while(time() < $timeout && !feof($http)) {
                    $response .= fgets($http, 4096);
                }
          // split on two newlines
                list($header, $xml) = preg_split("/\r?\n\r?\n/", $response, 2);
          // get the status
                if(preg_match("/^HTTP\/[0-9\.]+\s+(\d+)\s+/", $header, $matches)){
                    $status = $matches[1];
                 // if 200 OK
                    if($status == 200){
                 // create the parser
        $xml_parser = xml_parser_create();
           xml_set_element_handler($xml_parser, "startElement", "endElement");
           xml_set_character_data_handler($xml_parser, "characterData");
           // parse!
           xml_parse($xml_parser, trim($xml), true) or $g_rss_array[errors][] = xml_error_string(xml_get_error_code($xml_parser)) . " at line " . xml_get_current_line_number($xml_parser);

   // free parser
    xml_parser_free($xml_parser);
      }
     else {
         $g_rss_array[errors][] = "Can't get feed: HTTP status code $status";
         }
           }
  // Can't get status from header
      else {
         $g_rss_array[errors][] = "Can't get status from header";
           }
       }

		  else { 
             echo "<B><font color=#FF5F00>현재 연결 할 수 없습니다.<br />RSS주소또는서버문제 잠시 후 다시 시도해 보세요.</font></B><br />"; 
               }
        }
        // Feed url looks wrong
        else {
            $g_rss_array[errors][] = "Invalid url: $url";
        }

	 // unset 변수들
        unset($g_rss_array[channel_title]);
        unset($g_rss_array[channel_description]);
        unset($g_rss_array[channel_lastBuildDate]);
        unset($g_rss_array[channel_language]);

		unset($g_rss_array[inside_rdf]);
        unset($g_rss_array[inside_rss]);
        unset($g_rss_array[inside_channel]);
        unset($g_rss_array[inside_item]);
        unset($g_rss_array[inside_image]);

		unset($g_rss_array[current_tag]);
        unset($g_rss_array[current_title]);
        unset($g_rss_array[current_link]);
        unset($g_rss_array[current_description]);
		unset($g_rss_array[current_pubdate]);
		unset($g_rss_array[current_dcdate]);
        unset($g_rss_array[current_category]);
        unset($g_rss_array[current_comments]);
        unset($g_rss_array[current_author]);
        unset($g_rss_array[current_source]);

        return $g_rss_array;
    }
 //this function will be called everytime a tag starts
    function startElement($parser, $name){
        global $g_rss_array;
        $g_rss_array[current_tag] = $name;
        if($name == "RSS"){
            $g_rss_array[inside_rss] = true;
        }
        elseif($name == "RDF:RDF"){
            $g_rss_array[inside_rdf] = true;
        }
        elseif($name == "CHANNEL"){
            $g_rss_array[inside_channel] = true;
            $g_rss_array[channel_title] = "";
            $g_rss_array[channel_description] = "";
            $g_rss_array[channel_lastBuildDate] = "";
            $g_rss_array[channel_language] = "";
        }
        elseif(($g_rss_array[inside_rss] and $g_rss_array[inside_channel]) or $g_rss_array[inside_rdf]){
            if($name == "ITEM"){
                $g_rss_array[inside_item] = true;
            }
            elseif($name == "IMAGE"){
                $g_rss_array[inside_image] = true;
            }
        }
    }

// this function will be called everytime there is a string between two tags
    function characterData($parser, $data){
        global $g_rss_array;
        if($g_rss_array[inside_item]){
            switch($g_rss_array[current_tag]){
                case "TITLE":
                $g_rss_array[current_title] .= $data;
                break;
                case "DESCRIPTION":
                $g_rss_array[current_description] .= $data;
                break;
                case "LINK":
                $g_rss_array[current_link] .= $data;
                break;
                case "PUBDATE":
                $g_rss_array[current_pubdate] .= $data;
                break;
                case "DC:DATE":
                $g_rss_array[current_dcdate] .= $data;
                break;
                case "CATEGORY":
                $g_rss_array[current_category] .= $data;
                break;
                case "COMMENTS":
                $g_rss_array[current_comments] .= $data;
                break;
                case "AUTHOR":
                $g_rss_array[current_author] .= $data;
                break;
                case "SOURCE":
                $g_rss_array[current_source] .= $data;
                break;
            }
        }
        elseif($g_rss_array[inside_image]){
            switch($g_rss_array[current_tag]){
                case "TITLE":
                $g_rss_array[image_title] .= $data;
                break;
                case "LINK":
                $g_rss_array[image_link] .= $data;
                break;
                case "URL":
                $g_rss_array[image_url] .= $data;
                break;
            }
		}
        elseif($g_rss_array[inside_channel]){
            switch($g_rss_array[current_tag]){
                case "TITLE":
                $g_rss_array[channel_title] .= $data;
                break;
                case "DESCRIPTION":
                $g_rss_array[channel_description] .= $data;
                break;
                case "LASTBUILDDATE":
                $g_rss_array[channel_lastBuildDate] .= $data;
                break;
                case "LANGUAGE":
                $g_rss_array[channel_language] .= $data;
                break;
            }
        }
    }

    // this function will be called everytime a tag ends
    function endElement($parser, $name){
        global $g_rss_array;
      // end of item, add complete item to array
        if($name == "ITEM"){
            $g_rss_array[items][] = array(
				title => trim($g_rss_array[current_title]), 
				link => trim($g_rss_array[current_link]), 
				description => trim($g_rss_array[current_description]), 
				pubdate => trim($g_rss_array[current_pubdate]),
				dcdate => trim($g_rss_array[current_dcdate]),
				category => trim($g_rss_array[current_category]),
				comments => trim($g_rss_array[current_comments]),
				author => trim($g_rss_array[current_author]),
				source => trim($g_rss_array[current_source])				
			);
    // reset these vars for next loop
            $g_rss_array[current_title] = "";
            $g_rss_array[current_description] = "";									
			$g_rss_array[current_link] = "";
            $g_rss_array[current_pubdate] = "";
            $g_rss_array[current_dcdate] = "";
            $g_rss_array[current_category] = "";
            $g_rss_array[current_comments] = "";
            $g_rss_array[current_author] = "";
            $g_rss_array[current_source] = "";		
			$g_rss_array[inside_item] = false;
        }
        elseif($name == "RSS"){
            $g_rss_array[inside_rss] = false;
        }
        elseif($name == "RDF:RDF"){
            $g_rss_array[inside_rdf] = false;
        }
        elseif($name == "CHANNEL"){
            $g_rss_array[channel][title] = trim($g_rss_array[channel_title]);
            $g_rss_array[channel][description] = trim($g_rss_array[channel_description]);
            $g_rss_array[channel][lastBuildDate] = trim($g_rss_array[channel_lastBuildDate]);			
            $g_rss_array[channel][language] = trim($g_rss_array[channel_language]);
			$g_rss_array[inside_channel] = false;
        }
        elseif($name == "IMAGE"){
            $g_rss_array[image][title] = trim($g_rss_array[image_title]);
            $g_rss_array[image][link] = trim($g_rss_array[image_link]);
            $g_rss_array[image][url] = trim($g_rss_array[image_url]);
            $g_rss_array[inside_image] = false;
        }
    }
?>