<?
###############################################################
# Website Thumbnail Image Generator 1.1
###############################################################
# Visit http://www.zubrag.com/scripts/ for updates
# Modified by eVerRock
###############################################################
#
# REQUIREMENTS:
# PHP 4.0.6 and GD 2.0.1 or later
# May not work with GIFs if GD2 library installed on your server
# does not support GIF functions in full
#
# Parameters that can be passed via url (if not passed will be used values which are set below):
# url - url of the target website
# x - max width
# y - max height
# q - quality (applicable only to JPG, 1 to 100, 100 - best)
###############################################################
$x = 250;
$y = 350;

$thumbnails_folder = '../../data/webshot/';
if(!is_dir($thumbnails_folder)){
	@mkdir($thumbnails_folder);
}

// thumbnails expiration time in minutes
$cache_expire_time = 60;

// quality (for jpeg only)
$image_quality = 100;

// resulting image type (1 = GIF, 2 = JPG, 3 = PNG)
$image_type = 2;

// maximum thumb side size
$max_x = 100;
$max_y = 100;

// If not equal 0 then cut original image size before resizing (in pixels).
// Long page will have bad thumbnail, its better to cut page length first.
$cut_x = 0;
$cut_y = 1024;

###############################################################################
# END OF SETTINGS. DO NOT EDIT BELOW
###############################################################################
if (isset($_REQUEST['url'])) {
  $website_url = $_REQUEST['url'];
  $website_nick = $_REQUEST['nick'];
}
else {
  die("Site URL must be specified.");
}

if ($image_type == 1) $output_format = 'gif';
if ($image_type == 2) $output_format = 'jpg';
if ($image_type == 3) $output_format = 'png';

$cached_filename = $thumbnails_folder . $website_nick . '.' . $output_format;

// See if we have cached website screenshot image (to minimize server load)
if (!file_exists($cached_filename) ) {

  // Get website image and save it on the server.
  @exec('IECapt.exe ' . escapeshellarg($website_url) . ' ' . escapeshellarg($cached_filename));

} // if (!file_exists

if (!file_exists($cached_filename)) {
  die("Thumbnail Generation Error. Thumbnail not created.");
}

/*
+------------------------------------------------------------------------+
+                          Modified by eVerRock                              +
+------------------------------------------------------------------------+
*/
$output_format = "jpg";
/*
if (isset($_REQUEST['nick'])) {
  $website_nick = $_REQUEST['nick'];
}
else {
  die("Site URL must be specified.");
}
*/

if(file_exists($cached_filename)){
		createthumb($cached_filename,$cached_filename,250,350);
}
else echo "파일이 존재하지 않습니다.<br />경로가 옳바른지, 파일이 존재하고 있는지 확인하세요.";


function createthumb($name,$filename,$new_w,$new_h)
{
	//$system=explode(".",$name);
	if (preg_match("/jpg|jpeg/",$name)){$src_img=imagecreatefromjpeg($name);}
	if (preg_match("/png/",$name)){$src_img=imagecreatefrompng($name);}
	$old_x=imageSX($src_img);
	$old_y=imageSY($src_img);
	if ($old_x > $old_y) 
	{
		$thumb_w=$new_w;
		$thumb_h=$old_y*($new_h/$old_x);
	}
	/*
	if ($old_x < $old_y) 
	{
		$thumb_w=$old_x*($new_w/$old_y);
		$thumb_h=$new_h;
	}
	*/
	if($old_x < $old_y)
	{
		$thumb_w=$new_w;
		$thumb_h=$old_y*($new_w/$old_x);
	}
	if ($old_x == $old_y) 
	{
		$thumb_w=$new_w;
		$thumb_h=$new_h;
	}
	$tmp_img=ImageCreateTrueColor($thumb_w,$thumb_h);
	imagecopyresampled($tmp_img,$src_img,0,0,0,0,$thumb_w,$thumb_h,$old_x,$old_y); 
	if (preg_match("/png/",$system[1]))
	{
		imagepng($tmp_img,$filename); 
	} else {
		imagejpeg($tmp_img,$filename); 
	}
	imagedestroy($tmp_img); 
	imagedestroy($src_img); 
}

?>