<?php
/*
 * shukuma-library ver.0.9.0
 *
 * 1. gnuboard command(function)
 * 2. skm_thumb_maker
 *
 * GPL Version 2 licenses
 * Copyright shukuma.com
 *
 * $middle_center // true, false
 * $wt_position   // t_l, t_c, t_r, m_l, m_c, m_r, b_l, b_c, b_r
 * $scale         // full, width, height, auto, scale
 * $out_exp       // gif, jpg, png
 *
 */

if(!defined('_GNUBOARD_')) exit;

$skm['board_config_table'] = $g4['table_prefix'].'skm_board_config';
$skm['skm_uploader_table'] = $g4['table_prefix'].'skm_upload';

function skm_board_set_get($bo_table){
 global $skm;
 return sql_fetch("select * from ".$skm['board_config_table']." where bo_table = '$bo_table' limit 1 ", false);
}

function skm_thumb_maker($in_file, $out_file='', $n_w=0, $n_h=0, $middle_center='true', $wt_file='', $wt_position='b_r', $wt_w=0, $wt_h=0, $wt_alpha=30, $scale='auto', $out_exp='jpg', $quality=85, $back_r=255, $back_g=255, $back_b=255, $max_area=9000000){
  if(!file_exists($in_file)) return false;
  $info = array();
  $info = @getimagesize($in_file);

  $bigsize_check_area = ($info[0] * $info[1]);
  if($bigsize_check_area <= $max_area){
     @ini_set('memory_limit', -1);
     }else{
       return false;
       }

 if(!$info[0] || !$info[1] || !$info[2]) return false;
 if($info[2] > 3 || $info[2] < 1 ) return false;

  list($in_w, $in_h, $in_type, $in_attr) = $info;
  $in_w_ori = $in_w;
  $in_h_ori = $in_h;
  if($quality > 100){
    $quality = 100;
    }else if($quality < 0){
      $quality = 0;
      }

  switch ($in_type){
    case 1:
         $in_img = @imagecreatefromgif($in_file);
         break;
    case 2:
         $in_img = @imagecreatefromjpeg($in_file);
         break;
    case 3:
         $in_img = @imagecreatefrompng($in_file);
         break;
    default:
         return false;
         break;
    }

  if(!$n_w) $n_w = $in_w;
  if(!$n_h) $n_h = $in_h;

  $w_s = $in_w / $in_h;
  $h_s = $in_h / $in_w;

  switch($scale){
    case 'full':
         $nn_w = $n_w;
         $nn_h = $n_h;
         break;
    case 'width':
         $nn_w = $n_w;
         $wid_s = $in_w / $n_w;
         if(($n_h*$wid_s)<=$in_h){
         $nn_h = $n_h;
         $in_h = $n_h*$wid_s;
         }else{
         $nn_h = $n_w * $h_s;
           }
         break;
    case 'height':
         $nn_h = $n_h;
         $hei_s = $in_h / $n_h;
         if(($n_w*$hei_s)<=$in_w){
         $nn_w = $n_w;
         $in_w = $n_w*$hei_s;
         }else{
         $nn_w = $n_h * $w_s;
           }
         break;
    case 'auto':
         $nw_s = $n_w / $n_h;
         if($w_s<=$nw_s){
            $nn_w = $n_w;
            $wid_s = $in_w / $n_w;
            if(($n_h*$wid_s)<=$in_h){
            $nn_h = $n_h;
            $in_h = $n_h*$wid_s;
            }else{
            $nn_h = $n_w * $h_s;
              }
           }else{
             $nn_h = $n_h;
             $hei_s = $in_h / $n_h;
             if(($n_w*$hei_s)<=$in_w){
             $nn_w = $n_w;
             $in_w = $n_w*$hei_s;
             }else{
             $nn_w = $n_h * $w_s;
               }
             }
         break;
    case 'scale':
    default:
         $nn_w = $n_w;
         $nn_h = $n_w * $h_s;
         if($nn_h >= $n_h){
           $nn_h = $n_h;
           $nn_w = $nn_h * $w_s;
          }
        break;
  }

  $tmp = imagecreatetruecolor($n_w, $n_h);

  $back = imagecolorallocate($tmp, $back_r, $back_g, $back_b);

  imagefilledrectangle($tmp, 0, 0, (int)$n_w, (int)$n_h, $back);

  $w_p = ($n_w - $nn_w)/2;
  $h_p = ($n_h - $nn_h)/2;

  $in_w_p = 0;
  $in_h_p = 0;
  if($middle_center=='true'){
  $in_w_p = ($in_w_ori - $in_w)/2;
  $in_h_p = ($in_h_ori - $in_h)/2;
  }

  imagecopyresampled($tmp, $in_img, (int)$w_p, (int)$h_p, (int)$in_w_p, (int)$in_h_p, (int)$nn_w, (int)$nn_h, (int)$in_w, (int)$in_h);

  if($wt_file && file_exists($wt_file)){
   $wt_info = @getimagesize($wt_file);
    if($wt_info[0] && $wt_info[1] && $wt_info[2] && $wt_w<=$nn_w && $wt_h<=$nn_h){

      switch ($wt_info[2]){
      case 1:
           $wt_img = @imagecreatefromgif($wt_file);
           break;
      case 2:
           $wt_img = @imagecreatefromjpeg($wt_file);
           break;
      case 3:
           $wt_img = @imagecreatefrompng($wt_file);
           break;
      default:
           return false;
           break;
      }

      if(!$wt_w) $wt_w = $wt_info[0];
      if(!$wt_h) $wt_h = $wt_info[1];

    $wt_tmp = imagecreatetruecolor($wt_w, $wt_h);
    $t_back = imagecolorallocate($wt_tmp, 0, 0, 0);
    imagecolortransparent($wt_tmp, $t_back);

    imagecopyresampled($wt_tmp, $wt_img, 0, 0, 0, 0, (int)$wt_w, (int)$wt_h, (int)$wt_info[0], (int)$wt_info[1]);

      switch ($wt_position){
      case 't_l':
           $wt_w_p = $w_p;
           $wt_h_p = $h_p;
           break;
      case 't_c':
           $wt_w_p = ($n_w/2) - ($wt_w/2);
           $wt_h_p = $h_p;
           break;
      case 't_r':
           $wt_w_p = $nn_w - $wt_w - $w_p;
           $wt_h_p = $h_p;
           break;
      case 'm_l':
           $wt_w_p = $w_p;
           $wt_h_p = ($n_h/2)-($wt_h/2);
           break;
      case 'm_c':
           $wt_w_p = ($n_w/2) - ($wt_w/2);
           $wt_h_p = ($n_h/2)-($wt_h/2);
           break;
      case 'm_r':
           $wt_w_p = $n_w - $wt_w - $w_p;
           $wt_h_p = ($n_h/2)-($wt_h/2);
           break;
      case 'b_l':
           $wt_w_p = $w_p;
           $wt_h_p = $n_h - $wt_h - $h_p;
           break;
      case 'b_c':
           $wt_w_p = ($n_w/2) - ($wt_w/2);
           $wt_h_p = $n_h - $wt_h - $h_p;
           break;
      case 'b_r':
           $wt_w_p = $n_w - $wt_w - $w_p;
           $wt_h_p = $n_h - $wt_h - $h_p;
           break;
      default:
           $wt_w_p = $n_w - $wt_w - $w_p;
           $wt_h_p = $n_h - $wt_h - $h_p;
           break;
      }
      imagecopymerge($tmp, $wt_tmp, (int)$wt_w_p, (int)$wt_h_p, 0, 0, (int)$wt_w, (int)$wt_h, (int)$wt_alpha);
      imagedestroy($wt_img);
      imagedestroy($wt_tmp);
     }
  }

  if($out_exp == 'png') $quality = round(9-(9*($quality/100)));

  if($out_file)@unlink($out_file);

  switch ($out_exp){
    case 'gif':
         imagegif($tmp, $out_file);
         break;
    case 'jpg':
         imagejpeg($tmp, $out_file, $quality);
         break;
    case 'png':
         imagepng($tmp, $out_file, $quality);
         break;
    default:
         return false;
         break;
  }

 imagedestroy($in_img);
 imagedestroy($tmp);
 return true;
}

function skm_thumb_del($path, $bo_table, $wr_id){
 if(is_dir($path)){
  $ls = dir($path);
  while($file = $ls->read()){
   if(preg_match('/^'.$bo_table.'_'.$wr_id.'/i', $file) && $file != '.' && $file != '..'){
      @unlink($path.'/'.$file);
     }
   }
 }
}

function skm_mkdir($path){
 $file_html = $path.'/index.html';
 if(!file_exists($file_html)){
  if(file_exists($path)) @unlink($path);
  @mkdir($path, 0707);
  @chmod($path, 0707);
  $f_html = @fopen($file_html, 'w');
  @fwrite($f_html, '');
  @fclose($f_html);
  @chmod($file_html, 0606);
  $file_php = $path . '/index.php';
  $f_php = @fopen($file_php, 'w');
  @fwrite($f_php, '');
  @fclose($f_php);
  @chmod($file_php, 0606);
 }
}

function skm_get_image($bo_table, $wr_id, $cnt='one'){
 global $g4;
 if($cnt == 'all'){
    $sql = "select * from ".$g4['board_file_table']." where bo_table = '".$bo_table."' and wr_id = '".$wr_id."' and bf_type > 0 and bf_type <= 3 order by bf_no ";
    return sql_query($sql, false);
    }else{
     $sql = "select * from ".$g4['board_file_table']." where bo_table = '".$bo_table."' and wr_id = '".$wr_id."' and bf_type > 0 and bf_type <= 3 order by bf_no limit 1 ";
     return sql_fetch($sql, false);
    }
}

function skm_content_img_view_file($bo_table, $wr_id, $skmlightbox=false){
    global $config;
    global $g4;
    global $board;

    $get_img = skm_get_image($bo_table, $wr_id, 'all');

    if (!$get_img) return;
    $row = array();
    $skm_con_img_list = array();

    while($row=sql_fetch_array($get_img)){
    $width = $row['bf_width'];
    $height = $row['bf_height'];
    $file = $row['bf_file'];
    $bf_no = $row['bf_no'];

    //   ԽǼ ̹  ũٸ ԽǼ  ߰   ̸ 
    if ($width > $board['bo_image_width'] && $board['bo_image_width'])
    {
        $rate = $board['bo_image_width'] / $width;
        $width = $board['bo_image_width'];
        $height = (int)($height * $rate);
    }

    //  ִ    Ӽ ְ,  ڵ ǵ ڵ带  ʴ´.
    if ($width)
        $attr = ' width="'.$width.'" height="'.$height.'"';
    else
        $attr = '';

    if(preg_match('/\.(' .$config['cf_image_extension'] . ')$/i', $file)){
        // ̹ Ӽ  ʴ  ̹ Ŭ  ̹ ֱ Ѱ
        // ԽǼ ̹ ũٸ Ų ڹٽũƮ ̹ ٿش
        $thumb_ori = $bo_table.'_'.$wr_id.'_'.$bf_no.'.thumb';
        $img_file = $g4['path'].'/data/file/'.$bo_table.'/'.urlencode($file);
        $img_file_thumb_ori = $g4['path'].'/data/file/'.$bo_table.'/skm_thumb_ori/'.urlencode($thumb_ori);

        if(file_exists($img_file_thumb_ori)){
          $img_file = $img_file_thumb_ori;
          }

//        $size = getimagesize($img_file);
        // ̹ Խǿ  ̹ ʰѴٸ lightbox 
        if($skmlightbox){
            $skm_con_img_list[] = '<a rel="lightbox" href="'.$img_file.'"><img src="'.$img_file.'"'.$attr.' alt="lightbox" /></a>';
         }else{
           $skm_con_img_list[] = '<img src="'.$img_file.'" alt="'.$content.'" />';
           }
    }
  }
  return $skm_con_img_list;
}
?>