/*
 * SKM-Editor ver.1.0.0
 *
 * GPL Version 2 licenses
 * Copyright shukuma.com
 *
 */

//================ 사용자 설정 시작 ============================
var skmeditor_wr_sid = '';
var skmeditor_wr_id = '';
var skmeditor_wr_id2 = '';
var css_auto_load = true;  // skmeditor CSS 파일 자동 로드 사용선택(true, false)
var align_use     = true;  // 문단 정렬 사용 사용선택(true, false)
var html_readonly = false; // HTML 소스코드 읽기전용 사용선택(true, false)
//================ 사용자 설정 끝 ============================

var skmeditor = function(sid){
//================== 변수 지정 시작 =========================
var skm_id                    = "skmeditor_" + sid;
var editor_body               = "skmeditor_body_" + sid;
var editor_toolbar            = "skmeditor_toolbar" + sid;
var top_font_btn              = "skmeditor_top_font_btn_" + sid;
var top_font_btn_list         = top_font_btn + "_list";
var top_size_btn              = "skmeditor_top_size_btn_" + sid;
var top_size_btn_list         = top_size_btn + "_list";
var top_colorapp_btn          = "skmeditor_top_colorapp_btn_" + sid;
var top_colorapp_btn_span     = top_colorapp_btn + "_span";
var top_color_btn             = "skmeditor_top_color_btn_" + sid;
var top_color_btn_span        = top_color_btn + "_span";
var top_color_btn_list        = top_color_btn + "_list";
var top_color_btn_list_cell   = top_color_btn_list + "_cell";
var top_backcolorapp_btn      = "skmeditor_top_backcolorapp_btn_" + sid;
var top_backcolor_btn         = "skmeditor_top_backcolor_btn_" + sid;
var top_backcolor_btn_span    = top_backcolor_btn + "_span";
var top_backcolor_btn_list    = top_backcolor_btn + "_list";
var top_backcolor_btn_list_cell = top_backcolor_btn_list + "_cell";
var top_fontbackcolorapp_btn  = "skmeditor_top_fontbackcolorapp_btn_" + sid;
var top_Bold_btn              = "skmeditor_top_Bold_btn_" + sid;
var top_Underline_btn         = "skmeditor_top_Underline_btn_" + sid;
var top_Italic_btn            = "skmeditor_top_Italic_btn_" + sid;
var top_strikethrough_btn     = "skmeditor_top_strikethrough_btn_" + sid;
if(align_use){
var top_JustifyLeft_btn       = "skmeditor_top_JustifyLeft_btn_" + sid;
var top_JustifyCenter_btn     = "skmeditor_top_JustifyCenter_btn_" + sid;
var top_JustifyRight_btn      = "skmeditor_top_JustifyRight_btn_" + sid;
var top_JustifyFull_btn       = "skmeditor_top_JustifyFull_btn_" + sid;
}
var top_undo_btn              = "skmeditor_top_undo_btn_" + sid;
var top_redo_btn              = "skmeditor_top_redo_btn_" + sid;

var top_RemoveFormat_btn      = "skmeditor_top_RemoveFormat_btn_" + sid;
var char_chk_span             = "skmeditor_char_chk_span_" + sid;
var char_max_span             = "skmeditor_char_max_span_" + sid;
var run_time_chk              = "skmeditor_run_time_chk_" + sid;

var content                   = "skmeditor_content_" + sid;
var editor_html1              = "skmeditor_editor_html1_" + sid;
var editor_html2              = "skmeditor_editor_html2_" + sid;
var editor_text               = "skmeditor_editor_text_" + sid;
var content_resize            = "skmeditor_content_resize_" + sid;

var html1_view_btn            = "skmeditor_html1_view_btn_" + sid;
var html2_view_btn            = "skmeditor_html2_view_btn_" + sid;
var text_view_btn             = "skmeditor_text_view_btn_" + sid;

var editor_mode     = 'html1';
var in_con_html1    = null;
var in_con_html2    = null;
var in_con_text     = null;
var char_chk_re     = null;
var char_chk_run    = null;
var char_now_cnt    = 0;
var char_before_chk = 0;

var color_arr = new Array(
"#ff0000", "#ff5e00", "#ffbb00", "#ffe400", "#abf200", "#1fda11", "#00d8ff", "#0055ff", "#0900ff", "#6600ff", "#ff00dd", "#ff007f", "#000000", "#ffffff",
"#ffd8d8", "#fae0d4", "#faecc5", "#faf4c0", "#e4f7ba", "#cefbc9", "#d4f4fa", "#d9e5ff", "#dad9ff", "#e8d9ff", "#ffd9fa", "#ffd9ec", "#f6f6f6", "#eaeaea",
"#ffa7a7", "#ffc19e", "#ffe08c", "#faed7d", "#cef279", "#b7f0b1", "#b2ebf4", "#b2ccff", "#b5b2ff", "#d1b2ff", "#ffb2f5", "#ffb2d9", "#d5d5d5", "#bdbdbd",
"#f15f5f", "#f29661", "#f2cb61", "#e5d85c", "#bce55c", "#86e57f", "#5cd1e5", "#6699ff", "#6b66ff", "#a366ff", "#f261df", "#f261aa", "#a6a6a6", "#8c8c8c",
"#cc3d3d", "#cc723d", "#cca63d", "#c4b73b", "#9fc93c", "#47c83e", "#3db7cc", "#4174d9", "#4174d9", "#7e41d9", "#d941c5", "#d9418d", "#747474", "#5d5d5d",
"#980000", "#993800", "#997000", "#998a00", "#6b9900", "#2f9d27", "#008299", "#003399", "#050099", "#3d0099", "#990085", "#99004c", "#4c4c4c", "#353535",
"#670000", "#662500", "#664b00", "#665c00", "#476600", "#22741c", "#005766", "#002266", "#030066", "#290066", "#660058", "#660033", "#212121", "#000000");
var cnt_color_arr = color_arr.length;

var div_list = new Array(top_font_btn_list, top_size_btn_list, top_color_btn_list, top_backcolor_btn_list);
var cnt_div_list = div_list.length;

if(!char_min) var char_min = 0;
if(!char_max) var char_max = 0;
var editor_is_ie = navigator.userAgent.toLowerCase().indexOf('msie') != -1;
var editor_is_chrome = navigator.userAgent.toLowerCase().indexOf('chrome') != -1;

var i;
var default_set_font   = "DodumChe";
var default_set_size   = "2";

var default_set_color  = "#000000";
var default_set_back   = "#dad9ff";

var self = this;
//================== 변수 지정 끝 =========================

this.html_insert = function(){
var div = document.createElement('div');
var in_html = '';
in_html +='<div id="'+editor_body+'" class="editor_body">';
in_html +=' <div id="'+editor_toolbar+'" class="editor_toolbar">';
in_html +='  <div class="top_relative">';
in_html +='  <button id="'+top_font_btn+'" type="button" class="top_font_btn top_font_btn btn" onmousedown="'+skm_id+'.top_btn_click(this.id);"  title="글씨체">돋움체</button>';
in_html +='   <div id="'+top_font_btn_list+'" class="top_font_btn_list btn_list" style="width:200px;">';
in_html +='   <ul>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Gulim\');"><span>굴림&nbsp;&nbsp;</span><span style="font-family:Gulim;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'GulimChe\');"><span>굴림체</span><span style="font-family:GulimChe;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Dotum\');"><span>돋움&nbsp;&nbsp;</span><span style="font-family:Dotum;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'DotumChe\');"><span>돋움체</span><span style="font-family:DotumChe;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Batang\');"><span>바탕&nbsp;&nbsp;</span><span style="font-family:Batang;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'BatangChe\');"><span>바탕체</span><span style="font-family:BatangChe;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Gungsuh\');"><span>궁서&nbsp;&nbsp;</span><span style="font-family:Gungsuh;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'GungsuhChe\');"><span>궁서체</span><span style="font-family:GungsuhChe;"> (가나다라마바사)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Verdana\');"><span>Verdana</span><span style="font-family:Verdana;"> (ABCDEFG)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Tahoma\');"><span>Tahoma</span><span style="font-family:Tahoma;"> (ABCDEFG)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Arial\');"><span>Arial</span><span style="font-family:Arial;"> (ABCDEFG)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Arial Black\');"><span>Arial Black</span><span style="font-family:\'Arial Black\';"> (ABCDEFG)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Courier\');"><span>Courier</span><span style="font-family:Courier;"> (ABCDEFG)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'fontname\',\'Times New Roman\');"><span>Times New Roman</span><span style="font-family:\'Times New Roman\';"> (ABCDEFG)</span></button></li>';
in_html +='   </ul>';
in_html +='  </div>';
in_html +=' </div>';
in_html +=' <div class="top_relative">';
in_html +='  <button id="'+top_size_btn+'" type="button" class="top_size_btn btn" onmousedown="'+skm_id+'.top_btn_click(this.id);" title="글자크기">9pt</button>';
in_html +='  <div id="'+top_size_btn_list+'" class="top_size_btn_list btn_list" style="width:330px;">';
in_html +='   <ul>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'FontSize\',\'1\');"><span style="font-size:8pt;">가나다라마바사 (8pt)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'FontSize\',\'2\');"><span style="font-size:9pt;">가나다라마바사 (9pt)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'FontSize\',\'3\');"><span style="font-size:12pt;">가나다라마바사 (12pt)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'FontSize\',\'4\');"><span style="font-size:14pt;">가나다라마바사 (14pt)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'FontSize\',\'5\');"><span style="font-size:18pt;">가나다라마바사 (18pt)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'FontSize\',\'6\');"><span style="font-size:24pt;">가나다라마 (24pt)</span></button></li>';
in_html +='    <li><button type="button" onclick="'+skm_id+'.edit_run(\'FontSize\',\'7\');"><span style="font-size:36pt;">가나다 (36pt)</span></button></li>';
in_html +='   </ul>';
in_html +='  </div>';
in_html +=' </div>';
in_html +='  <button id="'+top_colorapp_btn+'" type="button" class="top_colorapp_btn btn" style="margin-left:5px;" onclick="'+skm_id+'.colorapp_click(\'font\');" title="글자색"><span id="'+top_colorapp_btn_span+'" class="top_colorapp_btn_span">가</span></button>';
in_html +='  <div class="top_relative">';
in_html +='   <button id="'+top_color_btn+'" type="button" class="top_color_btn btn" style="padding:1px;" onmousedown="'+skm_id+'.top_btn_click(this.id);" title="글자색 선택"><span id="'+top_color_btn_span+'" class="top_color_btn_span">▼</span></button>';
in_html +='   <div id="'+top_color_btn_list+'" class="top_color_btn_list">글자색<br />';
in_html +='      <div id="'+top_color_btn_list_cell+'" class="top_color_btn_list_cell"><br /></div>';
in_html +='   </div>';
in_html +='  </div>';
in_html +='  <button id="'+top_backcolorapp_btn+'" type="button" class="top_backcolorapp_btn btn" onclick="'+skm_id+'.colorapp_click(\'back\');" title="글자 배경색">가</button>';
in_html +='  <div class="top_relative">';
in_html +='   <button id="'+top_backcolor_btn+'" type="button" class="top_backcolor_btn btn" style="padding:1px;" onmousedown="'+skm_id+'.top_btn_click(this.id);" title="글자 배경색 선택"><span id="'+top_backcolor_btn_span+'" class="top_backcolor_btn_span">▼</span></button>';
in_html +='    <div id="'+top_backcolor_btn_list+'" class="top_backcolor_btn_list">배경색<br />';
in_html +='      <div id="'+top_backcolor_btn_list_cell+'" class="top_backcolor_btn_list_cell"><br /></div>';
in_html +='    </div>';
in_html +='  </div>';
in_html +='  <button id="'+top_fontbackcolorapp_btn+'" type="button" class="top_fontbackcolorapp_btn btn" style="margin-left:5px;" onclick="'+skm_id+'.colorapp_click(\'fontandback\');" title="글자색 및 글자 배경색">가</button>';
in_html +='<button id="'+top_Bold_btn+'" type="button" class="top_Bold_btn btn one" style="margin-left:5px;" onclick="'+skm_id+'.edit_run(\'Bold\', true);" title="굵게 (Ctrl+B)"></button>';
in_html +='<button id="'+top_Underline_btn+'" type="button" class="top_Underline_btn btn one" onclick="'+skm_id+'.edit_run(\'Underline\', true);" title="밑줄 (Ctrl+U)"></button>';
in_html +='<button id="'+top_Italic_btn+'" type="button" class="top_Italic_btn btn one" onclick="'+skm_id+'.edit_run(\'Italic\', true);" title="기울임 (Ctrl+I)"></button>';
in_html +='<button id="'+top_strikethrough_btn+'" type="button" class="top_strikethrough_btn btn one" onclick="'+skm_id+'.edit_run(\'strikethrough\', true);" title="취소선"></button>';
if(align_use){
in_html +='<button id="'+top_JustifyLeft_btn+'" type="button" class="top_JustifyLeft_btn btn one" style="margin-left:5px;" onclick="'+skm_id+'.edit_run(\'JustifyLeft\', true);" title="왼쪽 정렬"></button>';
in_html +='<button id="'+top_JustifyCenter_btn+'" type="button" class="top_JustifyCenter_btn btn one" onclick="'+skm_id+'.edit_run(\'JustifyCenter\', true);" title="가운데 정렬"></button>';
in_html +='<button id="'+top_JustifyRight_btn+'" type="button" class="top_JustifyRight_btn btn one" onclick="'+skm_id+'.edit_run(\'JustifyRight\', true);" title="오른쪽 정렬"></button>';
in_html +='<button id="'+top_JustifyFull_btn+'" type="button" class="top_JustifyFull_btn btn one" onclick="'+skm_id+'.edit_run(\'JustifyFull\', true);" title="양쪽분배"></button>';
}
//in_html +='<button id="'+top_undo_btn+'" type="button" class="top_undo_btn btn one" style="margin-left:5px;" onclick="'+skm_id+'.edit_run(\'undo\', null);" title="실행 취소"></button>';
//in_html +='<button id="'+top_redo_btn+'" type="button" class="top_redo_btn btn one" onclick="'+skm_id+'.edit_run(\'redo\', null);" title="다시 실행"></button>';
in_html +='<button id="'+top_RemoveFormat_btn+'" type="button" class="top_RemoveFormat_btn btn one" style="margin-left:5px;" onclick="'+skm_id+'.edit_run(\'RemoveFormat\', true);" title="속성 제거"></button>';
in_html +='<span id="'+char_chk_span+'" style="margin-left:10px; font-size:12px;">0</span><span id="'+char_max_span+'" style="font-size:12px;">/</span>';
//in_html +='<span id="'+run_time_chk+'" style="font-size:12px;">0</span>';
in_html +='  <br style="clear:both;" />';
in_html +=' </div>';
in_html +=' <div id="'+content+'" class="skmeditor_content">';
in_html +='  <div id="'+editor_html1+'" class="editor_html1"></div>';
in_html +='  <textarea id="'+editor_html2+'" class="editor_html2" cols="60" rows="20" ></textarea>';
in_html +='  <textarea id="'+editor_text+'" class="editor_text" cols="60" rows="20" ></textarea>';
in_html +=' </div>';
in_html +='  <div id="'+content_resize+'" class="content_resize">▼&nbsp;▲</div>';
in_html +=' <button type="button" id="'+html1_view_btn+'" class="html1_view_btn btn" onclick="'+skm_id+'.html1_view_btn();">Editor</button>';
if(html_readonly){
in_html +=' <button type="button" id="'+html2_view_btn+'" class="html2_view_btn btn" onclick="'+skm_id+'.html2_view_btn();">HTML (읽기 전용)</button>';
}else{
in_html +=' <button type="button" id="'+html2_view_btn+'" class="html2_view_btn btn" onclick="'+skm_id+'.html2_view_btn();">HTML</button>';
}
in_html +=' <button type="button" id="'+text_view_btn+'" class="text_view_btn btn" onclick="'+skm_id+'.text_view_btn();">TEXT (읽기 전용)</button>';
in_html +='</div><!-- #editor_body -->';
div.innerHTML = in_html;

document.getElementById(sid).parentNode.insertBefore(div, document.getElementById(sid));
document.getElementById(sid).style.display = "none";

in_con_html1 = document.getElementById(editor_html1);
skmeditor_wr_id = in_con_html1;
in_con_html2 = document.getElementById(editor_html2);
skmeditor_wr_id2 = in_con_html2;
in_con_text = document.getElementById(editor_text);

//if(document.getElementById(sid+"_div")){ // 편집시 표준통과 목적
//  in_con_html1.innerHTML = document.getElementById(sid+"_div").innerHTML;
//  }else{
  in_con_html1.innerHTML = this.editor_chk(document.getElementById(sid).value);
  skmeditor_wr_sid = document.getElementById(sid);
//  }
this.skm_start();
this.editor_update();
this.on_load();
}

this.skm_start = function(){
if(char_max == 0){ char_max_t = '∞'; }else{ char_max_t = char_max; }
document.getElementById(char_max_span).innerHTML = "&nbsp;/&nbsp;" + char_max_t;
document.getElementById(top_backcolorapp_btn).style.background = default_set_back;
document.getElementById(top_fontbackcolorapp_btn).style.color = default_set_color;
document.getElementById(top_fontbackcolorapp_btn).style.background = default_set_back;
}

//================= 뷰어 치환 설정 시작 ======================

this.html1_view_btn = function(){

 this.button_disabled(false);
 this.editor_update();

if(!html_readonly){
 if(editor_mode == "html2"){
// in_con_html1.innerHTML =  this.editor_chk(in_con_html2.value).replace(/\n/gi,'<br \/>');
   in_con_html1.innerHTML =  document.getElementById(sid).value;
 }
}
 editor_mode = 'html1';

 in_con_html2.style.display = "none";
 in_con_text.style.display = "none";
 in_con_html1.style.display = "block";

 document.getElementById(text_view_btn).style.color = "#a1a1a1";
 document.getElementById(html2_view_btn).style.color = "#a1a1a1";
 document.getElementById(html1_view_btn).style.color = "#000000";
}

this.html2_view_btn = function(){
 this.button_disabled(true);
 this.editor_update();
 
if(html_readonly){
 in_con_html2.readOnly = true;
 }else{
 editor_mode = 'html2';
   }
 in_con_html2.value = this.editor_chk(in_con_html1.innerHTML);

 in_con_html1.style.display = "none";
 in_con_text.style.display = "none";
 in_con_html2.style.display = "block";

 document.getElementById(text_view_btn).style.color = "#a1a1a1";
 document.getElementById(html1_view_btn).style.color = "#a1a1a1";
 document.getElementById(html2_view_btn).style.color = "#000000";
}

this.text_view_btn = function(){
 in_con_text.readOnly = true;
 this.button_disabled(true);
 var v;
 if(editor_mode == 'html1'){
    v = this.editor_chk(in_con_html1.innerHTML);
 }else{
    v = this.editor_chk(in_con_html2.value);
   }
   

 this.editor_update();
 editor_mode = 'text';

 in_con_text.value = this.html_to_text(v);
 in_con_html1.style.display = "none";
 in_con_html2.style.display = "none";
 in_con_text.style.display = "block";

 document.getElementById(html2_view_btn).style.color = "#a1a1a1";
 document.getElementById(html1_view_btn).style.color = "#a1a1a1";
 document.getElementById(text_view_btn).style.color = "#000000";
}

this.button_disabled = function(bool){
 var ed_toolbar_button = document.getElementById(editor_toolbar).getElementsByTagName("button");
 var cnt_ed_toolbar_button = ed_toolbar_button.length;
  for(i=0;i<cnt_ed_toolbar_button;i++){
   ed_toolbar_button[i].disabled = bool;
  }
}

//=================== 뷰어 치환 설정 끝 =====================

this.html_to_edit = function(v){
// v = v.replace(/<[^>]*>/gi,'');
// v = v.replace(/&lt;/gi,'<');
// v = v.replace(/&gt;/gi,'>');
// v = v.replace(/&quot;/gi,'"');
// v = v.replace(/&#039;/gi,"'");
// v = v.replace(/&/gi,'&amp;');

// v = v.replace(/\n/gi,'<br \/>');

 return v;
}

this.html_to_text = function(v){
 v = v.replace(/<[^>]*>/gi,'');
 v = v.replace(/&nbsp;/gi,' ');
 v = v.replace(/&lt;/gi,'<');
 v = v.replace(/&gt;/gi,'>');
 v = v.replace(/&quot;/gi,'"');
 v = v.replace(/&#039;/gi,"'");
 v = v.replace(/&amp;/gi,'&');
 return v;
}

this.char_chk = function(){
  clearTimeout(char_chk_run);
 if(!editor_is_ie && !editor_is_chrome){
  clearTimeout(char_chk_re);
  char_chk_run = setTimeout(function(){document.getElementById(char_chk_span).innerHTML = self.html_to_text(in_con_html1.innerHTML).length; self.char_cnt_chk(); }, 150);
  char_chk_re = setTimeout(function(){self.char_chk();}, 250);
 }else{
  char_chk_run = setTimeout(function(){document.getElementById(char_chk_span).innerHTML = self.html_to_text(in_con_html1.innerHTML).length; self.char_cnt_chk(); }, 150);
   }
}

this.char_cnt_chk = function(){
 if(char_max > 0){
  char_now_cnt = parseInt(document.getElementById(char_chk_span).innerHTML);
  if(char_max <= char_now_cnt){
    document.getElementById(char_chk_span).style.color = "#ff0000";
     if(char_before_chk < char_now_cnt){
        alert(char_max+"자 이하만 입력할 수 있습니다. ");
        }
     char_before_chk = char_now_cnt;
    }else{
    document.getElementById(char_chk_span).style.color = "#000000";
      }
  }
}

//=================== 데이터 저장용 치환 설정 시작 =====================

this.skm_tag_replace = function(v,patt,op,tar){
     v = "<skm>" + v + "<\/skm>";
 var v_match = new Array();
 var v_match_ch = new Array();
 var cnt_v_match;
     v_match = v.match(new RegExp("<[^>]*"+ patt +"[^>]*>",op));
 if(v_match){
   cnt_v_match = v_match.length;
   for(i=0;i<cnt_v_match;i++){
     v_match_ch[i] = v_match[i].replace(new RegExp(patt,op),tar);
     v = v.replace(v_match[i],v_match_ch[i]);
   }
   v = v.replace(/<[\/]?skm>/gi,'');
   return v;
 }
 v = v.replace(/<[\/]?skm>/gi,'');
 return v;
}

this.skm_badtag_replace = function(v){
 v = v.replace(/<[\/]?skm>/gi,'');
/*
 v = v.replace(/<\?/gi,'&lt;\?');
 v = v.replace(/\?>/gi,'?&gt;');
 v = v.replace(/<%/gi,'&lt;%');
 v = v.replace(/%>/gi,'%&gt;');
*/
 v = v.replace(/<[1+]/gi,'<');
 v = v.replace(/[1+]>/gi,'>');
 v = v.replace(/<([\/]?)(div|p|u|strike|span|img)([^>]*)>/gi,'<1$1$2$31>');
 v = v.replace(/<br([\s+]?[\/]?)>/gi,'<1br \/1>');
 v = v.replace(/<([\/]?)b>/gi,'<1$1b1>');
 v = v.replace(/<([\/]?)b ([^>]*)>/gi,'<1$1b $21>');
 v = v.replace(/<([\/]?)i>/gi,'<1$1i1>');
 v = v.replace(/<([\/]?)i ([^>]*)>/gi,'<1$1i $21>');

 v = v.replace(/<([^1])/gi,'&lt;$1');
 v = v.replace(/([^1])>/gi,'$1&gt;');
 v = v.replace(/<1/gi,'<');
 v = v.replace(/1>/gi,'>');

 v = this.skm_tag_replace(v,'(\\[|\\])','gi','');
 v = '<][skm][>'+v+'<][\/skm][>';

 v = v.replace(/<([\/])?(div|p|u|strike|span|img)([^>]*)>/gi,'<][$1$2]$3[>');
 v = v.replace(/<br([\s+]?[\/]?)>/gi,'<][br \/][>');
 v = v.replace(/<([\/]?)b>/gi,'<][$1b][>');
 v = v.replace(/<([\/]?)b ([^>]*)>/gi,'<][$1b] $2[>');
 v = v.replace(/<([\/]?)i>/gi,'<][$1i][>');
 v = v.replace(/<([\/]?)i ([^>]*)>/gi,'<][$1i] $2[>');


 v = v.replace(/<([^>]*)(font-family:[^\s;><\[\]]+;)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)(font-size:[^\s;><\[\]]+;)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)(background-color:[^\s;><\[\]]+;)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)([^\-]color:[^\s;><\[\]]+;)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)(text-decoration:[^\s;><\[\]]+;)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)(text-align:[^\s;><\[\]]+;)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)(src:[^\s;><\[\]]*)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)(width:[^\s;><\[\]]*)([^>]*)>/gi,'<$1[$2]$3>');
 v = v.replace(/<([^>]*)(height:[^\s;><\[\]]*)([^>]*)>/gi,'<$1[$2]$3>');

 v = v.replace(/<([^>]*)alt:([^>]*)>/gi,'<$1[alt:]$2>');

// v = v.replace(/\][^\[]+\[/gi,' ');
 v = this.skm_tag_replace(v,'\\][^\\[]+\\[','gi',' ');
 v = this.skm_tag_replace(v,'(\\[|\\])','gi','');
 v = this.skm_tag_replace(v,'[\\s+]','gi',' ');

 v = v.replace(/\s+>/gi,'>');

 return v;
}

this.editor_chk = function(v){
// var start_time = new Date();

     v = "<skm>" + v + "<\/skm>";
 var v_match = new Array();
 var v_match_ch = new Array();
 var cnt_v_match;
     v_match = v.match(new RegExp(">[^<]*('|\")[^<]*<","gi"));

 if(v_match){
   cnt_v_match = v_match.length;
   for(i=0;i<cnt_v_match;i++){
     v_match_ch[i] = v_match[i].replace(/'/gi, '&#039;');
     v_match_ch[i] = v_match_ch[i].replace(/"/gi, '&quot;');
     v = v.replace(v_match[i],v_match_ch[i]);
   }
 }

 var src_low_match = new Array();
 var low_match = new Array();
 var low_match_ch = new Array();
 var cnt_low_match;
 var cnt_src_low_match;

     src_low_match = v.match(new RegExp("src=[^\\s>]+","gi"));
     low_match = v.match(new RegExp("<[^>]+>","gi"));
 if(low_match){
   cnt_low_match = low_match.length;
   for(i=0;i<cnt_low_match;i++){
     if(!/src=/i.test(low_match[i])){
     low_match_ch[i] = low_match[i].toLowerCase();
     v = v.replace(low_match[i],low_match_ch[i]);
     }
   }
 }

     v = v.replace(/("|')/gi, '');
     v = v.replace(/&nbsp;/gi, ' ');

     if(/<img([^>]*)width:/i.test(v)){
     v = v.replace(/<img([^>]*)width=([\d]*)([^>]*)>/gi,'<img$1$4>');
     v = v.replace(/<img([^>]*)height=([\d]*)([^>]*)>/gi,'<img$1$4>');
}

//     v = v.replace(/\s\s\s/gi, '&nbsp;&nbsp;&nbsp;');
////     v = v.replace(/\s\s/gi, '&nbsp;&nbsp;');

     v = this.skm_tag_replace(v,'(style[\\s+]?=[\\s+]?|="")','gi','');
     v = this.skm_tag_replace(v,'[\\s+]?(=|:)[\\s+]?','gi',':');

     v = v.replace(/<([\/]?)div/gi,'<$1p');  // linux

     v = v.replace(/<([\/]?)font/gi, '<$1span');

     v = this.skm_tag_replace(v,'arial black','gi','arialblack');
     v = this.skm_tag_replace(v,'times new roman','gi','timesnewroman');
     v = this.skm_tag_replace(v,'font-family:([^\\s;>]*)[;]?','gi','font-family:$1;');
     v = this.skm_tag_replace(v,'face:([^\\s;>]*)[;]?','gi','font-family:$1;');

     v = this.skm_tag_replace(v,'font-size:([^\\s;>]+)[;]?','gi','font-size:$1;');
     v = this.skm_tag_replace(v,' size:1','gi',' font-size:8pt;');
     v = this.skm_tag_replace(v,' size:2','gi',' font-size:9pt;');
     v = this.skm_tag_replace(v,' size:3','gi',' font-size:12pt;');
     v = this.skm_tag_replace(v,' size:4','gi',' font-size:14pt;');
     v = this.skm_tag_replace(v,' size:5','gi',' font-size:18pt;');
     v = this.skm_tag_replace(v,' size:6','gi',' font-size:24pt;');
     v = this.skm_tag_replace(v,' size:7','gi',' font-size:36pt;');

     v = this.skm_tag_replace(v,'[\\s+]?rgb[\\s+]?\\([\\s+]?([0-9]{1,3})[\\s+]?,[\\s+]?([0-9]{1,3})[\\s+]?,[\\s+]?([0-9]{1,3})[\\s+]?\\)[\\s+]?[;]?', 'gi', 'rgb($1,$2,$3);');
     v = this.skm_tag_replace(v,'color:([^\\s;>]*)[;]?','gi','color:$1;');

     v = v.replace(/<([\/]?)strong/gi, '<$1b');
     v = this.skm_tag_replace(v,'text-decoration:([^\\s;>]+)[;]?','gi','text-decoration:$1;');
     v = v.replace(/<([\/]?)em>/gi, '<$1i>');

     v = this.skm_tag_replace(v,'text-align:([a-zA-Z]+)[;]?','gi',' text-align:$1;');
     v = this.skm_tag_replace(v,' align:([a-zA-Z]+)[;]?','gi',' text-align:$1;');

//     v = v.replace(/<br[^>]*>/gi, '');

     v = this.skm_badtag_replace(v);

     v = v.replace(/[\/]+>/gi,'>');
     v = v.replace(/<img([^>]*)src:([^>\s]*)([^>]*)>/gi,'<img$1src="$2"$3>');

     v = v.replace(/<img([^>]*)width:([\d]*)(px)?([^>]*)>/gi,'<img$1width="$2"$4>');
     v = v.replace(/<img([^>]*)height:([\d]*)(px)?([^>]*)>/gi,'<img$1height="$2"$4>');

     v = v.replace(/<img([^>]*)alt:([^>]*)>/gi,'<img$1alt=""$2>');
     v = v.replace(/<img([^>]*)>/gi,'<img$1\/>');
     v = v.replace(/[\/]+>/gi,'\/>');
     v = v.replace(/<br[^>]*>/gi,'<br \/>');

     v = v.replace(/<u /gi,'<span text-decoration:underline;');
     v = v.replace(/<strike /gi,'<span text-decoration:line-through;');

     v = v.replace(/<(p|span|b|u|i[^m][^g]|strike) ([^>]*)>/gi, '<$1 style="$2">');

     v = v.replace(/<u>/gi,'<span style="text-decoration:underline;">');
     v = v.replace(/<\/u>/gi,'<\/span>');
     v = v.replace(/<strike>/gi,'<span style="text-decoration:line-through;">');
     v = v.replace(/<\/strike>/gi,'<\/span>');

     for(i=0;i<3;i++){
     v = v.replace(/<span[^>]*>[\s]*<\/span>/gi,'');
     }
     v = v.replace(/<p([^>]*)>[\s\n]*<\/p>/gi, '<p$1>&nbsp;<\/p>');

     v = this.skm_tag_replace(v,'arialblack','gi',"'arial black'");
     v = this.skm_tag_replace(v,'timesnewroman','gi',"'times new roman'");

/*
 var end_time = new Date();
 var run_time = end_time.getTime() - start_time.getTime();
 document.getElementById(run_time_chk).innerHTML = "&nbsp;&nbsp;run time : " + run_time + "ms";
*/

 v = v.replace(/>(\n|\r)/gi,'>');

// v = v.replace(/\n/gi,'<br \/>');

 v = v.replace(/<[\/]?skm>/gi,'');

 return v;
}

this.editor_update = function(){
 if(editor_mode == 'html2'){
  document.getElementById(sid).value = this.editor_chk(in_con_html2.value);
 }else{
  document.getElementById(sid).value = this.editor_chk(in_con_html1.innerHTML);
 }
}
//=================== 데이터 저장용 치환 설정 끝 =====================

this.if_click = function(){
 in_con_html1.focus();
 var font_name = document.queryCommandValue('FontName');
 var font_size = document.queryCommandValue('FontSize');

 var patt;
 var font_name_ch;
 var font_state;
 var cnt_font_state;
 var state_val;

 patt = /굴림$|Gulim$/i;       if(patt.test(font_name)) font_name_ch = "굴림";
 patt = /굴림체$|GulimChe$/i;  if(patt.test(font_name)) font_name_ch = "굴림체";
 patt = /돋움$|Dotum$/i;       if(patt.test(font_name)) font_name_ch = "돋움";
 patt = /돋움체$|DotumChe$/i;  if(patt.test(font_name)) font_name_ch = "돋움체";
 patt = /바탕$|Batang$/i;      if(patt.test(font_name)) font_name_ch = "바탕";
 patt = /바탕체$|BatangChe$/i; if(patt.test(font_name)) font_name_ch = "바탕체";
 patt = /궁서$|Gungsuh$/i;     if(patt.test(font_name)) font_name_ch = "궁서";
 patt = /궁서체$|GungsuhChe$/i;if(patt.test(font_name)) font_name_ch = "궁서체";

 patt = /Verdana$/i; if(patt.test(font_name)) font_name_ch = "Verdana";
 patt = /Tahoma$/i; if(patt.test(font_name)) font_name_ch = "Tahoma";
 patt = /Arial$/i; if(patt.test(font_name)) font_name_ch = "Arial";
 patt = /Arial Black$/i; if(patt.test(font_name)) font_name_ch = "Arial Black";
 patt = /Courier$/i; if(patt.test(font_name)) font_name_ch = "Courier";
 patt = /Times New Roman$/i; if(patt.test(font_name)) font_name_ch = "Times New Roman";

 if(!font_name_ch) font_name_ch = "돋움체";
 if(!font_size) font_size = 2;
 document.getElementById(top_font_btn).innerHTML = font_name_ch;

 var font_size_ch = new Array(0, 8, 9, 12, 14, 18, 24, 36);
 document.getElementById(top_size_btn).innerHTML = font_size_ch[font_size] + "pt";

 font_state = new Array("Bold", "Underline", "Italic", "strikethrough" );
 if(align_use){
 font_state.push("JustifyLeft", "JustifyCenter", "JustifyRight", "JustifyFull" );
 }
 cnt_font_state = font_state.length;
 for(i=0;i<cnt_font_state;i++){
    state_val = document.queryCommandState(font_state[i]);
    if(!state_val){
       this.alpha_ch(document.getElementById(eval("top_" + font_state[i] + "_btn")), 30);
      }else{
       this.alpha_ch(document.getElementById(eval("top_" + font_state[i] + "_btn")), 100);
      }
 }

 this.char_chk();
// this.editor_update();
 setTimeout(this.list_hidden,150);
}

this.top_btn_click = function(btn_id){
 var view_chk = document.getElementById(btn_id + "_list").style.display;
   if(view_chk){
     if(view_chk != "block"){
     document.getElementById(btn_id + "_list").style.display = "block";
     }else{
      document.getElementById(btn_id + "_list").style.display = "none";
       }
    }else{
     document.getElementById(btn_id + "_list").style.display = "block";
      }

 this.list_hidden(btn_id+"_list");
}

this.edit_run = function(name,val){
 in_con_html1.focus();
 if(name == 'ForeColor'){
    default_set_color = val;
    document.getElementById(top_colorapp_btn_span).style.color = default_set_color;
    document.getElementById(top_colorapp_btn_span).style.borderColor = default_set_color;
   }
  if(name == 'BackColor'){
     default_set_back = val;
     document.getElementById(top_backcolorapp_btn).style.color = '#ffffff';
     document.getElementById(top_backcolorapp_btn).style.background = default_set_back;
     document.getElementById(top_backcolorapp_btn).style.textShadow="1px 1px #dcdcdc";
   }
     document.getElementById(top_fontbackcolorapp_btn).style.color = default_set_color;
     document.getElementById(top_fontbackcolorapp_btn).style.background = default_set_back;
     document.getElementById(top_fontbackcolorapp_btn).style.textShadow = "1px 1px #dcdcdc";

 document.execCommand(name, false, val);
 in_con_html1.focus();
 if(/Justify/i.test(name)){
 this.editor_update();
 in_con_html1.innerHTML = document.getElementById(sid).value;
 }
 this.if_click();
}

this.list_hidden = function(sel_id){
 var none = "none";
 if(!sel_id) sel_id = "all";
 for(var i=0;i<cnt_div_list;i++){
   if(document.getElementById(div_list[i]) && div_list[i] != sel_id)
      document.getElementById(div_list[i]).style.display = none;
   }
}

this.color_cell_make = function(name, tar){
  var color_in = '';
  var color_div = '';
  var color_div_s = '<button type="button" style="background-color:';
  var color_div_m = ';" onclick="'+skm_id+'.edit_run(\'' + name + '\',\'';
  var color_div_e = '\');">&nbsp;<\/button>';

  for(i=0;i<cnt_color_arr;i++){
    color_in = color_arr[i];
    if(i % 14 == 0 && i > 0) color_div += "<br />";
    color_div += color_div_s + color_in + color_div_m + color_in + color_div_e;
  }
  color_div += '<br style="clear:both;" />';
  if(tar)
  document.getElementById(tar).innerHTML = color_div;
}

this.to_rgb = function(in_num){
 if(typeof(in_num) != "number"){
    return in_num;
   }
    return "rgb(" + (in_num & 0xFF) + ", " + ((in_num & 0xFF00) >> 8) + ", " + ((in_num & 0xFF0000) >> 16 ) + ")";
}

this.colorapp_click = function(tar){
  if(tar == 'back'){
    this.edit_run('BackColor', default_set_back);
    }else if(tar == "font"){
     this.edit_run('ForeColor', default_set_color);
      }else{
       this.edit_run('BackColor', default_set_back);
       this.edit_run('ForeColor', default_set_color);
       }
}

this.resize_run = function(event){
  document.body.onmouseup = function(){self.resize_out();}
  document.body.onmousemove = function(event){self.resize_move(event);}
}

this.resize_move = function(event){
//  document.body.onmouseup = function(){self.resize_out();}
  var t = document.getElementById(content).getBoundingClientRect().top;
  if(!event) event = window.event;
  if(!event) event = event;
  var y = event.clientY;
  var n = y - t - 20;
  if(n < 50)n=50;
  document.getElementById(content).style.height = n + "px";
}

this.resize_out = function(){
  document.body.onmousemove = null;
}

this.on_load = function(){
 var ed_body_button = document.getElementById(editor_body).getElementsByTagName("button");
 var cnt_ed_body_button = ed_body_button.length;
  for(i=0;i<cnt_ed_body_button;i++){
   ed_body_button[i].unselectable = "on";
  }
/*
 var ed_body_span = document.getElementById(editor_body).getElementsByTagName("span");
 var cnt_ed_body_span = ed_body_span.length;
  for(i=0;i<cnt_ed_body_span;i++){
   ed_body_span[i].unselectable = "on";
  }
*/
 document.getElementById(editor_toolbar).unselectable="on";
 in_con_html1.unselectable="off";

 this.color_cell_make("ForeColor", top_color_btn_list_cell);
 this.color_cell_make("BackColor", top_backcolor_btn_list_cell);
// document.getElementById(content).style.resize = "both";

 in_con_html1.contentEditable = "true";
 in_con_html1.onmouseup = function(){self.if_click();}
 in_con_html1.onkeyup = function(){self.if_click();}

 in_con_html1.onblur = function(){self.editor_update();}
 in_con_html2.onblur = function(){self.editor_update();}
 in_con_text.onblur = function(){self.editor_update();}

 document.getElementById(content_resize).unselectable = "on";
 document.getElementById(content_resize).onmousedown = function(){self.resize_run();}
 
// in_con_html1.onmouseout = function(){self.editor_update();}

/*
 if(!editor_is_ie)
 in_con_html1.addEventListener("keypress", function(){self.if_click()}, false);

 if(editor_is_ie)
 in_con_html1.attachEvent("onkeypress", function(){self.key_chk();});
 this.editor_update();
 */
 this.if_click();
 in_con_html1.focus();
}

this.alpha_ch = function(obj, value) {
	obj.style.opacity = value/100;
	if(editor_is_ie)
	obj.style.filter = 'alpha(opacity=' + value + ')';
}

this.key_chk = function(){
 if (event.keyCode == 13){
   var range = document.selection.createRange();
     event.returnValue = false;
     event.cancelBubble = true;
     range.pasteHTML("<br />");
     range.collapse(false);
     range.select();
    }
}
}

function skmeditor_on(){
 var t;
 var textarea_se = document.getElementsByTagName("textarea");
 var cnt_textarea_se = textarea_se.length;
 var skm_se;
 var skmeditor_id = new Array();

 for(t=0;t<cnt_textarea_se;t++){
     skm_se = textarea_se[t];
     if(/skmeditor/i.test(skm_se.className) && skm_se.style.display.toLowerCase() != 'none' && skm_se.style.visibility.toLowerCase() != 'hidden' && !skm_se.readOnly && !skm_se.disabled){
        if(!skm_se.id){ skm_se.id = skm_se.name; }
         skm_se.id = skm_se.id + "_skmeditor";
         skmeditor_id.push(skm_se.id);
      }
 }
 var cnt_skmeditor_id = skmeditor_id.length;
 if(cnt_skmeditor_id){
  if(css_auto_load){
    if(typeof(board_skin_path) != 'undefined'){
      document.write('<link rel="stylesheet" type="text\/css" href="' + board_skin_path + '\/skmeditor\/style.css" media="all" \/>\n');
       }else{
       document.write('<link rel="stylesheet" type="text\/css" href="' + g4_path + '\/skmeditor\/style.css" media="all" \/>\n');
      }
    }
   for(t=0;t<cnt_skmeditor_id;t++){
       eval("skmeditor_" + skmeditor_id[t] + " = new skmeditor('" + skmeditor_id[t] + "');");
       eval("skmeditor_" + skmeditor_id[t] + ".html_insert();");
   }
 }
}

skmeditor_on();
