<?
include_once("./_common.php");

// 특수문자 변환
function specialchars_replace($str, $len=0) {
    if ($len) {
        $str = substr($str, 0, $len);
    }

    $str = preg_replace("/&/", "&amp;", $str);
    $str = preg_replace("/</", "&lt;", $str);
    $str = preg_replace("/>/", "&gt;", $str);
    return $str;
}

$day_limit_all = 7;
$day_limit_single = 30;
$rss_length_limit = 200;

$do_all = 0;

if(strlen($bo_table) == 0) {
    // "do all boards" function added by JesusReigns, 9/15/2009
	$do_all = 1;
    $sql = " select bo_table, bo_subject from g4_board
            where bo_read_level < 2 and bo_use_rss_view = 1 ";
	$result = sql_query($sql);
	$tables_str = "";
	for(;$row = sql_fetch_array($result);) {
		$tables_str = $tables_str . " (select *, '$row[bo_table]' as bo_table, '$row[bo_subject]' as bo_subject from $g4[write_prefix]$row[bo_table]) union ";
	}
	$tables_str = substr($tables_str, 0, strlen($tables_str) - 7);
	$title = "All postings";
	$lines = 100;
    $sql = "select t1.wr_id, t2.wr_subject, t1.wr_name,
            left(t1.wr_content, $rss_length_limit) as wr_content, char_length(t1.wr_content) as wr_len,
            t1.wr_datetime, t1.wr_option, t1.wr_is_comment,
            left(t3.wr_content, $rss_length_limit) as original, char_length(t3.wr_content) as original_len,
            length(t1.wr_comment_reply) as len_reply,
            t1.wr_parent,
            t1.bo_table, t1.bo_subject
        from ( $tables_str ) as t1,
             ( $tables_str ) as t2,
             ( $tables_str ) as t3
        where t1.wr_option not like '%secret%' and
            t1.wr_parent = t2.wr_id and
            t1.wr_comment = t3.wr_comment and
            t1.wr_parent = t3.wr_parent and
            left(t1.wr_comment_reply, length( t1.wr_comment_reply) -1) = t3.wr_comment_reply and
            datediff(now(), t1.wr_datetime) <= $day_limit_all
        order by t1.wr_datetime desc";

    $link_stub = "";
} else {
	$sql = " select gr_id, bo_subject, bo_page_rows, bo_read_level, bo_use_rss_view from $g4[board_table] where bo_table = '$bo_table' ";
	$row = sql_fetch($sql);
	$subj2 = specialchars_replace($row[bo_subject], 255);
	//$lines = $row[bo_page_rows];
	$lines = 100;

	// 비회원 읽기가 가능한 게시판만 RSS 지원
	if ($row[bo_read_level] >= 2) {
		echo "비회원 읽기가 가능한 게시판만 RSS 지원합니다.";
		exit;
	}

	// RSS 사용 체크
	if (!$row[bo_use_rss_view]) {
		echo "RSS 보기가 금지되어 있습니다.";
		exit;
	}
	$tables_str = "$g4[write_prefix]$bo_table";

	$sql = " select gr_subject from $g4[group_table] where gr_id = '$row[gr_id]' ";
	$row = sql_fetch($sql);
	$subj1 = specialchars_replace($row[gr_subject], 255);
	$title = "$subj1 > $subj2";

	//$sql = " select wr_id, wr_subject, wr_content, wr_name, wr_datetime, wr_option, wr_is_comment
	//           from $g4[write_prefix]$bo_table
	//          where wr_is_comment = 0
	//            and wr_option not like '%secret%'
	//          order by wr_num, wr_reply limit 0, $lines ";

	$sql = "select t1.wr_id, t2.wr_subject, t1.wr_name,
			left(t1.wr_content,$rss_length_limit) as wr_content, char_length(t1.wr_content) as wr_len,
			t1.wr_datetime, t1.wr_option, t1.wr_is_comment,
			left(t3.wr_content, $rss_length_limit) as original, char_length(t3.wr_content) as original_len,
			length(t1.wr_comment_reply) as len_reply,
			t1.wr_parent
		from $tables_str as t1,
			 $tables_str as t2,
			 $tables_str as t3
		where t1.wr_option not like '%secret%' and
			t1.wr_parent = t2.wr_id and
			t1.wr_comment = t3.wr_comment and
			t1.wr_parent = t3.wr_parent and
			left(t1.wr_comment_reply, length( t1.wr_comment_reply) -1) = t3.wr_comment_reply and
			datediff(now(), t1.wr_datetime) <= $day_limit_single
		order by t1.wr_datetime desc";
    $link_stub = "$g4[bbs]/board.php?bo_table=$bo_table";
}

Header("Content-type: text/xml");
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

echo "<?xml version=\"1.0\" encoding=\"$g4[charset]\"?>\n";
echo "<rss version=\"2.0\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n";
echo "<channel>\n";
echo "<title>".specialchars_replace("$config[cf_title] > $title") ."</title>\n";
echo "<link>".specialchars_replace("$g4[url]/$link_stub")."</link>\n";
echo "<description>테스트 버전 0.3j4 (2009-09-16)</description>\n";
echo "<language>ko</language>\n";

$result = sql_query($sql);

for ($i=0; $row=sql_fetch_array($result); $i++) {
    $file = "";

    if (strstr($row[wr_option], 'html'))
        $html = 1;
    else
        $html = 0;

    echo "<item>\n";
    if($do_all) {
	    echo "<title> [".specialchars_replace($row[bo_subject])."] ".specialchars_replace($row[wr_subject])."</title>\n";
		echo "<link>".specialchars_replace("$g4[url]/$g4[bbs]/board.php?bo_table=$row[bo_table]&wr_id=$row[wr_parent]");
    } else {
	    echo "<title>".specialchars_replace($row[wr_subject])."</title>\n";
		echo "<link>".specialchars_replace("$g4[url]/$g4[bbs]/board.php?bo_table=$bo_table&wr_id=$row[wr_parent]");
	}
	if($row[wr_is_comment]) {
		echo specialchars_replace("&c_id=$row[wr_id]#c_$row[wr_id]");
	}
	// 댓글 링크엔 c_id 넘겨주어 해당 댓글 밑에 댓글 박스 열리도록. (JesusReigns 9/16/09)
	echo "</link>\n";

    echo "<description><![CDATA[".$file . conv_content($row[wr_content], $html);
    if($row[wr_len] > $rss_length_limit) {
        echo " .... ";
    }
    if($row[len_reply] != 0) {
        echo "<br><br>앞글 내용 :<br> ".conv_content($row[original], $html);
		if($row[original_len] > $rss_length_limit) {
			echo " .... ";
		}
    }

    echo "]]></description>\n";
    echo "<dc:creator>".specialchars_replace($row[wr_name])."</dc:creator>\n";
    $date = $row[wr_datetime];
    // rss 리더 스킨으로 호출하면 날짜가 제대로 표시되지 않음
    //$date = substr($date,0,10) . "T" . substr($date,11,8) . "+09:00";
    $date = date('r', strtotime($date));
    echo "<dc:date>$date</dc:date>\n";
    echo "</item>\n";
}

echo "</channel>\n";
echo "</rss>\n";
?>
