
/*	============================================================================
	============================================================================
	==
	==		kplayer_audio_event.js
	==
	==		 kplayer event  script
	==
	============================================================================
	============================================================================*/

// ۸ ̺Ʈ
function OnBufferingChange(Start){
	bIsBufferMode = Start;

	if (bIsBufferMode){
		DisplayState(KP_PlayState);
		DisPlayBuffer();
	}else{
		DisplayState(KP_PlayState);
	}
}


// PlayState ̺Ʈ
function OnPlayStateChange(NewState){
	KP_PlayState = NewState;

	switch (KP_PlayState){
	case 0:
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(0);
		break;

	case 1:   /// ''
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;

			if (bIsTwoLyrics) bTwoLyricsLoaded = false;

			if (disPlayState != null ) clearTimeout(disPlayState);
			if (disPlayBuff != null ) clearTimeout(disPlayBuff);
			Ticks = 0;
			RotSecs = 0;

			nCurrentPosition = 0;
			nCurrentDuration = 0;
			nPreTrackPosX = 0;
			nPosValue = 0;
			PlayText = '';

			DisplayState(1);
			DisplayInit();
			DisplayTrack();
			OpenListChange();
		break;

	case 2:   /// 'Ͻ '
			bIsPlayMode = false;
			bIsPauseMode = true;
			bIsStopMode = false;

			if (disPlayState != null ) clearTimeout(disPlayState);
			if (disPlayBuff != null ) clearTimeout(disPlayBuff);
			Ticks = 0;
			RotSecs = 0;

			DisplayState(2);
			DisplaySong();
		break;

	case 3:   /// ' '
			bIsPlayMode = true;
			bIsPauseMode = false;
			bIsStopMode = false;

			DisplayDuration();
			DisplayState(3);
			DisplaySong();
			DisplayTrack();
			ShowMediaKBPS(GetBitRate(1));
			ShowMediaType(GetMediaType());
		break;

	case 4:
		break;

	case 5:
		break;

	case 6:    /// '۸'
		break;

	case 7:    ///  ' ...'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(7);
			//DisplayInit();
		break;

	case 8:   /// 'ħ'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			bIsEndOfStream = true;
			DisplayInit();

			if (bIsTwoLyrics){bTwoLyricsLoaded = false; GetTwoLyricsInit();}
			if (OnPlay != null ) clearTimeout(OnPlay);
			if (disPlayState != null ) clearTimeout(disPlayState);
			if (disPlayBuff != null ) clearTimeout(disPlayBuff);

			if (bIsEndOfStream) StreamChange();
		break;

	case 9:   /// 'ȯ '
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(9);
			//DisplayInit();
		break;

	case 10:  /// 'غ'
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(10);
			//DisplayInit();
		break;

	case 11:   /// 'ٽ  õ '
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
			DisplayState(11);
		break;
	}
}



// OpenState ̺Ʈ
function OnOpenStateChange(NewState){
	KP_OpenState = NewState;
	switch (KP_OpenState){
	case 0:
			bIsPlayMode = false;
			bIsPauseMode = false;
			bIsStopMode = true;
		break;

	case 1:
		break;

	case 2:  /// '  ã ...'
		break;

	case 3:  /// ' Ͽ  ...'
		break;

	case 4:   /// '  ε ...'
		break;

	case 5:   /// '   ...'
		break;

	case 6:
		break;

	case 7:
		break;

	case 8:  /// '̵  ...'
		break;

	case 9:   /// '̵ ã ...'
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		ImageShow(KP_PLAY_STATE_IMAGE.childNodes[0], MediaSearch);
		ShowState('̵ ã ....');
		break;

	case 10:   /// '̵  ...'
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		ImageShow(KP_PLAY_STATE_IMAGE.childNodes[0], MediaSearch);
		ShowState('̵  ....');
		break;

	case 11:   /// '̵ ε ...'
		break;

	case 12:   /// '̵  ...'
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		ImageShow(KP_PLAY_STATE_IMAGE.childNodes[0], MediaOpening);
		ShowState('̵  ....');
		break;

	case 13:   /// '̵ '

		bIsLiveBroadcast = (GetMediaInfo('Type') == 'broadcast');
		nCurrentDuration = parseInt(KP_KPlayer.CurrentMedia.Duration);
		if (nCurrentDuration > 0){
			PlayText = '[' + TotalTime(nCurrentDuration) + ']';
		}else{
			PlayText = '';
		}

		DisplayTrack();
		ShowMediaKBPS(GetBitRate(1));
		ShowMediaType(GetMediaType());
		break;

	case 14:   /// 'ڵ  ...'
		break;

	case 15:   /// 'ڵ '
		break;

	case 16:   /// '̼  ...'
		break;

	case 17:   /// '̼ '
		break;

	case 18:   /// 'ȭ  ...'
		break;

	case 19:   /// 'ȭ Ϸ'
		break;

	case 20:  /// ' '
		break;

	default:
		break;
	}
}


// Error ̺Ʈ
function OnError(){

	if(KP_Error.errorCount > 0){
		KP_Controls.Stop();

		errCount++;

		bIsBufferMode = false;
		bIsPlayMode = false;
		bIsPauseMode = false;
		bIsStopMode = true;
		DisplayState(99);
		DisplayInit();
		DisplaySong();
		DisplayTrack();

		if (errCount <= 4){
			if (bIsTwoLyrics){
				ShowTwoLyrics1('  õ(' + errCount + ') Դϴ.');
				ShowTwoLyrics2('ø ٷּ.');
			}else{
				ShowState('  õ(' + errCount + ') Դϴ.');
			}
			OnErrPlay = setTimeout('PlayMusic(' + nCurrentTrack + ');', 3000);
		}else{
			OnErrorNext();
		}
		KP_Error.clearErrorQueue();
	}
}


function OnErrorNext(){
	if ((nTotalTrack - 1) == 0 && (strLoopMode == 'one' || strLoopMode == 'none') && !bIsRandomMode){
		if (bIsTwoLyrics){
			ShowTwoLyrics1(' ε   ϴ.');
			ShowTwoLyrics2('. ٸ ϼ.');
			ShowState('̵  ȵ');
		}else{
			ShowState('. ٸ ϼ.');
		}
		errCount = 0;
	}else if ((nTotalTrack - 1) > 0 && strLoopMode == 'one' && !bIsRandomMode){
		if (bIsTwoLyrics){
			ShowTwoLyrics1(' ε   ϴ.');
			ShowTwoLyrics2('ٸ  մϴ.');
		}else{
			ShowState('. ٸ մϴ.');
		}
		OnErrRandom = setTimeout('RandomNext();', 3000);
		errCount = 0;
	}else if ((nTotalTrack - 1) > 0 && strLoopMode == 'none' && nCurrentTrack == (nTotalTrack - 1) && !bIsRandomMode){
		if (bIsTwoLyrics){
			ShowTwoLyrics1(' ε   ϴ.');
			ShowTwoLyrics2('. ٸ ϼ.');
			ShowState('̵  ȵ');
		}else{
			ShowState('. ٸ ϼ.');
		}
		errCount = 0;
	}else{
		if (bIsTwoLyrics){
			ShowTwoLyrics1(' ε   ϴ.');
			ShowTwoLyrics2('  մϴ.');
		}else{
			ShowState('.  մϴ.');
		}
		OnErrStream = setTimeout('StreamChange();', 3000);
		errCount = 0;
	}
}

function OnErrTimer(){
	if (OnErrPlay != null ) clearTimeout(OnErrPlay);
	if (OnErrRandom != null ) clearTimeout(OnErrRandom);
	if (OnErrStream != null ) clearTimeout(OnErrStream);
}
