
/*	============================================================================
	============================================================================
	==
	==		kplayer_audio_player.js
	==
	==		 kplayer player  script
	==
	============================================================================
	============================================================================*/

// ÷̾ ʱȭ
function SetKPlayerInit(){
	
	// ü
	KP_BG_TOP            = getID("bg_top");
	KP_BG_STATE          = getID("bg_state");
	if (bIsTwoLyrics) KP_BG_TWOLYRICS = getID("bg_twolyrics");
	KP_BG_FRAME          = getID("bg_frame");
	KP_BG_CONTROL        = getID("bg_control");
	KP_BG_LOGO           = getID("bg_logo");
	
	KP_BTN_WINDOW_CLOSE  = getID("btn_window_close");
	KP_BTN_LOOP_ALL      = getID("btn_loop_all");
	KP_BTN_LOOP_ONE      = getID("btn_loop_one");
	KP_BTN_RANDOM        = getID("btn_random");
	KP_BTN_LAPTIME       = getID("btn_laptime");
	KP_BTN_OPEN_CLOSE    = getID("btn_open_close");
	KP_BTN_ACT           = getID("btn_act");
	KP_BTN_STOP          = getID("btn_stop");
	KP_BTN_PREV          = getID("btn_prev");
	KP_BTN_NEXT          = getID("btn_next");
	KP_BTN_MUTE          = getID("btn_mute");
	KP_TRACK_BAR         = getID("track_bar");
	KP_VOLUME_BAR        = getID("volume_bar");
	KP_BTN_VIEW_CHANGE   = getID("btn_view_change");

	KP_CURRENT_TIME      = getID("current_time");
	KP_MEDIA_KBPS        = getID("media_kbps");
	KP_MEDIA_TYPE        = getID("media_type");
	KP_MEDIA_MODE        = getID("media_mode");
	KP_TOTAL_TRACK       = getID("total_track");
	KP_CURRENT_TRACK     = getID("current_track");
	KP_PLAY_STATE_IMAGE  = getID("play_state_image");
	KP_PLAY_STATE        = getID("play_state");
	KP_PERCENT_STATE     = getID("percent_state");

	if (bIsTwoLyrics){
		KP_TWO_LYRICS1   = getID("two_lyrics1");
		KP_TWO_LYRICS2   = getID("two_lyrics2");
	}
	KP_LABEL_COUNT       = getID("label_count");

	KP_VIEW_PLAY_LIST    = getID("view_play_list");
	KP_VIEW_PLAY_LYRICS  = getID("view_play_lyrics");

	//  ̹ 
	KPBG_TOP();
	KPBG_STATE();
	if (bIsTwoLyrics) KPBG_TWOLYRICS();
	KPBG_FRAME();
	KPBG_CONTROL();
	KPBG_LOGO();

	//  window close ư ̹ 
	KPBTN_WINDOW_CLOSE();

	//  mode  ư ̹ 
	KPBTN_LOOP_ALL();
	KPBTN_LOOP_ONE();
	KPBTN_RANDOM();
	KPBTN_LAPTIME();
	KPBTN_OPEN_CLOSE();

	// ϴ play ư ̹ 
	KPBTN_ACT();
	KPBTN_STOP();
	KPBTN_PREV();
	KPBTN_NEXT();
	KPBTN_MUTE();

	// Ʈ,  ̹ 
	KPBTN_TRACK_BAR();
	KPBTN_VOLUME_BAR();

	KPBTN_VIEW_CHANGE();			// playlist, lyrics  ư ̹ 

	//  , / , ٰ 
	KPSTATE_CURRENT_TIME();         //  ð
	if (bIsImage){
		BlockDisplay(getID('timer_num1_0'), '');
		BlockDisplay(getID('timer_num2_0'), '');
		BlockDisplay(getID('timer_num3_colon'), '');
		BlockDisplay(getID('timer_num4_0'), '');
		BlockDisplay(getID('timer_num5_0'), '');
	}
	KPSTATE_MEDIA_KBPS();           // mediakbps
	KPSTATE_MEDIA_TYPE();           // mediatype
	KPSTATE_MEDIA_MODE();           // mediamode
	KPSTATE_TOTAL_TRACK();          // ü Ʈ
	KPSTATE_CURRENT_TRACK();        //  Ʈ
	KPSTATE_PLAY_STATE_IMAGE();     //   ̹
	KPSTATE_PLAY_STATE();           //  
	KPSTATE_PERCENT_STATE();        // , , Ʈ ˻ % 
	
	if (bIsTwoLyrics){              //  
		KPLYRICS_TWO_LYRICS1();
		KPLYRICS_TWO_LYRICS2();
	}

	KPSTATE_LABEL_COUNT();		// / count

	// /
	KPVIEW_PLAY_LIST();
	KPVIEW_PLAY_LYRICS();

	ToolTipInit();
	SetPlayListOnload();
	DisplayInit();
	DisplayTrack();
	SetVolume();

	bIsLoaded = true;
}


// ε ̺Ʈ
function KPlayer_OnLoad(){

	// window resize 
	SetDivCheck();
	SetWinResize();
	
	// Window Media Player Plug-in, Mozilla ActiveX control and plugin üũ
	if (!BrInfo.ie5){
		if (!IsNSPluginInstalled() || !IsNSPluginInstalled2()){
			ErrAlt();
			window.close();
		}
	}

	// Window Media Player ü
	KP_KPlayer = getID("kplayer");
	KP_Controls = KP_KPlayer.Controls;
	KP_Settings = KP_KPlayer.Settings;
	KP_Network = KP_KPlayer.Network;
	KP_Error = KP_KPlayer.Error;
	
	// WMP  üũ (WMP 7.x+)
	var WMPVer = KP_KPlayer.VersionInfo;
	var strVer = new String(WMPVer);
	s = strVer.split('.');
	var fHasWMP7 = s[0];
	if (!WMPVer || WMPVer == null || !fHasWMP7 || fHasWMP7 == null || fHasWMP7 < 7 || fHasWMP7 == 'undefined'){
		ErrAlt();
		window.close();
	}else{
		nCurrentTrack = (bIsRandomMode && strLoopMode == 'none') ? Math.floor(Math.random() * (nTotalTrack-1)) : 0;
	
		SetKPlayerInit();  // ÷̾ design ʱȭ
		
		WinReSize();

		//   ȵ  üũ
		if (MediaInfo == null){ TrackErr(); return false;}

		if (bIsLoaded){
			if (!bIsAutoStart){
				OnPlay = setTimeout('StopInit()', 2000);
			}else{
				OnPlay = setTimeout('PlayMusic2(' + nCurrentTrack + ')', 2000); // ε ó 
			}
		}
	}
}


// window resize 
function SetWinResize(){
	if (BrInfo.ie5){
		var win_width2 = win_width + winw;
		var win_height2 = win_height + winh;
	}else if (BrInfo.ns6){
		var win_width2 = win_width + winw;
		var win_height2 = win_height + winh;
	}else{
		ErrAlt();
	}
	window.resizeTo(win_width2, win_height2);
	window.focus();
}

function WinReSize(){
	if (window.innerHeight || window.innerWidth){
		if (win_height > window.innerHeight || win_width > window.innerWidth){
			var win_width2 = win_width + (window.outerWidth - window.innerWidth);
			var win_height2 = win_height + (window.outerHeight - window.innerHeight);
			window.resizeTo(win_width2, win_height2);
			window.focus();
		}
	}else{
		if (document.body && (document.body.clientHeight || document.body.clientWidth)){
			if (win_height > document.body.clientHeight || win_width > document.body.clientWidth){
				var win_width2 = win_width + winw + (document.body.scrollWidth - document.body.clientWidth);
				var win_height2 = win_height + winh + (document.body.scrollHeight - document.body.clientHeight);
				window.resizeTo(win_width2, win_height2);
				window.focus();
			}
		}else if (document.documentElement && (document.documentElement.clientHeight || document.documentElement.clientWidth)){
			if (win_height > document.documentElement.clientHeight || win_width > document.documentElement.clientWidth){
				var win_width2 = win_width + winw + (document.documentElement.scrollWidth - document.documentElement.clientWidth);
				var win_height2 = win_height + winh + (document.documentElement.scrollHeight - document.documentElement.clientHeight);
				window.resizeTo(win_width2, win_height2);
				window.focus();
			}
		}
	}
}


// display : block / display : none
function BlockDisplay(objName, f_type){
	objName.style.display = f_type;
}

// ġ ̵ (left, top)
function DivMoveToLT(objName, X, Y){
	objName.style.left = X + 'px';
	objName.style.top = Y + 'px';
}

// ġ ̵ (top)
function DivMoveToT(objName, Y){
	objName.style.top = Y + 'px';
}

// ġ ̵ (left)
function DivMoveToL(objName, X){
	objName.style.left = X + 'px';
}

//   (height, width)
function DivMoveToHW(objName, H, W){
	objName.style.height = H + 'px';
	objName.style.width = W + 'px';
}

//   (height)
function DivMoveToH(objName, H){
	objName.style.height = H + 'px';
}

//   (width)
function DivMoveToW(objName, W){
	objName.style.width = W + 'px';
}


// üð
function TotalTime(playtem){
	var playTimeText = '';

	var nHours = Math.floor((playtem / 3600));
	if (nHours < 10) nHours = '0' + nHours;

	var nMinutes = Math.floor((playtem / 60) - (nHours * 60));
	if (nMinutes < 10) nMinutes = '0' + nMinutes;

	var nSeconds = Math.floor(playtem - (nMinutes * 60));
	if (nSeconds < 10) nSeconds = '0' + nSeconds;

	playTimeText = (nHours == 00) ? nMinutes + ':' + nSeconds : nHours + ':' + nMinutes + ':' + nSeconds;

	return playTimeText;
}


// ð
function PlayTime(playtem){
	var playtem2 = 0;
	if (nCurrentDuration > 0){
		if (bIsLapTime){
			playtem2 = nCurrentDuration - playtem;
		}else{
			playtem2 = playtem;
		}
	}else{
		playtem2 = playtem;
	}

	PlayTimeSet(playtem2);
}


// Ʈ ˻ 巡 ̵ ð
function PlayTime2(playtem){
	var playtem2 = parseInt((playtem / nTrackBarWidth) * nCurrentDuration);
	var playtem3 = 0;
	if(playtem2 < 0) playtem2 = 0;
	if(playtem2 > nCurrentDuration) playtem2 = nCurrentDuration;
	nPosValue = playtem2;

	if (bIsLapTime){
		playtem3 = nCurrentDuration - playtem2;
	}else{
		playtem3 = playtem2;
	}

	PlayTimeSet(playtem3);
}


function PlayTimeSet(playtem){

	var nMinutes = Math.floor((playtem / 60));
	var nSeconds = Math.floor(playtem - (nMinutes * 60));

	if (bIsImage){
		var playTime1 = '';
		var playTime2 = '';
		var playTime3 = '';
		var playTime4 = '';
		var playTime5 = '';

		if (nMinutes < 10){
			playTime1 = 0;
			playTime2 = nMinutes;
			playTime3 = ':';
			if (nSeconds < 10){
				playTime4 = 0;
				playTime5 = nSeconds;
			}else{
				playTime4 = Math.floor(nSeconds/10);
				playTime5 = Math.floor(nSeconds%10);
			}
		}else if (nMinutes < 100){
			playTime1 = Math.floor(nMinutes/10);
			playTime2 = Math.floor(nMinutes%10);
			playTime3 = ':';
			if (nSeconds < 10){
				playTime4 = 0;
				playTime5 = nSeconds;
			}else{
				playTime4 = Math.floor(nSeconds/10);
				playTime5 = Math.floor(nSeconds%10);
			}
		}else if (nMinutes < 1000){
			playTime1 = Math.floor(nMinutes/100);
			playTime2 = Math.floor(Math.floor(nMinutes%100)/10);
			playTime3 = Math.floor(nMinutes%10);
			playTime4 = ':';
			playTime5 = Math.floor(nSeconds/10);
		}else if (nMinutes < 10000){
			playTime1 = Math.floor(nMinutes/1000);
			playTime2 = Math.floor(Math.floor(nMinutes%1000)/100);
			playTime3 = Math.floor(Math.floor(nMinutes%100)/10);
			playTime4 = Math.floor(nMinutes%10);
			playTime5 = ':';
		}
		
		if(timeNum1 != playTime1){
			BlockDisplay(getID('timer_num1_' + timeNum1), 'none');
			timeNum1 = playTime1;
			switch(playTime1){
				case 0: BlockDisplay(getID('timer_num1_0'), ''); break;
				case 1: BlockDisplay(getID('timer_num1_1'), ''); break;
				case 2: BlockDisplay(getID('timer_num1_2'), ''); break;
				case 3: BlockDisplay(getID('timer_num1_3'), ''); break;
				case 4: BlockDisplay(getID('timer_num1_4'), ''); break;
				case 5: BlockDisplay(getID('timer_num1_5'), ''); break;
				case 6: BlockDisplay(getID('timer_num1_6'), ''); break;
				case 7: BlockDisplay(getID('timer_num1_7'), ''); break;
				case 8: BlockDisplay(getID('timer_num1_8'), ''); break;
				case 9: BlockDisplay(getID('timer_num1_9'), ''); break;
			}
		}
		if(timeNum2 != playTime2){
			BlockDisplay(getID('timer_num2_' + timeNum2), 'none');
			timeNum2 = playTime2;
			switch(playTime2){
				case 0: BlockDisplay(getID('timer_num2_0'), ''); break;
				case 1: BlockDisplay(getID('timer_num2_1'), ''); break;
				case 2: BlockDisplay(getID('timer_num2_2'), ''); break;
				case 3: BlockDisplay(getID('timer_num2_3'), ''); break;
				case 4: BlockDisplay(getID('timer_num2_4'), ''); break;
				case 5: BlockDisplay(getID('timer_num2_5'), ''); break;
				case 6: BlockDisplay(getID('timer_num2_6'), ''); break;
				case 7: BlockDisplay(getID('timer_num2_7'), ''); break;
				case 8: BlockDisplay(getID('timer_num2_8'), ''); break;
				case 9: BlockDisplay(getID('timer_num2_9'), ''); break;
			}
		}
		if(timeNum3 != playTime3){
			BlockDisplay(getID('timer_num3_' + ((timeNum3 == ':') ? 'colon' : timeNum3)), 'none');
			timeNum3 = playTime3;
			switch(playTime3){
				case 0: BlockDisplay(getID('timer_num3_0'), ''); break;
				case 1: BlockDisplay(getID('timer_num3_1'), ''); break;
				case 2: BlockDisplay(getID('timer_num3_2'), ''); break;
				case 3: BlockDisplay(getID('timer_num3_3'), ''); break;
				case 4: BlockDisplay(getID('timer_num3_4'), ''); break;
				case 5: BlockDisplay(getID('timer_num3_5'), ''); break;
				case 6: BlockDisplay(getID('timer_num3_6'), ''); break;
				case 7: BlockDisplay(getID('timer_num3_7'), ''); break;
				case 8: BlockDisplay(getID('timer_num3_8'), ''); break;
				case 9: BlockDisplay(getID('timer_num3_9'), ''); break;
				default : BlockDisplay(getID('timer_num3_colon'), ''); break;
			}
		}
		if(timeNum4 != playTime4){
			BlockDisplay(getID('timer_num4_' + ((timeNum4 == ':') ? 'colon' : timeNum4)), 'none');
			timeNum4 = playTime4;
			switch(playTime4){
				case 0: BlockDisplay(getID('timer_num4_0'), ''); break;
				case 1: BlockDisplay(getID('timer_num4_1'), ''); break;
				case 2: BlockDisplay(getID('timer_num4_2'), ''); break;
				case 3: BlockDisplay(getID('timer_num4_3'), ''); break;
				case 4: BlockDisplay(getID('timer_num4_4'), ''); break;
				case 5: BlockDisplay(getID('timer_num4_5'), ''); break;
				case 6: BlockDisplay(getID('timer_num4_6'), ''); break;
				case 7: BlockDisplay(getID('timer_num4_7'), ''); break;
				case 8: BlockDisplay(getID('timer_num4_8'), ''); break;
				case 9: BlockDisplay(getID('timer_num4_9'), ''); break;
				default : BlockDisplay(getID('timer_num4_colon'), ''); break;
			}
		}
		if(timeNum5 != playTime5){
			BlockDisplay(getID('timer_num5_' + ((timeNum5 == ':') ? 'colon' : timeNum5)), 'none');
			timeNum5 = playTime5;
			switch(playTime5){
				case 0: BlockDisplay(getID('timer_num5_0'), ''); break;
				case 1: BlockDisplay(getID('timer_num5_1'), ''); break;
				case 2: BlockDisplay(getID('timer_num5_2'), ''); break;
				case 3: BlockDisplay(getID('timer_num5_3'), ''); break;
				case 4: BlockDisplay(getID('timer_num5_4'), ''); break;
				case 5: BlockDisplay(getID('timer_num5_5'), ''); break;
				case 6: BlockDisplay(getID('timer_num5_6'), ''); break;
				case 7: BlockDisplay(getID('timer_num5_7'), ''); break;
				case 8: BlockDisplay(getID('timer_num5_8'), ''); break;
				case 9: BlockDisplay(getID('timer_num5_9'), ''); break;
				default : BlockDisplay(getID('timer_num5_colon'), ''); break;
			}
		}
	}else{
		var playTimeText = '';
		if (nMinutes < 10) nMinutes = '0' + nMinutes;
		if (nSeconds < 10) nSeconds = '0' + nSeconds;
		playTimeText = nMinutes + ':' + nSeconds;
		ShowCurrentTime(playTimeText.substring(0, 5));
	}
}


// ð / ð 
function LapTimeChange(){
	bIsLapTime = !bIsLapTime;
	var nTrackPosX = 0;
	var nTrackPosX2 = 0;
	ImageShow(KP_CURRENT_TIME.childNodes[0].childNodes[0], (bIsLapTime ? minus_on : minus_off));
	if (nCurrentDuration > 0){
		nTrackPosX = parseInt((nTrackBarWidth * (nCurrentPosition / nCurrentDuration)));
		nTrackPosX2 = parseInt((nTrackPosX / nTrackBarWidth) * 100);
		nPreTrackPosX = (bIsLapTime) ? 100 - nTrackPosX2 : nTrackPosX2;
		if (bIsPlayMode || bIsPauseMode){
			PerState((bIsLapTime ? 100 - nTrackPosX2 : nTrackPosX2), 'mt');
		}else{
			ShowStatePercent('');
		}
	}else{
		nPreTrackPosX = 0;
		ShowStatePercent('');
	}
	if (bIsStopMode){
		if (bIsImage){
			TimerInit();
		}else{
			ShowCurrentTime(StopText);
		}
	}else{
		PlayTime(nCurrentPosition);
	}
	ImageShow(KP_BTN_LAPTIME.childNodes[0], (bIsLapTime ? laptime_down : laptime_on));
	ShowToolTip(KP_BTN_LAPTIME, (bIsLapTime ? ' ð ǥ ' : ' ð ǥ '));
}


// , ˻,  %
function PerState(per, f_type){
	var dash = (bIsLapTime) ? '-' : '';
	if (f_type == 'mt'){
		ShowStatePercent(dash + ((bIsStopMode) ? '(0%)' : '(' + per + '%)'));
	}else if (f_type == 'dt'){
		ShowStatePercent(dash + ((bIsStopMode) ? '˻(0%)' : '˻(' + per + '%)'));
	}else if (f_type == 'dv'){
		ShowStatePercent('(' + per + '%)');
	}
}


///  , ü ݺ ,  ݺ , Ʈ ѹ  - Ѱ  
function StreamChange(){

	bIsEndOfStream = false;

	if (bIsRandomMode){
		RandomNext();
	}else{
		switch (strLoopMode){
			case 'all':
				if (nCurrentTrack == (nTotalTrack - 1)){
					nCurrentTrack = 0;
				}else{
					nCurrentTrack = nCurrentTrack + 1;
				}
				PlayMusic(nCurrentTrack);
				break;
			case 'none':
				if (nCurrentTrack == (nTotalTrack - 1)){
					bIsFinished = true;
					KP_Controls.Stop();
				}else{
					nCurrentTrack = nCurrentTrack + 1;
					PlayMusic(nCurrentTrack);
				}
				break;
			case 'one':
				PlayMusic(nCurrentTrack);
				break;
		}
	}
}


///  
function DisplayDuration(){
	if (disPlayState != null ) clearTimeout(disPlayState);

	nCurrentPosition = parseInt(KP_Controls.CurrentPosition);
	if (nCurrentDuration > 0){
		//  ð
		if (!bSetTrackPos) PlayTime(nCurrentPosition);

		//  ϴ   
		if (!bIsBufferMode){
			if (bIsPlayMode) RotateState();
		}

		// 	  ǥ
		if (bIsTwoLyrics){
			if (!bSetTrackPos){
				if (bTwoLyricsLoaded) PlayTwoLyrics(nCurrentPosition);
			}
		}

		// ¹ ̱
		MoveTrackBar();

	}else{
		if (nCurrentPosition > 0){
			PlayTime(nCurrentPosition);

			if (!bIsBufferMode){
				if (bIsPlayMode) RotateState();
			}

		}else{
			nCurrentPosition = 0;
		}
	}

	disPlayState = setTimeout('DisplayDuration();', 500);
}


// music 
function PlayMusic(track){
	OnErrTimer();
	if (OnPlay != null ) clearTimeout(OnPlay);
	if (disPlayState != null ) clearTimeout(disPlayState);
	if (disPlayBuff != null ) clearTimeout(disPlayBuff);

	KP_Controls.Stop();

	if (bIsTwoLyrics){
		bTwoLyricsLoaded = false;
		ShowColor1('');
		ShowTwoLyrics1('');
		ShowColor2('');
		ShowTwoLyrics2('');
	}

	Ticks = 0;
	RotSecs = 0;

	OnPlay = setTimeout('PlayMusic2(' + track + ')', 1000);
}

function PlayMusic2(track){
	nCurrentTrack = eval(track);

	DisplaySong();
	ViewMode();
	DisplayTrack();
	if (bIsTwoLyrics) GetTwolyrics(); ///  //
	
	if (MediaInfo[nCurrentTrack].getFLChk() == 1){
		KP_KPlayer.URL = root + '/data/file/' + board + '/' + MediaInfo[nCurrentTrack].getFName();
	}else if (MediaInfo[nCurrentTrack].getFLChk() == 2){
		KP_KPlayer.URL = MediaInfo[nCurrentTrack].getFName();
	}
	KP_Controls.Play();

	bIsFinished = false;
}

//   Ʈ  ̵
function MoveTrackBar(){
	if (!bSetTrackPos && KP_PlayState == 3){
		var nTrackPosX = parseInt((nTrackBarWidth * (nCurrentPosition / nCurrentDuration)) + nTrackBarStartPos);
		var nTrackPosX2 = nTrackPosX - nTrackBarStartPos;
		nPreTrackPosX = (bIsLapTime) ? 100 - parseInt((nTrackPosX2 / nTrackBarWidth) * 100) : parseInt((nTrackPosX2 / nTrackBarWidth) * 100);
		DivMoveToL(KP_TRACK_BAR, parseInt(nTrackPosX));
		if (!bSetVolumePos) PerState(nPreTrackPosX, 'mt');
	}
}


// TrackBar/ VolumeBar 
function TrackBarMouseDown(e){
	var evt = (!e) ? window.event : e;
	var check = (((evt.which) && (evt.which == 1)) || ((evt.button) && (evt.button == 1)));
	ImageShow(KP_TRACK_BAR.childNodes[0], track_bar_hover);
	if (check){
		if (nCurrentDuration > 0){
			if (KP_PlayState > 1 && KP_PlayState < 4){
				bSetTrackPos = true;
				PerState(nPreTrackPosX, 'dt');
				barTempPosX = evt.clientX;
				barTempPosL = parseInt(KP_TRACK_BAR.style.left);
				nPosValue = KP_Controls.CurrentPosition;
				if (document.addEventListener){
					document.addEventListener("mousemove", DragMoveBar, false);
					document.addEventListener("mouseup", DragUpBar, false);
				}else if (document.attachEvent){
					document.attachEvent("onmousemove", DragMoveBar);
					document.attachEvent("onmouseup", DragUpBar);
					document.attachEvent("onlosecapture", DragUpBar);
					document.setCapture();
				}else{
					document.onmousemove = DragMoveBar;
					document.onmouseup = DragUpBar;
				}
			}else{
				bSetTrackPos = false;
			}
		}else{
			bSetTrackPos = false;
		}
	}
	return false;
}


function VolumeBarMouseDown(e){
	var evt = (!e) ? window.event : e;
	var check = (((evt.which) && (evt.which == 1)) || ((evt.button) && (evt.button == 1)));
	ImageShow(KP_VOLUME_BAR.childNodes[0], volume_bar_hover);
	if (check){
		bSetVolumePos = true;
		PerState(KP_Settings.Volume, 'dv');
		barTempPosX = evt.clientX;
		barTempPosL = parseInt(KP_VOLUME_BAR.style.left);
		if (document.addEventListener){
			document.addEventListener("mousemove", DragMoveBar, false);
			document.addEventListener("mouseup", DragUpBar, false);
		}else if (document.attachEvent){
			document.attachEvent("onmousemove",DragMoveBar);
			document.attachEvent("onmouseup", DragUpBar);
			document.attachEvent("onlosecapture", DragUpBar);
			document.setCapture();
		}else{
			document.onmousemove = DragMoveBar;
			document.onmouseup = DragUpBar;
		}
	}
	return false;
}


function DragMoveBar(e){
	var evt = (!e) ? window.event : e;
	if (bSetTrackPos){
		nPosX = barTempPosL + evt.clientX - barTempPosX;
		if (nTrackBarStartPos > nPosX) nPosX = nTrackBarStartPos;
		if (nTrackBarEndPos < nPosX) nPosX = nTrackBarEndPos;
		DragMoveBarSet();
	}else if (bSetVolumePos){
		if(!bIsMuteMode){
			nVolX = barTempPosL + evt.clientX - barTempPosX;
			if (nVolumeBarStartPos > nVolX) nVolX = nVolumeBarStartPos;
			if (nVolumeBarEndPos < nVolX) nVolX = nVolumeBarEndPos;
			DragMoveBarSet();
		}
	}
	return false;
}

function DragMoveBarSet(){
	if (bSetTrackPos){
		var nPosX2 = nPosX - nTrackBarStartPos;
		DivMoveToL(KP_TRACK_BAR, parseInt(nPosX));
		nPreTrackPosX = (bIsLapTime) ? 100 - parseInt((nPosX2 / nTrackBarWidth) * 100) : parseInt((nPosX2 / nTrackBarWidth) * 100);
		PerState(nPreTrackPosX, 'dt');
		PlayTime2(nPosX2);
		if (bIsTwoLyrics) PlayTwoLyrics(nPosValue);
	}else if (bSetVolumePos){
		var nVolX2 = parseInt(((nVolX - nVolumeBarStartPos) / (nVolumeBarWidth)) * 100);
		DivMoveToL(KP_VOLUME_BAR, parseInt(nVolX));
		PerState(nVolX2, 'dv');
		KP_Settings.Volume = nVolX2;  // (0 - 100)
		setCookieVolume(nVolX);
	}
}


function DragUpBar(){
	if (document.removeEventListener){
		document.removeEventListener("mousemove", DragMoveBar, false);
		document.removeEventListener("mouseup", DragUpBar, false);
	}else if (document.detachEvent){
		document.detachEvent("onmousemove",DragMoveBar);
		document.detachEvent("onmouseup", DragUpBar);
		document.detachEvent("onlosecapture", DragUpBar);
		document.releaseCapture();
	}else{
		document.onmousemove = null;
		document.onmouseup = null;
	}

	if (bSetTrackPos){
		bSetTrackPos = false;
		KP_Controls.CurrentPosition = nPosValue;
		if (!bIsPlayMode){
			nCurrentPosition = parseInt(KP_Controls.CurrentPosition);
			PerState(nPreTrackPosX, 'mt');
		}
	}else if (bSetVolumePos){
		bSetVolumePos = false;
		if (bIsPauseMode){
			PerState(nPreTrackPosX, 'mt');
		}else if (bIsStopMode){
			ShowStatePercent('');
		}else if (!(nCurrentDuration > 0)){
			ShowStatePercent('');
		}else if (bIsBufferMode){
			PerState(nPreTrackPosX, 'mt');
		}
	}
	return false;
}


//  
function SetVolume(){
	var nVolume = (bIsMuteMode) ? nVolumeBarStartPos : getCookieVolume(); //(180 - 280) ġ px

	if (nVolumeBarStartPos > nVolume) nVolume = nVolumeBarStartPos;
	if (nVolumeBarEndPos < nVolume) nVolume = nVolumeBarEndPos;

	var nVolX2 = parseInt(((nVolume - nVolumeBarStartPos) / (nVolumeBarWidth)) * 100);

	nPreVolumePosX = parseInt(nVolume);
	DivMoveToL(KP_VOLUME_BAR, parseInt(nVolume));
	KP_Settings.Volume = nVolX2;  // (0 - 100)
}


// play control  ///////////
// Ұ
function SetMute(){
	KP_Settings.Mute = (bIsMuteMode = !bIsMuteMode);
	if (KP_Settings.Mute){
		ImageShow(KP_BTN_MUTE.childNodes[0], mute_down);
		ShowToolTip(KP_BTN_MUTE, ' Ҹ ');
		nPreVolumePosX = parseInt(KP_VOLUME_BAR.style.left);
		DivMoveToL(KP_VOLUME_BAR, parseInt(nVolumeBarStartPos));
		KP_Settings.Volume = 0;
	}else{
		ImageShow(KP_BTN_MUTE.childNodes[0], mute_on);
		ShowToolTip(KP_BTN_MUTE, '  Ұ ');
		DivMoveToL(KP_VOLUME_BAR, parseInt(nPreVolumePosX));
		var nVolX3 = parseInt(((nPreVolumePosX - nVolumeBarStartPos) / nVolumeBarWidth) * 100);
		KP_Settings.Volume = nVolX3;
   }
}


//  / Ͻ
function SetAct(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	if (bIsBufferMode){
		return false;
	}else{
		if (bIsLiveBroadcast && (bIsPlayMode || KP_PlayState == 3)){
			return false;
		}else if (bIsPlayMode || KP_PlayState == 3){
			KP_Controls.Pause();
		}else if (bIsPauseMode || KP_PlayState == 2){
			KP_Controls.Play();
		}else if (bIsStopMode || KP_PlayState == 1){
			PlayMusic(nCurrentTrack);
			errCount = 0;
		}
	}
}


//  
function SetStop(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	KP_Controls.Stop();
	KP_KPlayer.Close();
	DisplayInit();

	if (bIsTwoLyrics){bTwoLyricsLoaded = false; GetTwoLyricsInit();}
	OnErrTimer();
	if (OnPlay != null ) clearTimeout(OnPlay);
	if (disPlayState != null ) clearTimeout(disPlayState);
	if (disPlayBuff != null ) clearTimeout(disPlayBuff);

	if (bIsBufferMode) bIsBufferMode = false;
	DisplayState(1);
	DisplaySong();

	if (bIsStopMode || KP_PlayState == 1) errCount = 0;
}


// 
function SetPrev(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	errCount = 0;

	if (bIsRandomMode){
		if (nTotalTrack - 1 == 0){
			alert('  ϴ.');
			return false;
		}else{
			RandomNext();
		}
	}else{
		switch (strLoopMode){
			case 'all':
				if (nCurrentTrack == 0){
					nCurrentTrack = nTotalTrack - 1;
				}else{
					nCurrentTrack = nCurrentTrack - 1;
				}
				PlayMusic(nCurrentTrack);
				break;
			case 'none':
				if (nCurrentTrack == 0){
					if (nTotalTrack - 1 == 0){
						alert('  ϴ.');
					}else{
						alert('ó Դϴ.');
					}
					return false;
				}else{
					nCurrentTrack = nCurrentTrack - 1;
					PlayMusic(nCurrentTrack);
				}
				break;
			case 'one':
				if (nTotalTrack - 1 == 0){
					alert('  ϴ.');
					return false;
				}else{
					if (nCurrentTrack == 0){
						nCurrentTrack = nTotalTrack - 1;
					}else{
						nCurrentTrack = nCurrentTrack - 1;
					}
					PlayMusic(nCurrentTrack);
				}
				break;
		}
	}
}


// 
function SetNext(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	errCount = 0;

	if (bIsRandomMode){
		if (nTotalTrack - 1 == 0){
			alert('  ϴ.');
			return false;
		}else{
			RandomNext();
		}
	}else{
		switch (strLoopMode){
			case 'all':
				if (nCurrentTrack == (nTotalTrack - 1)){
					nCurrentTrack = 0;
				}else{
					nCurrentTrack = nCurrentTrack + 1;
				}
				PlayMusic(nCurrentTrack);
				break;
			case 'none':
				if (nCurrentTrack == (nTotalTrack - 1)){
					if (nTotalTrack - 1 == 0){
						alert('  ϴ.');
					}else{
						alert(' Դϴ.');
					}
					return false;
				}else{
					nCurrentTrack = nCurrentTrack + 1;
					PlayMusic(nCurrentTrack);
				}
				break;
			case 'one':
				if (nTotalTrack - 1 == 0){
					alert('  ϴ.');
					return false;
				}else{
					if (nCurrentTrack == (nTotalTrack - 1)){
						nCurrentTrack = 0;
					}else{
						nCurrentTrack = nCurrentTrack + 1;
					}
					PlayMusic(nCurrentTrack);
				}
				break;
		}
	}
}


//  
function SetRandom(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	if (!bIsRandomMode){
		bIsRandomMode = true;
		strLoopMode = 'none';

		DisplaySong();

		ImageShow(KP_BTN_RANDOM.childNodes[0], random_down);
		ShowToolTip(KP_BTN_RANDOM, ' Ʈ ѹ  ');
		ImageShow(KP_BTN_LOOP_ALL.childNodes[0], loopall_on);
		ShowToolTip(KP_BTN_LOOP_ALL, ' ü ݺ  ');
		ImageShow(KP_BTN_LOOP_ONE.childNodes[0], loopone_on);
		ShowToolTip(KP_BTN_LOOP_ONE, '  ݺ  ');
		ImageShow(KP_MEDIA_MODE.childNodes[0], Mode_Random);

	}else{
		bIsRandomMode = false;
		strLoopMode = 'none';

		DisplaySong();

		ImageShow(KP_BTN_RANDOM.childNodes[0], random_on);
		ShowToolTip(KP_BTN_RANDOM, '  ݺ  ');
		ImageShow(KP_BTN_LOOP_ALL.childNodes[0], loopall_on);
		ShowToolTip(KP_BTN_LOOP_ALL, ' ü ݺ  ');
		ImageShow(KP_BTN_LOOP_ONE.childNodes[0], loopone_on);
		ShowToolTip(KP_BTN_LOOP_ONE, '  ݺ  ');
		ImageShow(KP_MEDIA_MODE.childNodes[0], Mode_One);
	}
}

function RandomNext(){
	if ((nTotalTrack - 1) == 0){
		PlayMusic(nCurrentTrack);
		errCount = 0;
	}else{
		var tmp;
		do{
			tmp = Math.floor(Math.random() * nTotalTrack);
			if (tmp != nCurrentTrack) break;
		}while(1);
		nCurrentTrack = eval(tmp);
		PlayMusic(nCurrentTrack);
		errCount = 0;
	}
}

//  ݺ 
function SetLoopOne(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	if (strLoopMode == 'one'){
		bIsRandomMode = false;
		strLoopMode = 'none';

		DisplaySong();

		ImageShow(KP_BTN_LOOP_ALL.childNodes[0], loopall_on);
		ImageShow(KP_BTN_LOOP_ONE.childNodes[0], loopone_on);
		ShowToolTip(KP_BTN_LOOP_ONE, '  ݺ  ');
		ImageShow(KP_BTN_RANDOM.childNodes[0], random_on);
		ImageShow(KP_MEDIA_MODE.childNodes[0], Mode_One);

	}else{
		bIsRandomMode = false;
		strLoopMode = 'one';

		DisplaySong();

		ImageShow(KP_BTN_LOOP_ALL.childNodes[0], loopall_on);
		ImageShow(KP_BTN_LOOP_ONE.childNodes[0], loopone_down);
		ShowToolTip(KP_BTN_LOOP_ONE, ' Ʈ ѹ  ');
		ImageShow(KP_BTN_RANDOM.childNodes[0], random_on);
		ImageShow(KP_MEDIA_MODE.childNodes[0], Mode_LoopOne);
	}
}


// ü ݺ 
function SetLoopAll(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	if(strLoopMode == 'all'){
		bIsRandomMode = false;
		strLoopMode = 'none';

		DisplaySong();

		ImageShow(KP_BTN_LOOP_ALL.childNodes[0], loopall_on);
		ShowToolTip(KP_BTN_LOOP_ALL, ' ü ݺ  ');
		ImageShow(KP_BTN_LOOP_ONE.childNodes[0], loopone_on);
		ShowToolTip(KP_BTN_LOOP_ONE, '  ݺ  ');
		ImageShow(KP_BTN_RANDOM.childNodes[0], random_on);
		ImageShow(KP_MEDIA_MODE.childNodes[0], Mode_One);

	}else{
		bIsRandomMode = false;
		strLoopMode = 'all';

		DisplaySong();

		ImageShow(KP_BTN_LOOP_ALL.childNodes[0], loopall_down);
		ShowToolTip(KP_BTN_LOOP_ALL, ' Ʈ ѹ  ');
		ImageShow(KP_BTN_LOOP_ONE.childNodes[0], loopone_on);
		ShowToolTip(KP_BTN_LOOP_ONE, '  ݺ  ');
		ImageShow(KP_BTN_RANDOM.childNodes[0], random_on);
		ImageShow(KP_MEDIA_MODE.childNodes[0], Mode_LoopAll);
	}
}


//   /  open / close
function PlayListOpen(){
	if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

	bIsOpenList = !bIsOpenList;
	if (bIsOpenList){
		SetDivCheck();
		SetWinResize();

		ImageShow(KP_BTN_OPEN_CLOSE.childNodes[0], openlist_down);

		BlockDisplay(KP_BG_FRAME, '');
		BlockDisplay(KP_LABEL_COUNT, '');
		BlockDisplay(KP_BTN_VIEW_CHANGE, '');
		if (strViewType == 'list'){
			BlockDisplay(KP_VIEW_PLAY_LIST, '');
		}else if (strViewType == 'lyrics'){
			BlockDisplay(KP_VIEW_PLAY_LYRICS, '');
		}
	}else{
		SetDivCheck();
		SetWinResize();

		ImageShow(KP_BTN_OPEN_CLOSE.childNodes[0], openlist_on);

		BlockDisplay(KP_BG_FRAME, 'none');
		BlockDisplay(KP_LABEL_COUNT, 'none');
		BlockDisplay(KP_BTN_VIEW_CHANGE, 'none');
		BlockDisplay(KP_VIEW_PLAY_LIST, 'none');
		BlockDisplay(KP_VIEW_PLAY_LYRICS, 'none');
	}

	//FrmLayerMoveTo();
	DivControlTopMove();
	OpenListTitle();
	SetPlayListOnload();

	WinReSize();
}


//  /  
function ViewTypeChg(){
	if (bIsOpenList){
		if (!bIsLoaded){ShowState('뷡 ۵ ϼ.');return false;}

		if (strViewType == 'lyrics'){
			strViewType = 'list';
			BlockDisplay(KP_VIEW_PLAY_LYRICS, 'none');
			BlockDisplay(KP_VIEW_PLAY_LIST, '');
			ImageShow(KP_BTN_VIEW_CHANGE.childNodes[0], list_change_on);
		}else if (strViewType == 'list'){
			strViewType = 'lyrics';
			BlockDisplay(KP_VIEW_PLAY_LIST, 'none');
			BlockDisplay(KP_VIEW_PLAY_LYRICS, '');
			ImageShow(KP_BTN_VIEW_CHANGE.childNodes[0], lyrics_change_on);
		}
		
		OpenListTitle();
		SetPlayListOnload();
	}
}


//  ( Ʈ   ) /  (   ̵)
function ViewMode(){
	if (bIsOpenList){
		if (strViewType == 'list'){
			TextColor();
		}else if (strViewType == 'lyrics'){
			KP_VIEW_PLAY_LYRICS.childNodes[0].childNodes[0].childNodes[0].childNodes[1].innerHTML = KPVIEW_PLAY_LYRICS_VIEW(nCurrentTrack);
			KP_VIEW_PLAY_LYRICS.scrollTop = '0px';
		}
		OpenListChange();
	}
}


// display ʱȭ
function DisplayInit(){
	if (bIsTwoLyrics){
		ShowColor1('');
		ShowTwoLyrics1('');
		ShowColor2('');
		ShowTwoLyrics2('');
	}
	
	ShowStatePercent('');
	ImageShow(KP_CURRENT_TIME.childNodes[0].childNodes[0], (bIsLapTime ? minus_on : minus_off));
	if (bIsImage){
		TimerInit();
	}else{
		ShowCurrentTime(StopText);
	}
	ShowMediaKBPS('');
	ShowMediaType('');
	DivMoveToL(KP_TRACK_BAR, parseInt(nTrackBarStartPos));
}


function TimerInit(){
	PlayTimeSet(0);
}


// tooltip ʱȭ
function ToolTipInit(){
	ShowState('ε ....');

	ShowToolTip(KP_BTN_LOOP_ALL, (!bIsRandomMode && strLoopMode == 'all') ? ' Ʈ ѹ  ' : ' ü ݺ  ');
	ShowToolTip(KP_BTN_LOOP_ONE, (!bIsRandomMode && strLoopMode == 'one') ? ' Ʈ ѹ  ' : '  ݺ  ');
	ShowToolTip(KP_BTN_RANDOM, (bIsRandomMode && strLoopMode == 'none') ? ' Ʈ ѹ  ' : '  ݺ  ');
	
	ShowToolTip(KP_BTN_ACT, '  ');
	ShowToolTip(KP_BTN_STOP, '  ');
	ShowToolTip(KP_BTN_PREV, '  ');
	ShowToolTip(KP_BTN_NEXT, '  ');
	ShowToolTip(KP_BTN_MUTE, ' Ұ ');
	
	ShowToolTip(KP_TRACK_BAR, ' Ʈ ˻ ');
	ShowToolTip(KP_VOLUME_BAR, '  ');
	
	ShowToolTip(KP_BTN_LAPTIME, (bIsLapTime) ? ' ð ǥ ' : ' ð ǥ ');

	OpenListTitle();
}


//   
function StopInit(){
	KP_Controls.Stop();

	bIsBufferMode = false;
	bIsPlayMode = false;
	bIsPauseMode = false;
	bIsStopMode = true;
	DisplayState(100);
}


function SetUnload(){
	if (BrInfo.ie5){
		OnErrTimer();
		if (OnPlay != null ) clearTimeout(OnPlay);
		if (disPlayState != null ) clearTimeout(disPlayState);
		if (disPlayBuff != null ) clearTimeout(disPlayBuff);

		KP_Controls.Stop();
		KP_KPlayer.Close();
	}
}


// MediaType (audio, video, playlist, radio)  FileType (mid, wave, asf, wma, wmv ...)
function GetMediaInfo(itemName){
	if (KP_OpenState == 13){
		return KP_KPlayer.CurrentMedia.getItemInfo(itemName);
	}
}

function GetMediaType(){
	var e = GetMediaInfo('MediaType');
	var e2 = GetMediaInfo('FileType');
	var onAir = GetMediaInfo('Type');
	var str = '';
	if (e == '' || e == null){
		str = '????';
	}else{
		if (e2 == '' || e2 == null){
			str = e.toUpperCase() + ((onAir == 'broadcast') ? GetFileType('LIVE') : (e.toUpperCase() == 'AUDIO') ? GetFileType('MP3') : '');
		}else{
			str = e.toUpperCase() + GetFileType(e2.toUpperCase());
		}
	}
	return str;
}

function GetFileType(type){
	var str = '';
	switch (type){
		case 'ASF': case 'ASX': case 'DVR_MS': case 'WPL': case 'WM': case 'WMX': case 'WMD': case 'WMZ':
			str = '(ASF)';
			break;
		case 'WMA': case 'WAX':
			str = '(WMA)';
			break;
		case 'WMV': case 'WVX':
			str = '(WMV)';
			break;
		case 'CDA':
			str = '(CDA)';
			break;
		case 'AVI':
			str = '(AVI)';
			break;
		case 'WAV':
			str = '(WAV)';
			break;
		case 'MPEG': case 'MPG': case 'MPE': case 'M1V': case 'MP2': case 'MPV2': case 'MP2V': case 'MPA':
			str = '(MPEG)';
			break;
		case 'MPGA':
			str = '(MPGA)';
			break;
		case 'MP3': case 'M3U': case 'PLS':
			str = '(MP3)';
			break;
		case 'MID': case 'MIDI': case 'RMI':
			str = '(MIDI)';
			break;
		case 'AIF': case 'AIFC': case 'AIFF':
			str = '(AIFF)';
			break;
		case 'AU': case 'SND':
			str = '(AU)';
			break;
		case 'DSM':
			str = '(DSM)';
			break;
		case 'DRC':
			str = '(DRC)';
			break;
		case 'DFX':
			str = '(DFX)';
			break;
		case 'OGA':
			str = '(OGA)';
			break;
		case 'OGG':
			str = '(OGG)';
			break;
		case 'OGM':
			str = '(OGM)';
			break;
		case 'OGV':
			str = '(OGV)';
			break;
		case 'LIVE':
			str = '(LIVE)';
			break;
		case 'ASP': case 'ASPX': case 'PHP': case 'JSP':
			str = '';
			break;
		default : 
			str = '';
			break;
	}
	return str;
}

function GetBitRate(type){
	var str = '';
	//var bit = KP_Network.BitRate;
	var bit = GetMediaInfo('Bitrate');
	if (bit > 0){
		if(GetMediaInfo('FileType').toUpperCase() == 'MP3' && (bit > 320000)){
			str = (type == 1) ? 'VBR' : 'VBR ';
		}else{
			if (type == 1){
				str = (bit > 1000) ? Math.floor(bit/1000) : (bit/1000);
			}else{
				str = (bit > 1000) ? Math.floor(bit/1000) + 'KB/ ' : parseInt(bit) + 'B/ ';
			}
		}
	}else{
		str = (type == 1) ? 'VBR' : 'VBR ';
	}
	return str;
}

// text cutting
function GetFileExt(str){
	var str2 = str;
	var e = 0;
	e = str2.lastIndexOf(".") + 1;
	str2 = str2.substring( e );
	return str2.toUpperCase();
}

function GetFileName(str){
	var str2 = str;
	var e = 0;
	e = str2.lastIndexOf(".");
	str2 = str2.substring(0, e);
	return str2;
}


function LenghtB(strType){
	var lenObj = 0;

	for (var i = 0; i < strType.length; i++){
		if (strType.charCodeAt(i) > 128){
			lenObj += 2;
		}else{
			lenObj += 1;
		}
	}
	return lenObj;
}

function SubStrB(strType, size){
	var str;
	var lenObj = 0;

	for (var i = 0; i < strType.length; i++){
		if (strType.charCodeAt(i) > 128){
			lenObj += 2;
		}else{
			lenObj += 1;
		}

		if (lenObj > size){
			str = strType.substr(0,i);
			return str;
		}
	}
}

function TextLeft(text, size){
	var str;
	var intSet = LenghtB(text);

	if (intSet > size){
		str = SubStrB(text, size) + '...';
	}else{
		str = text;
	}
	return str;
}


//  Ű 
function getCookieVolume(){
	var search = 'KPlayerVolume=';
	var returnvalue = '';
	if (document.cookie.length > 0){
		offset = document.cookie.indexOf(search);
		if (offset != -1){
			offset += search.length;
			end = document.cookie.indexOf(';', offset);
			if (end == -1)
			end = document.cookie.length;
			returnvalue=unescape(document.cookie.substring(offset, end));
		}
	}
	if(returnvalue == '') returnvalue = nVolValue; //(180 - 280) ġ px(230 ==>  50%)
	return Math.floor(returnvalue);
}


function setCookieVolume(value){
	document.cookie = 'KPlayerVolume=' + value;
}


// Netscape Navigator Mozilla ActiveX control and plugin ġ üũ
function IsNSPluginInstalled(){
	if (navigator.mimeTypes && navigator.mimeTypes["application/x-mplayer2"] && navigator.mimeTypes["application/x-mplayer2"].enabledPlugin){
		return true;
	}else{
		return false;
	}
}


function IsNSPluginInstalled2(){
	if (navigator.mimeTypes && navigator.mimeTypes["application/x-oleobject"] && navigator.mimeTypes["application/x-oleobject"].enabledPlugin){
		return true;
	}else{
		return false;
	}
}


function ErrAlt(){
	var isMsg = '÷̾ : \n'
			+ 'Window Media Player 7+ ̻ ġ\n\n'
			+ ' : \n'
			+ 'Internet Explorer 5.x+ ̻  ,\n\n'
			+ 'Netscape 7.x+,\n'
			+ 'Mozilla 1.x+,\n'
			+ 'Mozilla Firefox 0.9.x+,\n'
			+ '(Window Media Player Plug-in : \n'
			+ ' npds.zip \n'
			+ ' npdsplay.dll \n'
			+ ' npwmsdrm.dll,\n'
			+ 'Mozilla ActiveX control and plugin : \n'
			+ ' npmozax.dll\n'
			+ ') ̻ ÷ ġ  ֽŹ \n\n'
			+ '  .';
	alert(isMsg);
	window.close();
}


function TrackErr(){
	var isMsg = ' ϵ  ϴ.\n\n'
			+ ' ϼ.';
	alert(isMsg);
	window.close();
}


//window.onunload = function(){SetUnload();};

// Ű 
window.onerror = function(){return true;};

document.onkeydown = processKey;
document.onkeypress = processKey;

function processKey(e){
	var evt = (!e) ? window.event : e;
	if (evt.keyCode) evt.keyCode = 0;
	if (evt.preventDefault){
		evt.preventDefault();
		evt.stopPropagation();
	}else{
		evt.returnValue = false;
		evt.cancelBubble = true;
	}
	return false;
}