<?
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

function rss_array($url) {
  global $g_rss_array;
  // empty our global array
  $g_rss_array = array();
  // if the URL looks ok
  if(preg_match("/^http:\/\/([^\/]+)(.*)$/", $url, $matches)) {
    $host = $matches[1];
    $uri = $matches[2];
    $request = "GET $uri HTTP/1.0\r\n";
    $request .= "Host: $host\r\n";
    $request .= "Connection: close\r\n\r\n";
    // open the connection
    // 소켓 연결,  최대연결시간 10초로설정
  	if($http = @fsockopen($host, 80, $errno, $errstr, 10)) {
      // make the request
      fwrite($http, $request);
      // read in for max 10 seconds
      $timeout = time() + 10;
      while(time() < $timeout && !feof($http)) {
        $response .= fgets($http, 4096);
      }
      // split on two newlines
      list($header, $xml) = preg_split("/\r?\n\r?\n/", $response, 2);
      // get the status
      if(preg_match("/^HTTP\/[0-9\.]+\s+(\d+)\s+/", $header, $matches)) {
        $status = $matches[1];
        // if 200 OK
        if($status == 200) {
        // create the parser
        $xml_parser = xml_parser_create();
        xml_set_element_handler($xml_parser, "startElement", "endElement");
        xml_set_character_data_handler($xml_parser, "characterData");
        // parse!
        xml_parse($xml_parser, trim($xml), true) or $g_rss_array[errors][] = xml_error_string(xml_get_error_code($xml_parser)) . " at line " . xml_get_current_line_number($xml_parser);
        // free parser
        xml_parser_free($xml_parser);
        }
        else {
          $g_rss_array[errors][] = "Can't get feed: HTTP status code $status";
        }
      }
      // Can't get status from header
      else {
        $g_rss_array[errors][] = "Can't get status from header";
      }
    }
    else {
      echo "<B><font color=#FF5F00>현재 연결 할 수 없습니다.<br />RSS주소또는서버문제 잠시 후 다시 시도해 보세요.</font></B><br />";
    }
  }
  // Feed url looks wrong
  else {
    $g_rss_array[errors][] = "Invalid url: $url";
  }
  // unset 변수들
  unset($g_rss_array[channel_title]);
  unset($g_rss_array[channel_description]);
  unset($g_rss_array[channel_lastBuildDate]);
  unset($g_rss_array[channel_total]);
  unset($g_rss_array[inside_rdf]);
  unset($g_rss_array[inside_rss]);
  unset($g_rss_array[inside_channel]);
  unset($g_rss_array[inside_item]);
  unset($g_rss_array[image_title]);
  unset($g_rss_array[image_link]);
  unset($g_rss_array[current_tag]);
  unset($g_rss_array[current_title]);
  unset($g_rss_array[current_link]);
  unset($g_rss_array[current_description]);
  return $g_rss_array;
}
//this function will be called everytime a tag starts
function startElement($parser, $name) {
  global $g_rss_array;
  $g_rss_array[current_tag] = $name;
  if($name == "RSS") {
    $g_rss_array[inside_rss] = true;
  }
  else if($name == "RDF:RDF") {
   $g_rss_array[inside_rdf] = true;
  }
  else if($name == "CHANNEL") {
    $g_rss_array[inside_channel] = true;
    $g_rss_array[channel_title] = "";
    $g_rss_array[channel_description] = "";
    $g_rss_array[channel_lastBuildDate] = "";
    $g_rss_array[channel_total] = "";
    $g_rss_array[channel_language] = "";
  }
  else if(($g_rss_array[inside_rss] and $g_rss_array[inside_channel]) or $g_rss_array[inside_rdf]) {
    if($name == "ITEM") {
      $g_rss_array[inside_item] = true;
    }
    else if($name == "IMAGE") {
      $g_rss_array[inside_image] = true;
    }
  }
}
// this function will be called everytime there is a string between two tags
function characterData($parser, $data) {
  global $g_rss_array;
  if($g_rss_array[inside_item]) {
    switch($g_rss_array[current_tag]) {
      case "TITLE":
       $g_rss_array[current_title] .= $data;
        break;
      case "DESCRIPTION":
        $g_rss_array[current_description] .= $data;
        break;
      case "LINK":
        $g_rss_array[current_link] .= $data;
        break;
    }
  }
  elseif($g_rss_array[inside_channel]) {
    switch($g_rss_array[current_tag]) {
      case "TITLE":
        $g_rss_array[channel_title] .= $data;
        break;
      case "DESCRIPTION":
        $g_rss_array[channel_description] .= $data;
        break;
      case "LASTBUILDDATE":
        $g_rss_array[channel_lastBuildDate] .= $data;
        break;
      case "TOTAL":
        $g_rss_array[channel_total] .= $data;
        break;
      case "LANGUAGE":
        $g_rss_array[channel_language] .= $data;
        break;
    }
  }
}
// this function will be called everytime a tag ends
function endElement($parser, $name) {
  global $g_rss_array;
  // end of item, add complete item to array
  if($name == "ITEM") {
    $g_rss_array[items][] = array(title => trim($g_rss_array[current_title]), link => trim($g_rss_array[current_link]), description => trim($g_rss_array[current_description]));
    // reset these vars for next loop
    $g_rss_array[current_title] = "";
    $g_rss_array[current_description] = "";									
    $g_rss_array[current_link] = "";
    $g_rss_array[inside_item] = false;
  }
  else if($name == "RSS") {
    $g_rss_array[inside_rss] = false;
  }
  else if($name == "RDF:RDF") {
    $g_rss_array[inside_rdf] = false;
  }
  else if($name == "CHANNEL") {
    $g_rss_array[channel][title] = trim($g_rss_array[channel_title]);
    $g_rss_array[channel][description] = trim($g_rss_array[channel_description]);
    $g_rss_array[channel][lastBuildDate] = trim($g_rss_array[channel_lastBuildDate]);
    $g_rss_array[channel][total] = trim($g_rss_array[channel_total]);
    $g_rss_array[inside_channel] = false;
  }
}
// Naver OpenAPI 요청 변수 (request parameter) 선택
$s_requesturl = "http://openapi.naver.com/search?"; // OpenAPI 요청 url
$map_key = "등록키입력" ; // 이용 등록을 통해 받은 key 스트링 입력
if($target=="kin") {
  $img = "op2.gif";
  $target_name = "지식인";
  $checked1 = "checked";
} else if($target=="cafe") {
  $img = "op3.gif";
  $target_name = "카페";
  $checked2 = "checked";
} else if($target=="blog") {
  $img = "op4.gif";
  $target_name = "블로그";
  $checked3 = "checked";
} else if($target=="news") {
  $img = "op5.gif";
  $target_name = "뉴스";
  $checked4 = "checked";
} else {
  $img = "op4.gif";
  $target_name = "블로그";
  $checked3 = "checked";
}
if(!$target) {
  $target = "blog";
}
$s_target = $target; // 타겟지정 (지식인 kin, 블로그 blog 등등)
$s_display ="40";  // 검색결과 출력건수
if(!$page) {
  $start ="1";
} else if($page) {
  $start = ($page-1)*$s_display+1;
}
// 기본 정렬옵션 선택(sim:유사도순,date:날짜순);
if(!$s_sort) {
  $s_sort = "sim";
}

// 페이지가 로딩되자마자 기본으로 보여지기 원하는 검색어가 있을 경우
// 주석을 풀고 기본 검색어를 지정합니다.
//if($channel_query == '') { $channel_query ="기본검색어"; }
?> 
<table width="<?=$table_width?>" border="0" cellspacing="0" cellpadding="0" align="center">
  <tr><td height=6></td></tr>
  <tr>
    <td width="4" height="32"><img src="<?=$board_skin_path?>/img/left.gif" width="4" height="32"></td>
    <td align="center" style='padding-top:5px;' background="<?=$board_skin_path?>/img/bg.gif" height="32">
      <form name="actFrm" method="get" style="margin:0px;" onsubmit="return fwrite_check(this);">
      <input type="hidden" name="bo_table" value="<?=$bo_table?>">
      <input type="hidden" name="target" value="">
      <table border="0" cellspacing="0" cellpadding="0" align="center">
        <tr>
          <td height=30 valign="top">
            <img src="<?=$board_skin_path?>/img/top2.gif" border="0">NAVER 검색서비스 :
            <input type=text id='channel_query' name='channel_query' size="53" style="border-width:1px; border-color:rgb(204,204,204); border-style:solid;" value="<?=$channel_query?>" itemname="검색어" required> 
            <input type='submit' value='검색' style="font-family:돋움; font-size:11; color:white; background-color:rgb(255,102,153); background-position:0% 2px; padding-top:3; border-width:1; border-color:rgb(255,102,153); border-style:solid;cursor:pointer;">
            <span style="font-size:9pt;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
            <input type="radio" name="target" value="kin" <?=$checked1?>>지식인&nbsp;&nbsp;
            <input type="radio" name="target" value="cafe" <?=$checked2?>>카페&nbsp;&nbsp;
            <input type="radio" name="target" value="blog" <?=$checked3?>>블로그&nbsp;&nbsp;
            <input type="radio" name="target" value="news" <?=$checked4?>>뉴스&nbsp;&nbsp;
            <select name="s_sort" itemname="정렬옵션" required>
              <option value="">#정렬옵션#</option>
              <option value="sim" <? if($s_sort=="sim") { echo "selected"; } ?>>유사도순</option>
              <option value="date" <? if($s_sort=="date") { echo "selected"; } ?>>날짜순</option>
            </select>
          </td>
        </tr>
      </table>
      </form>
    </td>
    <td width="4"><img src="<?=$board_skin_path?>/img/right.gif" width="4" height="32"></td>
  </tr>
</table>
<?
if($channel_query) {
  // url_fopen 허용
  if (ini_get("allow_url_fopen") == 0) { ini_set("allow_url_fopen", 1); }
  // 네이버 지식인 OpenAPI 요청 url입니다.
  $channel_list = $s_requesturl."display=".$s_display."&start=".$start."&target=".$s_target."&sort=".$s_sort."&key=".$map_key."&query=";
  $channel_query1 = str_replace(" ","",$channel_query);
  // 설정한 채널에서 검색된 뉴스를 읽어온다.
  $rss_array = rss_array($channel_list.$channel_query1);
  // 긁어온 RSS의 채널 태그의 타이틀을 네이버(UTF-8사용) euc-kr로 변환
  // 서버 환경이 UTF-8일경우 iconv를 사용하지 않으면 됩니다.
  $channel = $rss_array['channel']['title']; 
  $s_total = $rss_array['channel']['total']; 
  $s_lastBuildDate = $rss_array['channel']['lastBuildDate']; 
  $mt_cha =$channel;  
  $pubdate = date('Y-m-d H:i:s', strtotime($s_lastBuildDate));
  $arr_date = substr($pubdate, 0,4)."년".substr($pubdate, 5,2)."월".substr($pubdate, 8,2)."일  ".substr($pubdate, 11,8);
}
?> 
<table width="<?=$table_width?>" border="0" cellspacing="0" cellpadding="0" align="center"> 
<?
if($channel_query) {
?>
  <tr><td height=1 bgcolor=#ffffff></td></tr>
  <tr bgcolor=#Ffffff height=30 align=center>
    <td>
      <font color='red'>&nbsp;&nbsp;&nbsp;'<b><?=$channel_query?></b></font><font color="#FF6699">'</font>에 대한 <font color="#3399FF"><b><?=$target_name?></b></font> 서비스내 검색결과입니다. :: 검색건수 : <font color="#3399FF"><b><?=number_format($s_total)?></b></font>건 [실시간:  <?=$arr_date?>]
    </td>
  </tr>
  <tr><td height=1 bgcolor=#DBDBDA></td></tr>
<?
}
if(count($rss_array['items']) > 0 ) {
  foreach ($rss_array['items'] as $item) {
    $mtt1 = $item[title];
    $url = $item['link'];
?> 
  <tr onmouseover="this.style.backgroundColor='#FDF9DF';" onmouseout="this.style.backgroundColor='#FFFFFF';">
    <td style='padding-left:10px;'>
      <img src="<?=$board_skin_path?>/img/<?=$img?>"><a href='<?=$url?>' title="<?=$mtt1?>" target="_blank"><?=$mtt1?></a>
    </td>
  </tr>
  <tr><td height='1' bgcolor='#E7E7E7'></td></tr>
<? 
  }
  // 1회 검색시 최대 1000개의 자료가 검색이 가능합니다.
  if($s_total > 1000) {
    $s_total = "1000";
  }
  // 페이지 표시
  $total_page = ceil($s_total/$s_display);
  if (!$page) $page = 1;
  $primato = urlencode($channel_query);
  $write_pages = get_paging($config[cf_write_pages], $page, $total_page, "./board.php?bo_table=$bo_table&channel_query=$primato&s_sort=$s_sort&page=");
  $write_pages = str_replace("처음", "<img src='$board_skin_path/img/page_begin.gif' border='0' align='absmiddle' title='처음'>", $write_pages);
  $write_pages = str_replace("이전", "<img src='$board_skin_path/img/page_prev.gif' border='0' align='absmiddle' title='이전'>", $write_pages);
  $write_pages = str_replace("다음", "<img src='$board_skin_path/img/page_next.gif' border='0' align='absmiddle' title='다음'>", $write_pages);
  $write_pages = str_replace("맨끝", "<img src='$board_skin_path/img/page_end.gif' border='0' align='absmiddle' title='맨끝'>", $write_pages);
  $write_pages = preg_replace("/<span>([0-9]*)<\/span>/", "<b><span style=\"color:#B3B3B3; font-size:12px;\">$1</span></b>", $write_pages);
  $write_pages = preg_replace("/<b>([0-9]*)<\/b>/", "<b><span style=\"color:#4D6185; font-size:12px; text-decoration:underline;\">$1</span></b>", $write_pages);
  echo("<tr><td align='center' height='50'><div id='pagingNew'>".$write_pages."</div></td></tr>");
  echo("</table>");
}
else {
  if($channel_query == '') {
    echo("<tr><td align=center height=500>검색어를 입력하세요.</td></tr><tr><td height=1 bgcolor=#B0ADF5></td></tr></table>");
  } else {
    echo("<tr><td align=center height=500>검색된 자료가 없습니다.</td></tr><tr><td height=1 bgcolor=#B0ADF5></td></tr></table>");
  }
} 
?>
<script language="JavaScript">
function fwrite_check(f) {
  return true;
}
</script>