<?
/////////////////////////////////////////////////////////////////////
//
// ZeroBoard to GNU Board converter (2006.02.28)
//
// Modified by AccessDenied, http://b4you.net
//
// 수정사항
// 소스의 가독성을 높이기 위해 들여쓰기 수정
// 제로보드 공지사항, 비밀글 컨버팅 될 때의 문제 수정
// < 또는 >와 같은 문자들이 컨버팅 될 때의 문제 수정
// 파일 첨부 문제의 수정
// 파일 크기가 제대로 기입되지 않은 문제 수정
//
/////////////////////////////////////////////////////////////////////
//
// 원본
//
// 원소스 : http://www.sir.co.kr/bbs/board.php?bo_table=g4_convert&wr_id=41
//
// 2005.12.21 taejun 작성
// http://www.sir.co.kr/bbs/board.php?bo_table=g4_convert&wr_id=37 의 내용 참고하여 파일복사 부분 추가
// http://www.sir.co.kr/bbs/board.php?bo_table=g4_tiptech&wr_id=1000 "제로보드에서 G4로 변환하기 프로그램의 두가지 오류 수정..." 참고하여 카테고리 가져오기 , 답글이 한단계 밑으로 밖에 변환되지 않는 문제수정
// 원소스i(taejun님 소스) : http://sir.co.kr/bbs/board.php?bo_table=g4_convert&wr_id=55
//
/////////////////////////////////////////////////////////////////////
include_once('./_common.php');
include_once('./zb4_config.php');

// zb4_config에서 사용자가 경로를 지정하지 않으면 data들을 복사할 때 문제가 생길 수도 있으므로 확인
if(!$zb_path)
{
	alert('제로보드의 경로가 지정되지 않았습니다');
}

if(!$g4_path)
{
	alert('그누보드의 경로가 지정되지 않았습니다');
}

// 설정된 경로의 맨 뒤에 /가 붙어 있지 않다면 추가
if(substr($zb_path, -1) != '/')
{
	$zb_path .= '/';
}

if(substr($g4_path, -1) != '/')
{
	$g4_path .= '/';
}

// 권한을 확인한다
if($is_admin != 'super')
{
	alert('최고 관리자로 로그인 하여 주시기 바랍니다');
}

// zb4_board.php 로부터 인자가 넘어와졌는지를 확인한다
if(!$src)
{
	alert('제로보드의 테이블이 지정되지 않았습니다');
}

if(!$dst)
{
	alert('그누보드의 테이블이 지정되지 않았습니다');
}

// 첨부파일들을 위한 디렉토리 생성
@mkdir($g4_path.'data/file/'.$src, 0707);
chmod($g4_path.'data/file/'.$src, 0707);

// 원본
//$sql = " select * from zetyx_board_{$src} order by headnum ,arrangenum ";
// 신비님께서 알려주신 코드입니다.
//$sql = " select * from zetyx_board_{$src} order by headnum desc,arrangenum desc"; 

// 공지사항과 같은 글은 headnum과 arrangenum이 독특하기 때문에 컨버팅 과정에서 문제를 일으킬 수도 있다
// 제로보드에서 공지사항은 headnum의 값이 -2000000000 이하이며, 이런식으로 소팅하면 공지사항이었던 항목은
// 맨 나중에 등록되게 된다
// 이를 방지하기 위해 ORDER BY구문에 no 필드를 사용한다
$query = 'SELECT * FROM zetyx_board_'.$src.' ORDER BY no';
$zb4_result = sql_query($query);

$zb4_count = mysql_num_rows($zb4_result);

if(!$zb4_count)
{
	alert('제로보드에 게시물이 한건도 없으므로 변환하지 않습니다.');
}

// 카테고리 정보를 얻어온다
$category = array();
$query = 'SELECT no, name FROM zetyx_board_category_'.$src.' ORDER BY no';
$category_result = sql_query($query);

for($i = 0; $row = sql_fetch_array($category_result); $i++)
{
	$category[$row[no]] = $row[name];
}
?>
<link rel="stylesheet" href="<?=$g4[path]?>/style.css" type="text/css">
Converting <b>'<?=$src?>'</b> to <b>'<?=$dst?>'</b>...<br>

<?
$tmp_target = $g4[write_prefix].$dst;

// 그누보드에 있는 내용을 모두 삭제한다
$query = 'DELETE FROM '.$tmp_target;
sql_query($query);

// 첨부되어 있던 파일들도 모두 삭제한다
// 첫번째로 그누보드에 포함되어 있던 파일 목록을 얻어온다
$query = 'SELECT * FROM '.$g4[board_file_table].' WHERE bo_table = \''.$dst.'\'';
$g4file_result = sql_query($query);

$file_path = $g4_path.'data/file/'.$dst.'/';

// 순회하면서 실존하는 파일들을 삭제한다
for($i = 0; $row = sql_fetch_array($g4file_result); $i++)
{
	$file_name = $file_path.$row[bf_file];

	// 파일이 존재하는지 확인한다
	if(file_exists($file_name))
	{
		unlink($file_name);
		echo('- GNUBoard : \''.$file_name.'\' 파일이 삭제되었습니다.<br>');
	}
	else
	{
		echo('- GNUBoard : \''.$file_name.'\' 파일이 발견되었지만 존재하지 않습니다.<br>');
	}
}

// DB상에 존재하는 파일들을 모두 삭제한다
$query = "DELETE FROM $g4[board_file_table] WHERE bo_table = '$dst'";
sql_query($query);

// 공지사항 목록을 초기화 시킨다
$query = "UPDATE $g4[board_table] SET bo_notice = '' WHERE bo_table = '$dst'";
sql_query($query);

// 게시물 변환을 시작한다
$count_write = 0;
$count_comment = 0;
$count_notice = 0;		// 공지사항 글을 위해 필요한 항목
$prev_num = 0;			// 바로 전 글의 headnum을 기억하며, 첫번째 글이 공지사항이라면 그 공지사항의 headnum은 -1부터 시작하게 된다(나중에 -1해주므로 0)

for($i = 0; $row = sql_fetch_array($zb4_result); $i++)
{
	echo(($count_write + 1).'. '.$row["subject"].' :: ');
	
	$reg_date = date("Y-m-d H:i:s", $row[reg_date]);

	if($row[arrangenum] == 0)
	{
		$reply = '';
		$save_depth = 0;
		$save_reply = '';
	}
	else
	{
		if($save_depth)
		{
			$reply = $save_reply;
			if($row[depth] > $save_depth)
			{
				$reply .= 'A';
			}
			else if ($row[depth] == $save_depth)
			{
				$ch = substr($reply, -1);
				$reply = substr($reply, 0, strlen($reply)-1).chr(ord($ch) + 1);
			}
			else
			{
				$reply = substr($reply, 0, strlen($reply)-1);
				$ch = substr($reply, -1);
				$reply = substr($reply, 0, strlen($reply)-1) . chr(ord($ch) + 1);
			}
		}
		else
		{
			$reply = 'A';
		}
	}

	$num = $row[headnum];
	$notice = false;

	// 공지사항이라면
	if($num <= -2000000000)
	{
		// 새로운 게시물 번호를 발급받는다
		$num = $prev_num - 1;
		$count_notice++;
		$notice = true;
	}
	else
	{
		// 공지사항의 개수에 따라서 headnum값이 그만큼 밀리게 된다
		$num -= $count_notice;
	}

	// 게시물을 회원이 작성한 것이라면 그 회원 번호를 기준으로 id를 얻어온다
	// (제로보드에서는 회원 번호를 저장하지만 그누보드에서는 회원 id를 저장하기때문에)
	if($row[ismember])
	{
		$query = 'SELECT user_id FROM zetyx_member_table where no = \''.$row[ismember].'\'';
		$member_result = sql_query($query);
		$member_row = sql_fetch_array($member_result);
		$mb_id = $member_row[user_id];
	}
	else
	{
		// 회원 정보를 얻지 못했다면 그냥 빈칸으로 남겨둔다
		$mb_id = '';
	}

	// 원본
	//    $subject = preg_replace("/\'/", "&#039;", addslashes($row[subject]));
	//    $memo = preg_replace("/\'/", "&#039;", addslashes($row[memo]));
	//    $name = preg_replace("/\'/", "&#039;", addslashes($row[name]));
	// 제로보드에서는 특수문자(<, >와 같은)를 &lt;, &gt; 와 같은 식으로 변경하여 저장하지만
	// 그누보드에서는 특수문자를 변환하지 않고 그대로 저장한다
	// 따라서 이부분에서 문제가 생길 여지가 있는데 이것을 처리한다
	$subject = my_strip_slashes($row[subject]);
	$memo = my_strip_slashes($row[memo]);
	$name = my_strip_slashes($row[name]);

	// html의 사용 여부
	$html = '';
	if($row[use_html] == 1)
	{
		$html = ',html2';
	}
	if($row[use_html] == 2)
	{
		$html = ',html1'; 
	}

	// 비밀글
	$secret = '';
	if($row[is_secret])
	{
		$secret = ',secret';
	}

	// email로 답변받기
	$recv_email = '';
	if($row[reply_email])
	{
		$mail = ',mail';
	}

	// 해당 게시물의 카테고리 이름을 얻어온다
	$query = 'SELECT name FROM zetyx_board_category_'.$src.' WHERE no = '.$row[category];
	$category_result = sql_query($query);
	$category_row = sql_fetch_array($category_result);
	$category_name = $category_row[name];

	// 게시물을 등록한다
	$query = "INSERT INTO $tmp_target SET
		ca_name = '{$category[$row[category]]}', 
				wr_option = '$html,$secret,$mail',
				wr_num = '$num',
				wr_reply = '$reply',
				wr_subject = '$subject',
				wr_content = '$memo',
				wr_link1 = '$row[sitelink1]',
				wr_link2 = '$row[sitelink1]',
				wr_hit = '$row[hit]',
				wr_good = '$row[vote]',
				mb_id = '$mb_id',
				wr_password = '$row[password]',
				wr_name = '$name',
				wr_email = '$row[email]',
				wr_homepage = '$row[homepage]',
				wr_datetime = '$reg_date',
				wr_ip = '$row[ip]',
				wr_is_comment = 0,
				wr_comment = '$row[total_comment]',
				wr_1 = '$row[x]',
				wr_2 = '$row[y]',
				wr_3 = '',
				wr_4 = '',
				wr_5 = '',
				wr_6 = '',
				wr_7 = '',
				wr_8 = '',
				wr_9 = '',
				wr_10 = ''";

	sql_query($query);

	$id = mysql_insert_id();

	if($notice == true)
	{
		// 현재 게시물을 공지사항으로 저장한다
		$query = "UPDATE $g4[board_table] SET bo_notice = CONCAT('$id', '\\n', bo_notice) WHERE bo_table = '$dst'";
		sql_query($query);
	}
	
	// 리플과 같은 글들에 대해 부모의 id를 등록해야 하므로
	$query = "UPDATE $tmp_target SET wr_parent = '$id' WHERE wr_id = '$id'";
	sql_query($query);
	
	// 삼윤의 새글등록추가
	sql_query(" insert into $g4[board_new_table] ( bo_table, wr_id, wr_parent, bn_datetime, mb_id ) values ( '$dst', '$id', '$id', '$reg_date', '$mb_id' ) ");

	// 코멘트에 대해서도 이동시킨다
	$comment = 1;
	$query = 'SELECT * FROM zetyx_board_comment_'.$src.' WHERE parent = '.$row[no].' ORDER BY reg_date';
	$comment_result = sql_query($query);

	for($k = 0; $comment_row = sql_fetch_array($comment_result); $k++)
	{
		$query = 'SELECT user_id FROM zetyx_member_table WHERE no = '.$comment_row[ismember];
		$user_result = sql_query($query);
		$user_row = sql_fetch_array($user_result);
		$mb_id = $user_row[user_id];

		//        $memo = trim(preg_replace("/\'/", "&#039;", addslashes($row2[memo])));
		//        $name = trim(preg_replace("/\'/", "&#039;", addslashes($row2[name])));
		$memo = my_strip_slashes($comment_row[memo]);
		$name = my_strip_slashes($comment_row[name]);

		$query = "INSERT INTO $tmp_target
			set wr_num = '$num',
				wr_parent = '$id',
				wr_is_comment = 1,
				wr_comment = '$comment',
				wr_content = '$memo',
				mb_id = '$mb_id',
				wr_password = '$comment_row[password]',
				wr_name = '$name',
				wr_datetime = '".date("Y-m-d H:i:s", $comment_row[reg_date])."',
				wr_ip = '$comment_row[ip]'";

		sql_query($query);
		
		// 삼윤의 새글등록추가
		$comment_id = mysql_insert_id();
		sql_query(" insert into $g4[board_new_table] ( bo_table, wr_id, wr_parent, bn_datetime, mb_id ) values ( '$dst', '$comment_id', '$id', '".date("Y-m-d H:i:s", $comment_row[reg_date])."', '$mb_id' ) ");

		$comment++;

		echo('c');

		$count_comment++;
	}

	// 코멘트가 끝나면 줄바꿈..
	echo('<br />');

	for($k = 0; $k < 2; $k++)
	{
		$m = $k + 1;

		// 첨부 파일이 있다면 추가한다
		if($row["s_file_name{$m}"])
		{
			// 업로드 할 때의 파일 이름
			$zb_file_name = addslashes($row["file_name{$m}"]);
			// 타겟 파일 이름을 정하는데, 제로보드에서 중복된 파일은 별도의 디렉토리를 만든 후 그안에 넣는다
			// 예를들어, data/test_board/1.zip이 있을 때 또다시 1.zip파일을 업로드 하면
			// data/test_board/12345678/1.zip에 저장을 하게 된다
			// 여기서 /문자를 _로 변경하면 data_test_board_12345678_1.zip 라는 파일 이름이 만들어져서
			// 굳이 중복 처리를 하지 않아도 된다
			$g4_file_name = addslashes(str_replace('/', '_', $zb_file_name));

			// 경로를 포함하여 파일 이름 생성
			$zb_file = $zb_path.$zb_file_name;
			$g4_file = $g4_path.'data/file/'.$dst.'/'.$g4_file_name;

			// 파일의 크기를 구해옴
			// 아직 제로보드쪽에서 복사하기 전이므로 제로보드쪽에 있는 파일의 크기를 구해와야한다
			$g4_file_size = filesize($zb_file);

			// 파일카피
			copy($zb_file, $g4_file);

			// 화면표시
			echo('('.$zb_file.') -> ('.$g4_file.')<br>');

			// 파일을 DB상에 등록
			$query = "INSERT INTO $g4[board_file_table]
				SET bo_table = '$dst', 
					wr_id = '$id', 
					bf_no = '$k', 
					bf_source = '".addslashes($row["s_file_name{$m}"])."',
					bf_file = '$g4_file_name', 
					bf_download = '".$row["download{$m}"]."',
					bf_datetime = '$reg_date',
					bf_filesize = '$g4_file_size'";

			sql_query($query); 
		}
	}

	$count_write++;

	$save_reply = $reply;
	$save_depth = $row[depth];

	$prev_num = $num;
}

// 게시물과 코멘트 수를 일치시킨다
$query = "UPDATE $g4[board_table]
SET bo_count_write = '$count_write',
	bo_count_comment = '$count_comment'
	WHERE
	bo_table = '$dst'";

sql_query($query);

echo("<p>게시물 $count_write 건, 코멘트 $count_comment 건 변환 완료<p><a href='./zb4_board.php'>뒤로</a>");

// $string문자열을 제로보드에서 변환하는 방식과 같이 변환한다
function my_strip_slashes($string)
{
	$string = str_replace("\\'", "'", $string);		// \' 를 '로 변환
	$string = str_replace("\\\"", "\"", $string);	// \" 를 "로 변환
	$string = str_replace("&lt;", "<", $string);	// &lt; 를 <로 변환
	$string = str_replace("&gt;", ">", $string);	// &gt; 를 >로 변환
	$string = str_replace("&nbsp;", " ", $string);	// &nbsp; 를 공백으로 변환
	$string = addslashes($string);

	return $string;
}
?>
