<?
/****************************************************************************************************
*     프로그램명		:	그누보드 게시판 플러그인 - 게시판 글쓰기시 외부링크 이미지 모두 저장
*     Version			:	1.0
*     제작일			:	2009-11-12 오전 00:00
*     최근 수정일		:	2009-11-13 오전 09:32
****************************************************************************************************/
$imgSave[max] = 0;// (1024*1024);			// 저장가능한 최대사이즈, max 보다 작아야만 저장한다. byte 단위, 0이면 무제한
$imgSave[min] = 0; //1;								// 저장가능한 최소사이즈, min 보다 커야만 저장한다. byte 단위, 0이면 무제한
$imgSave[site] = "";							// 전체사이트의 이미지를 저장
//$imgSave[site] = "naver,daum";			// 특정사이트의 이미지만 저장, 쉼표로 구분

$img_content = image_save_run();
$_POST[wr_content] = addslashes($img_content);
$wr_content = $_POST[wr_content];

function remote_read($urlstr)
{
	$url				= parse_url($urlstr);
	$domain		= str_replace("www.", "", $url[host]);									// 도메인
	$file				= substr($url[path], strrpos($url[path], "/")+1);					// 파일명
	$basename	= str_replace("%", "", substr($file, 0, strrpos($file, ".")));	// 파일명 (확장자 제외)
	if (empty($basename)) {
		$basename = $file;
		$extension = "";
	} else	$extension	= substr($file, strrpos($file,".") + 1);						// 확장자

	$data			= "";
	$res				= @fsockopen("$domain", 80, $strErrorNo, $strErrStr, 2);
	if($res) {
		$headerstr = "GET $urlstr HTTP/1.0\r\n"; 
		$headerstr.= "Host:$domain:80\r\n"; 
		$headerstr.= "\r\n";
		fputs($res, $headerstr);
		while (!feof($res)) {
			$data.= fgets($res, 1024); 
		} 
		fclose($res);
		if (stristr($data, "Not Found") || stristr($data, "Bad Request"))
			return false;
	} else return false;

	$patten = "/Content\\-Length:\\s+([0-9]*)\\r\\n/i";
	preg_match($patten, $data, $match);
	if ($match) $filesize = $match[1];
	else $filesize = 0;

	$dataset = explode("\r\n\r\n", $data);

	return array("data"=>$data, "domain"=>$domain, "file"=>$file, "basename"=>$basename, "extension"=>$extension, "url"=>$urlstr, "header"=>$dataset[0], "body"=>$dataset[1], "filesize"=>$filesize);
}

function image_save($file, $data) {
	global $g4;
	@mkdir("$g4[path]/data/$g4[cheditor4]/", 0707);
	@chmod("$g4[path]/data/$g4[cheditor4]/", 0707);
	$ym = date("ym", $g4[server_time]);
	define('SAVE_AS_DIRECTORY', 	"$g4[path]/data/$g4[cheditor4]/$ym/");
	@mkdir(SAVE_AS_DIRECTORY, 0707);
	@chmod(SAVE_AS_DIRECTORY, 0707);

	if (!file_exists($file)) {
		$fp = @fopen ($file, 'w');
		if(!$fp) return false;
		fwrite ($fp, $data);
		fclose ($fp);
	}
	return true;
}

function image_save_run() {
	global $g4, $imgSave;

	$img_content = stripslashes($_POST[wr_content]);
	$img_content = str_replace("&lt;", "<", $img_content);
	$img_content = str_replace("&gt;", ">", $img_content);
	$patten = "/<img[^>]*src=[\"']?([^>\"']+)[\"']?[^>]*>/i";
	preg_match_all($patten, $img_content, $match); 
	$dest_file = "data/$g4[cheditor4]/".date("ym")."/";		//저장경로
	
	if ($match[1]) {
		foreach ($match[1] as $link) {
			$url = parse_url($link);
			if ($url[host] && $url[host] != $_SERVER['HTTP_HOST']) {
				$image = remote_read($link);			
				if ($image) {
					if ($imgSave[min] && $imgSave[min] > $image[filesize]) continue; // 이미지가 최소크기보다 작으면 저장안함
					if ($imgSave[max] && $imgSave[max] < $image[filesize]) continue; // 이미지가 최대크기보다 크면 저장안함
					if (empty($imgSave[site])) $siteflag = true; //저장 사이트 목록이 없다면 모든 사이트의 이미지 저장
					else { // 저장 사이트 목록이 있는 경우
						$siteList = explode(",", $imgSave[site]);
						$siteListCnt = count($siteList);
						$siteflag = false;
						
						for($c=0; $c<$siteListCnt; $c++) {
							if (stristr($image[domain], trim($siteList[$c]))) { // 지정한 도메인에 포함이 되어 있다면
								$siteflag = true;
								break;
							}
						}
					}

					if ($siteflag) {
						$saveFileName = $dest_file.$image[basename]."_".random_generator(8, 15) . ($image[extension]?".".$image[extension]:"");
						if (image_save($g4[path]."/".$saveFileName, $image[body])) {
							$img_content = str_replace($link, ($g4[path]."/".$saveFileName), $img_content);
						}
					}
				}
			}
		}
		return $img_content;
	}
	else
		return $_POST[wr_content];
	
	
}

function random_generator ($min=8, $max=32, $special=NULL, $chararray=NULL) { 
    $random_chars = array(); 
    
    if ($chararray == NULL) { 
        $str = "abcdefghijklmnopqrstuvwxyz"; 
        $str .= strtoupper($str); 
        $str .= "1234567890"; 

        if ($special) { 
            $str .= "!@#$%"; 
        } 
    } 
    else { 
        $str = $charray; 
    } 

    for ($i=0; $i<strlen($str)-1; $i++) { 
        $random_chars[$i] = $str[$i]; 
    } 

    srand((float)microtime()*1000000); 
    shuffle($random_chars); 

    $length = rand($min, $max); 
    $rdata = ''; 
    
    for ($i=0; $i<$length; $i++) { 
        $char = rand(0, count($random_chars) - 1); 
        $rdata .= $random_chars[$char]; 
    } 
    return $rdata; 
} 
?>
