var gmail;
if(!gmail) gmail = {};
if(!gmail.kevinpark1981) gmail.kevinpark1981 = {};
if(gmail.kevinpark1981.dp_slider2) {throw new Error("gmail.kevinpark1981.dp_slider2 already exists!");}

gmail.kevinpark1981.dp_slider2 = function(name, width, height, interval, effect, info_height) {

	var util = gmail.kevinpark1981.util;

	var root = document.getElementById(name);
	var ul = util.FirstChild(root);

	var old_show;
	var old_tab;
	var first = true;

	for(var i=0; i<ul.childNodes.length; i++) {
		if(ul.childNodes[i].nodeType != 1) continue;

		var args = util.Explode('||', ul.childNodes[i].getAttribute('alt'));
		var subject = args[0];
		var content = args[1];
		var href = args[2];
		var img_path = args[3];

		var div = document.createElement('div');
		div.className = 'panel';
		div.setAttribute('id', "panel"+name+i);
		div.style.width = width+'px';
		if(!first) {
			div.style.display = 'none';
		} else {
			old_show = div;
			old_tab = ul.childNodes[i];
			ul.childNodes[i].className = 'selected';
			first = false;
		}

			var img = document.createElement('img');
			img.src = img_path;
			img.alt = subject;
			img.width = width;
			img.height = height;
			div.appendChild(img);

			var info = document.createElement('div');
			info.className = 'info';
			info.style.height = info_height+'px';

				var h2 = document.createElement('h2');
					var link = document.createElement('a');
					link.href = href;
					link.appendChild(document.createTextNode(subject));
					h2.appendChild(link);
				info.appendChild(h2);

				var p = document.createElement('p');
					var span = document.createElement('span');
					span.appendChild(document.createTextNode(content.replace(/\s/g,' ')+' '));
					var link_more = document.createElement('a');
					link_more.href = href;
					link_more.innerText = '';
					p.appendChild(span);
					p.appendChild(link_more);
				info.appendChild(p);

			div.appendChild(info);

		util.AddEvent(ul.childNodes[i], 'click', function() {
			ChangeImage(this);
		});

		ul.childNodes[i].setAttribute('alt', div.getAttribute('id'));

		root.appendChild(div);
	}

	function ChangeImage(tab) {

		var show = document.getElementById(tab.getAttribute('alt'));

		old_show.style.display = 'none';
		old_tab.className = '';

		show.style.display = 'block';
		tab.className = 'selected';

		if(effect==1) {
			gmail.kevinpark1981.util.ChangeOpacity(show, 0, 10);
		}

		old_show = show;
		old_tab = tab;
	}

	function Auto() {
		setTimeout(function() {
			ChangeImage(util.FindNext(old_tab, true));
			setTimeout(Auto, interval);
		}, interval);
	}
	Auto(); // 자동탭 전환
}

if(!gmail.kevinpark1981.util) gmail.kevinpark1981.util = {};

gmail.kevinpark1981.util.AddEvent = function(obj, type, fn) {
	if(type=="dom:loaded") {
		if(document.addEventListener) {
			document.addEventListener("DOMContentLoaded", fn, false);
		} else {
			document.write("<script id=__onDOMContentLoaded defer src=//:><\/script>");
			document.getElementById("__onDOMContentLoaded").onreadystatechange = function() {
				if (this.readyState == "complete") {
					this.onreadystatechange = null;
					fn();
				}
			};
		}
	} else {
		if (obj.addEventListener) {
			obj.addEventListener(type, fn, false);  
		} else if (obj.attachEvent) {  
			obj["e"+type+fn] = fn;  
			obj[type+fn] = function() { obj["e"+type+fn]( window.event ); }  
			obj.attachEvent("on"+type, obj[type+fn]);  
		}  
	}
}
gmail.kevinpark1981.util.SetOpacity = function(ele, value) {
	ele.style.opacity = value/10;
	ele.style.filter = 'alpha(opacity=' + value*10 + ')';
}
gmail.kevinpark1981.util.ChangeOpacity = function(ele, start, end) {
	var opacity = start;

	setTimeout(function() {
		if(opacity<=end) {
			opacity += 1;
			gmail.kevinpark1981.util.SetOpacity(ele, opacity);
			setTimeout(arguments.callee, 50);
		}
	}, 50);
}

gmail.kevinpark1981.util.FirstChild = function(obj) {
	for(var i=0; i<obj.childNodes.length; i++) {
		if(obj.childNodes[i].nodeType == 1) {
			return obj.childNodes[i];
		}
	}
	return null;
}

gmail.kevinpark1981.util.FindNext = function(obj, repeat) {
	if(repeat==null) repeat=false;
	var parentNode = obj.parentNode;
	do {
		obj = obj.nextSibling;
	} while(obj && obj.nodeType != 1);

	if(repeat && !obj) {
		obj = gmail.kevinpark1981.util.FirstChild(parentNode);
	}
	return obj;
}

// http://kevin.vanzonneveld.net
// +     original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
// +     improved by: kenneth
// +     improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
// +     improved by: d3x
// +     bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
// *     example 1: explode(' ', 'Kevin van Zonneveld');
// *     returns 1: {0: 'Kevin', 1: 'van', 2: 'Zonneveld'}
// *     example 2: explode('=', 'a=bc=d', 2);
// *     returns 2: ['a', 'bc=d']
gmail.kevinpark1981.util.Explode = function(delimiter, string, limit) {
	var emptyArray = { 0: '' };
	// third argument is not required
	if ( arguments.length < 2 || typeof arguments[0] == 'undefined' || typeof arguments[1] == 'undefined' ) { return null; }
	if ( delimiter === '' || delimiter === false || delimiter === null ) { return false; }
	if ( typeof delimiter == 'function' || typeof delimiter == 'object' || typeof string == 'function' || typeof string == 'object' ) { return emptyArray; }
	if ( delimiter === true ) { delimiter = '1'; }

	if (!limit) {
		return string.toString().split(delimiter.toString());
	} else {
		// support for limit argument
		var splitted = string.toString().split(delimiter.toString());
		var partA = splitted.splice(0, limit - 1);
		var partB = splitted.join(delimiter.toString());
		partA.push(partB);
		return partA;
	}
}
