<?php
/*! 
 *	\fn		strcut_utf8
 *	\brief	한글 문자열 자르기
 */
function strcut_utf8($str, $len, $checkmb=false, $tail='...') {

	preg_match_all('/[\xEA-\xED][\x80-\xFF]{2}|./', $str, $match);
	$m    = $match[0];
	$slen = strlen($str);  // length of source string
	$tlen = strlen($tail); // length of tail string
	$mlen = count($m); // length of matched characters

	if ($slen <= $len) return $str;
	if (!$checkmb && $mlen <= $len) return $str;

	$ret   = array();
	$count = 0;

	for ($i=0; $i < $len; $i++) {
		$count += ($checkmb && strlen($m[$i]) > 1)?2:1;
		if ($count + $tlen > $len) break;
		$ret[] = $m[$i];
	}
	  
	return join('', $ret).$tail;
}

/*! 
 *	\fn		CheckFunction
 *	\brief	함수 체크
 */
function CheckFunction($name) {
	if(!function_exists($name)) {
		echo "require function : {$name}()";
		exit;
	}
}

/*! 
 *	\fn		Thumb
 *	\brief	썸네일 생성
 *	\param  imgWidth 이미지 너비
 *	\param  imgHeight 이미지 높이
 *	\param  imgSource 원본 이미지
 *	\param  imgThumb 결과이미지 인자를 주지 않으면 원본이미지를 대체함
 */
function Thumb($imgWidth, $imgHeight, $imgSource, $imgThumb='') {

	if (!$imgThumb) $imgThumb = $imgSource;
	$size = getimagesize($imgSource);

	if ($size[2] == 1) $source = imagecreatefromgif($imgSource);
	else if ($size[2] == 2) $source = imagecreatefromjpeg($imgSource);
	else if ($size[2] == 3) $source = imagecreatefrompng($imgSource);
	else continue;

	$target = @imagecreatetruecolor($imgWidth, $imgHeight);

	@imagecopyresampled($target, $source, 0, 0, 0, 0, $imgWidth, $imgHeight, $size[0], $size[1]);
	if($imgSource==$imgThumb) unlink($imgSource);
	@imagejpeg($target, $imgThumb, 100);
	@chmod($imgThumb, 0606); // 추후 삭제를 위하여 파일모드 변경
}
?>
<script type="text/javascript" src="<?php echo $latest_skin_path?>/lib.js"></script>
<script type="text/javascript">
//<![CDATA[
var style = document.createElement("link");
style.type = "text/css";
style.rel = "stylesheet";
style.href = "<?php echo $latest_skin_path?>/style.css";
document.getElementsByTagName("head")[0].appendChild(style);
//]]>
</script>
