## ̿ť dump 10.11
##
## Host: localhost    Database: gnuboard4
## ######################################################
## Server version	5.0.37-log







##
## Table structure for table `$g4[auth_table]`
##

DROP TABLE IF EXISTS `$g4[auth_table]`;
CREATE TABLE `$g4[auth_table]` (
  `mb_id` varchar(255) NOT NULL default '',
  `au_menu` varchar(20) NOT NULL default '',
  `au_auth` set('r','w','d') NOT NULL default '',
  PRIMARY KEY  (`mb_id`,`au_menu`)
);

##
## Table structure for table `$g4[board_table]`
##

DROP TABLE IF EXISTS `$g4[board_table]`;
CREATE TABLE `$g4[board_table]` (
  `bo_table` varchar(20) NOT NULL default '',
  `gr_id` varchar(255) NOT NULL default '',
  `bo_subject` varchar(255) NOT NULL default '',
  `bo_admin` varchar(255) NOT NULL default '',
  `bo_list_level` tinyint(4) NOT NULL default '0',
  `bo_read_level` tinyint(4) NOT NULL default '0',
  `bo_write_level` tinyint(4) NOT NULL default '0',
  `bo_reply_level` tinyint(4) NOT NULL default '0',
  `bo_comment_level` tinyint(4) NOT NULL default '0',
  `bo_upload_level` tinyint(4) NOT NULL default '0',
  `bo_download_level` tinyint(4) NOT NULL default '0',
  `bo_html_level` tinyint(4) NOT NULL default '0',
  `bo_link_level` tinyint(4) NOT NULL default '0',
  `bo_trackback_level` tinyint(4) NOT NULL default '0',
  `bo_count_delete` tinyint(4) NOT NULL default '0',
  `bo_count_modify` tinyint(4) NOT NULL default '0',
  `bo_read_point` int(11) NOT NULL default '0',
  `bo_write_point` int(11) NOT NULL default '0',
  `bo_comment_point` int(11) NOT NULL default '0',
  `bo_download_point` int(11) NOT NULL default '0',
  `bo_use_category` tinyint(4) NOT NULL default '0',
  `bo_category_list` text NOT NULL,
  `bo_disable_tags` text NOT NULL,
  `bo_use_sideview` tinyint(4) NOT NULL default '0',
  `bo_use_file_content` tinyint(4) NOT NULL default '0',
  `bo_use_secret` tinyint(4) NOT NULL default '0',
  `bo_use_dhtml_editor` tinyint(4) NOT NULL default '0',
  `bo_use_rss_view` tinyint(4) NOT NULL default '0',
  `bo_use_comment` tinyint(4) NOT NULL default '0',
  `bo_use_good` tinyint(4) NOT NULL default '0',
  `bo_use_nogood` tinyint(4) NOT NULL default '0',
  `bo_use_name` tinyint(4) NOT NULL default '0',
  `bo_use_signature` tinyint(4) NOT NULL default '0',
  `bo_use_ip_view` tinyint(4) NOT NULL default '0',
  `bo_use_trackback` tinyint(4) NOT NULL default '0',
  `bo_use_list_view` tinyint(4) NOT NULL default '0',
  `bo_use_list_content` tinyint(4) NOT NULL default '0',
  `bo_table_width` int(11) NOT NULL default '0',
  `bo_subject_len` int(11) NOT NULL default '0',
  `bo_page_rows` int(11) NOT NULL default '0',
  `bo_new` int(11) NOT NULL default '0',
  `bo_hot` int(11) NOT NULL default '0',
  `bo_image_width` int(11) NOT NULL default '0',
  `bo_skin` varchar(255) NOT NULL default '',
  `bo_image_head` varchar(255) NOT NULL default '',
  `bo_image_tail` varchar(255) NOT NULL default '',
  `bo_include_head` varchar(255) NOT NULL default '',
  `bo_include_tail` varchar(255) NOT NULL default '',
  `bo_content_head` text NOT NULL,
  `bo_content_tail` text NOT NULL,
  `bo_insert_content` text NOT NULL,
  `bo_gallery_cols` int(11) NOT NULL default '0',
  `bo_upload_size` int(11) NOT NULL default '0',
  `bo_reply_order` tinyint(4) NOT NULL default '0',
  `bo_use_search` tinyint(4) NOT NULL default '0',
  `bo_order_search` int(11) NOT NULL default '0',
  `bo_count_write` int(11) NOT NULL default '0',
  `bo_count_comment` int(11) NOT NULL default '0',
  `bo_write_min` int(11) NOT NULL default '0',
  `bo_write_max` int(11) NOT NULL default '0',
  `bo_comment_min` int(11) NOT NULL default '0',
  `bo_comment_max` int(11) NOT NULL default '0',
  `bo_notice` text NOT NULL,
  `bo_upload_count` tinyint(4) NOT NULL default '0',
  `bo_use_email` tinyint(4) NOT NULL default '0',
  `bo_sort_field` varchar(255) NOT NULL default '',
  `bo_1_subj` varchar(255) NOT NULL default '',
  `bo_2_subj` varchar(255) NOT NULL default '',
  `bo_3_subj` varchar(255) NOT NULL default '',
  `bo_4_subj` varchar(255) NOT NULL default '',
  `bo_5_subj` varchar(255) NOT NULL default '',
  `bo_6_subj` varchar(255) NOT NULL default '',
  `bo_7_subj` varchar(255) NOT NULL default '',
  `bo_8_subj` varchar(255) NOT NULL default '',
  `bo_9_subj` varchar(255) NOT NULL default '',
  `bo_10_subj` varchar(255) NOT NULL default '',
  `bo_1` varchar(255) NOT NULL default '',
  `bo_2` varchar(255) NOT NULL default '',
  `bo_3` varchar(255) NOT NULL default '',
  `bo_4` varchar(255) NOT NULL default '',
  `bo_5` varchar(255) NOT NULL default '',
  `bo_6` varchar(255) NOT NULL default '',
  `bo_7` varchar(255) NOT NULL default '',
  `bo_8` varchar(255) NOT NULL default '',
  `bo_9` varchar(255) NOT NULL default '',
  `bo_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`bo_table`)
);

##
## Table structure for table `$g4[board_file_table]`
##

DROP TABLE IF EXISTS `$g4[board_file_table]`;
CREATE TABLE `$g4[board_file_table]` (
  `bo_table` varchar(20) NOT NULL default '',
  `wr_id` int(11) NOT NULL default '0',
  `bf_no` int(11) NOT NULL default '0',
  `bf_source` varchar(255) NOT NULL default '',
  `bf_file` varchar(255) NOT NULL default '',
  `bf_download` varchar(255) NOT NULL default '',
  `bf_content` text NOT NULL,
  `bf_filesize` int(11) NOT NULL default '0',
  `bf_width` int(11) NOT NULL default '0',
  `bf_height` smallint(6) NOT NULL default '0',
  `bf_type` tinyint(4) NOT NULL default '0',
  `bf_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`bo_table`,`wr_id`,`bf_no`)
);

##
## Table structure for table `$g4[board_good_table]`
##

DROP TABLE IF EXISTS `$g4[board_good_table]`;
CREATE TABLE `$g4[board_good_table]` (
  `bg_id` int(11) NOT NULL auto_increment,
  `bo_table` varchar(20) NOT NULL default '',
  `wr_id` int(11) NOT NULL default '0',
  `mb_id` varchar(20) NOT NULL default '',
  `bg_flag` varchar(255) NOT NULL default '',
  `bg_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`bg_id`),
  UNIQUE KEY `fkey1` (`bo_table`,`wr_id`,`mb_id`)
);

##
## Table structure for table `$g4[board_new_table]`
##

DROP TABLE IF EXISTS `$g4[board_new_table]`;
CREATE TABLE `$g4[board_new_table]` (
  `bn_id` int(11) NOT NULL auto_increment,
  `bo_table` varchar(20) NOT NULL default '',
  `wr_id` int(11) NOT NULL default '0',
  `wr_parent` int(11) NOT NULL default '0',
  `bn_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `mb_id` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`bn_id`),
  KEY `mb_id` (`mb_id`)
);

##
## Table structure for table `$g4[config_table]`
##

DROP TABLE IF EXISTS `$g4[config_table]`;
CREATE TABLE `$g4[config_table]` (
  `cf_title` varchar(255) NOT NULL default '',
  `cf_admin` varchar(255) NOT NULL default '',
  `cf_use_point` tinyint(4) NOT NULL default '0',
  `cf_use_norobot` tinyint(4) NOT NULL default '0',
  `cf_use_copy_log` tinyint(4) NOT NULL default '0',
  `cf_use_email_certify` tinyint(4) NOT NULL default '0',
  `cf_login_point` int(11) NOT NULL default '0',
  `cf_cut_name` tinyint(4) NOT NULL default '0',
  `cf_nick_modify` int(11) NOT NULL default '0',
  `cf_new_skin` varchar(255) NOT NULL default '',
  `cf_login_skin` varchar(255) NOT NULL default '',
  `cf_new_rows` int(11) NOT NULL default '0',
  `cf_search_skin` varchar(255) NOT NULL default '',
  `cf_connect_skin` varchar(255) NOT NULL default '',
  `cf_read_point` int(11) NOT NULL default '0',
  `cf_write_point` int(11) NOT NULL default '0',
  `cf_comment_point` int(11) NOT NULL default '0',
  `cf_download_point` int(11) NOT NULL default '0',
  `cf_search_bgcolor` varchar(255) NOT NULL default '',
  `cf_search_color` varchar(255) NOT NULL default '',
  `cf_write_pages` int(11) NOT NULL default '0',
  `cf_link_target` varchar(255) NOT NULL default '',
  `cf_delay_sec` int(11) NOT NULL default '0',
  `cf_filter` text NOT NULL,
  `cf_possible_ip` text NOT NULL,
  `cf_intercept_ip` text NOT NULL,
  `cf_register_skin` varchar(255) NOT NULL default 'basic',
  `cf_member_skin` varchar(255) NOT NULL default '',
  `cf_use_homepage` tinyint(4) NOT NULL default '0',
  `cf_req_homepage` tinyint(4) NOT NULL default '0',
  `cf_use_tel` tinyint(4) NOT NULL default '0',
  `cf_req_tel` tinyint(4) NOT NULL default '0',
  `cf_use_hp` tinyint(4) NOT NULL default '0',
  `cf_req_hp` tinyint(4) NOT NULL default '0',
  `cf_use_addr` tinyint(4) NOT NULL default '0',
  `cf_req_addr` tinyint(4) NOT NULL default '0',
  `cf_use_signature` tinyint(4) NOT NULL default '0',
  `cf_req_signature` tinyint(4) NOT NULL default '0',
  `cf_use_profile` tinyint(4) NOT NULL default '0',
  `cf_req_profile` tinyint(4) NOT NULL default '0',
  `cf_register_level` tinyint(4) NOT NULL default '0',
  `cf_register_point` int(11) NOT NULL default '0',
  `cf_icon_level` tinyint(4) NOT NULL default '0',
  `cf_use_recommend` tinyint(4) NOT NULL default '0',
  `cf_recommend_point` int(11) NOT NULL default '0',
  `cf_leave_day` int(11) NOT NULL default '0',
  `cf_search_part` int(11) NOT NULL default '0',
  `cf_email_use` tinyint(4) NOT NULL default '0',
  `cf_email_wr_super_admin` tinyint(4) NOT NULL default '0',
  `cf_email_wr_group_admin` tinyint(4) NOT NULL default '0',
  `cf_email_wr_board_admin` tinyint(4) NOT NULL default '0',
  `cf_email_wr_write` tinyint(4) NOT NULL default '0',
  `cf_email_wr_comment_all` tinyint(4) NOT NULL default '0',
  `cf_email_mb_super_admin` tinyint(4) NOT NULL default '0',
  `cf_email_mb_member` tinyint(4) NOT NULL default '0',
  `cf_email_po_super_admin` tinyint(4) NOT NULL default '0',
  `cf_prohibit_id` text NOT NULL,
  `cf_prohibit_email` text NOT NULL,
  `cf_new_del` int(11) NOT NULL default '0',
  `cf_memo_del` int(11) NOT NULL default '0',
  `cf_visit_del` int(11) NOT NULL default '0',
  `cf_popular_del` int(11) NOT NULL default '0',
  `cf_use_jumin` tinyint(4) NOT NULL default '0',
  `cf_use_member_icon` tinyint(4) NOT NULL default '0',
  `cf_member_icon_size` int(11) NOT NULL default '0',
  `cf_member_icon_width` int(11) NOT NULL default '0',
  `cf_member_icon_height` int(11) NOT NULL default '0',
  `cf_login_minutes` int(11) NOT NULL default '0',
  `cf_image_extension` varchar(255) NOT NULL default '',
  `cf_flash_extension` varchar(255) NOT NULL default '',
  `cf_movie_extension` varchar(255) NOT NULL default '',
  `cf_formmail_is_member` tinyint(4) NOT NULL default '0',
  `cf_page_rows` int(11) NOT NULL default '0',
  `cf_visit` varchar(255) NOT NULL default '',
  `cf_max_po_id` int(11) NOT NULL default '0',
  `cf_stipulation` text NOT NULL,
  `cf_privacy` text NOT NULL,
  `cf_open_modify` int(11) NOT NULL default '0',
  `cf_memo_send_point` int(11) NOT NULL default '0',
  `cf_1_subj` varchar(255) NOT NULL default '',
  `cf_2_subj` varchar(255) NOT NULL default '',
  `cf_3_subj` varchar(255) NOT NULL default '',
  `cf_4_subj` varchar(255) NOT NULL default '',
  `cf_5_subj` varchar(255) NOT NULL default '',
  `cf_6_subj` varchar(255) NOT NULL default '',
  `cf_7_subj` varchar(255) NOT NULL default '',
  `cf_8_subj` varchar(255) NOT NULL default '',
  `cf_9_subj` varchar(255) NOT NULL default '',
  `cf_10_subj` varchar(255) NOT NULL default '',
  `cf_1` varchar(255) NOT NULL default '',
  `cf_2` varchar(255) NOT NULL default '',
  `cf_3` varchar(255) NOT NULL default '',
  `cf_4` varchar(255) NOT NULL default '',
  `cf_5` varchar(255) NOT NULL default '',
  `cf_6` varchar(255) NOT NULL default '',
  `cf_7` varchar(255) NOT NULL default '',
  `cf_8` varchar(255) NOT NULL default '',
  `cf_9` varchar(255) NOT NULL default '',
  `cf_10` varchar(255) NOT NULL default ''
);

##
## Table structure for table `$g4[group_table]`
##

DROP TABLE IF EXISTS `$g4[group_table]`;
CREATE TABLE `$g4[group_table]` (
  `gr_id` varchar(10) NOT NULL default '',
  `gr_subject` varchar(255) NOT NULL default '',
  `gr_admin` varchar(255) NOT NULL default '',
  `gr_use_access` tinyint(4) NOT NULL default '0',
  `gr_1_subj` varchar(255) NOT NULL default '',
  `gr_2_subj` varchar(255) NOT NULL default '',
  `gr_3_subj` varchar(255) NOT NULL default '',
  `gr_4_subj` varchar(255) NOT NULL default '',
  `gr_5_subj` varchar(255) NOT NULL default '',
  `gr_6_subj` varchar(255) NOT NULL default '',
  `gr_7_subj` varchar(255) NOT NULL default '',
  `gr_8_subj` varchar(255) NOT NULL default '',
  `gr_9_subj` varchar(255) NOT NULL default '',
  `gr_10_subj` varchar(255) NOT NULL default '',
  `gr_1` varchar(255) NOT NULL default '',
  `gr_2` varchar(255) NOT NULL default '',
  `gr_3` varchar(255) NOT NULL default '',
  `gr_4` varchar(255) NOT NULL default '',
  `gr_5` varchar(255) NOT NULL default '',
  `gr_6` varchar(255) NOT NULL default '',
  `gr_7` varchar(255) NOT NULL default '',
  `gr_8` varchar(255) NOT NULL default '',
  `gr_9` varchar(255) NOT NULL default '',
  `gr_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`gr_id`)
);

##
## Table structure for table `$g4[group_member_table]`
##

DROP TABLE IF EXISTS `$g4[group_member_table]`;
CREATE TABLE `$g4[group_member_table]` (
  `gm_id` int(11) NOT NULL auto_increment,
  `gr_id` varchar(255) NOT NULL default '',
  `mb_id` varchar(255) NOT NULL default '',
  `gm_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`gm_id`),
  KEY `gr_id` (`gr_id`),
  KEY `mb_id` (`mb_id`)
);

##
## Table structure for table `$g4[login_table]`
##

DROP TABLE IF EXISTS `$g4[login_table]`;
CREATE TABLE `$g4[login_table]` (
  `lo_ip` varchar(255) NOT NULL default '',
  `mb_id` varchar(255) NOT NULL default '',
  `lo_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `lo_location` text NOT NULL,
  `lo_url` text NOT NULL,
  PRIMARY KEY  (`lo_ip`)
);

##
## Table structure for table `$g4[mail_table]`
##

DROP TABLE IF EXISTS `$g4[mail_table]`;
CREATE TABLE `$g4[mail_table]` (
  `ma_id` int(11) NOT NULL auto_increment,
  `ma_subject` varchar(255) NOT NULL default '',
  `ma_content` mediumtext NOT NULL,
  `ma_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ma_ip` varchar(255) NOT NULL default '',
  `ma_last_option` text NOT NULL,
  PRIMARY KEY  (`ma_id`)
);

##
## Table structure for table `$g4[member_table]`
##

DROP TABLE IF EXISTS `$g4[member_table]`;
CREATE TABLE `$g4[member_table]` (
  `mb_no` int(11) NOT NULL auto_increment,
  `mb_id` varchar(255) NOT NULL default '',
  `mb_password` varchar(255) NOT NULL default '',
  `mb_name` varchar(255) NOT NULL default '',
  `mb_nick` varchar(255) NOT NULL default '',
  `mb_nick_date` date NOT NULL default '0000-00-00',
  `mb_email` varchar(255) NOT NULL default '',
  `mb_homepage` varchar(255) NOT NULL default '',
  `mb_password_q` varchar(255) NOT NULL default '',
  `mb_password_a` varchar(255) NOT NULL default '',
  `mb_level` tinyint(4) NOT NULL default '0',
  `mb_jumin` varchar(255) NOT NULL default '',
  `mb_sex` char(1) NOT NULL default '',
  `mb_birth` varchar(255) NOT NULL default '',
  `mb_tel` varchar(255) NOT NULL default '',
  `mb_hp` varchar(255) NOT NULL default '',
  `mb_zip1` char(3) NOT NULL default '',
  `mb_zip2` char(3) NOT NULL default '',
  `mb_addr1` varchar(255) NOT NULL default '',
  `mb_addr2` varchar(255) NOT NULL default '',
  `mb_signature` text NOT NULL,
  `mb_recommend` varchar(255) NOT NULL default '',
  `mb_point` int(11) NOT NULL default '0',
  `mb_today_login` datetime NOT NULL default '0000-00-00 00:00:00',
  `mb_login_ip` varchar(255) NOT NULL default '',
  `mb_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `mb_ip` varchar(255) NOT NULL default '',
  `mb_leave_date` varchar(8) NOT NULL default '',
  `mb_intercept_date` varchar(8) NOT NULL default '',
  `mb_email_certify` datetime NOT NULL default '0000-00-00 00:00:00',
  `mb_memo` text NOT NULL,
  `mb_mailling` tinyint(4) NOT NULL default '0',
  `mb_sms` tinyint(4) NOT NULL default '0',
  `mb_open` tinyint(4) NOT NULL default '0',
  `mb_open_date` date NOT NULL default '0000-00-00',
  `mb_profile` text NOT NULL,
  `mb_memo_call` varchar(255) NOT NULL default '',
  `mb_1` varchar(255) NOT NULL default '',
  `mb_2` varchar(255) NOT NULL default '',
  `mb_3` varchar(255) NOT NULL default '',
  `mb_4` varchar(255) NOT NULL default '',
  `mb_5` varchar(255) NOT NULL default '',
  `mb_6` varchar(255) NOT NULL default '',
  `mb_7` varchar(255) NOT NULL default '',
  `mb_8` varchar(255) NOT NULL default '',
  `mb_9` varchar(255) NOT NULL default '',
  `mb_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`mb_no`),
  UNIQUE KEY `mb_id` (`mb_id`),
  KEY `mb_today_login` (`mb_today_login`),
  KEY `mb_datetime` (`mb_datetime`)
);

##
## Table structure for table `$g4[memo_table]`
##

DROP TABLE IF EXISTS `$g4[memo_table]`;
CREATE TABLE `$g4[memo_table]` (
  `me_id` int(11) NOT NULL default '0',
  `me_recv_mb_id` varchar(255) NOT NULL default '',
  `me_send_mb_id` varchar(255) NOT NULL default '',
  `me_send_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `me_read_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `me_memo` text NOT NULL,
  PRIMARY KEY  (`me_id`)
);

##
## Table structure for table `$g4[point_table]`
##

DROP TABLE IF EXISTS `$g4[point_table]`;
CREATE TABLE `$g4[point_table]` (
  `po_id` int(11) NOT NULL auto_increment,
  `mb_id` varchar(20) NOT NULL default '',
  `po_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `po_content` varchar(255) NOT NULL default '',
  `po_point` int(11) NOT NULL default '0',
  `po_rel_table` varchar(20) NOT NULL default '',
  `po_rel_id` varchar(20) NOT NULL default '',
  `po_rel_action` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`po_id`),
  KEY `index1` (`mb_id`,`po_rel_table`,`po_rel_id`,`po_rel_action`)
);

##
## Table structure for table `$g4[poll_table]`
##

DROP TABLE IF EXISTS `$g4[poll_table]`;
CREATE TABLE `$g4[poll_table]` (
  `po_id` int(11) NOT NULL auto_increment,
  `po_subject` varchar(255) NOT NULL default '',
  `po_poll1` varchar(255) NOT NULL default '',
  `po_poll2` varchar(255) NOT NULL default '',
  `po_poll3` varchar(255) NOT NULL default '',
  `po_poll4` varchar(255) NOT NULL default '',
  `po_poll5` varchar(255) NOT NULL default '',
  `po_poll6` varchar(255) NOT NULL default '',
  `po_poll7` varchar(255) NOT NULL default '',
  `po_poll8` varchar(255) NOT NULL default '',
  `po_poll9` varchar(255) NOT NULL default '',
  `po_cnt1` int(11) NOT NULL default '0',
  `po_cnt2` int(11) NOT NULL default '0',
  `po_cnt3` int(11) NOT NULL default '0',
  `po_cnt4` int(11) NOT NULL default '0',
  `po_cnt5` int(11) NOT NULL default '0',
  `po_cnt6` int(11) NOT NULL default '0',
  `po_cnt7` int(11) NOT NULL default '0',
  `po_cnt8` int(11) NOT NULL default '0',
  `po_cnt9` int(11) NOT NULL default '0',
  `po_etc` varchar(255) NOT NULL default '',
  `po_level` tinyint(4) NOT NULL default '0',
  `po_point` int(11) NOT NULL default '0',
  `po_date` date NOT NULL default '0000-00-00',
  `po_ips` mediumtext NOT NULL,
  `mb_ids` text NOT NULL,
  PRIMARY KEY  (`po_id`)
);

##
## Table structure for table `$g4[poll_etc_table]`
##

DROP TABLE IF EXISTS `$g4[poll_etc_table]`;
CREATE TABLE `$g4[poll_etc_table]` (
  `pc_id` int(11) NOT NULL default '0',
  `po_id` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL default '',
  `pc_name` varchar(255) NOT NULL default '',
  `pc_idea` varchar(255) NOT NULL default '',
  `pc_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`pc_id`)
);

##
## Table structure for table `$g4[popular_table]`
##

DROP TABLE IF EXISTS `$g4[popular_table]`;
CREATE TABLE `$g4[popular_table]` (
  `pp_id` int(11) NOT NULL auto_increment,
  `pp_word` varchar(50) NOT NULL default '',
  `pp_date` date NOT NULL default '0000-00-00',
  `pp_ip` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`pp_id`),
  UNIQUE KEY `index1` (`pp_date`,`pp_word`,`pp_ip`)
);

##
## Table structure for table `$g4[scrap_table]`
##

DROP TABLE IF EXISTS `$g4[scrap_table]`;
CREATE TABLE `$g4[scrap_table]` (
  `ms_id` int(11) NOT NULL auto_increment,
  `mb_id` varchar(255) NOT NULL default '',
  `bo_table` varchar(20) NOT NULL default '',
  `wr_id` varchar(15) NOT NULL default '',
  `ms_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`ms_id`),
  KEY `mb_id` (`mb_id`)
);

##
## Table structure for table `$g4[token_table]`
##

DROP TABLE IF EXISTS `$g4[token_table]`;
CREATE TABLE `$g4[token_table]` (
  `to_token` varchar(32) NOT NULL default '',
  `to_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `to_ip` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`to_token`),
  KEY `to_datetime` (`to_datetime`),
  KEY `to_ip` (`to_ip`)
);

##
## Table structure for table `$g4[visit_table]`
##

DROP TABLE IF EXISTS `$g4[visit_table]`;
CREATE TABLE `$g4[visit_table]` (
  `vi_id` int(11) NOT NULL default '0',
  `vi_ip` varchar(255) NOT NULL default '',
  `vi_date` date NOT NULL default '0000-00-00',
  `vi_time` time NOT NULL default '00:00:00',
  `vi_referer` text NOT NULL,
  `vi_agent` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`vi_id`),
  UNIQUE KEY `index1` (`vi_ip`,`vi_date`),
  KEY `index2` (`vi_date`)
);

##
## Table structure for table `$g4[visit_sum_table]`
##

DROP TABLE IF EXISTS `$g4[visit_sum_table]`;
CREATE TABLE `$g4[visit_sum_table]` (
  `vs_date` date NOT NULL default '0000-00-00',
  `vs_count` int(11) NOT NULL default '0',
  PRIMARY KEY  (`vs_date`),
  KEY `index1` (`vs_count`)
);







## Dump completed on 2007-08-22  6:49:49


##
## Table structure for table `g4_site_bill`
##

DROP TABLE IF EXISTS `g4_site_bill`;
CREATE TABLE `g4_site_bill` (
  po_id int(11) NOT NULL auto_increment,
  po_subject varchar(255) NOT NULL default '',
  po_poll1 varchar(255) NOT NULL default '',
  po_poll2 varchar(255) NOT NULL default '',
  po_poll3 varchar(255) NOT NULL default '',
  po_poll4 varchar(255) NOT NULL default '',
  po_poll5 varchar(255) NOT NULL default '',
  po_poll6 varchar(255) NOT NULL default '',
  po_poll7 varchar(255) NOT NULL default '',
  po_poll8 varchar(255) NOT NULL default '',
  po_poll9 varchar(255) NOT NULL default '',
  po_poll10 varchar(255) NOT NULL default '',
  po_poll11 varchar(255) NOT NULL default '',
  po_poll12 varchar(255) NOT NULL default '',
  po_poll13 varchar(255) NOT NULL default '',
  po_poll14 varchar(255) NOT NULL default '',
  po_poll15 text NOT NULL,
  po_poll16 varchar(255) NOT NULL default '',
  po_poll17 varchar(255) NOT NULL default '',
  po_poll18 varchar(255) NOT NULL default '',
  po_poll19 varchar(255) NOT NULL default '',
  po_cnt1 int(11) NOT NULL default '0',
  po_cnt2 int(11) NOT NULL default '0',
  po_cnt3 int(11) NOT NULL default '0',
  po_cnt4 int(11) NOT NULL default '0',
  po_cnt5 int(11) NOT NULL default '0',
  po_cnt6 int(11) NOT NULL default '0',
  po_cnt7 int(11) NOT NULL default '0',
  po_cnt8 int(11) NOT NULL default '0',
  po_cnt9 int(11) NOT NULL default '0',
  po_cnt10 int(11) NOT NULL default '0',
  po_cnt11 int(11) NOT NULL default '0',
  po_cnt12 int(11) NOT NULL default '0',
  po_cnt13 int(11) NOT NULL default '0',
  po_cnt14 int(11) NOT NULL default '0',
  po_cnt15 int(11) NOT NULL default '0',
  po_cnt16 int(11) NOT NULL default '0',
  po_cnt17 int(11) NOT NULL default '0',
  po_cnt18 int(11) NOT NULL default '0',
  po_cnt19 int(11) NOT NULL default '0',
  po_etc varchar(255) NOT NULL default '',
  po_level tinyint(4) NOT NULL default '0',
  po_point int(11) NOT NULL default '0',
  po_date date NOT NULL default '0000-00-00',
  po_ips mediumtext NOT NULL,
  mb_ids text NOT NULL,
  PRIMARY KEY  (`po_id`)
);


##
## Table structure for table `g4_site_banner`
##

DROP TABLE IF EXISTS `g4_site_banner`;
CREATE TABLE `g4_site_banner` (
  po_id int(11) NOT NULL auto_increment,
  po_subject varchar(255) NOT NULL default '',
  po_poll1 varchar(255) NOT NULL default '',
  po_poll2 varchar(255) NOT NULL default '',
  po_poll3 varchar(255) NOT NULL default '',
  po_poll4 varchar(255) NOT NULL default '',
  po_poll5 varchar(255) NOT NULL default '',
  po_poll6 varchar(255) NOT NULL default '',
  po_poll7 varchar(255) NOT NULL default '',
  po_poll8 varchar(255) NOT NULL default '',
  po_poll9 varchar(255) NOT NULL default '',
  po_poll10 varchar(255) NOT NULL default '',
  po_poll11 varchar(255) NOT NULL default '',
  po_poll12 varchar(255) NOT NULL default '',
  po_poll13 varchar(255) NOT NULL default '',
  po_poll14 varchar(255) NOT NULL default '',
  po_poll15 varchar(255) NOT NULL default '',
  po_poll16 varchar(255) NOT NULL default '',
  po_poll17 varchar(255) NOT NULL default '',
  po_poll18 varchar(255) NOT NULL default '',
  po_poll19 varchar(255) NOT NULL default '',
  po_cnt1 int(11) NOT NULL default '0',
  po_cnt2 int(11) NOT NULL default '0',
  po_cnt3 int(11) NOT NULL default '0',
  po_cnt4 int(11) NOT NULL default '0',
  po_cnt5 int(11) NOT NULL default '0',
  po_cnt6 int(11) NOT NULL default '0',
  po_cnt7 int(11) NOT NULL default '0',
  po_cnt8 int(11) NOT NULL default '0',
  po_cnt9 int(11) NOT NULL default '0',
  po_cnt10 int(11) NOT NULL default '0',
  po_cnt11 int(11) NOT NULL default '0',
  po_cnt12 int(11) NOT NULL default '0',
  po_cnt13 int(11) NOT NULL default '0',
  po_cnt14 int(11) NOT NULL default '0',
  po_cnt15 int(11) NOT NULL default '0',
  po_cnt16 int(11) NOT NULL default '0',
  po_cnt17 int(11) NOT NULL default '0',
  po_cnt18 int(11) NOT NULL default '0',
  po_cnt19 int(11) NOT NULL default '0',
  PRIMARY KEY  (`po_id`)
);



DROP TABLE IF EXISTS `g4_cart_order`;
CREATE TABLE `g4_cart_order` (
  `wr_id` int(11) NOT NULL auto_increment,
  `order_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `order_code` varchar(20) NOT NULL default '',
  `wr_subject` varchar(255) NOT NULL default '',
  `wr_content` text NOT NULL,
  `mb_id` varchar(20) NOT NULL default '',
  `ne_1` varchar(255) NOT NULL default '',
  `ne_2` varchar(255) NOT NULL default '',
  `ne_3` varchar(255) NOT NULL default '',
  `ne_4` varchar(255) NOT NULL default '',
  `ne_5` varchar(255) NOT NULL default '',
  `ne_6` varchar(255) NOT NULL default '',
  `ne_7` varchar(255) NOT NULL default '',
  `ne_8` varchar(255) NOT NULL default '',
  `ne_9` varchar(255) NOT NULL default '',
  `ne_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`wr_id`),
  KEY `order_code` (`order_code`)
);



DROP TABLE IF EXISTS `g4_cart_category`;
CREATE TABLE `g4_cart_category` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL default '',
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL default '',
  `wr_subject` varchar(255) NOT NULL default '',
  `wr_content` text NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `mb_id` varchar(20) NOT NULL default '',
  `ne_1` varchar(255) NOT NULL default '',
  `ne_2` varchar(255) NOT NULL default '',
  `ne_3` varchar(255) NOT NULL default '',
  `ne_4` varchar(255) NOT NULL default '',
  `ne_5` varchar(255) NOT NULL default '',
  `ne_6` varchar(255) NOT NULL default '',
  `ne_7` varchar(255) NOT NULL default '',
  `ne_8` varchar(255) NOT NULL default '',
  `ne_9` varchar(255) NOT NULL default '',
  `ne_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS `g4_cart_count`;
CREATE TABLE `g4_cart_count` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_code` int(30) NOT NULL default '0',
  `wr_hit` int(11) NOT NULL default '0',
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_ip` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`wr_id`)
) TYPE=MyISAM;



###################################
###################################
###################################



-- 
-- ̺  `g4_write_p_sitemap`
-- 
DROP TABLE IF EXISTS `g4_write_p_sitemap`;
CREATE TABLE `g4_write_p_sitemap` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL default '',
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL default '',
  `ca_name` varchar(255) NOT NULL default '',
  `wr_option` set('html1','html2','secret','mail') NOT NULL default '',
  `wr_subject` varchar(255) NOT NULL default '',
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL default '',
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL default '',
  `wr_password` varchar(255) NOT NULL default '',
  `wr_name` varchar(255) NOT NULL default '',
  `wr_email` varchar(255) NOT NULL default '',
  `wr_homepage` varchar(255) NOT NULL default '',
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL default '',
  `wr_ip` varchar(255) NOT NULL default '',
  `wr_1` varchar(255) NOT NULL default '',
  `wr_2` varchar(255) NOT NULL default '',
  `wr_3` varchar(255) NOT NULL default '',
  `wr_4` varchar(255) NOT NULL default '',
  `wr_5` varchar(255) NOT NULL default '',
  `wr_6` varchar(255) NOT NULL default '',
  `wr_7` varchar(255) NOT NULL default '',
  `wr_8` varchar(255) NOT NULL default '',
  `wr_9` varchar(255) NOT NULL default '',
  `wr_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_p_sitemap`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_shopping`
-- 
DROP TABLE IF EXISTS `g4_write_shopping`;
CREATE TABLE `g4_write_shopping` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL default '',
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL default '',
  `ca_name` varchar(255) NOT NULL default '',
  `wr_option` set('html1','html2','secret','mail') NOT NULL default '',
  `wr_subject` varchar(255) NOT NULL default '',
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL default '',
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL default '',
  `wr_password` varchar(255) NOT NULL default '',
  `wr_name` varchar(255) NOT NULL default '',
  `wr_email` varchar(255) NOT NULL default '',
  `wr_homepage` varchar(255) NOT NULL default '',
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL default '',
  `wr_ip` varchar(255) NOT NULL default '',
  `wr_1` varchar(255) NOT NULL default '',
  `wr_2` varchar(255) NOT NULL default '',
  `wr_3` varchar(255) NOT NULL default '',
  `wr_4` varchar(255) NOT NULL default '',
  `wr_5` varchar(255) NOT NULL default '',
  `wr_6` varchar(255) NOT NULL default '',
  `wr_7` varchar(255) NOT NULL default '',
  `wr_8` varchar(255) NOT NULL default '',
  `wr_9` varchar(255) NOT NULL default '',
  `wr_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_shopping`
-- 


-- --------------------------------------------------------


-- 
-- ̺  `g4_write_sub_1010`
-- 
DROP TABLE IF EXISTS `g4_write_sub_1010`;
CREATE TABLE `g4_write_sub_1010` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL default '',
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL default '',
  `ca_name` varchar(255) NOT NULL default '',
  `wr_option` set('html1','html2','secret','mail') NOT NULL default '',
  `wr_subject` varchar(255) NOT NULL default '',
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL default '',
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL default '',
  `wr_password` varchar(255) NOT NULL default '',
  `wr_name` varchar(255) NOT NULL default '',
  `wr_email` varchar(255) NOT NULL default '',
  `wr_homepage` varchar(255) NOT NULL default '',
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL default '',
  `wr_ip` varchar(255) NOT NULL default '',
  `wr_1` varchar(255) NOT NULL default '',
  `wr_2` varchar(255) NOT NULL default '',
  `wr_3` varchar(255) NOT NULL default '',
  `wr_4` varchar(255) NOT NULL default '',
  `wr_5` varchar(255) NOT NULL default '',
  `wr_6` varchar(255) NOT NULL default '',
  `wr_7` varchar(255) NOT NULL default '',
  `wr_8` varchar(255) NOT NULL default '',
  `wr_9` varchar(255) NOT NULL default '',
  `wr_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_1010`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_1020`
-- 
DROP TABLE IF EXISTS `g4_write_sub_1020`;
CREATE TABLE `g4_write_sub_1020` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_1020`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_1030`
-- 
DROP TABLE IF EXISTS `g4_write_sub_1030`;
CREATE TABLE `g4_write_sub_1030` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_1030`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_1040`
-- 
DROP TABLE IF EXISTS `g4_write_sub_1040`;
CREATE TABLE `g4_write_sub_1040` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_1040`
-- 


-- 
-- ̺  `g4_write_sub_1050`
-- 
DROP TABLE IF EXISTS `g4_write_sub_1050`;
CREATE TABLE `g4_write_sub_1050` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_1050`
-- 


-- --------------------------------------------------------


-- 
-- ̺  `g4_write_sub_2010`
-- 
DROP TABLE IF EXISTS `g4_write_sub_2010`;
CREATE TABLE `g4_write_sub_2010` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL default '',
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL default '',
  `ca_name` varchar(255) NOT NULL default '',
  `wr_option` set('html1','html2','secret','mail') NOT NULL default '',
  `wr_subject` varchar(255) NOT NULL default '',
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL default '',
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL default '',
  `wr_password` varchar(255) NOT NULL default '',
  `wr_name` varchar(255) NOT NULL default '',
  `wr_email` varchar(255) NOT NULL default '',
  `wr_homepage` varchar(255) NOT NULL default '',
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL default '',
  `wr_ip` varchar(255) NOT NULL default '',
  `wr_1` varchar(255) NOT NULL default '',
  `wr_2` varchar(255) NOT NULL default '',
  `wr_3` varchar(255) NOT NULL default '',
  `wr_4` varchar(255) NOT NULL default '',
  `wr_5` varchar(255) NOT NULL default '',
  `wr_6` varchar(255) NOT NULL default '',
  `wr_7` varchar(255) NOT NULL default '',
  `wr_8` varchar(255) NOT NULL default '',
  `wr_9` varchar(255) NOT NULL default '',
  `wr_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_2010`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_2020`
-- 
DROP TABLE IF EXISTS `g4_write_sub_2020`;
CREATE TABLE `g4_write_sub_2020` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_2020`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_2030`
-- 
DROP TABLE IF EXISTS `g4_write_sub_2030`;
CREATE TABLE `g4_write_sub_2030` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_2030`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_2040`
-- 
DROP TABLE IF EXISTS `g4_write_sub_2040`;
CREATE TABLE `g4_write_sub_2040` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_2040`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_2050`
-- 
DROP TABLE IF EXISTS `g4_write_sub_2050`;
CREATE TABLE `g4_write_sub_2050` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_2050`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_3010`
-- 
DROP TABLE IF EXISTS `g4_write_sub_3010`;
CREATE TABLE `g4_write_sub_3010` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_3010`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_3020`
-- 
DROP TABLE IF EXISTS `g4_write_sub_3020`;
CREATE TABLE `g4_write_sub_3020` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_3020`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_3030`
-- 
DROP TABLE IF EXISTS `g4_write_sub_3030`;
CREATE TABLE `g4_write_sub_3030` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_3030`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_3040`
-- 
DROP TABLE IF EXISTS `g4_write_sub_3040`;
CREATE TABLE `g4_write_sub_3040` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_3040`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_3050`
-- 
DROP TABLE IF EXISTS `g4_write_sub_3050`;
CREATE TABLE `g4_write_sub_3050` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_3050`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_3060`
-- 
DROP TABLE IF EXISTS `g4_write_sub_3060`;
CREATE TABLE `g4_write_sub_3060` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_3060`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_4010`
-- 
DROP TABLE IF EXISTS `g4_write_sub_4010`;
CREATE TABLE `g4_write_sub_4010` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_4010`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_4020`
-- 
DROP TABLE IF EXISTS `g4_write_sub_4020`;
CREATE TABLE `g4_write_sub_4020` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_4020`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_4030`
-- 
DROP TABLE IF EXISTS `g4_write_sub_4030`;
CREATE TABLE `g4_write_sub_4030` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_4030`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_4040`
-- 
DROP TABLE IF EXISTS `g4_write_sub_4040`;
CREATE TABLE `g4_write_sub_4040` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_4040`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_4050`
-- 
DROP TABLE IF EXISTS `g4_write_sub_4050`;
CREATE TABLE `g4_write_sub_4050` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_4050`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_4060`
-- 
DROP TABLE IF EXISTS `g4_write_sub_4060`;
CREATE TABLE `g4_write_sub_4060` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_4060`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_5010`
-- 
DROP TABLE IF EXISTS `g4_write_sub_5010`;
CREATE TABLE `g4_write_sub_5010` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_5010`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_5020`
-- 
DROP TABLE IF EXISTS `g4_write_sub_5020`;
CREATE TABLE `g4_write_sub_5020` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_5020`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_5030`
-- 
DROP TABLE IF EXISTS `g4_write_sub_5030`;
CREATE TABLE `g4_write_sub_5030` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_5030`
-- 


-- --------------------------------------------------------

-- 
-- ̺  `g4_write_sub_5040`
-- 
DROP TABLE IF EXISTS `g4_write_sub_5040`;
CREATE TABLE `g4_write_sub_5040` (
  `wr_id` int(11) NOT NULL auto_increment,
  `wr_num` int(11) NOT NULL default '0',
  `wr_reply` varchar(10) NOT NULL,
  `wr_parent` int(11) NOT NULL default '0',
  `wr_is_comment` tinyint(4) NOT NULL default '0',
  `wr_comment` int(11) NOT NULL default '0',
  `wr_comment_reply` varchar(5) NOT NULL,
  `ca_name` varchar(255) NOT NULL,
  `wr_option` set('html1','html2','secret','mail') NOT NULL,
  `wr_subject` varchar(255) NOT NULL,
  `wr_content` text NOT NULL,
  `wr_link1` text NOT NULL,
  `wr_link2` text NOT NULL,
  `wr_link1_hit` int(11) NOT NULL default '0',
  `wr_link2_hit` int(11) NOT NULL default '0',
  `wr_trackback` varchar(255) NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `wr_good` int(11) NOT NULL default '0',
  `wr_nogood` int(11) NOT NULL default '0',
  `mb_id` varchar(255) NOT NULL,
  `wr_password` varchar(255) NOT NULL,
  `wr_name` varchar(255) NOT NULL,
  `wr_email` varchar(255) NOT NULL,
  `wr_homepage` varchar(255) NOT NULL,
  `wr_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `wr_last` varchar(19) NOT NULL,
  `wr_ip` varchar(255) NOT NULL,
  `wr_1` varchar(255) NOT NULL,
  `wr_2` varchar(255) NOT NULL,
  `wr_3` varchar(255) NOT NULL,
  `wr_4` varchar(255) NOT NULL,
  `wr_5` varchar(255) NOT NULL,
  `wr_6` varchar(255) NOT NULL,
  `wr_7` varchar(255) NOT NULL,
  `wr_8` varchar(255) NOT NULL,
  `wr_9` varchar(255) NOT NULL,
  `wr_10` varchar(255) NOT NULL,
  PRIMARY KEY  (`wr_id`),
  KEY `wr_num_reply_parent` (`wr_num`,`wr_reply`,`wr_parent`),
  KEY `wr_is_comment` (`wr_is_comment`,`wr_id`)
);

-- 
-- ̺   `g4_write_sub_5040`
-- 





-- 
-- ̺   `g4_group`
-- 

INSERT INTO `g4_group` VALUES ('gr_adm', 'GR-ADMIN', '', 0, '', '', '', '', '', '', '', '', '', 'SITE MAP', '', '', '', '', '', '', '', '', '', 'NOT USE');
INSERT INTO `g4_group` VALUES ('gr_100', 'GR-100', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `g4_group` VALUES ('gr_200', 'GR-200', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `g4_group` VALUES ('gr_300', 'GR-300', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `g4_group` VALUES ('gr_400', 'GR-400', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `g4_group` VALUES ('gr_500', 'GR-500', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');

-- --------------------------------------------------------




-- 
-- ̺   `g4_board`
-- 

INSERT INTO `g4_board` VALUES ('sub_1010', 'gr_100', 'sub_1010', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_1020', 'gr_100', 'sub_1020', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_1030', 'gr_100', 'sub_1030', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_1040', 'gr_100', 'sub_1040', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_1050', 'gr_100', 'sub_1050', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_2010', 'gr_200', 'sub_2010', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_2020', 'gr_200', 'sub_2020', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_2030', 'gr_200', 'sub_2030', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_2040', 'gr_200', 'sub_2040', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_2050', 'gr_200', 'sub_2050', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_3010', 'gr_300', 'sub_3010', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_3020', 'gr_300', 'sub_3020', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_3030', 'gr_300', 'sub_3030', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_3040', 'gr_300', 'sub_3040', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_3050', 'gr_300', 'sub_3050', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_3060', 'gr_300', 'sub_3060', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_4010', 'gr_400', 'sub_4010', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_4020', 'gr_400', 'sub_4020', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_4030', 'gr_400', 'sub_4030', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_4040', 'gr_400', 'sub_4040', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_4050', 'gr_400', 'sub_4050', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_4060', 'gr_400', 'sub_4060', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_5010', 'gr_500', 'sub_5010', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_5020', 'gr_500', 'sub_5020', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_5030', 'gr_500', 'sub_5030', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('sub_5040', 'gr_500', 'sub_5040', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'basic.skin.php');
INSERT INTO `g4_board` VALUES ('p_sitemap', 'gr_adm', 'SITE MAP', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'sitemap.skin.php');
INSERT INTO `g4_board` VALUES ('shopping', 'gr_adm', 'SHOPPING', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 5, 1, -20, 0, '', 'script|iframe', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 60, 15, 24, 100, 600, 'basic', '', '', '../_head.php', '../_tail.php', '', '', '', 4, 1048576, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', 2, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'gallery.skin.php');

-- --------------------------------------------------------

-- 
-- ̺   `g4_site_bill`
-- 

INSERT INTO `g4_site_bill` VALUES (1, 'connect', 'skin', 'connect', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (2, 'latest', 'skin', 'latest', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (3, 'member', 'skin', 'member', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (4, 'new', 'skin', 'new', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (5, 'outlogin', 'skin', 'outlogin', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (6, 'poll', 'skin', 'poll', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (7, 'popular', 'skin', 'popular', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (8, 'search', 'skin', 'search', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (9, 'visit', 'skin', 'visit', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (10, 'head', 'skin', 'head', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (11, 'sub_menu', 'skin', 'sub_menu', 'basic', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (12, 'main', 'skin', 'main', 'default', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (13, 'head_sub', 'skin', 'head_sub', 'basic', 'center', '840', '180', '420', '5', '5', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (14, 'head_menu', 'skin', 'head_menu', 'intro_y_1', '', '', ' ', '', '', '', '', '', '', '', '', '', ' ', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (15, 'GR-ADMIN', 'gr_adm', 'basic', 'basic', 'basic', 'basic', 'center', '', '', 'gr_id', 'basic', '', '', '', '', '', '', '', '', '', 980, 180, 795, 190, 180, 2, 1, 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'gr_adm', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (16, 'GR-100', 'gr_100', 'basic', 'basic', 'basic', 'basic', 'center', '', '', 'gr_id', 'basic', '', '', '', '', '', '', '', '', '', 980, 180, 795, 190, 180, 1, 1, 2, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'gr_100', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (17, 'GR-200', 'gr_200', 'basic', 'basic', 'basic', 'basic', 'center', '', '', 'gr_id', 'basic', '', '', '', '', '', '', '', '', '', 980, 180, 795, 190, 180, 1, 2, 2, 2, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'gr_200', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (18, 'GR-300', 'gr_300', 'basic', 'basic', 'basic', 'basic', 'center', '', '', 'gr_id', 'basic', '', '', '', '', '', '', '', '', '', 980, 180, 795, 190, 180, 1, 3, 2, 3, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'gr_300', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (19, 'GR-400', 'gr_400', 'basic', 'basic', 'basic', 'basic', 'center', '', '', 'gr_id', 'basic', '', '', '', '', '', '', '', '', '', 980, 180, 795, 190, 180, 1, 4, 2, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'gr_400', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (20, 'GR-500', 'gr_500', 'basic', 'basic', 'basic', 'basic', 'center', '', '', 'gr_id', 'basic', '', '', '', '', '', '', '', '', '', 980, 180, 795, 190, 180, 1, 5, 2, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'gr_500', 0, 0, '0000-00-00', '', '');
INSERT INTO `g4_site_bill` VALUES (21, 'sub_1010', 'sub_1010', 'basic', 'gr_100', 'basic', 'basic', 'basic', '3', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 9, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (22, 'sub_1020', 'sub_1020', 'basic', 'gr_100', 'basic', 'basic', 'basic', '4', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 5, 160, 9, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (23, 'sub_1030', 'sub_1030', 'basic', 'gr_100', 'basic', 'basic', 'basic', '4', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 4, 160, 9, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (24, 'sub_1040', 'sub_1040', 'basic', 'gr_100', 'basic', 'basic', 'basic', '4', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 9, 4, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 7, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (25, 'sub_1050', 'sub_1050', 'basic', 'gr_100', 'basic', 'basic', 'basic', '4', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 5, 160, 9, 5, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (26, 'sub_2010', 'sub_2010', 'basic', 'gr_200', 'basic', 'basic', 'basic', '1', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 4, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (27, 'sub_2020', 'sub_2020', 'basic', 'gr_200', 'basic', 'basic', 'basic', '1', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (28, 'sub_2030', 'sub_2030', 'basic', 'gr_200', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (29, 'sub_2040', 'sub_2040', 'basic', 'gr_200', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (30, 'sub_2050', 'sub_2050', 'basic', 'gr_200', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 130, 9, 9, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 4, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (31, 'sub_3010', 'sub_3010', 'basic', 'gr_300', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (32, 'sub_3020', 'sub_3020', 'basic', 'gr_300', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 4, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (33, 'sub_3030', 'sub_3030', 'basic', 'gr_300', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (34, 'sub_3040', 'sub_3040', 'basic', 'gr_300', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (35, 'sub_3050', 'sub_3050', 'basic', 'gr_300', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 130, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (36, 'sub_3060', 'sub_3060', 'basic', 'gr_300', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 7, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (37, 'sub_4010', 'sub_4010', 'basic', 'gr_400', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (38, 'sub_4030', 'sub_4030', 'basic', 'gr_400', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (39, 'sub_4020', 'sub_4020', 'basic', 'gr_400', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '4', 'basic');
INSERT INTO `g4_site_bill` VALUES (40, 'sub_4040', 'sub_4040', 'basic', 'gr_400', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (41, 'sub_4050', 'sub_4050', 'basic', 'gr_400', 'basic', 'basic', 'basic', '8', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 7, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (42, 'sub_4060', 'sub_4060', 'basic', 'gr_400', 'basic', 'basic', 'basic', '8', '5', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 7, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (43, 'sub_5010', 'sub_5010', 'basic', 'gr_500', 'basic', 'basic', 'basic', '8', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 10, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 4, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (44, 'sub_5020', 'sub_5020', 'basic', 'gr_500', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 5, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (45, 'sub_5030', 'sub_5030', 'basic', 'gr_500', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 10, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 6, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (46, 'sub_5040', 'sub_5040', 'basic', 'gr_500', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 7, '0000-00-00', '5', 'basic');
INSERT INTO `g4_site_bill` VALUES (47, 'SITE MAP', 'p_sitemap', 'basic', 'gr_adm', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 9, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 1, '0000-00-00', '1', 'basic');
INSERT INTO `g4_site_bill` VALUES (48, 'SHOPPING', 'shopping', 'basic', 'gr_adm', 'basic', 'basic', 'basic', '1', '1', 'bo_table', '', '', '', '', '', '', '', '', '', '', 0, 0, 1, 1, 160, 2, 7, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 1, '0000-00-00', '1', 'basic');


-- --------------------------------------------------------


-- 2008.11.24  Ʈ  ̺ ߰

-- 
-- ̺  `g4_site_point`
-- 
DROP TABLE IF EXISTS `g4_site_point`;
CREATE TABLE `g4_site_point` (
  `po_id` int(11) NOT NULL auto_increment,
  `order_id` int(11) NOT NULL default '0',
  `bo_table` varchar(255) NOT NULL default '',
  `wr_id` varchar(255) NOT NULL default '',
  `mb_id` varchar(255) NOT NULL default '',
  `b_name` varchar(255) NOT NULL default '',
  `order_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ing_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `send_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `order_state` varchar(255) NOT NULL default '',
  `b_tel` varchar(255) NOT NULL default '',
  `b_hp` varchar(255) NOT NULL default '',
  `b_email` varchar(255) NOT NULL default '',
  `b_addr1` varchar(255) NOT NULL default '',
  `b_addr2` varchar(255) NOT NULL default '',
  `b_ch` int(11) NOT NULL default '0',
  `b_name2` varchar(255) NOT NULL default '',
  `b_tel2` varchar(255) NOT NULL default '',
  `b_hp2` varchar(255) NOT NULL default '',
  `b_email2` varchar(255) NOT NULL default '',
  `b_addr1_2` varchar(255) NOT NULL default '',
  `b_addr2_2` varchar(255) NOT NULL default '',
  `b_ch2` int(11) NOT NULL default '0',
  `b_opt1` varchar(255) NOT NULL default '',
  `b_opt2` varchar(255) NOT NULL default '',
  `b_opt3` varchar(255) NOT NULL default '',
  `b_opt5` varchar(255) NOT NULL default '',
  `b_opt6` varchar(255) NOT NULL default '',
  `b_opt7` varchar(255) NOT NULL default '',
  `b_opt8` varchar(255) NOT NULL default '',
  `b_opt9` varchar(255) NOT NULL default '',
  `b_opt10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`po_id`)
);

-- 2007.12.16   ̺ Խñ  ߰

-- 
-- ̺  `g4_site_count`
-- 

DROP TABLE IF EXISTS `g4_site_count`;
CREATE TABLE `g4_site_count` (
  `bn_id` int(11) NOT NULL auto_increment,
  `bo_table` varchar(20) NOT NULL default '',
  `wr_id` int(11) NOT NULL default '0',
  `wr_parent` int(11) NOT NULL default '0',
  `bn_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `mb_id` varchar(20) NOT NULL default '',
  `wr_subject` varchar(255) NOT NULL default '',
  `wr_content` text NOT NULL,
  `wr_hit` int(11) NOT NULL default '0',
  `ne_1` varchar(255) NOT NULL default '',
  `ne_2` varchar(255) NOT NULL default '',
  `ne_3` varchar(255) NOT NULL default '',
  `ne_4` varchar(255) NOT NULL default '',
  `ne_5` varchar(255) NOT NULL default '',
  `ne_6` varchar(255) NOT NULL default '',
  `ne_7` varchar(255) NOT NULL default '',
  `ne_8` varchar(255) NOT NULL default '',
  `ne_9` varchar(255) NOT NULL default '',
  `ne_10` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`bn_id`),
  KEY `mb_id` (`mb_id`)
) ;


-- 2007.12.29  â ̺ ߰

-- 
-- ̺  `g4_popup`
-- 

DROP TABLE IF EXISTS `g4_popup`;
CREATE TABLE `g4_popup` (
  `nIdx` mediumint(6) unsigned NOT NULL auto_increment,
  `nWidth` smallint(3) unsigned default NULL,
  `nHeight` smallint(3) unsigned default NULL,
  `nLeft` smallint(3) default NULL,
  `nRight` smallint(3) default NULL,
  `nOptions` varchar(255) default NULL,
  `szSubject` varchar(255) default NULL,
  `szMemo` text,
  `szImage` varchar(255) default NULL,
  `szView` char(1) NOT NULL default 'N',
  `nStartDate` int(12) unsigned default NULL,
  `nEndDate` int(12) unsigned default NULL,
  `nDate` int(12) unsigned default NULL,
  PRIMARY KEY  (`nIdx`)
) ;


