
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

DROP TABLE IF EXISTS `zm_alimi`;
CREATE TABLE IF NOT EXISTS `zm_alimi` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_id` varchar(255) NOT NULL,
  `db_content` text,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_new_reply_check` varchar(1) default NULL,
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;



DROP TABLE IF EXISTS `zm_blacklist_bbs`;
CREATE TABLE IF NOT EXISTS `zm_blacklist_bbs` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_table` varchar(20) NOT NULL,
  `db_wrid` int(11) NOT NULL,
  `db_blockdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_report_count` int(11) NOT NULL COMMENT '신고개수',
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_blacklist_mem`;
CREATE TABLE IF NOT EXISTS `zm_blacklist_mem` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_block_id` varchar(50) NOT NULL,
  `db_report_count` int(11) NOT NULL,
  `db_block_end` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_block_service` varchar(20) NOT NULL,
  `db_flag` varchar(1) NOT NULL,
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_blacklist_report`;
CREATE TABLE IF NOT EXISTS `zm_blacklist_report` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_block_id` varchar(20) NOT NULL,
  `db_report_id` varchar(20) NOT NULL,
  `db_table` varchar(20) NOT NULL,
  `db_wrid` int(11) NOT NULL,
  `db_why_report` varchar(100) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00' COMMENT '신고일',
  PRIMARY KEY  (`db_recno`),
  FULLTEXT KEY `db_report_id` (`db_report_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_board_best`;
CREATE TABLE IF NOT EXISTS `zm_board_best` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_table` varchar(50) NOT NULL,
  `db_wrid` int(11) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=69500 ;


DROP TABLE IF EXISTS `zm_board_config`;
CREATE TABLE IF NOT EXISTS `zm_board_config` (
  `db_table` varchar(40) NOT NULL,
  `db_varname` varchar(255) NOT NULL,
  `db_variable` varchar(255) NOT NULL,
  `db_value` varchar(255) NOT NULL,
  `db_valtype` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `zm_board_good`;
CREATE TABLE IF NOT EXISTS `zm_board_good` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_table` varchar(20) NOT NULL,
  `db_wrid` int(11) NOT NULL,
  `db_flag` text NOT NULL,
  PRIMARY KEY  (`db_recno`),
  KEY `db_table` (`db_table`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_builder_config`;
CREATE TABLE IF NOT EXISTS `zm_builder_config` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_level` varchar(2) NOT NULL,
  `db_up_recno` int(11) NOT NULL,
  `db_rank` int(11) NOT NULL,
  `db_group_name` varchar(40) NOT NULL,
  `db_group_explain` varchar(100) NOT NULL,
  `db_more` varchar(1) NOT NULL,
  `db_menu_reg` tinyint(1) NOT NULL,
  `db_index_skin` varchar(30) NOT NULL,
  `db_layout_skin` varchar(30) NOT NULL,
  `db_pagename` varchar(40) NOT NULL,
  `db_url` varchar(255) NOT NULL,
  `db_target` varchar(10) NOT NULL,
  `db_link_type` varchar(1) NOT NULL,
  `db_board` varchar(30) NOT NULL,
  `db_href` varchar(255) NOT NULL,
  `db_subdomain` varchar(40) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;



DROP TABLE IF EXISTS `zm_config`;
CREATE TABLE IF NOT EXISTS `zm_config` (
  `db_varname` varchar(255) NOT NULL,
  `db_variable` varchar(255) NOT NULL,
  `db_value` varchar(255) NOT NULL,
  `db_valtype` varchar(255) NOT NULL,
  PRIMARY KEY  (`db_variable`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `zm_friend`;
CREATE TABLE IF NOT EXISTS `zm_friend` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_id` varchar(50) NOT NULL,
  `db_friend_id` varchar(50) NOT NULL COMMENT '친구 아이디',
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00' COMMENT '날짜',
  `db_state` varchar(1) NOT NULL COMMENT '상태',
  `db_group` varchar(50) NOT NULL,
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_lineword`;
CREATE TABLE IF NOT EXISTS `zm_lineword` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_id` varchar(50) NOT NULL,
  `db_write_id` varchar(50) NOT NULL,
  `db_memo` varchar(255) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_flag` varchar(1) NOT NULL,
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_login_log`;
CREATE TABLE IF NOT EXISTS `zm_login_log` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_id` varchar(40) NOT NULL,
  `db_date` datetime NOT NULL,
  `db_service` varchar(255) NOT NULL,
  `db_authtype` varchar(50) NOT NULL,
  `db_result` varchar(50) NOT NULL,
  `db_ip` varchar(15) NOT NULL,
  `db_flag` varchar(1) NOT NULL,
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;



DROP TABLE IF EXISTS `zm_member`;
CREATE TABLE IF NOT EXISTS `zm_member` (
  `db_id` varchar(255) NOT NULL,
  `db_profile_pic` varchar(255) NOT NULL,
  `db_location` varchar(20) NOT NULL,
  `db_bloodtype` varchar(2) NOT NULL,
  `db_belong` varchar(100) NOT NULL,
  `db_school` varchar(255) NOT NULL,
  `db_sns_link` varchar(100) NOT NULL,
  `db_zium_money` int(11) NOT NULL,
  `db_new_memo` tinyint(4) NOT NULL COMMENT '새 쪽지 개수',
  `db_memosend_date` date NOT NULL default '0000-00-00' COMMENT '최근 쪽지 발송 일',
  `db_memo_today` tinyint(4) NOT NULL COMMENT '오늘 발송한 쪽지 개수',
  `db_memo_latesend` varchar(255) NOT NULL COMMENT '최근 쪽지 발송한 아이디',
  `db_memo_recv_condition` varchar(1) NOT NULL,
  `db_profile_open_level` varchar(3) NOT NULL,
  `db_write_latedate` date NOT NULL default '0000-00-00' COMMENT '마지막 글쓴 날짜',
  `db_write_today` tinyint(4) NOT NULL COMMENT '오늘 쓴 글',
  `db_sms_certify` datetime NOT NULL,
  PRIMARY KEY  (`db_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `zm_member_pic`;
CREATE TABLE IF NOT EXISTS `zm_member_pic` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_id` varchar(50) NOT NULL,
  `db_picno` tinyint(4) NOT NULL COMMENT '사진 번호',
  `db_dir` varchar(10) NOT NULL,
  `db_filename` varchar(255) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_flag` varchar(1) NOT NULL,
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_memo_refusal`;
CREATE TABLE IF NOT EXISTS `zm_memo_refusal` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_id` varchar(50) NOT NULL COMMENT '차단한 사람',
  `db_refusal_id` varchar(50) NOT NULL COMMENT '차단된 사람',
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00' COMMENT '차단 시간',
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_popular_history`;
CREATE TABLE IF NOT EXISTS `zm_popular_history` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_rank` int(11) NOT NULL,
  `db_word` varchar(256) NOT NULL,
  `db_search_count` int(11) NOT NULL,
  `db_up` varchar(4) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_todayrank` int(11) NOT NULL COMMENT '오늘시작랭킹',
  `db_realrank` int(11) NOT NULL COMMENT '실시간순위',
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;


DROP TABLE IF EXISTS `zm_popup_notice`;
CREATE TABLE IF NOT EXISTS `zm_popup_notice` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_winstyle` varchar(2) NOT NULL,
  `db_winsize` varchar(9) NOT NULL,
  `db_winpos` varchar(9) NOT NULL,
  `db_start_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_end_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `db_target_level` varchar(2) NOT NULL,
  `db_subject` varchar(100) NOT NULL,
  `db_content` text NOT NULL,
  `db_skin` varchar(40) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;


DROP TABLE IF EXISTS `zm_search_word`;
CREATE TABLE IF NOT EXISTS `zm_search_word` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_word` varchar(50) NOT NULL,
  `db_rank` int(11) NOT NULL,
  `db_count` int(11) NOT NULL,
  `db_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`db_recno`),
  KEY `db_word` (`db_word`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=44 ;



DROP TABLE IF EXISTS `zm_se_images`;
CREATE TABLE IF NOT EXISTS `zm_se_images` (
  `db_recno` int(11) NOT NULL auto_increment,
  `db_table` varchar(50) NOT NULL,
  `db_wrid` int(11) NOT NULL,
  `db_folder` varchar(10) NOT NULL,
  `db_filename` varchar(255) NOT NULL,
  `db_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`db_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_sms_config`;
CREATE TABLE IF NOT EXISTS `zm_sms_config` (
  `ds_variable` varchar(255) NOT NULL default '',
  `ds_value` varchar(255) default NULL,
  PRIMARY KEY  (`ds_variable`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `zm_sms_history`;
CREATE TABLE IF NOT EXISTS `zm_sms_history` (
  `ds_recno` int(11) NOT NULL auto_increment,
  `ds_send_name` varchar(40) default NULL,
  `ds_send_id` varchar(20) default NULL,
  `ds_send_pcs` varchar(15) default NULL,
  `ds_send_msg` varchar(80) default NULL,
  `ds_receive_name` varchar(40) default NULL,
  `ds_receive_pcs` varchar(15) default NULL,
  `ds_send_type` varchar(1) default NULL,
  `ds_send_date` int(11) default NULL,
  PRIMARY KEY  (`ds_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `zm_sms_phonebook`;
CREATE TABLE IF NOT EXISTS `zm_sms_phonebook` (
  `ds_recno` int(11) NOT NULL auto_increment,
  `ds_mng_id` varchar(20) default NULL,
  `ds_phn_name` varchar(40) default NULL,
  `ds_phn_id` varchar(20) default NULL,
  `ds_phn_pcs` varchar(15) default NULL,
  `ds_phn_date` int(11) default NULL,
  `ds_memo` varchar(40) default NULL,
  PRIMARY KEY  (`ds_recno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;