<?
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가
/*
 * AMINA Skin Lib for AMINA BBS & THEMA
 *
 * ver 1.3
 *
 * Copyright (c) 2012 AMINA - http://amina.co.kr
 *
 */

function wr_amina($wr_10) { //wr_10의 설정값(첨부이미지 옵션)

	$post = array();

	list($post[photo], $post[img_location], $post[img_space], $post[post_main], $post[post_good], $post[post_rss]) = explode("|", trim($wr_10));

	return $post;
}

function wr_movie($wr_6) { //wr_6의 설정값(유투브 동영상)

	$movie = array();

	list($movie[movie_url], $movie[movie_w], $movie[movie_h], $movie[movie_auto]) = explode("|", trim($wr_6));

	$str = parse_url($movie[movie_url]); //주소분해
	if($str[host] == "youtu.be") $movie[movie_id] = trim(str_replace("/","",$str[path])); //유튜브 주소일 때만 출력가능함.

	return $movie;
}

//변수값 전환하기
function amina_query($str) { 

	$querystring = array();
	$query = array();

	//공백(" ")으로 변수분리
	$querystring = explode(" ", $str);
	foreach($querystring as $q) {
		list($k, $v) = explode("=", $q, 2);
		$query[$k] = str_replace("+"," ",trim($v)); // "+" 를 공백으로 변환
	}

	return $query;
}

function show_movie($movie) { //동영상 재생하기

	$show = "";
	if($movie[movie_id]) {
		if(!$movie[movie_w] || !is_numeric($movie[movie_w])) $movie[movie_w] = 640;
		if(!$movie[movie_h] || !is_numeric($movie[movie_h])) $movie[movie_h] = 360;

		if($movie[movie_auto]) $auto = "&amp;autoplay=1";
		$show = "<p align=center><EMBED width='{$movie[movie_w]}' height='{$movie[movie_h]}' type=application/x-shockwave-flash src=http://www.youtube.com/v/{$movie[movie_id]}{$auto}&amp;loop=1 allowScriptAccess='always' allowfullscreen='true' hl='ko_KR&amp;feature=player_embedded&amp;version=3'></EMBED></p>";
	}

	return $show;
}

// 분류 자동 선택
function amina_category_option($bo_table='',$ca_name)
{
    global $g4, $board;

    $arr = explode("|", $board[bo_category_list]); // 구분자가 , 로 되어 있음
    $str = "";
    for ($i=0; $i<count($arr); $i++) {
        if (trim($arr[$i])) {
			if(trim($arr[$i]) == $ca_name) { $selected = "selected"; } else { $selected = ""; }
			$str .= "<option value='$arr[$i]' $selected >$arr[$i]</option>\n";
		}
	}
    return $str;
}

function amina_attach_img($attach, $wr_content, $rows='1') {
	global $g4;

	$z = 0;
	for ($k=0; $k<count($attach); $k++) { //직접 첨부한 이미지
		if ($attach[$k][view]) {
			$attach_img[$k] = $attach[$k][path]."/".$attach[$k][file];
			if(preg_match("/\.(jp[e]?g|gif|png)$/i", $attach_img[$k]) && file_exists($attach_img[$k])) {
				$img[$z] = $attach_img[$k];
				$z++;
				if($z == $rows) break;
			}
		}
    }

	if($z != $rows) { //에디터에 삽입된 이미지
		$ym = 'data/cheditor4/[^<>]*/[^<>]*\.(gif|jpg|png)';
		if(preg_match_all("/<img[^>]*src=[\"']?([^>\"']+)[\"']?[^>]*>/i", $wr_content, $match)) {
			for ($k=0; $k<count($match[0]); $k++) {
				if(eregi($ym, $match[0][$k], $tmp_img)) {
					$chk_img[$z] = $g4[path]."/".$tmp_img[0];
					if(file_exists($chk_img[$z])) $img[$z] = $chk_img[$z];
					$z++;
					if($z == $rows) break;
				}
			}
		}
	}

	return $img;
}

// 파일 첨부여부 확인...
function amina_attach_file($attach) {
	global $g4;

	for ($i=0; $i<count($attach); $i++) {
		if ($attach[$i][source] && !$attach[$i][view]) {
			$chk_file = "ok";
			return $chk_file;
		}
    }
}

//유튜브 썸네일 저장
function get_youtube($url, $name) { 
	global $g4;

	$data_path = $g4[path]."/data/youtube";
	if(!is_dir($data_path)) {
        @mkdir($data_path, 0707);
        @chmod($data_path, 0707);
	}

	$imageurl = $url;
	$savefile = $data_path . '/' . $name;
	$file = $savefile;
	if(!file_exists($savefile)) {
		$ch = curl_init ($imageurl);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($ch, CURLOPT_BINARYTRANSFER,1); 
		$rawdata=curl_exec($ch); 
		curl_close ($ch); 		
		$fp = fopen($savefile,'w'); 
		fwrite($fp, $rawdata); 
		fclose($fp); 
	}

	return $savefile;
}

// 유튜브 썸네일 체크
function img_youtube($vid="") {
	global $g4;

	if($vid) {
		if(file_exists($g4[path]."/data/youtube/".$vid)) {
			$thumb = $g4[path]."/data/youtube/".$vid;
		} else {
			$org = "http://img.youtube.com/vi/{$vid}/hqdefault.jpg";
			$thumb = get_youtube($org, $vid);
		}
	}

	return $thumb;
}

//유튜브 동영상 썸네일 체크
function amina_movie_thumb($wr_6, $wr_content) {
	global $g4;

	$movie = array();

	$img = "";
	$movie = wr_movie($wr_6); //유튜브 동영상
	if($movie[movie_id]) {
		$img = img_youtube($movie[movie_id]);
	} else {
		//{동영상:주소|width|height|auto} 형식 - 유튜브만 썸네일 생성가능
		$youtube = "http://youtu.be";
		if(preg_match_all("/{동영상\:([^}]*)}/ie", $wr_content, $match)) {
			for ($i=0; $i<count($match[1]); $i++) {
				if(eregi($youtube, $match[1][$i])) {
					list($url) = explode("|", trim(strip_tags($match[1][$i])));
					$info = parse_url($url); //주소분해
					$movie[movie_id] = trim(str_replace("/","",$info[path])); 
					$img = img_youtube($movie[movie_id]);
					break;
				}
			}
		}
	}

	return $img;
}

// 썸네일 가져오기
function amina_thumb($path, $list, $img_w, $img_h, $no_img="", $mb_photo="", $is_crop=2, $quality=90, $is_create=false) {
	global $g4;

	if($list[img]) {
		$thumb = thumbnail($list[img], $img_w, $img_h, $is_create, $is_crop, $quality);
	} else {
		//유튜브 동영상 썸네일
		$you_img = amina_movie_thumb($list[wr_6], $list[wr_content]);

		if($you_img) {
			$thumb = thumbnail($you_img, $img_w, $img_h, $is_create, $is_crop, $quality);
		} else {
			$it_img = $g4[path]."/data/item/".$list[wr_9]."_l1"; //상품이미지
			if($list[wr_9] && file_exists($it_img)) {
				$thumb = thumbnail($it_img, $img_w, $img_h, $is_create, $is_crop, $quality);
			} else {
				if($mb_photo) {
					$thumb = $g4[path]."/data/mb_photo/".$list[mb_id].".gif";
					if($no_img && !file_exists($thumb)) $thumb = $path."/no_photo.gif";
				} else {
					if($no_img) $thumb = thumbnail($path."/no_image.gif", $img_w, $img_h, $is_create, $is_crop, $quality);
				}
			}
		}
	}

	return $thumb;
}

// 동영상 종류 파악
function amina_chk_movie($vid) {
	global $g4;

	$movie = array();
	$query = array();

	list($url, $opt) = explode("|", trim($vid));

	//변수 분리하기
	$movie = amina_query($opt);

	//변수값에서 숫자값만 가져오기
	$movie[width] = ereg_replace("[^0-9]", "", $movie[width]); 
	$movie[height] = ereg_replace("[^0-9]", "", $movie[height]);

	//주소분해
	$info = parse_url(strip_tags($url)); 
	$info[query] = preg_replace("/&amp;/", "&", $info[query]);
	parse_str($info[query], $query); 

	if($info[host] == "youtu.be") { //유튜브
		$movie[type] = "youtube";
		$movie[vid] = trim(str_replace("/","",$info[path])); 

	} else if($info[host] == "tvpot.daum.net") { //다음tv팟
		$movie[type] = "daum";
		$movie[vid] = $query[vid];

	} else if($info[host] == "channel.pandora.tv") { //판도라tv
		$movie[type] = "pandora";
		$movie[ch_userid] = $query[ch_userid];
		$movie[prgid] = $query[prgid];

	} else if($info[host] == "serviceapi.nmv.naver.com") { //네이버
		$movie[type] = "naver";
		$movie[vid] = $query[vid];
		$movie[outKey] = $query[outKey];
	}

     return $movie;
}

// 본문 동영상 출력
function amina_movie_content($vid) {
	global $g4;

	$movie = array();

	$movie = amina_chk_movie($vid);

	$show = "";
	if($movie[type] == "youtube") { //유튜브
		if(!$movie[width]) $movie[width] = 640;
		if(!$movie[height]) $movie[height] = 360;
		if($movie[auto]) $auto = "&amp;autoplay=1";
		$show = "<EMBED width='{$movie[width]}' height='{$movie[height]}' type=application/x-shockwave-flash src=http://www.youtube.com/v/{$movie[vid]}{$auto}&amp;loop=1 allowScriptAccess='always' allowfullscreen='true' hl='ko_KR&amp;feature=player_embedded&amp;version=3'></EMBED>\n\n";

	} else if($movie[type] == "daum") { //다음tv팟
		if(!$movie[width]) $movie[width] = 640;
		if(!$movie[height]) $movie[height] = 390;

		$show = "<object type='application/x-shockwave-flash' id='{$movie[vid]}' width='{$movie[width]}' height='{$movie[height]}px' align='middle' classid='clsid:d27cdb6e-ae6d-11cf-96b8-444553540000' codebase='http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0'>\n";
		$show .= "<param name='movie' value='http://flvs.daum.net/flvPlayer.swf?vid={$movie[vid]}&barOff=true' />\n";
		$show .= "<param name='allowScriptAccess' value='always' />\n";
		$show .= "<param name='allowFullScreen' value='true' />\n";
		$show .= "<param name='bgcolor' value='#000000' />\n";
		$show .= "<param name='wmode' value='opaque' />\n";
		$show .= "<embed src='http://flvs.daum.net/flvPlayer.swf?vid={$movie[vid]}&barOff=true' width='{$movie[width]}px' height='{$movie[height]}px' allowScriptAccess='always' type='application/x-shockwave-flash' allowFullScreen='true' bgcolor='#000000' ></embed>\n";
		$show .= "</object>\n\n";

	} else if($movie[type] == "pandora") { //판도라tv
		if(!$movie[width]) $movie[width] = 540;
		if(!$movie[height]) $movie[height] = 331;
		if($movie[auto]) $auto = "&amp;autoPlay=true";

		$show = "<object classid='clsid:d27cdb6e-ae6d-11cf-96b8-444553540000' codebase='http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=10,0,0,0' width='{$movie[width]}' height='{$movie[height]}' id='movie' align='middle'>\n";
		$show .= "<param name='quality' value='high' />\n";
		$show .= "<param name='movie' value='http://flvr.pandora.tv/flv2pan/flvmovie.dll/userid={$movie[ch_userid]}&amp;prgid={$movie[prgid]}&amp;skin=1{$auto}&amp;share=on&countryChk=ko' />\n";
		$show .= "<param name='allowScriptAccess' value='always' />\n";
		$show .= "<param name='allowFullScreen' value='true' />\n";
		$show .= "<param name='wmode' value='transparent' />\n";
		$show .= "<embed src='http://flvr.pandora.tv/flv2pan/flvmovie.dll/userid={$movie[ch_userid]}&amp;prgid={$movie[prgid]}&amp;skin=1{$auto}&amp;share=on&countryChk=ko' type='application/x-shockwave-flash' wmode='transparent' allowScriptAccess='always' allowFullScreen='true' pluginspage='http://www.macromedia.com/go/getflashplayer' width='{$movie[width]}' height='{$movie[height]}' /></embed>\n";
		$show .= "</object>\n\n";

	} else if($movie[type] == "naver") { //네이버(iframe)
		if(!$movie[width]) $movie[width] = 512;
		if(!$movie[height]) $movie[height] = 321;
		$show = "<iframe width='{$movie[width]}' height='{$movie[height]}' src='http://serviceapi.nmv.naver.com/flash/convertIframeTag.nhn?vid={$movie[vid]}&outKey={$movie[outKey]}' frameborder='no' scrolling='no'></iframe>\n\n";
	}

	return $show;
}

//{이미지:번호:옵션} 형식 변환
function amina_image_content($board, $view, $width='650', $num, $info){
	global $g4;

	$query = array();

	if($num != "0") {
		if(!$num || !is_numeric($num)) return;
	}

	//변수 분리하기
	$query = amina_query($info);

	//변수값에서 숫자값만 가져오기
	$query[width] = ereg_replace("[^0-9]", "", $query[width]); 
	$query[height] = ereg_replace("[^0-9]", "", $query[height]);

	//이미지 체크
	if($view[file][$num][view]) {
		$image = $view[file][$num][path]."/".$view[file][$num][file];
		if(preg_match("/\.(jp[e]?g|gif|png)$/i", $image) && file_exists($image)) {
			$img = "<img src='{$image}' name='target_resize_image[]' onclick='image_window(this);' style='cursor:pointer;' title='{$view[file][$num][content]}'>";
			if($query[thumb]) {
				if(!$query[width]) $query[width] = $width;
				if(!$query[height]) $query[height] = "";
				$img = amina_resize_content($img, $query[width], $query[height]);
			} else {
				$img = amina_resize_content($img, $width , "");
			}

			// 크기재입력하기
			if($query[width] && $query[height]) {
				$img = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', 'width="' . $query[width] . '" height="' . $query[height] . '"', $img); 
			} else if($query[width] && !$query[height]) {
				$img = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', 'width="' . $query[width] . '"', $img); 
			} else if(!$query[width] && $query[height]) {
				$img = preg_replace('/width\=(\'|\")?[^\s\'\"]+(\'|\")?/i', 'width="' . $width . '" height="' . $query[height] . '"', $img); 
			}

			return $img;
		}
	}
	
	return;
}

//본문 내용 full 출력..
function amina_contents($board, $list, $width='640') {
	global $g4, $bo_table, $amina;

	$post = array();
	$movie = array();

	$post = wr_amina($list[wr_10]); //글쓰기 옵션
	$movie = wr_movie($list[wr_6]); //유튜브 동영상

	$content = "";
	if($post[img_location] == "insert") { //첨부이미지 본문삽입이라면..
		$content = preg_replace("/{이미지\:([0-9]+)[:]?([^}]*)}/ie", "amina_image_content(\$board, \$list, \$width, '\\1', '\\2')", $list[content]);
	} else {
		$file = "";
		for ($i=0; $i<=count($list[file]); $i++) {
		    if($list[file][$i][view]) {
				$file .= $list[file][$i][view]."<br>\n";
				if($post[img_space] != "1") $file .= "<br>\n";
			}
		}

		if($file && $post[img_location] != "bottom") $content .= "<p align=center>".$file."</p>\n";
		$content .= $list[content];
		if($file && $post[img_location] == "bottom") $content .= "<p align=center>".$file."</p>\n";

		$content = amina_resize_content($content, $width);
	}

	//본문 동영상 변환 - {동영상:주소|width=크기 height=크기 auto=ok} 형식
	$content = preg_replace("/{동영상\:([^}]*)}/ie", "amina_movie_content('\\1')", $content);

	$view_content = "";
	$view_content .= show_movie($movie);
	$view_content .= $content;
	$view_content .= "<!-- 테러 태그 방지용 --></xml></xmp><a href=\"\"></a><a href=''></a>";


	return $view_content;
}

// 텍스만 출력하기
function amina_text($str) {
	global $g4;

	$str = strip_tags($str);
	$str = preg_replace("/{이미지\:([^}]*)}/ie", "", $str); //본문첨부 이미지 제외...
	$str = preg_replace("/{동영상\:([^}]*)}/ie", "", $str); //본문첨부 동영상 제외...
	$str = str_replace("&nbsp;"," ",$str); //공백으로 변환
	$str = preg_replace('/\s\s+/', ' ', $str); //연속된 공백 1개로
	$str = trim($str); //앞뒤 공백 제거

	return $str;
}

// 본문 내용 자르기..
function amina_cut($str, $len, $tail="…") {
	global $g4;

	$str = amina_text($str);

	/*
	if(strtoupper($g4[charset]) == "UTF-8") {
		$charset = "utf-8";
	} else {
		$charset = "CP949"; //euc-kr
	}
	
	//mb_strlen, mb_substr는 PHP 4이상에서는 내장함수에서 지원하지만, 확장모듈로 설치가 되어있어야 사용 가능함.
	$slen = mb_strlen($str,$charset);
	if($slen <= $len) return $str; 

	$str = mb_substr($str,0,$len,$charset);
	$str = $str."".$tail;
	*/

	$str = cut_str($str, $len, $tail);

	return $str;
}

// 별점 구하기
function amina_star($star, $total, $people, $type=''){
	global $g4, $board_skin_path;

	if(!$star) $star = "gold";

	$score = 0;
	if($people > 0) $score = $total / $people;

	$score = round($score,1);
	$point = round($score) * 10;

	switch($type) {
		case 'l'	: $size = "l"; $width = "100"; $height = "25"; break;
		case 'm'	: $size = "m"; $width = "70"; $height = "12"; break;
		case 's'	: $size = "s"; $width = "55"; $height = "10"; break;
		default		: $size = "s"; $width = "55"; $height = "10"; break;
	}

	$alt = number_format($score, 1)."점 / ".number_format($people, 0)."명";
	$star = "<div class='star_{$size}'><div class='mask' style='width:{$point}%'><img src='{$board_skin_path}/img/star/star_{$star}_{$size}.png' width='{$width}' height='{$height}' border=0 title=' {$alt} ' style='cursor:pointer;'></div></div>";

	return $star;
}

// Good 아이콘 출력하기
function amina_star_form($skin, $bo_table, $wr_id){
	global $g4, $amina, $board, $view, $board_skin_path;

    if ($skin)
        $star_form_path = "$board_skin_path/star/$skin";
    else
        $star_form_path = "$board_skin_path/star/basic";

	ob_start();
	include "$star_form_path/star.form.php";
    $view_star = ob_get_contents();
    ob_end_clean();

	return $view_star;
}

// 글내용 SNS 아이콘 출력
function chk_view_sns($bo_table, $sca, $view){
	global $amina;

	$view_sns = "yes";
	if(strstr($view[wr_option], "secret") || $amina[view_sns] != "yes") $view_sns = ""; //비밀글에는 출력하지 않음

	return $view_sns;
}

// 글내용 SNS 아이콘 출력
function chk_cmt_sns($bo_table, $sca, $view){
	global $amina;

	$cmt_sns = "yes";
    if(strstr($view[wr_option], "secret") || $amina[cmt_sns] != "yes") $cmt_sns = ""; //원글이 비밀글에는 출력하지 않음

	return $cmt_sns;
}

// SNS 아이콘 출력하기
function amina_sns($skin_dir, $sns_subj, $lurl, $surl=''){
	global $g4, $config;

    if ($skin_dir)
        $sns_skin_path = "$g4[path]/skin/sns/$skin_dir";
	else
        $sns_skin_path = "$g4[path]/skin/sns/basic";

	if(!$surl) $surl = $lurl;

    $org_url = trim($lurl);
    $sns_url = trim($surl);

    $me2day_url = "http://me2day.net/posts/new?new_post[body]=".urlencode(set_utf8($sns_subj)." - \"$sns_url\":$sns_url");
    //$twitter_url = "http://twitter.com/home?status=".urlencode(set_utf8($view[wr_subject])." - $sns_url");
    $twitter_url = "http://twitter.com/?status=".str_replace("+", " ", urlencode(set_utf8($sns_subj)." - $sns_url"));
	$tw_url = $org_url;
	$tw_txt = $sns_subj;
	$facebook_url = "http://www.facebook.com/share.php?u=".urlencode($org_url);
	$fb_url = urlencode($org_url);
	$yozm_url = "http://yozm.daum.net/api/popup/prePost?sourceid=41&link={$sns_url}&prefix=".urlencode(set_utf8($sns_subj));
    $cy_url = "javascript:window.open('http://csp.cyworld.com/bi/bi_recommend_pop.php?url={$sns_url}', ";
    $cy_url.= "'recom_icon_pop', 'width=400,height=364,scrollbars=no,resizable=no');";
	$google_url = "https://www.google.com/bookmarks/mark?op=add&title=".urlencode(set_utf8($sns_subj))."&bkmk=".$sns_url;
	$naver_url = "http://bookmark.naver.com/post?ns=1&title=".urlencode(set_utf8($sns_subj))."&url=".$sns_url;

    ob_start();
    include "$sns_skin_path/sns.skin.php";
    $view_sns = ob_get_contents();
    ob_end_clean();

	return $view_sns;
}

// Good 아이콘 출력하기
function amina_good($skin, $bo_table, $wr_id){
	global $g4, $board;

    if ($skin)
        $good_skin_path = "$g4[path]/skin/good/$skin";
    else
        $good_skin_path = "$g4[path]/skin/good/basic";

	ob_start();
	include "$g4[bbs_path]/amina.good.php";
    $view_good = ob_get_contents();
    ob_end_clean();

	return $view_good;
}

//그누보드 긴글 주소 만들기
function sns_lurl($bo_table, $wr_id, $opt=''){
	global $g4, $amina;

	$lurl = $amina[gnu_url]."/bbs/board.php?bo_table={$bo_table}&wr_id={$wr_id}";
	if($opt == "yes") $lurl = $amina[site_url]."/".$bo_table."/".$wr_id;

	return $lurl;
}

//그누보드 짧은 주소 만들기
function sns_surl($surl, $opt=''){
	global $g4, $amina;

	if($opt == "yes") $surl = bitly_url($surl);

	return $surl;

}

//Bit.ly 짧은 주소 사용하기
function bitly_url($url){  
	global $g4, $amina;

	$result = "http://api.bit.ly/shorten?version=2.0.1&longUrl=".urlencode($url)."&login=".$amina[bitly_id]."&apiKey=".$amina[bitly_key]."&format=json&history=1";
	$data = file_get_contents_curl($result);
    $data = json_decode($data);
    foreach($data->results as $row) {
		$burl = $row->shortCNAMEUrl;
	}
	return $burl;
}

// 회원사진 불러오기
function mb_photo($login_id, $mb_id, $width='80', $height='80', $no_photo='', $thumb='') {
	global $g4, $bo_table, $board_skin_path;

	$mb_photo = $g4[path]."/data/mb_photo/".$mb_id.".gif";

	if(!$mb_id || !file_exists($mb_photo)) {
		if($no_photo) {
			$mb_photo = "";
			return $mb_photo;
		} else {
			$mb_photo = $board_skin_path."/img/no_photo.gif";
		}
	}

	if($login_id && $login_id == $mb_id) {
		$photo_upload_url = $board_skin_path."/mb_photo.php?bo_table={$bo_table}";
		$onclick = " onclick=\"window.open('{$photo_upload_url}','photo','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no,width=400,height=200,top=20,left=20');\" style='cursor:pointer;' title='회원사진 등록 및 수정하기' ";
	}	

	if($thumb) $mb_photo = thumbnail($mb_photo, $width, $height,false,1,90);
	$mb_photo = "<img src='".$mb_photo."' width='{$width}' height='{$height}' border=0 {$onclick}>";

	return $mb_photo;
}

//회원사진 등록
function mb_photo_upload($mb_id, $del_photo, $_FILES) {
	global $g4;

	//사진 크기
	$photo_w = 80;
	$photo_h = 80;
	$photo_dir = $g4[path]."/data/mb_photo";

	if(!is_dir($photo_dir)) {
        @mkdir($photo_dir, 0707);
        @chmod($photo_dir, 0707);
	}

	// 사진 삭제
	if ($del_photo == "1")
		@unlink($photo_dir."/{$mb_id}.gif");
    
	//사진 업로드
	if (is_uploaded_file($_FILES[mb_icon2][tmp_name])) {
		if (!preg_match("/(\.gif)$/i", $_FILES[mb_icon2][name])) {
			alert($_FILES[mb_icon2][name] . '은(는) gif 파일이 아닙니다.');
		}

		if (preg_match("/(\.gif)$/i", $_FILES[mb_icon2][name])) {
			$dest_path2 = $photo_dir."/{$mb_id}.gif";
			move_uploaded_file($_FILES[mb_icon2][tmp_name], $dest_path2);
			chmod($dest_path2, 0606);
			if(file_exists($dest_path2)) {
				$size = getimagesize($dest_path2);
				// 사진이 80x80이 아니면 이미 업로드 된 아이콘 삭제
				if ($size[0] != $photo_w || $size[1] != $photo_h) {
					@unlink($dest_path2);
					alert('80x80 크기의 사진만 등록이 가능합니다.');
				}
			}
		}
	}
}

//영문 숫자 조합 난수생성
function amina_rand_id($num) {

	if($num > 0) {
		;
	} else {
		$num = 8;
	}

	$temp = str_split('abcdefghijklmnopqrstuvwxyz012345678901234567890123456789'); 
	shuffle($temp); 
	$id = implode('',array_slice($temp,0,$num));

	return $id;
} 

//----------- 배추보드에서 차용 -------------

if(!function_exists("file_get_contents_curl")) {
function file_get_contents_curl($url) {
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_HEADER, 0);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_URL, $url); 
  $data = curl_exec($ch);
  curl_close($ch); 
  return $data;
}}

// euckr -> utf8 
if (!function_exists("set_utf8")) {
function set_utf8($str)
{
    if (!is_utf8($str))
        $str = convert_charset('cp949', 'utf-8', $str);

    $str = trim($str);

    return $str;
}}

// utf8 -> euckr 
if (!function_exists("set_euckr")) {
function set_euckr($str)
{
    if (is_utf8($str))
        $str = convert_charset('utf-8', 'cp949', $str);

    $str = trim($str);

    return $str;
}}

// Charset 을 변환하는 함수 
if (!function_exists("convert_charset")) {
function convert_charset($from_charset, $to_charset, $str) {
    if( function_exists('iconv') )
        return iconv($from_charset, $to_charset, $str);
    elseif( function_exists('mb_convert_encoding') )
        return mb_convert_encoding($str, $to_charset, $from_charset);
    else
        die("Not found 'iconv' or 'mbstring' library in server.");
}}

// 텍스트가 utf-8 인지 검사하는 함수 
if (!function_exists("is_utf8")) {
function is_utf8($string) {

  // From http://w3.org/International/questions/qa-forms-utf-8.html
  return preg_match('%^(?:
        [\x09\x0A\x0D\x20-\x7E]            # ASCII
      | [\xC2-\xDF][\x80-\xBF]            # non-overlong 2-byte
      |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
      | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
      |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
      |  \xF0[\x90-\xBF][\x80-\xBF]{2}    # planes 1-3
      | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
      |  \xF4[\x80-\x8F][\x80-\xBF]{2}    # plane 16
 )*$%xs', $string);
}}

//----------- 최근글 관련 함수 -------------

function amina_get_list($write_row, $board, $skin_path, $subject_len=40) {
    global $g4, $config;
    //global $qstr, $page;

    //$t = get_microtime();

    // 배열전체를 복사
    $list = $write_row;
    unset($write_row);

    //$list['is_notice'] = preg_match("/[^0-9]{0,1}{$list['wr_id']}[\r]{0,1}/",$board['bo_notice']);

    if ($subject_len)
        $list['subject'] = conv_subject($list['wr_subject'], $subject_len, "…");
    else
        $list['subject'] = conv_subject($list['wr_subject'], $board['bo_subject_len'], "…");

    // 목록에서 내용 미리보기 사용한 게시판만 내용을 변환함 (속도 향상) : kkal3(커피)님께서 알려주셨습니다.
    if ($board['bo_use_list_content'])
	{
		$html = 0;
		if (strstr($list['wr_option'], "html1"))
			$html = 1;
		else if (strstr($list['wr_option'], "html2"))
			$html = 2;

        $list['content'] = conv_content($list['wr_content'], $html);
	}

    $list['comment_cnt'] = "";
    if ($list['wr_comment'])
        $list['comment_cnt'] = "($list[wr_comment])";

    // 당일인 경우 시간으로 표시함
    $list['datetime'] = substr($list['wr_datetime'],0,10);
    $list['datetime2'] = $list['wr_datetime'];
    if ($list['datetime'] == $g4['time_ymd'])
        $list['datetime2'] = substr($list['datetime2'],11,5);
    else
        $list['datetime2'] = substr($list['datetime2'],5,5);
    // 4.1
    $list['last'] = substr($list['wr_last'],0,10);
    $list['last2'] = $list['wr_last'];
    if ($list['last'] == $g4['time_ymd'])
        $list['last2'] = substr($list['last2'],11,5);
    else
        $list['last2'] = substr($list['last2'],5,5);

    $list['wr_homepage'] = get_text(addslashes($list['wr_homepage']));

    $tmp_name = get_text(cut_str($list['wr_name'], $config['cf_cut_name'])); // 설정된 자리수 만큼만 이름 출력
    if ($board['bo_use_sideview'])
        $list['name'] = get_sideview($list['mb_id'], $tmp_name, $list['wr_email'], $list['wr_homepage']);
    else
        $list['name'] = "<span class='".($list['mb_id']?'member':'guest')."'>$tmp_name</span>";

    $reply = $list['wr_reply'];

    $list['reply'] = "";
    if (strlen($reply) > 0)
    {
        for ($k=0; $k<strlen($reply); $k++)
            $list['reply'] .= ' &nbsp;&nbsp; ';
    }

    $list['icon_reply'] = "";
    if ($list['reply'])
        $list['icon_reply'] = "<img src='$skin_path/img/icon_reply.gif' align='absmiddle'>";

    $list['icon_link'] = "";
    if ($list['wr_link1'] || $list['wr_link2'])
        $list['icon_link'] = "<img src='$skin_path/img/icon_link.gif' align='absmiddle'>";

    // 분류명 링크
    $list['ca_name_href'] = "$g4[bbs_path]/board.php?bo_table=$board[bo_table]&sca=".urlencode($list['ca_name']);

    $list['href'] = "$g4[bbs_path]/board.php?bo_table=$board[bo_table]&wr_id=$list[wr_id]" . $qstr;
    //$list['href'] = "$g4[bbs_path]/board.php?bo_table=$board[bo_table]&wr_id=$list[wr_id]";
    if ($board['bo_use_comment'])
        $list['comment_href'] = "javascript:win_comment('$g4[bbs_path]/board.php?bo_table=$board[bo_table]&wr_id=$list[wr_id]&cwin=1');";
    else
        $list['comment_href'] = $list['href'];

    $list['icon_new'] = "";
    if ($list['wr_datetime'] >= date("Y-m-d H:i:s", $g4['server_time'] - ($board['bo_new'] * 3600)))
        $list['icon_new'] = "<img src='$skin_path/img/icon_new.gif' align='absmiddle'>";

    $list['icon_hot'] = "";
    if ($list['wr_hit'] >= $board['bo_hot'])
        $list['icon_hot'] = "<img src='$skin_path/img/icon_hot.gif' align='absmiddle'>";

    $list['icon_secret'] = "";
    if (strstr($list['wr_option'], "secret"))
        $list['icon_secret'] = "<img src='$skin_path/img/icon_secret.gif' align='absmiddle'>";

    // 링크
    for ($i=1; $i<=$g4['link_count']; $i++)
    {
        $list['link'][$i] = set_http(get_text($list["wr_link{$i}"]));
        $list['link_href'][$i] = "$g4[bbs_path]/link.php?bo_table=$board[bo_table]&wr_id=$list[wr_id]&no=$i" . $qstr;
        $list['link_hit'][$i] = (int)$list["wr_link{$i}_hit"];
    }

    // 가변 파일
    $list['file'] = get_file($board['bo_table'], $list['wr_id']);

    if ($list['file']['count'])
        $list['icon_file'] = "<img src='$skin_path/img/icon_file.gif' align='absmiddle'>";

    return $list;
}

function amina_sort($records, $field, $reverse=false) {
     $hash = array();
    
     foreach($records as $record) {
         $hash[$record[$field]] = $record;
     }
    
     ($reverse)? krsort($hash) : ksort($hash);
    
     $records = array();
    
     foreach($hash as $record) {
         $records []= $record;
     }
    
     return $records;
}
 
function latest_amina($skin_dir="", $bo_table="", $rows=10, $subject_len=40, $options="", $tab_list="", $sql_opt="") {
    global $g4, $config;

    $list = array();
	$tab = array();
	$opt = array();

	//탭 아이디 설정
	$tab_id = $bo_table;

	//탭이 있는지 확인
	$tab_num = count($tab_list);

	//탭이 1개이상일 경우에는 jquery용으로
	if($tab_num > 1) { 
		$tab_opt = "&org=".urlencode("skin_dir={$skin_dir} rows={$rows} subject_len={$subject_len}")."&opt=".urlencode($options);
		for ($i=0; $i < $tab_num; $i++) {
			if($i == "0") {
				$tab[$i][query] = "#";
			} else {
				$tab[$i][query] = $g4[path]."/latest.php?tab=".urlencode($tab_list[$i])."".$tab_opt;
			}

			$tmp = amina_query($tab_list[$i]);
			$tab[$i][title] = $tmp[title];

			$arr_board = explode(",", trim($tmp[bo_list]));

			// 타이틀 링크설정
			if($tmp[type] == "newgul" || $tmp[type] == "newcmtgul") {
				$tab[$i][href] = $g4[bbs_path]."/new.php?view=w";
			} else if($tmp[type] == "newcmt") {
				$tab[$i][href] = $g4[bbs_path]."/new.php?view=c";
			} else {
				if(count($arr_board) > 1) {
					$tab[$i][href] = "#";
				} else {
					$tab[$i][href] = $g4[bbs_path]."/board.php?bo_table=".$tmp[bo_list]."&sca=".urlencode($tmp[ca_name]);
				}
			}
		}	

		// 첫번째 탭 정리하기..
		$tmp2 = amina_query($options);
		$tmp2[bo_list] = $tmp2[title] = $tmp2[ca_name] = "";

		$tmp1 = amina_query($tab_list[0]);

		$opt = $tmp1 + $tmp2; //두 배열키로 합치기

		if($opt[skin_dir]) $skin_dir = $opt[skin_dir];
		if($opt[rows]) $rows = $opt[rows];
		if($opt[subject_len]) $subject_len = $opt[subject_len];

	} else {
		//탭값 및 옵션을 변수값으로 변환
		if($tab_list) {
			$tmp2 = amina_query($options);
			$tmp2[bo_list] = $tmp2[title] = $tmp2[ca_name] = "";

			$tmp1 = amina_query($tab_list);

			$opt = $tmp1 + $tmp2; //두 배열키로 합치기

			if($opt[skin_dir]) $skin_dir = $opt[skin_dir];
			if($opt[rows]) $rows = $opt[rows];
			if($opt[subject_len]) $subject_len = $opt[subject_len];
		} else {
			$opt = amina_query($options);
		}
	}

	//스킨디렉토리
	if(file_exists($g4[path]."/skin/latest/".$skin_dir."/latest.skin.php")) {
		$latest_skin_path = $g4[path]."/skin/latest/".$skin_dir;
	} else {
        $latest_skin_path = $g4[path]."/skin/latest/basic";
	}

	// 탭 초기번호..
	$z = 0;

	// 새글, 새댓글 등
	if($opt[type] == "newgul" || $opt[type] == "newcmt" || $opt[type] == "newcmtgul") {

		// 포함 게시판 설정
		if($opt[bo_include]) {
			$new_sql = "";
			$bo_in = explode(",", trim($opt[bo_include]));
			for ($k=0; $k < count($bo_in); $k++) {
				if (trim($bo_in[$k])=='') continue;
				$new_sql .= " bo_table = '$bo_in[$k]' or ";
			}
			if($new_sql) $new_sql = " and (".substr($new_sql,0,-3).")";
		} 

		// 제외 게시판 설정
		if($opt[bo_exclude]) {
			$new_sql = "";
			$bo_ex = explode(",", trim($opt[bo_exclude]));
			for ($k=0; $k < count($bo_ex); $k++) {
				if (trim($bo_ex[$k])=='') continue;
				$new_sql .= " and bo_table != '$bo_ex[$k]' ";
			}
		} 

		// 추출 및 정리
		if($opt[type] == "newcmt") {
			$tab[$z][title] = "새로 달린 댓글";
			$tab[$z][href] = $g4[bbs_path]."/new.php?view=c";

			$result = sql_query(" select * from $g4[board_new_table] where wr_id <> wr_parent $new_sql order by bn_id desc limit 0, $rows ");
			for ($i=0; $row=sql_fetch_array($result); $i++) {
			    $board = sql_fetch(" select * from $g4[board_table] where bo_table = '$row[bo_table]' ");
				$row1 = sql_fetch(" select wr_option from {$g4['write_prefix']}{$row[bo_table]} where wr_id = '$row[wr_parent]' "); //원글 글옵션
				$row2 = sql_fetch(" select * from {$g4['write_prefix']}{$row[bo_table]} where wr_id = '$row[wr_id]' "); //댓글 정보 불러오기..
				// 댓글이라 글제목을 글내용으로 대체
				if(strstr($row1[wr_option], "secret") || strstr($row2[wr_option], "secret")) {
					$row2[wr_subject] = "비밀 댓글입니다.";
				} else {
					$row2[wr_subject] = $row2[wr_content];
				}
				$row2[wr_comment] = 0; //댓글수 0으로
				$list[$i] = amina_get_list($row2, $board, $latest_skin_path, $subject_len);
			}
		} else {
			if($opt[type] == "newcmtgul") {
				$tab[$z][title] = "새로 댓글달린 글";
				$tab[$z][href] = $g4[bbs_path]."/new.php?view=c";

				$result = sql_query(" select bo_table, wr_parent from $g4[board_new_table] where wr_id <> wr_parent $new_sql group by bo_table, wr_parent order by bn_id desc limit 0, $rows ");
			} else {
				$tab[$z][title] = "새로 등록된 글";
				$tab[$z][href] = $g4[bbs_path]."/new.php?view=w";

				$result = sql_query(" select bo_table, wr_parent from $g4[board_new_table] where wr_id = wr_parent $new_sql order by bn_id desc limit 0, $rows ");
			}

			for ($i=0; $row=sql_fetch_array($result); $i++) {
			    $board = sql_fetch(" select * from $g4[board_table] where bo_table = '$row[bo_table]' ");
				$row1 = sql_fetch(" select * from {$g4['write_prefix']}{$row[bo_table]} where wr_id = '$row[wr_parent]' "); //글 정보 불러오기..
				$list[$i] = amina_get_list($row1, $board, $latest_skin_path, $subject_len);
			}
		}

	} else {

		// sql 추가조건 결정
		if($sql_opt) $sql_opt = " and ".$sql_opt." ";

		// 추출기간 설정
		if($opt[term]) {
			$nowYmd = date(Ymd); # 시작시간을 구합니다. 
			$time = time(); 
			$startYmd = date("Ymd",strtotime("-".$opt[term]." day", $time)); 

			//비밀글 제외함
			$sql_term = " and wr_option not like '%secret%' and date_format(wr_datetime, '%Y%m%d') between '$startYmd' and '$nowYmd' ";
		}

		// 정렬방법
		switch($opt[order]) {
			case 'hit'			: $order_by = " wr_hit desc "; break;
			case 'good'			: $order_by = " wr_good desc, wr_hit desc "; break;
			case 'nogood'		: $order_by = " wr_nogood desc, wr_hit desc "; break;
			case 'cmt'			: $order_by = " wr_comment desc, wr_hit desc "; break;
			case 'date'			: $order_by = " wr_datetime desc "; break;
			case 'rand'			: $order_by = " rand() "; break;
			default				: $order_by = " wr_num "; break;
		}

		// 복수게시판에서 추출
		$arr_bo = explode(",", trim($opt[bo_list]));
		$bo_num = count($arr_bo);

		// 복수 게시판일 경우
		if($bo_num > 1 && $opt[term]) {
			$tmp = "";
			for($i=0; $i < $bo_num; $i++){ 
				$tmp_write_table = $g4['write_prefix'] . $arr_bo[$i];
				$tmp .= " select '{$arr_bo[$i]}' as bo_table, wr_id, wr_subject, wr_content, wr_comment, wr_hit, wr_good, wr_nogood, wr_datetime, wr_last from $tmp_write_table where wr_is_comment=0 $sql_opt $sql_term UNION ALL ";
			}

			if($tmp) $tmp = "select * from ( ".substr($tmp,0,-10).") as a order by $order_by limit 0, $rows";
			$result = sql_query($tmp);
			for ($i=0; $row=sql_fetch_array($result); $i++){ 
				$sql = "select * from {$g4['board_table']} where bo_table='$row[bo_table]'";
				$board = sql_fetch($sql);
				$list[$i] = amina_get_list($row, $board, $latest_skin_path, $subject_len);
				$list[$i]['bo_table'] = $board['bo_table'];
			} 

			$tab[$z][href] = "#";
			$tab[$z][title] = "제목입력";

		} else {

			if($opt[bo_list]) list($bo_table) = explode(",", trim($opt[bo_list]));

			$tab[$z][href] = $g4[bbs_path]."/board.php?bo_table=".$bo_table."&sca=".urlencode($opt[ca_name]);

			//일반 게시물 추출
		    $sql = " select * from $g4[board_table] where bo_table = '$bo_table' ";
		    $board = sql_fetch($sql);

			if(!$board) {
				$tab[$z][title] = "미등록 게시판";
			} else {
			    $tmp_write_table = $g4['write_prefix'] . $bo_table; // 게시판 테이블 전체이름

				if($opt[ca_name]) $sql_ca = " and ca_name = '$opt[ca_name]' ";

				$i = 0;
				if($opt[type] == "notice" || $opt[type] == "nonotice") {
					$notice_sql = "";
					$arr_notice = explode("\n", trim($board[bo_notice]));
					if($opt[type] == "notice") {
						for ($k=0; $k<count($arr_notice); $k++) {
							if (trim($arr_notice[$k])=='') continue;
							$row = sql_fetch(" select * from $tmp_write_table where wr_id = '$arr_notice[$k]' $sql_ca $sql_opt ");
						    if (!$row[wr_id]) continue;
							$list[$i] = amina_get_list($row, $board, $latest_skin_path, $subject_len);
							$list[$i][is_notice] = true;
							if($opt[ca_name]) $list[$i][href] = $list[$i][href]."&sca=".urlencode($opt[ca_name]);
							$notice_sql .= " and wr_id != '$arr_notice[$k]' "; 
							$i++;
						}

						$rows = $rows - $i;
					} else { //공지는 출력안함
						for ($k=0; $k<count($arr_notice); $k++) {
							if (trim($arr_notice[$k])=='') continue;
							$notice_sql .= " and wr_id != '$arr_notice[$k]' "; 
						}
					}
					$sql = " select * from $tmp_write_table where wr_is_comment = 0 $sql_ca $notice_sql $sql_opt $sql_term order by $order_by limit 0, $rows ";
				} else {
					$sql = " select * from $tmp_write_table where wr_is_comment = 0 $sql_ca $sql_opt $sql_term order by $order_by limit 0, $rows ";
				}
			}

			$result = sql_query($sql);
			for ($i=$i; $row = sql_fetch_array($result); $i++) { 
				$list[$i] = amina_get_list($row, $board, $latest_skin_path, $subject_len);
				if($opt[ca_name]) $list[$i][href] = $list[$i][href]."&sca=".urlencode($opt[ca_name]);
			}

			$tab[$z][title] = $board[bo_subject];
		}
	}

	if($opt[title]) $tab[$z][title] = $opt[title];

	$latest_amina = "ok";

    ob_start();
    include "$latest_skin_path/latest.skin.php";
    $content = ob_get_contents();
    ob_end_clean();

    return $content;
} 

function amina_latest($skin_dir="", $bo_table="", $rows=10, $subject_len=40, $options="", $type_arr="", $ca_name="", $bo_title="", $sql_opt="") {
    global $g4, $thema_skin_path;

	if(file_exists("{$g4[path]}/skin/latest/{$skin_dir}/latest.skin.php")) {
			$latest_skin_path = "$g4[path]/skin/latest/$skin_dir";
	} else {
		if(file_exists("{$thema_skin_path}/latest/{$skin_dir}/latest.skin.php")) {
			$latest_skin_path = "$thema_skin_path/latest/$skin_dir";		
		} else {
	        $latest_skin_path = "$g4[path]/skin/latest/basic";
		}
	}

    $list = array();

	list($type[name], $type[opt], $type[bo_list]) = explode("|", trim($type_arr));

	if($type[name] == "newgul" || $type[name] == "newcmt" || $type[name] == "newcmtgul") {

		// 새글에서 추출
		$new_sql = "";
		$arr_board = explode(",", trim($type[bo_list]));
		$arr_num = count($arr_board);

		if($type[opt] == "exclude") {
			for ($k=0; $k < $arr_num; $k++) {
				if (trim($arr_board[$k])=='') continue;
				$new_sql .= " and bo_table != '$arr_board[$k]' ";
			}
		} else if($type[opt] == "include") {
			$tmp_sql = "";
			for ($k=0; $k < $arr_num; $k++) {
				if (trim($arr_board[$k])=='') continue;
				$tmp_sql .= " bo_table = '$arr_board[$k]' or ";
			}

			if($tmp_sql) {
				$tmp_sql .= "//END";
				list($tmp2_sql) = explode(" or //END", trim($tmp_sql));
				$new_sql .= " and (".$tmp2_sql.") ";
			}
		}
		
		if($type[name] == "newgul") {
			$new_type = " wr_id = wr_parent ";
			$bo_href = $g4[bbs_path]."/new.php?view=w";
		} else if($type[name] == "newcmt" || $type[name] == "newcmtgul") {
			$new_type = " wr_id <> wr_parent ";	
			$bo_href = $g4[bbs_path]."/new.php?view=c";
		}

		// 추출 및 정리
		if($type[name] == "newcmt") {
			$result = sql_query(" select * from $g4[board_new_table] where $new_type $new_sql order by bn_datetime desc limit 0, $rows ");
			for ($i=0; $row=sql_fetch_array($result); $i++) {
			    $board = sql_fetch(" select * from $g4[board_table] where bo_table = '$row[bo_table]' ");
				$row1 = sql_fetch(" select wr_option from {$g4['write_prefix']}{$row[bo_table]} where wr_id = '$row[wr_parent]' "); //원글 글옵션
				$row2 = sql_fetch(" select * from {$g4['write_prefix']}{$row[bo_table]} where wr_id = '$row[wr_id]' "); //댓글 정보 불러오기..
				if(strstr($row1[wr_option], "secret") || strstr($row2[wr_option], "secret")) {
					$row2[wr_subject] = "비밀 댓글입니다.";
				} else {
					$row2[wr_subject] = amina_cut($row2[wr_content],100); //댓글이라 글제목을 글내용으로 대체
				}
				$row2[wr_comment] = 0; //댓글수 0으로
				$list[$i] = amina_get_list($row2, $board, $latest_skin_path, $subject_len);
			}
		} else {
			$result = sql_query(" select distinct bo_table, wr_parent from $g4[board_new_table] where $new_type $new_sql order by bn_datetime desc limit 0, $rows ");
			for ($i=0; $row=sql_fetch_array($result); $i++) {
			    $board = sql_fetch(" select * from $g4[board_table] where bo_table = '$row[bo_table]' ");
				$row1 = sql_fetch(" select bn_datetime from $g4[board_new_table] where bo_table = '$row[bo_table]' and wr_parent = '$row[wr_parent]' "); //새글 시간
				$row2 = sql_fetch(" select * from {$g4['write_prefix']}{$row[bo_table]} where wr_id = '$row[wr_parent]' "); //글 정보 불러오기..
				$row2[wr_datetime] = $row1[bn_datetime];
				$list[$i] = amina_get_list($row2, $board, $latest_skin_path, $subject_len);
			}
		}
	
	} else {

		$bo_href = $g4[bbs_path]."/board.php?bo_table=".$bo_table;

		//일반 게시물 추출
	    $sql = " select * from $g4[board_table] where bo_table = '$bo_table' ";
	    $board = sql_fetch($sql);

		if(!$board) {
			$bo_title = "추출 게시판 아이디 수정";
		} else {
		    $tmp_write_table = $g4['write_prefix'] . $bo_table; // 게시판 테이블 전체이름

			if($ca_name) {
				$sql_ca = " and ca_name = '$ca_name' ";
				$bo_href .= "&sca=".urlencode($ca_name);
			}
			$i = 0;
			$notice_sql = "";
			$arr_notice = explode("\n", trim($board[bo_notice]));
			if($type[name] == "notice" || $type[name] == "notice_rand") {
				for ($k=0; $k<count($arr_notice); $k++) {
					if (trim($arr_notice[$k])=='') continue;

					$row = sql_fetch(" select * from $tmp_write_table where wr_id = '$arr_notice[$k]' $sql_ca $sql_opt ");

				    if (!$row[wr_id]) continue;

					$list[$i] = amina_get_list($row, $board, $latest_skin_path, $subject_len);
					$list[$i][is_notice] = true;
					if($ca_name) $list[$i][href] = $list[$i][href]."&sca=".urlencode($ca_name);
					$notice_sql .= " and wr_id != '$arr_notice[$k]' "; //[2008-02-03] 추가
				    $i++;
				}

				$rows = $rows - $i;
			} else { //공지는 출력안함
				for ($k=0; $k<count($arr_notice); $k++) {
					if (trim($arr_notice[$k])=='') continue;
					$notice_sql .= " and wr_id != '$arr_notice[$k]' "; //[2008-02-03] 추가
				}
			}

			$order_by = "wr_num";

			if($type[name] == "rand" || $type[name] == "notice_rand") $order_by = "rand()";

		    $sql = " select * from $tmp_write_table where wr_is_comment = 0 $sql_ca $notice_sql $sql_opt order by $order_by limit 0, $rows ";
			$result = sql_query($sql);
			for ($i=$i; $row = sql_fetch_array($result); $i++) { 
				$list[$i] = amina_get_list($row, $board, $latest_skin_path, $subject_len);
				if($ca_name) $list[$i][href] = $list[$i][href]."&sca=".urlencode($ca_name);
			}
		}
	}

    ob_start();
    include "$latest_skin_path/latest.skin.php";
    $content = ob_get_contents();
    ob_end_clean();

    return $content;
} 

// 아미나 외부로그인
function amina_outlogin($skin_dir="") {
    global $g4, $config, $member, $urlencode, $is_admin, $amina, $ashop, $thema_skin_path;

    $nick  = cut_str($member['mb_nick'], $config['cf_cut_name']);
    $point = number_format($member['mb_point']);

	if(file_exists("{$g4[path]}/skin/outlogin/{$skin_dir}/outlogin.skin.1.php")) {
	    $outlogin_skin_path = "$g4[path]/skin/outlogin/$skin_dir";
	} else {
		if(file_exists("{$thema_skin_path}/outlogin/outlogin.skin.1.php")) {
		    $outlogin_skin_path = "$thema_skin_path/outlogin";
		} else {
		    $outlogin_skin_path = "$g4[path]/skin/outlogin/basic";
		}
	}

    // 읽지 않은 쪽지가 있다면
    if ($member['mb_id']) {
        $sql = " select count(*) as cnt from {$g4['memo_table']} where me_recv_mb_id = '{$member['mb_id']}' and me_read_datetime = '0000-00-00 00:00:00' ";
        $row = sql_fetch($sql);
        $memo_not_read = $row['cnt'];

        $is_auth = false;
        $sql = " select count(*) as cnt from $g4[auth_table] where mb_id = '$member[mb_id]' ";
        $row = sql_fetch($sql);
        if ($row['cnt']) 
            $is_auth = true;
    }

    ob_start();
    if ($member['mb_id'])
        include_once ("$outlogin_skin_path/outlogin.skin.2.php");
    else // 로그인 전이라면
        include_once ("$outlogin_skin_path/outlogin.skin.1.php");
    $content = ob_get_contents();
    ob_end_clean();

    return $content;
}

// LNB 출력하기
function amina_lnb($skin="basic", $css="basic", $width="100%"){
	global $g4, $config, $member, $amina, $is_admin, $si_auth, $urlencode;

    $lnb_skin_path = "$g4[path]/skin/lnb/$skin";

	ob_start();
	include "$lnb_skin_path/lnb.skin.php";
    $view_lnb = ob_get_contents();
    ob_end_clean();

	return $view_lnb;
}

//새글 목록 출력
function new_post($update='1', $bo_table='') {
	global $g4;

	$chk_date = date("Y-m-d H:i:s", $g4['server_time'] - ($update * 24 * 3600));
	if($bo_table) {
	    $tmp_write_table = $g4['write_prefix'] . $bo_table; // 게시판 테이블 전체이름
	    $result = sql_query(" select distinct ca_name from $tmp_write_table where wr_datetime >= '$chk_date' and wr_is_comment = 0 ", FALSE);
	} else {
		$result = sql_query(" select distinct bo_table from $g4[board_new_table] where bn_datetime >= '$chk_date' and wr_id = wr_parent ", FALSE); //새글 : 댓글은 wr_id <> wr_parent
	}

	for ($i=0; $row=sql_fetch_array($result); $i++) {
		$list[$i] = $row;
	}

	return $list;
}

//사이트 새글 아이콘
function new_icon($bo_list, $list) {
	global $g4, $thema_skin_path;

	$arr_bo = explode("|", trim($bo_list));

	$up_icon = " <img src='{$thema_skin_path}/img/icon_new.gif' border=0 align=absmiddle>";

	for ($i=0; $i<count($list); $i++) { 
		for ($j=0; $j<count($arr_bo); $j++) {
			if ($list[$i][bo_table] == $arr_bo[$j] || $list[$i][ca_name] == $arr_bo[$j]) return $up_icon;
		}
	}

	$up_icon = "";

	return $up_icon;
}

//사이트 새글 아이콘
function new_menu($bo_list, $list) {
	global $g4;

	$arr_bo = explode("|", trim($bo_list));

	$new_icon = "new";

	for ($i=0; $i<count($list); $i++) { 
		for ($j=0; $j<count($arr_bo); $j++) {
			if ($list[$i][bo_table] == $arr_bo[$j] || $list[$i][ca_name] == $arr_bo[$j]) return $new_icon;
		}
	}

	$new_icon = "old";

	return $new_icon;
}

//선택 메뉴 아이콘
function sel_menu($bo_list='', $page_list='') {
	global $bo_table, $page_id;

	$sel_icon = " class=on ";

	if($bo_list) {
		$chk_bo = explode("|", trim($bo_list));
		for ($i=0; $i<count($chk_bo); $i++) { 
			if ($bo_table == $chk_bo[$i]) return $sel_icon;
		}
	}

	if($page_list) {
		$chk_page = explode("|", trim($page_list));
		for ($i=0; $i<count($chk_page); $i++) { 
			if ($page_id == $chk_page[$i]) return $sel_icon;
		}
	}

	$sel_icon = "";

	return $sel_icon;

}

//----------- AMINA BBS 관련 설정 -------------

function bo_amina1($bo_amina) { //bo_amina1 설정값

	$amina = array();

	list($amina[use_star], $amina[star_color], $amina[view_photo], $amina[view_nophoto], $amina[cmt_photo], $amina[cmt_nophoto], $amina[view_sns], $amina[cmt_sns], $amina[limit_cmt], $amina[limit_date], $amina[close_cmt], $amina[set_num], $amina[cate_w], $amina[cate_hide], $amina[photo_w], $amina[photo_show], $amina[name_w], $amina[name_align], $amina[nameless_gul], $amina[nameless_cmt], $amina[nameless_name], $amina[nameless_num]) = explode("|", trim($bo_amina));

	return $amina;
}

function bo_amina2($bo_amina) { //bo_amina2 설정값

	$amina = array();

	list($amina[cate], $amina[list_skin], $amina[img_w], $amina[img_h], $amina[list_mod], $amina[subj_len], $amina[cont_len], $amina[view_skin], $amina[cmt_skin], $amina[write_skin], $amina[cate_skin], $amina[head_skin], $amina[btn_skin], $amina[paging_skin], $amina[search_skin], $amina[sign_skin]) = explode("|", trim($bo_amina));

	return $amina;
}

function amina_set($board, $sca='') {

	//기본설정
	$basic = bo_amina1($board[bo_amina1]);

	//출력설정
	$set = explode("[]", trim($board[bo_amina2]));

	if($sca && count($set) > 1) {
		for($i=1; $i<count($set); $i++) {
			$tmp[$i] = bo_amina2($set[$i]);
			if($sca == trim($tmp[$i][cate])) {
				$amina = array_merge($basic, $tmp[$i]); 
				return $amina;
			}
		}
	}

	$tmp = bo_amina2($set[0]);
	$amina = array_merge($basic, $tmp); 

	return $amina;
}

// AMINA BBS 설정값 

$amina = array();

if($board[bo_skin] == "amina" || $board[bo_amina1]) $amina = amina_set($board, $sca);

@include_once($g4[path]."/amina.cfg.php");

if($board[bo_skin] == "amina" || $board[bo_amina1]) { 
	if(!$amina[list_skin]) $amina[list_skin] = "basic";
	if(!$amina[view_skin]) $amina[view_skin] = "basic";
	if(!$amina[cmt_skin]) $amina[cmt_skin] = "basic";
	if(!$amina[write_skin]) $amina[write_skin] = "basic";
	if(!$amina[cate_skin]) $amina[cate_skin] = "basic";
	if(!$amina[head_skin]) $amina[head_skin] = "basic";
	if(!$amina[btn_skin]) $amina[btn_skin] = "basic";
	if(!$amina[paging_skin]) $amina[paging_skin] = "basic";
	if(!$amina[search_skin]) $amina[search_skin] = "basic";
	if(!$amina[sign_skin]) $amina[sign_skin] = "basic";

	//스킨 주소
	$list_skin_path = $board_skin_path."/list/".$amina[list_skin];
	$view_skin_path = $board_skin_path."/view/".$amina[view_skin];
	$cmt_skin_path = $board_skin_path."/cmt/".$amina[cmt_skin];
	$write_skin_path = $board_skin_path."/write/".$amina[write_skin];
	$cate_skin_path = $board_skin_path."/cate/".$amina[cate_skin];
	$head_skin_path = $board_skin_path."/head/".$amina[head_skin];
	$btn_skin_path = $board_skin_path."/btn/".$amina[btn_skin];
	$paging_skin_path = $board_skin_path."/paging/".$amina[paging_skin];
	$search_skin_path = $board_skin_path."/search/".$amina[search_skin];
	$sign_skin_path = $board_skin_path."/sign/".$amina[sign_skin];
}

//링크 확장하기 : $frame_opt & $qstr 확장
$frame_opt = "";

if($frame) {
	$frame_opt .= "&frame=".$frame;
	$qstr .= "&frame=".$frame;
}

if($bo_it) {
	$frame_opt .= "&bo_it=".$bo_it;
	$qstr .= "&bo_it=".$bo_it;
}

?>
