<?
if (!defined("_GNUBOARD_")) exit;

//-- 지음빌더에서 사용하는 함수                                                                --//
//-- 본 라이브러리는 그누보드4를 기반하는 것으로 타 프레임워크에서 정상 작동하지 않습니다.     --//
//-- zm.lib.common.php를 지음빌더가 아닌 다른 프로그램에 자유롭게 사용 할 수 있습니다.         --//
//-- 단, 파일명과 함수명은 바꿀 수 없습니다.                                                   --//
//-- 2012. 03. 06                                                                              --//

/* -------------------------------- */
/* - 범용 활용 함수 2012 ziumsoft - */
/* -------------------------------- */

//-- 에러 메시지 출력 -----------------------------------------------------------------------------
function zm_errmsg($msg) {
	echo "<script language='javascript'>alert('$msg'); history.back();</script>";
	exit;
}

//-- 경고 메시지 출력 -----------------------------------------------------------------------------
function zm_artmsg($msg) {
	echo "<script language='javascript'>zm_alert('$msg');</script>";
	//echo "<script language='javascript'>alert('$msg');</script>";
}

//-- 숫자 앞에 0붙이기. $n앞에 0을 붙여 #$no만큼 자리수를 맞춘다. 날짜 등에 사용 ------------------
function zm_paste0($n, $no=2) {
	$tmpno		= "";
	for($i = 0; $i < $no-strlen($n); $i++) $tmpno .= "0";

	return $tmpno.$n;
}

//-- 페이지 이동 ----------------------------------------------------------------------------------
function zm_gourl($url) {
	if(!$url) zm_errmsg("페이지 이름이 없습니다.");
	echo "<script language='javascript'>document.location.href='$url'</script>";
	exit;
}

//-- 이미지 업로드 --------------------------------------------------------------------------------
/*	zm_imgupload(원본 파일명, 서버 임시 파일명, 업로드 경로, #워터마크, #워터마크 위치, #워터마크 투명도, #썸네일 크기 WxH, 최대가로 폭)
	없으면 썸네일은 생성하지 않는다. 썸네일은 $uppath/thumb에 생성한다.
	$watermark : 워터마크로 사용할 이미지 경로.	
	$wmposition : 워터마크 위치 1=상좌, 2=상중, 3=상우, 4=중좌, 5=중중, 6=중우, 7=하좌, 8=하중, 9=하우
	$submbsize : 썸네일 크기는 "100x100"형식으로 x는 알바벳 소문자 x로 한다. 각각 가로, 세로 크기이며 10px 이상이여야 합니다. 0x0이면 썸네일 생성 X
	$limitsize : 가로 제한 폭 ex)600일 때 이미지 폭이 600이 넘으면 폭을 600으로 축소. 세로는 비율로 맞춰 크기 조절

 
	return 메시지 배열 : [msg]="결과 메시지", [result]=결과(1:성공, 0실패), [savename]=저장 된 파일명 
*/
function zm_imgupload($ofile, $tfile, $uppath, $watermark="", $wmposition="0", $wmopacity="60", $thumbsize="0x0", $limitsize="0") {
	global $g4, $zmb;

	//-- 함수 호출 시 null값이 넘어 올 때를 대비
	if(!$wmposition)	$wmposition	= "5";
	if(!$wmopacity)		$wmopacity	= "60";
	if(!$thumbsize)		$thumbsize	= "0x0";
	if(!$limitsize)		$limitsize	= "0";

	$result		= array();
	$filexec	= "";

	if(substr($uppath, strlen($uppath)-1, 1) == "/") $uppath = substr($uppath, 0, strlen($uppath)-1);
	if(substr($watermark, 0, 1) == "/") {
		$result[result]	= 0;
		$result[msg]	= $watermark . " : 워터마크 이미지의 경로를 절대경로로 할 수 없습니다.";
		return $result;
	}

	//-- GD 버젼
	$tmpgd		= gd_info(); 
	$gdver		= substr(preg_replace("/[^0-9]/", "", $tmpgd['GD Version']), 0, 1); 
	if($gdver < 2) {
		$result[result]	= 0;
		$result[msg]	= $tmpgd['GD Version'] . " : GD 라이브러리 버전이 너무 낮습니다.";
		return $result;
	}

	//-- 이미지 체크
	$fileinfo		= @getimagesize($tfile);
	$filetype		= strtolower($fileinfo[mime]);
	if($filetype == "image/gif")		
		$fileexec = "gif";
	elseif(($filetype == "image/jpg") || ($filetype == "image/jpeg"))	
		$fileexec = "jpg";
	elseif($filetype == "image/png")	
		$fileexec = "png";
	else {
		$result[result]	= 0;
		$result[msg]	= "이미지는 gif, jpg, png만 사용 가능 합니다.";
		return $result;
	}

	//-- 워터마크 이미지 체크
	if($watermark) {
		$imgwater		= @getimagesize($watermark);
		$watertype		= strtolower($imgwater[mime]);
		if(($watertype != "image/gif") && ($watertype != "image/jpg") && ($watertype != "image/jpeg") && ($watertype != "image/png")) {
			$result[result]	= 0;
			$result[msg]	= $watermark . " : 워터마크 이미지는 gif, jpg, png만 사용 가능 합니다.";
			return $result;
		}
	}

	//-- 업로드 경로 체크
	if(!file_exists($uppath)) {
		$result[result]	= 0;
		$result[msg]	= $uppath . " : 없는 경로입니다.";
		return $result;
	}

	//-- 업로드 하려는 디렉토리에 index파일이 없으면 생성
	if(!file_exists($uppath."/index.php")){
		fclose(fopen($uppath."/index.php", "w"));
		@chmod($uppath."/index.php", 0606);
	}

	//-- 파일 업로드
	$savename	= md5($ofile.time()) . "." . $fileexec;
	$savepath	= $uppath . "/" . $savename;
	$upres		= move_uploaded_file($tfile, $savepath);
	@chmod($savepath, 0606);

	//-- 사이즈 처리
	if($upres) {
		$new_w		= $fileinfo[0];
		$new_h		= $fileinfo[1];

		//-- 가로 폭이 지정 됐을 때
		if($limitsize > 0) {
			$ratio_s	=  $limitsize / $fileinfo[0];
			$new_w		= $limitsize;
			$new_h		= round($fileinfo[1] * $ratio_s);

			//-- 이미지를 축소한다.(원본 이미지 이름, 폭, 높이, 1=축소 0=썸네일)
			zm_makethumb($savepath, $new_w, $new_h, 1);
		}
		
		//-- 썸네일 크기가 있으면 생성. thumb 디렉토리 체크
		$tmp		= explode("x", $thumbsize);
		if(($tmp[0] > 10) && ($tmp[1] > 10)) {
			zm_makethumb($savepath, $tmp[0], $tmp[1]);
		}
	}else{
		$result[result]	= 0;
		$result[msg]	= "이미지 업로드 오류입니다.";
		return $result;
	}

	//-- 파일에 워터마크 생성
	if(file_exists($watermark)) {
		//-- 이미지 폭이 워터마크 보다 작으면 워터마크 생성하지 않음.
		if($fileinfo[0] >= $imgwater[0])
			zm_makewatermark($savepath, $watermark, $wmposition, $wmopacity);
	}

	$result[result]		= 1;
	$result[msg]		= "이미지를 업로드 했습니다.";
	$result[savename]	= $savename;			//-- 업로드 된 이미지 이름
	return $result;
}

//-- 이미지 축소(썸네일 생성). zm_makethumb(원본이미지 이름, 가로 크기, 세로 크기, #축소or썸네일)
//-- $thumb : 1=이미지 크기 변경. null or 0=썸네일 생성
//-- 썸네일은 원본이미지의 하위 디렉토리 /thumb에 같은 파일명으로 생성
function zm_makethumb($ofile, $size_w, $size_h, $thumb=0) {
	global $g4, $zmb;
	
	$uppath		= "";
	$ofilename	= "";
	$tmp		= explode("/", $ofile);
	for($i = 0; $i < count($tmp)-1; $i++) $uppath .= $tmp[$i] . "/";
	$ofilename	= $tmp[count($tmp)-1];			//-- 원본 파일 이름

	if(substr($uppath, strlen($uppath)-1, 1) == "/") $uppath = substr($uppath, 0, strlen($uppath)-1);

	$result		= array();
	if(substr($ofile, 0, 1) == "/") {
		$result[result]	= 0;
		$result[msg]	= $ofile . " : 원본 이미지의 경로는 절대경로로 할 수 없습니다.";
		return $result;
	}
	if(!file_exists($ofile)) {
		$result[result]	= 0;
		$result[msg]	= $ofile . " : 없는 파일입니다.";
		return $result;
	}
	if(!file_exists($uppath)) {
		$result[result]	= 0;
		$result[msg]	= $uppath . " : 없는 경로입니다.";
		return $result;
	}

	$imginfo	= @getimagesize($ofile);

	if($thumb)	$savepath	= $ofile;
	else{
		//-- 썸네일 경로가 없으면 생성
		$thumbpath	= $uppath . "/thumb";
		if(!file_exists($thumbpath)) {
			@mkdir($thumbpath);
			@chmod($thumbpath, 0707);

			fclose(fopen($thumbpath."/index.php", "w"));
			@chmod($thumbpath."/index.php", 0606);
		}
		$savepath	= $thumbpath . "/" . $ofilename;
	}

	//-- 원본 이미지가 축소 할 크기보다 작으면 실행 하지 않음
	if(($imginfo[0] < $size_w) && ($imginfo[1] < $size_h)) {
		$result[result]	= 0;
		$result[msg]	= "원본 이미지가 축소할 크기보다 작습니다.";

		return $result;
	}

	//-- 이미지 체크
	$filetype		= strtolower($imginfo[mime]);
	if($filetype == "image/gif")		
		$fileexec = "gif";
	elseif(($filetype == "image/jpg") || ($filetype == "image/jpeg"))	
		$fileexec = "jpg";
	elseif($filetype == "image/png")	
		$fileexec = "png";
	else {
		$result[result]	= 0;
		$result[msg]	= "이미지는 gif, jpg, png만 사용 가능 합니다.";
		return $result;
	}

	//-- 가로가 길면 세로 기준, 세로가 길면 가로 기준
	$osize_w = $oimg_x	= $imginfo[0];
	$osize_h = $oimg_y	= $imginfo[1];
	//-- 썸네일일 때 비율 맞추지 않음
	if(!$thumb && $size_w && $size_h) {
		if($oimg_x > $size_w && $oimg_y < $size_h){
			//-- 캔버스보다 가로는 크고 세로는 작을 때, 가로 기준으로 캔버스 축소해서 이미지 영역으로
			$exp_ratio	= $oimg_y / $size_h;
			$osize_w	= $exp_ratio * $size_w;
			$osize_h	= $exp_ratio * $size_h;
		}
		if($oimg_x < $size_w && $oimg_y > $size_h){
			//-- 캔버스보다 가로는 작고 세로는 클 때, 세로 기준으로 캔버스 축소해서 이미지 영역으로
			$exp_ratio	= $oimg_x / $size_w;
			$osize_w	= $size_w * $exp_ratio;
			$osize_h	= $size_h * $exp_ratio;
		}

		if(($oimg_x > $size_w && $oimg_y > $size_h) || ($oimg_x < $size_w && $oimg_y < $size_h)) {
			//-- 캔버스 보다 가로, 세로 모두 크거나 작을 때 비율에 따라서 캔버스 크기 변경
			$x_rto	= $oimg_x / $size_w;
			$y_rto	= $oimg_y / $size_h;
			if($x_rto < $y_rto) 
				$redu_ratio = $x_rto;
			else 
				$redu_ratio = $y_rto;

			$osize_w = $size_w * $redu_ratio;
			$osize_h = $size_h * $redu_ratio;
		}
	}
	


	$imgsrc		= "";
	$imgtrg		= "";

	//-- 가로가 길면 세로 기준, 세로가 길면 가로 기준
	$osize_w = $oimg_x	= $imginfo[0];
	$osize_h = $oimg_y	= $imginfo[1];
	//-- 썸네일일 때 비율 맞추지 않음
	if(!$thumb && $size_w && $size_h) {
		if($oimg_x > $size_w && $oimg_y < $size_h){
			//-- 캔버스보다 가로는 크고 세로는 작을 때, 가로 기준으로 캔버스 축소해서 이미지 영역으로
			$exp_ratio	= $oimg_y / $size_h;
			$osize_w	= $exp_ratio * $size_w;
			$osize_h	= $exp_ratio * $size_h;
		}
		if($oimg_x < $size_w && $oimg_y > $size_h){
			//-- 캔버스보다 가로는 작고 세로는 클 때, 세로 기준으로 캔버스 축소해서 이미지 영역으로
			$exp_ratio	= $oimg_x / $size_w;
			$osize_w	= $size_w * $exp_ratio;
			$osize_h	= $size_h * $exp_ratio;
		}

		if(($oimg_x > $size_w && $oimg_y > $size_h) || ($oimg_x < $size_w && $oimg_y < $size_h)) {
			//-- 캔버스 보다 가로, 세로 모두 크거나 작을 때 비율에 따라서 캔버스 크기 변경
			$x_rto	= $oimg_x / $size_w;
			$y_rto	= $oimg_y / $size_h;
			if($x_rto < $y_rto) 
				$redu_ratio = $x_rto;
			else 
				$redu_ratio = $y_rto;

			$osize_w = $size_w * $redu_ratio;
			$osize_h = $size_h * $redu_ratio;
		}
	}

	

	$imgtrg		= @imagecreatetruecolor($size_w, $size_h);
	if($filetype == "image/gif"){
		$imgsrc	= @imagecreatefromgif($ofile);
		@imagecopyresized($imgtrg, $imgsrc, 0, 0, 0, 0,  $size_w, $size_h, $osize_w, $osize_h);
		@imagegif($imgtrg, $savepath);
	}elseif(($filetype == "image/jpg") || ($filetype == "image/jpeg")){
		$imgsrc = @imagecreatefromjpeg($ofile);
		@imagecopyresized($imgtrg, $imgsrc, 0, 0, 0, 0,  $size_w, $size_h, $osize_w, $osize_h);
		@imagejpeg($imgtrg, $savepath, 100);
	}elseif($filetype == "image/png"){
		$imgsrc = @imagecreatefrompng($ofile);
		@imagecopyresized($imgtrg, $imgsrc, 0, 0, 0, 0,  $size_w, $size_h, $osize_w, $osize_h);
		@imagepng($imgtrg, $savepath);
	}

	@chmod($savepath, 0606);

	@imagedestroy($imgtrg);
	@imagedestroy($imgsrc);


	return true;
}

//-- 워터마크 만들기 ------------------------------------------------------------------------------
//-- zm_makewatermark(이미지 경로, 워터마크 경로, 워터마크 위치, 투명도) 
function zm_makewatermark($savepath, $watermark, $wmposition, $wmopacity="60") {
	if(!file_exists($watermark) || !file_exists($savepath)) return false;

	$fileinfo		= @getimagesize($savepath);
	$imgwater		= @getimagesize($watermark);

	//-- 워터마크 위치
	$wtrmrk_w		= $imgwater[0];			//-- 워터마크 폭
	$wtrmrk_h		= $imgwater[1];			//-- 워터마크 높이
	$orgimg_w		= $fileinfo[0];			//-- 원본 이미지 폭
	$orgimg_h		= $fileinfo[1];			//-- 원본 이미지 높이

	//-- y:세로, x:가로
	switch($wmposition) {
		case "1" :							//-- 상좌
			$wtrmrk_y	= round($orgimg_h / 10);
			$wtrmrk_x	= round($orgimg_w / 10);
			break;
		case "2" :							//-- 상중
			$wtrmrk_y	= round($orgimg_h / 10);
			$wtrmrk_x	= round($orgimg_w / 2) - round($wtrmrk_w / 2);
			break;
		case "3" :							//-- 상우
			$wtrmrk_y	= round($orgimg_h / 10);
			$wtrmrk_x	= ($orgimg_w - $wtrmrk_w) - round($orgimg_w / 10);
			break;
		case "4" :							//-- 중좌
			$wtrmrk_y	= round($orgimg_h / 2) - round($wtrmrk_h / 2);
			$wtrmrk_x	= round($orgimg_w / 10);
			break;
		case "5" :							//-- 중중
			$wtrmrk_y	= round($orgimg_h / 2) - round($wtrmrk_h / 2);
			$wtrmrk_x	= round($orgimg_w / 2) - round($wtrmrk_w / 2);
			break;
		case "6" :							//-- 중우
			$wtrmrk_y	= round($orgimg_h / 2) - round($wtrmrk_h / 2);
			$wtrmrk_x	= ($orgimg_w - $wtrmrk_w) - round($orgimg_w / 10);
			break;
		case "7" :							//-- 하좌
			$wtrmrk_y	= ($orgimg_h - $wtrmrk_h) - round($orgimg_h / 10);
			$wtrmrk_x	= round($orgimg_w / 10);
			break;
		case "8" :							//-- 하중
			$wtrmrk_y	= ($orgimg_h - $wtrmrk_h) - round($orgimg_h / 10);
			$wtrmrk_x	= round($orgimg_w / 2) - round($wtrmrk_w / 2);
			break;
		case "9" :							//-- 하우
			$wtrmrk_y	= ($orgimg_h - $wtrmrk_h) - round($orgimg_h / 10);
			$wtrmrk_x	= ($orgimg_w - $wtrmrk_w) - round($orgimg_w / 10);
			break;
		default :
			$wtrmrk_y	= round($orgimg_h / 10);
			$wtrmrk_x	= round($orgimg_w / 10);
			break;
	}

	//-- 원본 이미지 생성
	if($fileinfo[2] == 1)		$tgtimg	= @imagecreatefromgif($savepath);
	elseif($fileinfo[2] == 2)	$tgtimg = @imagecreatefromjpeg($savepath);
	elseif($fileinfo[2] == 3)	$tgtimg = @imagecreatefrompng($savepath);

	//-- 워터마크 이미지 생성
	if($imgwater[2] == 1)		$wmimg	= @imagecreatefromgif($watermark);
	elseif($imgwater[2] == 2)	$wmimg	= @imagecreatefromjpeg($watermark);
	elseif($imgwater[2] == 3)	$wmimg	= @imagecreatefrompng($watermark);
	
	@imagecopymerge($tgtimg, $wmimg, $wtrmrk_x, $wtrmrk_y, 0, 0, $imgwater[0], $imgwater[1], $wmopacity);
	if($fileinfo[2] == 1)		@imagegif($tgtimg, $savepath);
	elseif($fileinfo[2] == 2)	@imagejpeg($tgtimg, $savepath);
	elseif($fileinfo[2] == 3)	@imagepng($tgtimg, $savepath);
	@chmod($savepath, 0606);

	@imagedestroy($tgtimg);
	@imagedestroy($wmimg);
}


//-- 확장 회원 정보 읽어오기 ----------------------------------------------------------------------
//-- $field는 읽어 올 필드명이며 ,로 구분한다. ex)mb_id, mb_email, mb_level
function zm_getmember($mb_id, $field="*"){
	global $g4, $zmb;

	if(!$mb_id) return false;
	$mb		= get_member($mb_id);
	$rd		= sql_fetch("select $field from $zmb[table_member] where db_id='$mb_id'");
	if(!$rd) return false;

	//-- 앞에 접두어 db_를 제거
	$zm_mb	= array();
	foreach($rd as $key=>$value) {
		$k			= substr($key, 3, strlen($key));
		$zm_mb[$k]	= $value;
	}

	$tmpsns		= explode("/", $zm_mb[sns_link]);
	$zm_mb[sns_link_f]		= $tmpsns[0];
	$zm_mb[sns_link_t]		= $tmpsns[1];
	$zm_mb[sns_link_y]		= $tmpsns[2];
	$zm_mb[sns_link_m]		= $tmpsns[3];
	unset($zm_mb[sns_link]);

	//-- 프로필 공개 설정
	$temp		= explode("/", $zm_mb[profile_open_level]);
	if($mb[mb_open] == "1") {
		$zm_mb[profile_open_level]		= $temp[0];
		$zm_mb[profile_open_condition]	= $temp[1];
	}else{
		$zm_mb[profile_open_level]		= $temp[0];
		$zm_mb[profile_open_condition]	= "3";				//-- 비공개
	}

	$tmp	= explode("/", $zm_mb[school]);
	for($i = 1; $i <= count($tmp); $i++) {
		$stmp		= explode("&", $tmp[$i-1]);
		$zm_mb['school'.$i]	= $stmp[0];
		$zm_mb['iphak'.$i]	= $stmp[1];
	}
	unset($zm_mb[school]);

	return $zm_mb;
}

//-- 친구 관계 -- 0:서로 친구 아님, 1:$id만 나를 친구로 등록, 2:나만($member[mb_id]) $id를 친구로 등록, 3 : 서로 친구
function zm_is_friend($id) {
	global $g4, $zmb, $member;

	if(!$id || trim($id) == $member[mb_id]) return false;

	$result		= 0;
	$friend_	= 0;

	$rd			= sql_fetch("select db_id from $zmb[table_friend] where db_state='2' and db_id='$id' and db_friend_id='$member[mb_id]'");
	if($rd[db_id])	{ $result = 1; $friend_++; }			//-- $id는 나를 친구로 등록
	$rd			= sql_fetch("select db_id from $zmb[table_friend] where db_state='2' and db_id='$member[mb_id]' and db_friend_id='$id'");
	if($rd[db_id])	{ $result = 2; $friend_++; }			//-- 나는 $id를 친구로 등록

	if($friend_ >= 2) $result = 3;	//-- 서로 친구

	return $result;
}

//-- 쪽지 전송하기 --------------------------------------------------------------------------------
function zm_sendmemo($send_id, $recv_id, $memo, $type="0"){
	global $g4, $zmb, $member;

	if($type == "0") $type = "";

	$tmp_row	= sql_fetch(" select max(me_id) as max_me_id from $g4[memo_table] ");
    $me_id		= $tmp_row[max_me_id] + 1;

	//-- 받는 사람이 보내는 사람을 차단 했을 때. 
	$rs_refusal	= sql_fetch("select * from $zmb[table_memo_refusal] where db_id='$recv_id' and db_refusal_id='$send_id'");
	if($rs_refusal[db_refusal_id])							//-- 차단 됐음 ㅠㅠ
			$where_refusal	= ", me_type='1'";
	else	$where_refusal	= ", me_type='$type'";

	$sql		= "insert into $g4[memo_table] set me_id='$me_id', me_recv_mb_id='$recv_id', me_send_mb_id='$send_id', me_send_datetime='$g4[time_ymdhis]', me_memo='$memo' $where_refusal";
    sql_query($sql);

    // 실시간 쪽지 알림 기능
    $sql = " update $g4[member_table] set mb_memo_call = '$recv_id' where mb_id = '$recv_id' ";
    sql_query($sql);

	//-- 회원 정보에서 새 쪽지 카운트
	if(!$where_refusal) mysql_query("update $zmb[table_member] set db_new_memo=db_new_memo+1 where db_id='$recv_id'");

	return true;
}

//-- 신고 된 건 수가 몇개? ------------------------------------------------------------------------
function zm_reportcount($bo_table, $wrid) {
	global $g4, $zmb, $zm_config;

	if(!$bo_table || !$wrid) return false;

	$report_count	= sql_fetch("select count(db_recno) as rcnt from $zmb[table_blacklist_report] where db_table='$bo_table' and db_wrid='$wrid'");

	return $report_count[rcnt];
}

//-- 블라인드 된 게시물인가? ----------------------------------------------------------------------
function zm_isblindbbs($bo_table, $wrid) {
	global $g4, $zmb, $zm_config;

	if(!$bo_table || !$wrid) return false;

	$report_count	= sql_fetch("select db_recno from $zmb[table_blacklist_bbs] where db_table='$bo_table' and db_wrid='$wrid'");
	if($report_count[db_recno]) {
		return true;
	}else{
		return false;
	}
}

//-- 신고 버튼 ------------------------------------------------------------------------------------
function zm_police($bo_table, $wrid, $report='bbs') {
	global $g4, $zm_config;

	$report_cnt	= zm_reportcount($bo_table, $wrid);

	//-- 신고 아이콘, 단계별로 구분. 신고가 누적 될 수록 잘 보이는 아이콘으로
	$rep_ratio	= round($report_cnt / $zm_config[bbsreport] * 100);
	if($rep_ratio <= 25)		$icon_police = $g4[path] . "/zm.extend/img/icon_police_1.gif";
	elseif($rep_ratio <= 50)	$icon_police = $g4[path] . "/zm.extend/img/icon_police_2.gif";
	elseif($rep_ratio <= 75)	$icon_police = $g4[path] . "/zm.extend/img/icon_police_3.gif";
	else						$icon_police = $g4[path] . "/zm.extend/img/icon_police_4.gif";

	if(ZM_IS_MOBILE)
		$icon	= "<span onclick=\"window.open('".$g4[bbs_path]."/zm.police.php?bo_table=".$bo_table."&wrid=".$wrid."&report=".$report."', 'police')\" style='cursor:pointer;'><img src=".$icon_police." align=absmiddle></span>";
	else
		$icon	= "<span onclick=\"window.open('".$g4[bbs_path]."/zm.police.php?bo_table=".$bo_table."&wrid=".$wrid."&report=".$report."', 'police', 'width=600, height=500, toolbar=0')\" style='cursor:pointer;'><img src=".$icon_police." align=absmiddle></span>";
	return $icon;
}

//-- 최신 베스트 글 읽기 --------------------------------------------------------------------------
//-- 최근 등록 한 글부터 100개를 표본으로 조회수, 추천수, 댓글수로 10개까지                      --
function zm_get_board_best($bo_table) {
	global	$g4, $zm_config, $zmb, $board, $zm_board;

	$bestlist		= array();
	$writetable		= $g4['write_prefix'] . $bo_table;		//-- 게시판


	//-- 최근 업데이트 한 레코드가 10분이 지났는지 체크
	$ranking	= array();
	$i			= 0;
	$rd			= sql_fetch("select db_datetime from $zmb[table_board_best] where db_table='$bo_table' limit 1");
	$nowdate	= date("Y-m-d H:i:s", $g4[server_time] - 600);
	if(!$rd[db_datetime] || ($rd[db_datetime] < $nowdate)) {
		//-- 10분 지났으면 베스트 글 갱신. 10개 까지만.
		//-- 베스트 글 조건. 조회수 40%, 추천수 30%, 댓글수 30%
		$rs_sample	= sql_query("select wr_id, wr_comment, wr_good, wr_hit, wr_datetime from $writetable where wr_is_comment='0' order by wr_datetime desc limit 0, 100");
		$rec_num	= mysql_num_rows($rs_sample);			//-- 표본 레코드 개수
		while($rd_sample = sql_fetch_array($rs_sample)) {
			$arr_notice = explode("\n", trim($board[bo_notice]));		//-- 공지사항은 제외
			$is_notice	= false;
			foreach($arr_notice as $key => $value) {
				if($value == $rd_sample[wr_id]) $is_notice = true;
			}
			if(!$is_notice) {
				$ranking[$i][wr_id]		= $rd_sample[wr_id];
				$ranking[$i][hit]		= ($rd_sample[wr_hit] * 0.4);
				$ranking[$i][good]		= ($rd_sample[wr_good] * 0.3);
				$ranking[$i][comment]	= ($rd_sample[wr_comment] * 0.3);
				$ranking[$i][total]		= $ranking[$i][hit] + $ranking[$i][good] + $ranking[$i][comment];

				$i++;
			}
		}
		//-- 배열 정렬
		for($j = 0; $j < count($ranking); $j++) {
			for($k = $j; $k < count($ranking); $k++) {
				if($ranking[$j][total] < $ranking[$k][total]) {
					$tmp	= $ranking[$j][total];
					$ranking[$j][total]	= $ranking[$k][total];
					$ranking[$k][total]	= $tmp;

					$tmp	= $ranking[$j][wr_id];
					$ranking[$j][wr_id]	= $ranking[$k][wr_id];
					$ranking[$k][wr_id]	= $tmp;
				}// end if
			}// end for
		}// end for
//		print_r2($ranking); exit;
		//-- 상위 10개만 레코드에 기록
		sql_query("delete from $zmb[table_board_best] where db_table='$bo_table'");
		$n		= date("Y-m-d H:i:s", $g4[server_time]);
		for($i = 0; $i < 10; $i++) {
			if($ranking[$i][wr_id]) sql_query("insert into $zmb[table_board_best] set db_table='$bo_table', db_wrid='{$ranking[$i][wr_id]}', db_datetime='$n'");
		}
	}

	//-- 최근 베스트 글 추출
	$i		= 0;
	$rs		= sql_query("select * from $zmb[table_board_best] a, $writetable b where a.db_wrid = b.wr_id and  a.db_table='$bo_table' order by a.db_recno asc");
	while($rd = sql_fetch_array($rs)) {
		//-- Thumb 이미지 생성. --------------------- ziumsoft
		preg_match_all("/<img[^>]*src=[\"']?([^>\"']+)[\"']?[^>]*>/i", $rd[wr_content], $match);

		for($j = 0; $j < count($match); $j++) {
			for($k = 0; $k < count($match[$j]); $k++) {
				if(strlen($match[$j][$k])) {
					$tmp_img = explode("/data/zm.exp/", strip_tags($match[$j][$k]));
					$tmp_org_img	= "../data/zm.exp/" . $tmp_img[1];
					if($tmp_img[1]) {
						$tmp	= explode("/", $tmp_img[1]);
						$tmp_thm_img	= "../data/zm.exp";
						for($m = 0; $m < count($tmp)-1; $m++) $tmp_thm_img .= "/" . $tmp[$m];
						$tmp_thm_img	.= "/thumb/" . $tmp[count($tmp)-1];

						if(file_exists($tmp_org_img)) {
							if(!file_exists($tmp_thm_img))
								zm_makethumb($tmp_org_img, $zm_board[thumbwidthsize], $zm_board[thumbheightsize]);
								if(!file_exists($tmp_thm_img)) {
									//-- 그래도 파일이 없으면 너무 작아서 안 만든 것임. 원본을 사용
									$tmp_thm_img	= str_replace("/thumb/", "/", $tmp_thm_img);
								}

							if(!$bestlist[$i][se_thumb]) {
								$bestlist[$i][se_thumb]	= "<img src='$tmp_thm_img'>";
								$bestlist[$i][se_thumb_url]	= $tmp_thm_img;
							}
						}
					}
				}
			}
		}


		$list_file = get_file($bo_table, $rd[wr_id]);

		for($j = 0; $j < count($list_file); $j++) {
			$tmp_org_img	= $list_file[$j][path] . "/" . $list_file[$j][file];
			$tmp_thm_img	= $list_file[$j][path] . "/thumb/" . $list_file[$j][file];
			if(preg_match("/(jp[e]?g|gif|png)/i", $tmp_org_img))	{
				if(!file_exists($tmp_thm_img)) {
					zm_makethumb($tmp_org_img, $zm_board[thumbwidthsize], $zm_board[thumbheightsize]);
				}
				$bestlist[$i][g4_thumb]	= "<img src='$tmp_thm_img'>";
				$bestlist[$i][g4_thumb_url]	= $tmp_thm_img;
				$j = count($list_file);						//-- 루트 종료
			}
		}
		//-------------------------------------------

		$bestlist[$i][wr_id]		= $rd[wr_id];
		$bestlist[$i][wr_subject]	= $rd[wr_subject];
		$i++;
	}

	return $bestlist;
}


//-- 디렉토리 만들기 ------------------------------------------------------------------------------
//-- $path = "./dir", "../dir", "../../dir", "/dir"
function zm_mkdir($path) {
	if((substr($path, 0, 1) != "/") && (substr($path, 0, 2) != "./") && (substr($path, 0, 3) != "../")) $path	= "./" . $path;


	$dir_step	= explode("/", $path);
	$first_dir	= array();

	/* 
		$first_dir[0] : "../../dir"
		$first_dir[1] : "../../dir/dir2"
		$first_dir[..] : ........
	*/

	//-- ex)경로가 ../../dir/dir2 처럼 여러 단계 일 때 처음 생성할 경로 "../../dir을 구한다. 
	$c		= 0;
	if($dir_step[0] == "..") {
		for($i = 0; $i < count($dir_step); $i++) {
			if($dir_step[$i] == "..") {
				$first_dir[0] .= "../";
				$c++;
			}
		}
		$first_dir[0]	.= $dir_step[$c];

		$e	= 1;
		for($i = $c+1; $i < count($dir_step); $i++) {
			$first_dir[$e]	= $first_dir[$e-1] . "/" . $dir_step[$i];
			$e++;
		}
	}

	//-- ex)경로가 ./dir/dir2 처럼 현재로 부터 여러 단계 일 때 처음 생성할 경로 "./dir"을 구한다.
	if($dir_step[0] == ".") {
		$first_dir[0]	= $dir_step[0] . "/" . $dir_step[1];
		$e	= 1;
		for($i = 2; $i < count($dir_step); $i++) {
			$first_dir[$e]	= $first_dir[$e-1] . "/" . $dir_step[$i];
			$e++;
		}
	}

	//-- ex)경로가 /dir/dir2 처럼 home에서 시작 할 때 처음 생성할 경로 'home/www/dir"을 구한다.
	if(substr($path, 0, 1) == "/"){
		$first_dir[0]	= $_SERVER[DOCUMENT_ROOT] . "/" . $dir_step[1];
		$e	= 1;
		for($i = 2; $i < count($dir_step); $i++) {
			$first_dir[$e]	= $first_dir[$e-1] . "/" . $dir_step[$i];
			$e++;
		}
	}



	//-- 본격적으로 디렉토리 생성
	for($i = 0; $i < count($first_dir); $i++) {
		if(!file_exists($first_dir[$i])) {
			@mkdir($first_dir[$i]);
			@chmod($first_dir[$i], 0707);
		}
		//-- index.php 생성
		$idxpath	= $first_dir[$i] . "/index.php";
		if(!file_exists($idxpath)) {
			$f = fopen($idxpath, "w");
			fclose($f);
		}

	}
	
	return;
}


//-- 문자열에서 특수문자 제거 ---------------------------------------------------------------------
function zm_dropspectxt($str) {
	return preg_replace("/[#\&\+\-%@=\/\\\:;,\.'\"\^`~\_|\!\?\*$#<>()\[\]\{\}]/i", "", $str);
}

//-- 회원 레벨 select -----------------------------------------------------------------------------
function zm_get_member_level($name, $selected=''){
	global	$zm_levelname;

	$str	= "";
	$sel	= "";

	$str	.= "<select name='$name' id='$name'>";
	for($i = 1; $i <= 10; $i++) {
		if($i == $selected) $sel = "selected"; else $sel = "";
		$str	.= "<option value='$i' $sel>$i : $zm_levelname[$i]</option>";
	}
	$str	.= "</select>";

	return $str;
}


//-- 디렉토리의 파일 정보 -------------------------------------------------------------------------
function zm_get_dir($dir)
{
    if ($dir[strlen($dir)-1] != '/') $dir .= '/';
    if (!is_dir($dir)) return array();
 
    $dir_handle  = opendir($dir);
    $dir_objects = array();
    while ($object = readdir($dir_handle))
        if (!in_array($object, array('.','..')))
        {
            $filename    = $dir . $object;
            $file_object = array(
                                    'name' => $object,
                                    'size' => filesize($filename),
                                    'type' => filetype($filename),
                                    'time' => date("d-M-Y H:i", filemtime($filename))
                                );
            $dir_objects[] = $file_object;
        }
     return $dir_objects;
}

//-- 회원의 정보를 공개 수준에 맞춰 배열에 저장 ---------------------------------------------------
//-- writer_id : 글쓴이, viewer_id : 열람하려는 회원
function zm_get_writer_info($writer_id, $viewer_id='') {
	global $g4, $board, $zmb, $zm_levelname, $config;

	$member_skin_path = "$g4[path]/skin/member/$config[cf_member_skin]";			//-- 회원관리 스킨 경로

	//-- 글쓴이의 정보
	$mb_writer	= get_member("$writer_id");					//-- 기본정보
	$zm_writer	= zm_getmember("$writer_id");				//-- 확장정보

	//-- 글쓴이와 열람하는 회원은 친구인가?
	$rd_friend	= sql_fetch("select db_id, db_state from $zmb[table_friend] where db_id='$writer_id' and db_friend_id='$viewer_id'");
	if($rd_friend[db_state] == "2") $is_friend = true; 
	else							$is_friend = false;

	//-- 단계별 공개 정보 ---------------------------
	$writer_info	= array();								//-- 글쓴이의 프로필 정보가 들어갈 배열 
	$openlevel		= 9;									//-- 공개할 단계

	//-- 둘이 친구면 공개 설정한 레벨 수준만큼 공개
	if($zm_writer[profile_open_condition] == "2" && $is_friend) {	
		$openlevel	= $zm_writer[profile_open_level]; 
	}

	//-- 내 정보를 공개하지 않았고 친구도 아니라면 아무것도 열람 할 수 없다.
	if(!$member[mb_open] && !$is_friend) $openlevel = 0;	

	//-- 공개 조건이 모두공개이면 친구 여부 상관 없이 설정한 수준만큼 공개
	if($zm_writer[profile_open_condition] == "1") {	
		$openlevel	= $zm_writer[profile_open_level]; 
	}

	//-- 내가 내 글을 보고 있음.
	if($member[mb_id] == $mb_writer[mb_id])	$openlevel = 3;

	//-- 열람하는 회원이 관리자면 싹다 공개
	if($member[mb_level] >= 10) $openlevel = 3;

	//-- 글쓴이의 간단 프로필
	if($zm_writer[profile_pic]) 
		$writer_info[profile_pic]	= $g4[path]."/data/zm.exp/profile/" . $zm_writer[profile_pic];
	else
		$writer_info[profile_pic]	= $member_skin_path."/img/img_nopic.gif";

	//-- 일단 $writer_info에 회원정보를 모두 저장
	$writer_info[mb_nick]		= $mb_writer[mb_nick];
	$writer_info[mb_signature]	= $mb_writer[mb_signature];
	$writer_info[mb_level]		= $mb_writer[mb_level];						//-- 회원등급
	$writer_info[mb_levelname]	= $zm_levelname[$writer_info[mb_level]];	//-- 등급명 
	$writer_info[mb_homepage]	= set_http("$mb_writer[mb_homepage]");
	$writer_info[mb_homepage]	= ($writer_info[mb_homepage]) ? "<a href='$writer_info[mb_homepage]' target='_blacnk'>$mb_writer[mb_homepage]</a>" : "";//-- 홈페이지
	$writer_info[mb_email]		= $mb_writer[mb_email];
	$writer_info[mb_belong]		= $zm_writer[belong];						//-- 소속
	$writer_info[mb_today_login] = $mb_writer[mb_today_login];				//-- 최종 접속일
	$writer_info[mb_datetime]	= $mb_writer[mb_datetime];					//-- 가입일
	$writer_info[mb_location]	= $zm_writer[location];						//-- 접속 지역
	$writer_info[mb_profile]	= $mb_writer[mb_profile];					//-- 자기소개
	$birth	= substr($mb_writer[mb_birth], 0, 4);
	$year	= date("Y");
	$writer_info[mb_age]		= $year - $birth;							//-- 나이
	$writer_info[mb_bloodtype]	= $zm_writer[bloodtype];					//-- 혈핵형
	$tmp	= explode("/", $zm_writer[school]);
	for($i = 0; $i < count($tmp); $i++) {
		if($tmp[$i]) {
			$tmp2	= explode("&", $tmp[$i]);
			$writer_info[mb_school]		.= $tmp2[0] . "(" . $tmp2[1] . ")";	//-- 학교
		}
	}
	$writer_info[mb_phone]		= ($mb_writer[mb_ph])?$mb_writer[mb_ph] : $mb_writer[mb_tel];						//-- 전번

	if($openlevel == 1) {
		$writer_info[mb_belong] = $writer_info[mb_email] = $writer_info[mb_homepage] = $writer_info[mb_level] = $writer_info[mb_levelname] = $writer_info[mb_datetime] = $writer_info[mb_location] = $writer_info[mb_profile] = "비공개 ";
	} elseif($openlevel == 2) {
		$writer_info[mb_level] = $writer_info[mb_levelname] = $writer_info[mb_age] = $writer_info[mb_bloodtype] = $writer_info[mb_school] = $writer_info[mb_phone] = "비공개";
	} elseif($openlevel == 3) {
		//-- 모두 공개
	} else {										
		//-- 모두 비공개
		foreach($writer_info as $key=>$value) $writer_info[$key] = "비공개";
		$writer_info[mb_nick]	= $mb_writer[mb_nick];						//-- 닉네임은 공개
		$writer_info[profile_pic] = $member_skin_path."/img/img_nopic.gif";
	}

	return $writer_info;
}

//-- xml2array XML을 배열로 바꾸기 ----------------------------------------------------------------
class xml2array { 
    public $parser; 
    public $depth	= 0; 
    public $termStack; 
    public $nodeData; 
    public $fullParseData; 
    public $prevdepth; 
    public $uri; 
    public $last_node; 
    public $inside_data; 
 
    function xml2array($uri) { 
        $this->setURI($uri); 
        $this->run(); 
    } 
 
    function run() { 
        $this->termStack = array(); 
        $this->xmlInit(); 
        $this->parsing(); 
    } 
 
    function setURI($uri) { 
        $this->uri = $uri; 
    } 
 
    function xmlInit() { 
        $this->parser = @xml_parser_create(); 
        if(!$this->parser) echo "Parser Error<br>"; 
        if(!@xml_set_object($this->parser, $this)) echo "xml set object error<br>"; 
        if(!@xml_set_element_handler($this->parser, "tag_open", "tag_close")) echo "handler set error<br>"; 
        if(!@xml_set_character_data_handler($this->parser, "cdata")) echo "cdata handler error<br>"; 
    } 
 
    function cdata($parser, $cdata) { 
        if($this->depth > $this->prevdepth) { 
            if($this->inside_data) 
                $this->nodeData[$this->nodeName()] .= $cdata; 
            else 
                $this->nodeData[$this->nodeName()] = $cdata; 
            $this->last_node = $this->nodeName(); 
        } 
        $this->inside_data=true; 
    } 
 
    function getArray($node=null) { 
        if($node == null) { 
            return $this->fullParseData; 
        } 
        return $this->fullParseData[$node]; 
    } 
 
    function parsing() { 
        $fp = fopen($this->uri, "r"); 
	    if(!$fp) return 0;  
		while($data = fread($fp, 9182)) { 
			$this->parse($data); 
        } 
	    fclose($fp); 

        return 1; 
    } 
 
    function parse($data) { 
        //if(@xml_parse($this->parser, $data)) echo xml_error_string(xml_get_error_code($this->parser)); 
        @xml_parse($this->parser, $data);
    } 
 
    function getpNode($depth=0) { 
        if($depth != 0) { 
            $node=count($this->termStack) + $depth; 
            $stack = array_slice($this->termStack, 0, $node); 
        } else { 
            $stack = $this->termStack; 
        } 
        return join("/",$stack); 
    } 
 
    function pushStack($name) { 
        array_push($this->termStack, $name); 
    } 
  
    function getStackSize() { 
        return count($this->termStack); 
    } 
 
    function tag_open($parser, $tag, $attributes) { 
        $this->pushStack($tag); 
        if($this->depth > $this->prevdepth) { 
            if(count($this->nodeData)) { 
                $last_node = $this->getpNode(-2); 
                $this->fullParseData[$last_node] = $this->nodeData; 
            } 
            $this->nodeData=array(); 
            $this->prevdepth = $this->depth; 
        } 
        $this->depth++; 
        $this->inside_data=false; 
    } 
 
    function tag_close($parser, $tag) { 
        $count = count($this->nodeData); 
        if($count == 0) 
            array_pop($this->termStack); 
        $this->depth--; 
        if($this->depth < $this->prevdepth) { 
            if(count($this->nodeData) > 1) 
                $this->fullParseData[$this->getpNode()][] = $this->nodeData; 
            else 
                $this->fullParseData[$this->getpNode()] = $this->nodeData; 
            $this->nodeData=array(); 
        } else { 
            $this->prevdepth = $this->depth; 
        } 
        if($count != 0) 
            array_pop($this->termStack); 
                $this->inside_data=false; 
    } 
 
    function nodeName() { 
        return $this->termStack[$this->depth-1]; 
    } 
}


//-- fopen대신 원격 파일 열기 ---------------------------------------------------------------------
/*
function zm_away_fopen($url){
	if(!$url) return false;

	$info = parse_url($url);
    $send = "POST " . $info["path"] . " HTTP/1.1\r\n"
        . "Host: " . $info["host"] . "\r\n"
        . "Content-type: application/x-www-form-urlencoded\r\n"
        . "Content-length: " . strlen($info["query"]) . "\r\n"
        . "Connection: close\r\n\r\n" . $info["query"];
 
    $fp = fsockopen($info[host], 80);
    fputs($fp, $send);
 
    $start = false;
    $data = "";

    while (!feof ($fp)) {
        $tmp = fgets($fp, 1024);
        if ($start == true) $data .= $tmp;
        if ($tmp == "\r\n") $start = true;
    }

    fclose($fp);
	return trim($data);
}
*/
function zm_away_fopen($url, $method = 'GET')
{   
    // Initialize
    $info   = parse_url($url);
    $req    = '';
    $data   = '';
    $line   = '';
    $agent  = 'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.0; Trident/5.0)';
    $linebreak  = "\r\n";
    $headPassed = false;
 
    // Setting Protocol
    switch($info['scheme'] = strtoupper($info['scheme'])) {
        case 'HTTP':
            $info['port']   = 80;
            break;
 
        case 'HTTPS':
            $info['ssl']    = 'ssl://';
            $info['port']   = 443;
            break;
 
        default:
            return false;
    }
 
    // Setting Path
    if(!$info['path'])   {
        $info['path'] = '/';
    }
 
    // Setting Request Header
    switch($method = strtoupper($method))    {
        case 'GET':
            if($info['query'])  {
                $info['path'] .= '?' . $info['query'];
            }
 
            $req .= 'GET ' . $info['path'] . ' HTTP/1.1' . $linebreak;
            $req .= 'Host: ' . $info['host'] . $linebreak;
            $req .= 'User-Agent: ' . $agent . $linebreak;
            $req .= 'Referer: ' . $url . $linebreak;
            $req .= 'Connection: Close' . $linebreak . $linebreak;
            break;
 
        case 'POST':
            $req .= 'POST ' . $info['path'] . ' HTTP/1.1' . $linebreak;
            $req .= 'Host: ' . $info['host'] . $linebreak;
            $req .= 'User-Agent: ' . $agent . $linebreak; 
            $req .= 'Referer: ' . $url . $linebreak;
            $req .= 'Content-Type: application/x-www-form-urlencoded'.$linebreak; 
            $req .= 'Content-Length: '. strlen($info['query']) . $linebreak;
            $req .= 'Connection: Close' . $linebreak . $linebreak;
            $req .= $info['query']; 
            break;
    }
 
    // Socket Open
    $fsock  = @fsockopen($info['ssl'] . $info['host'], $info['port']);
    if ($fsock)   {
        fwrite($fsock, $req);
        while(!feof($fsock))      {
            $line = fgets($fsock, 128);
            if($line == "\r\n" && !$headPassed)   {
                $headPassed = true;
                continue;
            }
            if($headPassed)            {
                $data .= $line;
            }
        }
        fclose($fsock);
    }
 
    return $data;
}



//-- 휴대전화 번호 유효성 검사 --------------------------------------------------------------------
function zm_is_phonenum($no) {
	$arr_exnum	= array("010", "016", "018", "019", "017");

	$sw			= 0;
	$tmp		= explode("-", $no);
	for($i = 0; $i < count($arr_exnum); $i++) {
		if($arr_exnum[$i] == $tmp[0]) {
			$sw		= 1;
		}
	}
	if(strlen($tmp[1]) < 3)	$sw = 0;				//-- 두번째 자리 수가 2자리 이하
	if(strlen($tmp[2]) < 4)	$sw = 0;				//-- 세번째 자리 수가 4자리 이하

	if($sw)	return true;
	else	return false;
}






/* ---------------------------------- */
/* - 시스템 응용 함수 2012 ziumsoft - */
/* ---------------------------------- */

//-- 게시판 환경설정 정보 -------------------------------------------------------------------------
function zm_get_board_cfg($bo_table) {
	global $zmb;

	$zm_board	= array();

	$tmpqry		= sql_query("select * from $zmb[table_board_config] where db_table='$bo_table'");
	while($tmpres = sql_fetch_array($tmpqry)) {
		$zm_board[$tmpres[db_variable]]	= $tmpres[db_value];
	}

	return $zm_board;
}

//-- 로그인 기록 리스트 얻기 ----------------------------------------------------------------------
function zm_getloglist($rows) {
	global $g4, $zmb, $zm_config;
	$list		= array();

	$list[db_date]	= $rows[db_date];
	$list[db_id]	= $rows[db_id];
	$list[db_ip]	= $rows[db_ip];
	$list[db_authtype]	= $rows[db_authtype];
	$list[db_service]	= $rows[db_service];
	$list[db_result]	= $rows[db_result];

	return $list;
}

//-- 로그인 기록 저장 -----------------------------------------------------------------------------
function zm_write_login($id, $url, $auth, $msg) {
	global	$g4, $zmb, $zm_board, $zm_config;

	if(!$id) return false;

	$date		= date("Y-m-d H:i:s");
	$latedate	= date("Y-m-d H:i:s", time()-24*60*60 * $zm_config[loginlogterm]);		//-- ?일 이전의 날짜
	$ip			= $_SERVER[REMOTE_ADDR];

	$url		= urldecode($url);
	if($msg == "성공") $flag	= "1";
	elseif($msg == "실패") $flag	= "0";

	sql_query("insert into $zmb[table_login_log] set db_id='$id', db_service='$url', db_date='$date', db_authtype='$auth', db_result='$msg', db_ip='$ip', db_flag='$flag'");

	//-- 지정한 날짜 이후의 레코드 삭제
	sql_query("delete from $zmb[table_login_log] where db_date < '$latedate'");

	return true;
}

//-- 읽지 않은 쪽기 개수 --------------------------------------------------------------------------
function zm_new_memo() {
	global $g4, $zmb, $zm_config, $member;

	$sql		= "select count(*) as cnt from {$g4['memo_table']} where me_recv_mb_id = '{$member['mb_id']}' and me_read_datetime = '0000-00-00 00:00:00' and me_save_mb_id='' and me_type<>'1'";
	$row		= sql_fetch($sql);
	$memo_not_read = $row['cnt'];
	sql_query("update $zmb[table_member] set db_new_memo='$memo_not_read' where db_id='{$member['mb_id']}'");

	return ($memo_not_read < 1)?0:$memo_not_read;
}

//-- URL에 sub domain이 있으면 적용한 url 반환 ----------------------------------------------------
function zm_conv_url($recno){
	global $g4, $zmb, $zm_config;

	$go_href	= "";

	//-- 현재 빌더가 설치 된 경로
	$this_url	= $_SERVER[SERVER_NAME];

	$tmp_info	= sql_fetch("select * from $zmb[table_builder_config] where db_recno='$recno'");

	if(!$tmp_info[db_href] || $tmp_info[db_href] == "#") {
		$go_href = ZM_BUILDER_URL . $_SERVER[REQUEST_URI] . "#";
	}else{
		if($tmp_info[db_link_type] == "3")
			$go_href	= str_replace("[#G4URL#]", ZM_BUILDER_URL,  $tmp_info[db_href]);
		else{
			$temp_href	= str_replace("[#G4URL#]", ZM_BUILDER_URL,  $tmp_info[db_href]);
			$go_href = $temp_href;
		}
	}

	if($tmp_info[db_subdomain]) {
		$go_href	= str_replace("http://", "http://".$tmp_info[db_subdomain].".", $go_href);
	}

	return $go_href;
}
//-- sub domain gogossing -------------------------------------------------------------------------
function zm_subdomain(){
	global $zmb, $zm_config;

	$req_uri	= str_replace("/", "", $_SERVER['REQUEST_URI']);

	if(($_SERVER[SERVER_NAME] != $_SERVER[HTTP_HOST]) && (!$req_uri || $req_uri == $zm_config[install_dir])) {
		$_host_name	= $_SERVER[HTTP_HOST];
		if($zm_config[install_dir]) 
			$_host_name .= "/" . $zm_config[install_dir] . "/";
		$rs = sql_fetch("select db_recno, db_href from $zmb[table_builder_config] where db_url='$_host_name'");
		if($rs[db_recno] && ($rs[db_href] && $rs[db_href] != "#")){
			$go_url	= zm_conv_url($rs[db_recno]);

			echo "
			<html><head><meta http-equiv='content-type' content='text/html; charset=utf-8'></head><body>
			<script language='javascript'>
				document.location.href = '$go_url';
			</script>
			</body></html>";
			exit;
		}else{
			return false;
		}
	}

	return;
}
zm_subdomain();
?>