<?
// $global_index와 $local_index 얻기
if (!defined("_GNUBOARD_")) exit;

// 현재 경로 구하기
function get_current_path() {
	if($_SERVER['QUERY_STRING']) {
		// utf-8 환경
		return urldecode($_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']);

		// euc-kr 환경
		// return iconv("utf-8", "euc-kr", urldecode($_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']));
	} else {
		// utf-8 환경
		return urldecode($_SERVER['PHP_SELF']);

		// euc-kr 환경
		// return iconv("utf-8", "euc-kr", urldecode($_SERVER['PHP_SELF']));
	}
}


// 메뉴에 포함된 ./ 또는 ../ 제거
function get_pure_menu($menu) {
	$menu = str_replace("../", "", $menu);
	$menu = str_replace("./", "", $menu);
	return $menu;
}


// $local_index 얻기
function hn_local_index($global_index) {
	global $localmenu;

	// 해당 메뉴가 없으면 실행하지 않음
	$localmenu_count = count($localmenu[$global_index]);
	if($localmenu_count == 0) {
		return 0;
	}

	// 초기화
	$local_index=0;
	$current_path = get_current_path();

	//bo_table, wr_id
	$bo_table=($_GET['bo_table'])? $_GET['bo_table'] : $_POST['bo_table'];
	$wr_id=($_GET['wr_id'])? $_GET['wr_id'] : $_POST['wr_id'];

	// url 비교 검색
	for($i=0; $i<$localmenu_count; $i++) {
		// 메뉴에 포함된 ./ 또는 ../ 제거하여 비교
		$menu = $localmenu[$global_index][$i][1];
		$menu = get_pure_menu($menu);

		// 현재 경로 중 메뉴와 일치하는 문자열 이후만 잘라냄
		$match_current_path = stristr($current_path, $menu);

		// 1. 메뉴와 완전히 일치하면 $local_index 반환
		if($menu === $match_current_path) {
			return $i+1;
		}

		//wr_id는 없고, bo_table만 있을 경우 글쓰기, 목록, 글보기시 활성화
		if(!$local_index && !strpos($menu, "wr_id") && strpos($menu, "bo_table")) {
			// menu에는 board, 현재 path에는 write 인 경우
			if(strpos($menu, "board.php") && strpos($current_path, "write.php")) {
				$tmp_path = str_replace('write.php', 'board.php', $current_path);
			// menu에는 write, 현재 path는 board인 경우
			} else if(strpos($menu, "write.php") && strpos($current_path, "board.php")) {
				$tmp_path = str_replace('board.php', 'write.php', $current_path);
			}

			$match_tmp_path = stristr($tmp_path, $menu);
		}

		// 2. QUERY_STRING에 bo_table, wr_id 이 있으면 유연하게 비교
		if($bo_table && $wr_id && ($match_current_path || $match_tmp_path)) {
			$local_index = $i+1;
		} else if(!$local_index && $bo_table && ($match_current_path || $match_tmp_path)) {
			$local_index = $i+1;
		}
	}//end for

	if($local_index) {
		return $local_index;
	} else {
		return 0;
	}
}


// $global_index 구하기
function hn_global_index() {
	global $globalmenu;

	$current_path = get_current_path();

	// 1. $globalmenu 비교
	for($i=0; $i<count($globalmenu); $i++) {
		// 메뉴에 포함된 ./ 또는 ../ 제거하여 비교
		$menu = $globalmenu[$i][1];
		$menu = get_pure_menu($menu);

		// 현재 경로 중 메뉴와 일치하는 문자열 이후만 잘라냄
		$match_current_path = stristr($current_path, $menu);

		// 글로벌메뉴와 완전히 일치하면 $global_index 반환
		if($menu == $match_current_path) {
			return $i+1;
		}
	}

	// 2. localmenu 비교
	$tmp_global_index = 0;
	$tmp_local_index = 0;

	for($global_idx=1; $global_idx<=count($globalmenu); $global_idx++) {
		// local_index 있다면 세팅 지정
		if($tmp_local_index = hn_local_index($global_idx)) {
			$tmp_global_index = $global_idx;
		}
	}

	//echo "<h2>".$tmp_global_index." ,,, ".$tmp_local_index."</h2>";

	return $tmp_global_index;
}



$global_index = hn_global_index();

// 글로벌인덱스
if(!$global_index)
    $global_index=0;

//로컬인덱스 얻기
$local_index = hn_local_index($global_index);
?>