<?
// hnResizeImage
// =========================
// Author : huon
// Date : 2011.05.09
// Latest : 2011.05.17
// =========================
// 휴온 이미지 리사이즈
// 리사이즈 높이는 너비에 맞게 리사이즈 됩니다.
// 매개변수(원본이미지파일, 리사이즈하여 저장할 이미지경로와 파일명, 리사이즈 너비)
// 반환값 : 생성되면 true반환, 생성되지 않으면 false 반환
if (!defined("_GNUBOARD_")) exit;

function hn_resize_image($org, $target, $width) {		
	// 원본이 없거나 대상이 지정되지 않으면
	//if (!file_exists($org) || !$target || !$width) {
	if (!is_file($org) || !$target || !$width) {
		return false;
	}	
	
	//이미지정보 얻기
	$org_info = getimagesize($org);
	list($org_w, $org_h, $org_kind) = $org_info;

  	if ($org_kind == 1)
		$src = imagecreatefromgif($org);
	else if ($org_kind == 2)
		$src = imagecreatefromjpeg($org);
	else if ($org_kind == 3)
		$src = imagecreatefrompng($org);	
	else 
		return false;
			
	$factor = $width/$org_w;
	$height = round($org_h * $factor);		
		
	$dst = imagecreatetruecolor($width, $height);
	imagecopyresampled($dst, $src, 0, 0, 0, 0, $width, $height, $org_w, $org_h);
		
	if ($org_kind == 1)
		@imagegif($dst, $target);
	else if ($org_kind == 2)
		@imagejpeg($dst, $target);
	else if ($org_kind == 3)
		@imagepng($dst, $target);
	
	@chmod($target, 0666);
	
	imagedestroy($src);
	imagedestroy($dst);		
		
	//최종결과
	if (file_exists($target))
		return true;	
	else 	
		return false;
}
/* 사용  예
-------------------------------------------------------
    //썸네일 라이브러리
    include_once($g4[path]."/lib/hn_resize_image.lib.php");
    //썸네일 생성
    $org_file = $list[$i][file][0][path] .'/'. $list[$i][file][0][file];
    if(file_exists($org_file)) {
	    $thumb_file = $thumb_path."/".$list[$i][wr_id];
	    //만일 썸네일 생성하지 못하면 원본을 썸네일로 사용한다.
    	if(!hn_resize_image($org_file, $thumb_file, $thumb_width))
    			$thumb_file = $org_file;
   	}
*/    	
?>
