<?
/**
 * RSA 폼 전송 제어 클래스
 * @package	SmileSERV
 * @author	솔루션개발팀
 * @since	2015년 01월 27일
 * @see		RSA 를 이용하여 폼 전송 자동화 처리를 위한 클래스
 */
class ssRsaForm extends ssRsa
{
	/**
	 * @var	암/복호화 제외 대상
	 */
	private $exclude = array ( 'ssRsaForm' , 'x' , 'y' , '_x' , '_y' ) ;
	
	
	/**
	 * 클래스 생성자, 암/복호화에 필요한 기본 처리를 진행한다.
	 * @return	Void
	 * @see		암호화된 데이터가 존재 할 경우 복호화를 진행한다.
	 */
	public function __construct ()
	{
		// RSA 사용 여부 확인
		parent::__construct () ;
		
		// 세션 활성화
		if ( session_id () == '' )
		{
			if ( headers_sent () )
				$this->error ( '세션이 활성화되지 않았습니다. RSA 암/복호화 폼 전송은 세션이 반드시 필요합니다.' ) ;
			session_start () ;
		}
		
		// RSA 키 생성 혹은 할당
		if ( ! isset ( $_SESSION['ssRsa'] ) )
			$this->makeKey () ;
		else
			$this->setKey ( $_SESSION['ssRsa']['private'] , $_SESSION['ssRsa']['public'] ) ;
		
		// 암호화 데이터 존재 확인
		$form	= & $GLOBALS['_' . strtoupper ( $_SERVER['REQUEST_METHOD'] )] ;
		if ( ! isset ( $form['ssRsaForm'] ) || ! $form['ssRsaForm'] )
			return ;
		
		// 복호화
		foreach ( $this->exclude as $v )
			unset ( $form[$v] ) ;
		$this->decryptFormData ( $form ) ;
		
		// 전역화 ( register_globals )
		if ( ! ini_get ( 'register_globals' ) )
			return ;
		foreach ( array_keys ( $form ) as $v )
			$GLOBALS[$v] = $form[$v] ;
	}
	
	
	/**
	 * 암호화되어 전송된 폼 데이터를 복호화한다.
	 * @param	Mixed	$data	암호화되어 전송된 폼 데이터
	 * @return	Mixed			복호화된 폼 데이터
	 */
	private function decryptFormData ( & $data )
	{
		if ( is_array ( $data ) )
			foreach ( $data as & $v )
				$this->decryptFormData ( $v ) ;
		else if ( ! empty ( $data ) && strlen ( $data ) == $_SESSION['ssRsa']['length'] )
			$data	= $this->decrypt ( $data ) ;
	}
	
	
	/**
	 * 키를 생성한다.
	 * @param	Integer	$bit		[optional]	비트 ( 기본 값 : 1024 )
	 * @param	String	$algorithm	[optional]	키 생성 알고리즘 ( 기본 값 : sha256 )
	 * @return	Array							RSA 키 정보가 담긴 1차 연관 배열
	 */
	public function makeKey ( $bit = 1024 , $algorithm = 'sha256' )
	{	
		$_SESSION['ssRsa']	= parent::makeKey ( $bit , $algorithm ) ;		
		$encrypt = $bit / 8 ;																			// 암호화 문자열 길
		$_SESSION['ssRsa']['length'] = ( floor ( $encrypt / 3 ) * 4 ) + ( $encrypt % 3 ? 4 : 0 ) ;		// Base64 인코딩 여부에 따른 길이 차이 계산
		return $_SESSION ;
	}
}


/**************************************************
인스턴스 생성 및 초기화 작업
--------------------------------------------------
**************************************************/
$ssRsaForm	= new ssRsaForm ;
?>