<?php
/*
 * 기본설정
 */
$sub_menu = "100100";
include_once("./_common.php");

auth_check($auth[$sub_menu], "r");

$token = get_token();

if ($is_admin != "super")
    alert("최고관리자만 접근 가능합니다.");

// 쪽지보낼시 차감 포인트 필드 추가 : 061218
sql_query(" ALTER TABLE `$g4[config_table]` ADD `cf_memo_send_point` INT NOT NULL AFTER `cf_login_point` ", FALSE);

// 개인정보보호정책 필드 추가 : 061121
$sql = " ALTER TABLE `$g4[config_table]` ADD `cf_privacy` TEXT NOT NULL AFTER `cf_stipulation` ";
sql_query($sql, FALSE);
if (!trim($config[cf_privacy])) {
    $config[cf_privacy] = "해당 홈페이지에 맞는 개인정보취급방침을 입력합니다.";
}

$g4['title'] = "기본환경설정";
include_once ("./admin.head.php");
?>
<style type='text/css'>
    .tabnav > li > a{padding: 2px 4px}
</style>

<form name='fconfigform' method='post' onsubmit="return fconfigform_submit(this);" role="form" class='form-horizontal ad_config'>
    <input type='hidden' name='token' value='<?php echo $token ?>'/>
    <ul class="tabnav nav nav-tabs">
        <li class="active"><a href="#default" data-toggle="tab">기본</a></li>
        <li><a href="#board" data-toggle="tab">게시판</a></li>
        <li><a href="#join" data-toggle="tab">회원</a></li>
        <li><a href="#mail" data-toggle="tab">메일</a></li>
        <li><a href="#ext" data-toggle="tab">여분</a></li>
        <li><a href="#mobile" data-toggle="tab">모바일</a></li>
    </ul>
    <!-- 기본설정 -->
    <div class='row tab-content'>
        <div class='round-box tab-pane active' id='default'>
            <div class="col-sm-12">
                <?php echo subtitle("기본 설정") ?>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        홈페이지 제목
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-control' name='cf_title' size='30' required itemname='홈페이지 제목' value='<?php echo $config['cf_title'] ?>'/>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        최고관리자
                    </label>
                    <div class='col-sm-9'>
                        <?php echo get_member_id_select("cf_admin", 10, $config['cf_admin'], "required itemname='최고 관리자'") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        포인트 사용
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_point' value='1' <?php echo $config['cf_use_point'] ? 'checked' : ''; ?>> 사용</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        로그인시 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_login_point' size='5' required itemname='로그인시 포인트' value='<?php echo $config['cf_login_point'] ?>'/>
                        <?php echo help("회원에게 하루에 한번만 부여") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        쪽지보낼시 차감 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_memo_send_point' size='5' required itemname='쪽지전송시 차감 포인트' value='<?php echo $config[cf_memo_send_point] ?>'/>
                        <?php echo help("양수로 입력하십시오. 0으로 입력하시면 쪽지보낼시 포인트를 차감하지 않습니다.") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        이름(별명) 표시 자리수
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_cut_name' value='<?php echo $config['cf_cut_name'] ?>' size='2'/>
                        <?php echo help("영숫자 2글자 = 한글 1글자") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        별명 수정
                    </label>
                    <div class='col-sm-9'>
                        수정한 후 <input type='text' class='form-inline' name='cf_nick_modify' value='<?php echo $config['cf_nick_modify'] ?>' size='2'/> 일 동안 바꿀 수 없음
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        정보공개 수정
                    </label>
                    <div class='col-sm-9'>
                        수정한 후 <input type='text' class='form-inline' name='cf_open_modify' value='<?php echo $config['cf_open_modify'] ?>' size=2> 일 동안 바꿀 수 없음
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        최근게시물 삭제
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_new_del' value='<?php echo $config['cf_new_del'] ?>' size='5'/> 일
                        <?php echo help("설정일이 지난 최근게시물 자동 삭제") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        쪽지 삭제
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_memo_del' value='<?php echo $config['cf_memo_del'] ?>'size='5'/> 일
                        <?php echo help("설정일이 지난 쪽지 자동 삭제") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        접속자로그 삭제
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_visit_del' value='<?php echo $config['cf_visit_del'] ?>'size='5'> 일
                        <?php echo help("설정일이 지난 접속자 로그 자동 삭제") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        인기검색어 삭제
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_popular_del' value='<?php echo $config['cf_popular_del'] ?>'size='5'> 일
                        <?php echo help("설정일이 지난 인기검색어 자동 삭제") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        현재 접속자
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_login_minutes' value='<?php echo $config['cf_login_minutes'] ?>'size='5'> 분
                        <?php echo help("설정값 이내의 접속자를 현재 접속자로 인정") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        한페이지당 라인수
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_page_rows' value='<?php echo $config['cf_page_rows'] ?>'size='5'> 라인
                        <?php echo help("목록(리스트) 한페이지당 라인수") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        최근게시물 스킨
                    </label>
                    <div class='col-sm-9'>
                        <select id='cf_new_skin' class='form-control' name='cf_new_skin' required itemname="최근게시물 스킨">
                            <?php
                            $arr = get_skin_dir("new");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_new_skin').value = "<?php echo $config[cf_new_skin] ?>";</script>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        최근게시물 라인수
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_new_rows' value='<?php echo $config[cf_new_rows] ?>'size='5'> 라인
                        <?php echo help("목록 한페이지당 라인수") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        검색 스킨
                    </label>
                    <div class='col-sm-9'>
                        <select id='cf_search_skin' class='form-control' name='cf_search_skin' required itemname="검색 스킨">
                            <?php
                            $arr = get_skin_dir("search");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_search_skin').value = "<?php echo $config[cf_search_skin] ?>";</script>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        접속자 스킨
                    </label>
                    <div class='col-sm-9'>
                        <select id='cf_connect_skin' class='form-control' name='cf_connect_skin' required itemname="접속자 스킨">
                            <?php
                            $arr = get_skin_dir("connect");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_connect_skin').value = "<?php echo $config[cf_connect_skin] ?>";</script>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        복사, 이동시 로그
                    </label>
                    <div class='col-sm-9'>
                        <input type='checkbox' name='cf_use_copy_log' value='1' <?php echo $config[cf_use_copy_log] ? 'checked' : ''; ?>> 남김
                        <?php echo help("게시물 아래에 누구로 부터 복사, 이동됨 표시") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        접근가능 IP
                    </label>
                    <div class='col-sm-9'>
                        <textarea class='form-control' name='cf_possible_ip' rows='5' ><?php echo $config[cf_possible_ip] ?> </textarea><br>입력된 IP의 컴퓨터만 접근할 수 있음.<br>123.123.+ 도 입력 가능. (엔터로 구분)
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        접근차단 IP
                    </label>
                    <div class='col-sm-9'>
                        <textarea class='form-control' name='cf_intercept_ip' rows='5' ><?php echo $config[cf_intercept_ip] ?> </textarea><br>입력된 IP의 컴퓨터는 접근할 수 없음.<br>123.123.+ 도 입력 가능. (엔터로 구분)
                    </div>
                </div>

            </div>

        </div>

        <!-- 게시판 설정 -->
        <div class='round-box tab-pane' id='board'>
            <div class="col-sm-12">
                <?php echo subtitle("게시판 설정") ?>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        글읽기 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_read_point' size='10' required itemname='글읽기 포인트' value='<?php echo $config['cf_read_point'] ?>'> 점
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        글쓰기 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_write_point' size='10' required itemname='글쓰기 포인트' value='<?php echo $config['cf_write_point'] ?>'> 점
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        코멘트쓰기 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_comment_point' size='10' required itemname='답변, 코멘트쓰기 포인트' value='<?php echo $config['cf_comment_point'] ?>'> 점
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        다운로드 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_download_point' size='10' required itemname='다운로드받기 포인트' value='<?php echo $config['cf_download_point'] ?>'> 점
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        LINK TARGET
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_link_target' size='10' value='<?php echo $config['cf_link_target'] ?>'> 
                        <?php echo help("게시판 내용중 자동으로 링크되는 창의 타켓을 지정합니다. _self, _top, _blank, _new 를 주로 지정합니다.") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        검색 단위
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_search_part' size='10' itemname='검색 단위' value='<?php echo $config['cf_search_part'] ?>'> 건 단위로 검색
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        검색 배경 색상
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_search_bgcolor' size='10' required itemname='검색 배경 색상' value='<?php echo $config['cf_search_bgcolor'] ?>'>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        검색 글자 색상
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_search_color' size='10' required itemname='검색 글자 색상' value='<?php echo $config['cf_search_color'] ?>'>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        새로운 글쓰기 
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_delay_sec' size='10' required itemname='새로운 글쓰기' value='<?php echo $config['cf_delay_sec'] ?>'> 초 지난후 가능
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        페이지 표시 수
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_write_pages' size='10' required itemname='페이지 표시 수' value='<?php echo $config['cf_write_pages'] ?>'> 페이지씩 표시
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        이미지 업로드 확장자
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-control' name='cf_image_extension' size='80' itemname='이미지 업로드 확장자' value='<?php echo $config['cf_image_extension'] ?>'>
                        <?php echo help("게시판 글작성시 이미지 파일 업로드 가능 확장자. | 로 구분") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        플래쉬 업로드 확장자
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-control' name='cf_flash_extension' size='80' itemname='플래쉬 업로드 확장자' value='<?php echo $config['cf_flash_extension'] ?>'>
                        <?php echo help("게시판 글작성시 플래쉬 파일 업로드 가능 확장자. | 로 구분") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        동영상 업로드 확장자
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-control' name='cf_movie_extension' size='80' itemname='동영상 업로드 확장자' value='<?php echo $config['cf_movie_extension'] ?>'>
                        <?php echo help("게시판 글작성시 동영상 파일 업로드 가능 확장자. | 로 구분") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        단어 필터링
                    </label>
                    <div class='col-sm-9'>
                        <textarea class='form-control' name='cf_filter' rows='7' ><?php echo $config['cf_filter'] ?> </textarea>
                        <?php echo help("입력된 단어가 포함된 내용은 게시할 수 없습니다. 단어와 단어 사이는 ,로 구분합니다.") ?>
                    </div>
                </div>
            </div>
        </div>
 
        <div class='round-box tab-pane' id='join'>
            <div class="col-sm-12">
                <?php echo subtitle("회원가입 설정") ?>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원 스킨
                    </label>
                    <div class='col-sm-9'>
                        <select id='cf_member_skin' name='cf_member_skin' class="form-control" required itemname="회원가입 스킨">
                            <?php
                            $arr = get_skin_dir("member");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_member_skin').value = "<?php echo $config['cf_member_skin'] ?>";</script>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        홈페이지 입력
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_homepage' value='1' <?php echo $config['cf_use_homepage'] ? 'checked' : ''; ?>> 보이기</label>
                        <label><input type='checkbox' name='cf_req_homepage' value='1' <?php echo $config['cf_req_homepage'] ? 'checked' : ''; ?>> 필수입력</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        주소 입력
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_addr' value='1' <?php echo $config['cf_use_addr'] ? 'checked' : ''; ?>> 보이기</label>
                        <label><input type='checkbox' name='cf_req_addr' value='1' <?php echo $config['cf_req_addr'] ? 'checked' : ''; ?>> 필수입력</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        전화번호 입력
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_tel' value='1' <?php echo $config['cf_use_tel'] ? 'checked' : ''; ?>> 보이기</label>
                        <label><input type='checkbox' name='cf_req_tel' value='1' <?php echo $config['cf_req_tel'] ? 'checked' : ''; ?>> 필수입력</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        핸드폰 입력
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_hp' value='1' <?php echo $config['cf_use_hp'] ? 'checked' : ''; ?>> 보이기</label>
                        <label><input type='checkbox' name='cf_req_hp' value='1' <?php echo $config['cf_req_hp'] ? 'checked' : ''; ?>> 필수입력</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        서명 입력
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_signature' value='1' <?php echo $config['cf_use_signature'] ? 'checked' : ''; ?>> 보이기</label>
                        <label><input type='checkbox' name='cf_req_signature' value='1' <?php echo $config['cf_req_signature'] ? 'checked' : ''; ?>> 필수입력</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        자기소개 입력
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_profile' value='1' <?php echo $config['cf_use_profile'] ? 'checked' : ''; ?>> 보이기</label>
                        <label><input type='checkbox' name='cf_req_profile' value='1' <?php echo $config['cf_req_profile'] ? 'checked' : ''; ?>> 필수입력</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원가입시 권한
                    </label>
                    <div class='col-sm-9'>
                        <?php echo get_member_level_select('cf_register_level', 1, 9, $config['cf_register_level']) ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원가입시 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_register_point' size='5' value='<?php echo $config['cf_register_point'] ?>'> 점
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원탈퇴후 삭제일
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_leave_day' size='5' value='<?php echo $config['cf_leave_day'] ?>'> 일 후 자동 삭제
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원아이콘 사용
                    </label>
                    <div class='col-sm-9'>
                        <select name='cf_use_member_icon' class="form-control"> 
                            <option value='0'>미사용
                            <option value='1'>아이콘만 표시
                            <option value='2'>아이콘+이름 표시
                        </select>
                        <?php echo help("게시물에 게시자 별명 대신 아이콘 사용") ?>
                        <script type='text/javascript'> document.fconfigform.cf_use_member_icon.value = '<?php echo $config['cf_use_member_icon'] ?>';</script>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        아이콘 업로드 권한
                    </label>
                    <div class='col-sm-9'>
                        <?php echo get_member_level_select('cf_icon_level', 1, 9, $config['cf_icon_level']) ?> 이상
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원아이콘 용량
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_member_icon_size' size='5' value='<?php echo $config['cf_member_icon_size'] ?>'> 바이트 이하
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원아이콘 사이즈
                    </label>
                    <div class='col-sm-9'>
                        폭 <input type='text' class='form-inline' name='cf_member_icon_width' size='5' value='<?php echo $config['cf_member_icon_width'] ?>'>
                        픽셀 , 높이 <input type='text' class='form-inline' name='cf_member_icon_height' size='5' value='<?php echo $config[cf_member_icon_height] ?>'> 픽셀 이하
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        추천인제도 사용
                    </label>
                    <div class='col-sm-9'>
                        <label><input type='checkbox' name='cf_use_recommend' value='1' <?php echo $config[cf_use_recommend] ? 'checked' : ''; ?>> 사용</label>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        추천인 포인트
                    </label>
                    <div class='col-sm-9'>
                        <input type='text' class='form-inline' name='cf_recommend_point' size='5' value='<?php echo $config[cf_recommend_point] ?>'> 점
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        아이디,별명 금지단어
                    </label>
                    <div class='col-sm-9'>
                        <textarea class='form-control' name='cf_prohibit_id' rows='5' ><?php echo $config[cf_prohibit_id] ?></textarea>
                        <?php echo help("입력된 단어가 포함된 내용은 회원아이디, 별명으로 사용할 수 없습니다.\n\n단어와 단어 사이는 , 로 구분합니다.") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        입력 금지 메일
                    </label>
                    <div class='col-sm-9'>
                        <textarea class='form-control' name='cf_prohibit_email' rows='5' ><?php echo $config[cf_prohibit_email] ?> </textarea><?php echo help("hanmail.net과 같은 메일 주소는 입력을 못합니다.\n\n엔터로 구분합니다.") ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원가입약관
                    </label>
                    <div class='col-sm-9'>
                        <textarea class='form-control' name='cf_stipulation' rows='10' ><?php echo $config[cf_stipulation] ?> </textarea>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        개인정보취급방침
                    </label>
                    <div class='col-sm-9'>
                        <textarea class='form-control' name='cf_privacy' rows='10' ><?php echo $config[cf_privacy] ?></textarea>
                    </div>
                </div>
            </div>
        </div>
 
        <div class='round-box tab-pane' id='mail'>
            <div class="col-sm-12">
                <?php echo subtitle("메일 설정") ?>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        메일발송 사용
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_use value='1' <?php echo $config[cf_email_use] ? 'checked' : ''; ?>> 사용 (체크하지 않으면 메일발송을 아예 사용하지 않습니다. 메일 테스트도 불가합니다.)
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        메일인증 사용
                    </label>
                    <div class='col-sm-9'>
                        <input type='checkbox' name='cf_use_email_certify' value='1' <?php echo $config[cf_use_email_certify] ? 'checked' : ''; ?>> 사용
                        <?php echo help("메일에 배달된 인증 주소를 클릭하여야 회원으로 인정합니다."); ?>
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        폼메일 사용 여부
                    </label>
                    <div class='col-sm-9'>
                        <input type='checkbox' name='cf_formmail_is_member' value='1' <?php echo $config[cf_formmail_is_member] ? 'checked' : ''; ?>> 회원만 사용
                        <?php echo help("체크하지 않으면 비회원도 사용 할 수 있습니다.") ?>
                    </div>
                </div>
                <?php echo subtitle("게시판 글작성시") ?>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        최고관리자 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_wr_super_admin value='1' <?php echo $config[cf_email_wr_super_admin] ? 'checked' : ''; ?>> 사용 (최고관리자에게 메일을 발송합니다.)
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        그룹관리자 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_wr_group_admin value='1' <?php echo $config[cf_email_wr_group_admin] ? 'checked' : ''; ?>> 사용 (그룹관리자에게 메일을 발송합니다.)
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        게시판관리자 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_wr_board_admin value='1' <?php echo $config[cf_email_wr_board_admin] ? 'checked' : ''; ?>> 사용 (게시판관리자에게 메일을 발송합니다.)
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        원글 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_wr_write value='1' <?php echo $config[cf_email_wr_write] ? 'checked' : ''; ?>> 사용 (게시자님께 메일을 발송합니다.)
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        코멘트 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_wr_comment_all value='1' <?php echo $config[cf_email_wr_comment_all] ? 'checked' : ''; ?>> 사용 (원글에 코멘트가 올라오는 경우 코멘트 쓴 모든 분들께 메일을 발송합니다.)
                    </div>
                </div>
                <?php echo subtitle("회원 가입시") ?>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        최고관리자 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_mb_super_admin value='1' <?php echo $config[cf_email_mb_super_admin] ? 'checked' : ''; ?>> 사용 (최고관리자에게 메일을 발송합니다.)
                    </div>
                </div>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        회원님께 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_mb_member value='1' <?php echo $config[cf_email_mb_member] ? 'checked' : ''; ?>> 사용 (회원가입한 회원님께 메일을 발송합니다.)
                    </div>
                </div>
                <?php echo subtitle("투표 기타의견 작성시") ?>
                <div class='form-group'>
                    <label for='' class='col-sm-3 control-label'>
                        최고관리자 메일발송
                    </label>
                    <div class='col-sm-9'>
                        <input type=checkbox name=cf_email_po_super_admin value='1' <?php echo $config[cf_email_po_super_admin] ? 'checked' : ''; ?>> 사용 (최고관리자에게 메일을 발송합니다.)
                    </div>
                </div>
            </div>
        </div>
 
        <div class='round-box tab-pane' id='ext'>
            <div class="col-sm-12">
                <?php echo subtitle("여분 필드") ?>
                <?php for ($i = 1; $i <= 10; $i++) { ?>
                    <div class='form-group'>
                        <label for='' class='col-sm-3 '>
                            <input type='text' class='form-control' name='cf_<?php echo $i ?>_subj' value='<?php echo get_text($config["cf_{$i}_subj"]) ?>' title='여분필드 <?php echo $i ?> 제목' placeholder="<?php echo $i?>번 여분필드제목">
                        </label>
                        <div class='col-sm-9'>
                            <input type='text' class='form-control' name=cf_<?php echo $i ?> value='<?php echo $config["cf_$i"] ?>' title='여분필드 <?php echo $i ?> 설정값'>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>

 
        <div class='round-box tab-pane' id='mobile'>
            <div class="col-sm-12">
                <?php echo subtitle('모바일설정') ?>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_cut_name">별명글자수</label>
                    <div class="col-sm-9">
                        <input type='text' id="cf_m_cut_name" name='cf_m_cut_name' value='<?php echo $config['cf_m_cut_name'] ?>' size='2' class="form-control"/>
                        <p class="help-block">별명을 설정한 자릿수만큼 출력한다.</p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_page_rows">목록 줄수</label>
                    <div class="col-sm-9">
                        <input type='text' id="cf_m_page_rows" name='cf_m_page_rows' value='<?php echo $config['cf_m_page_rows'] ?>' size='5' class="form-control"/>
                        <p class="help-block">쪽지,게시판관리자의 게시판목록 등의 줄수 설정</p>  
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_new_rows">최근게시물</label>
                    <div class="col-sm-9">
                        <input type='text' id="cf_m_new_rows" name='cf_m_new_rows' value='<?php echo $config['cf_m_new_rows'] ?>' size='5' class="form-control"/>
                        <p class="help-block">최근게시물 라인수 라인 new.php</p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_site_skin">사이트 스킨</label>
                    <div class="col-sm-9">
                        <select id='cf_m_site_skin' name='cf_m_site_skin' required itemname="사이트 스킨" class="form-control">
                            <?php
                            $arr = get_siteskin_dir();
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_m_site_skin').value="<?php echo $config['cf_m_site_skin'] ?>";</script>
                        <p class="help-block">css, javascript 등을 siteskin/폴더명 으로 업로드한다.  basic 폴더 참고</p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_new_skin">최근게시물 스킨</label>
                    <div class="col-sm-9">
                        <select id='cf_m_new_skin' name='cf_m_new_skin' required itemname="최근게시물 스킨" class="form-control">
                            <?php
                            $arr = get_mskin_dir("new");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_m_new_skin').value="<?php echo $config['cf_m_new_skin'] ?>";</script>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_search_skin">검색스킨</label>
                    <div class="col-sm-9">
                        <select id='cf_m_search_skin' name='cf_m_search_skin' required itemname="검색 스킨" class="form-control">
                            <?php
                            $arr = get_mskin_dir("search");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_m_search_skin').value="<?php echo $config['cf_m_search_skin'] ?>";</script>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_connect_skin">접속자 스킨</label>
                    <div class="col-sm-9">
                        <select id='cf_m_connect_skin' name='cf_m_connect_skin' required itemname="접속자 스킨" class="form-control">
                            <?php
                            $arr = get_mskin_dir("connect");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_m_connect_skin').value="<?php echo $config['cf_m_connect_skin'] ?>";</script>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_member_skin">회원 스킨</label>
                    <div class="col-sm-9">
                        <select id='cf_m_member_skin' name='cf_m_member_skin' required itemname="회원가입 스킨" class="form-control">
                            <?php
                            $arr = get_mskin_dir("member");
                            for ($i = 0; $i < count($arr); $i++) {
                                echo "<option value='{$arr[$i]}'>{$arr[$i]}</option>\n";
                            }
                            ?>
                        </select>
                        <script type="text/javascript"> document.getElementById('cf_m_member_skin').value="<?php echo $config['cf_m_member_skin'] ?>";</script>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3" for="cf_m_write_pages">페이지 표시</label>
                    <div class="col-sm-9">
                        <input type='text' id="cf_m_write_pages" name='cf_m_write_pages' size='10' required itemname='페이지 표시 수' value='<?php echo $config['cf_m_write_pages'] ?>' class="form-control"/> 
                        <p class="help-block">페이지 네비게이션 출력수</p>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <?php echo subtitle("XSS / CSRF 방지") ?>

            <div class='form-group'>
                <label for='' class='col-sm-3 control-label'>
                    관리자 패스워드
                </label>
                <div class='col-sm-9'>
                    <input class='form-control' type='password' name='admin_password' itemname="관리자 패스워드" required>
                    <?php echo help("<br/>관리자 권한을 빼앗길 것에 대비하여 로그인한 관리자의 패스워드를 한번 더 묻는것 입니다."); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="form-action">
        <button type='submit' class='btn btn-primary btn-100'>확인</button>
    </div>

</form>

<script type="text/javascript">
    function fconfigform_submit(f)
    {
        f.action = "./config_form_update.php";
        return true;
    }
</script>

<?php
include_once ("./admin.tail.php");
?>
