<?php
if (!defined("_GNUBOARD_"))
    exit; // 개별 페이지 접근 불가 
$list_count = count($list);
?>
<div class="g4memo_basic">
    <div class="page-header">
        <h1>쪽지함</h1>
    </div>
    <div class="btn-box">
        <div class="pull-left">
            <a href="./memo.php?kind=recv" class="btn btn-info" title="받은쪽지">받음</a>
            <a href="./memo.php?kind=send" class="btn btn-default" title="보낸쪽지">보냄</a>
        </div>
        <div class="pull-right" style="text-align: right">
            <a href="./memo_form.php" class="btn btn-primary pull-right" title="쪽지보내기">보내기</a>
        </div>
        <div class="clearfix"></div>
    </div>
    <div class="panel panel-default">
        <div class='panel-heading'>
            전체 <?php echo $kind_title ?> 쪽지 <span class='badge'><?php echo $total_count ?></span>통
        쪽지 보관일수는 최장 <?php echo $config['cf_memo_del'] ?>일 입니다.
        </div>
        <ul class="memo_list list-group">
            <?php
            for ($i = 0; $i < $list_count; $i++) {
                if ($list[$i]['me_read_datetime'] == "0000-00-00 00:00:00") {
                    $chk_read = "not-read";
                } else {
                    $chk_read = "read";
                }
                ?>
                <li class="<?php echo $chk_read?> list-group-item">
                    <a href="<?php echo $list[$i]['view_href'] ?>">
                        <span class="se_subject"><?php echo cut_str($list[$i]['me_memo'], '40') ?></span>
                        <br />
                        <span class="se_nick">보낸이 : <?php echo $list[$i]['mb_nick'] ?></span>
                        <span class="se_date"><?php echo $list[$i]['send_datetime'] ?></span>  
                    </a>
                    <p class="me_del"><button type="button" onclick="del('<?php echo $list[$i]['del_href'] ?>');" class="btn btn-danger btn-mini">삭제</button></p>
                </li>
            <?php } ?>

            <?php
            if ($list_count == 0) {
                echo "<li><span>자료가 없습니다.</span></li>";
            }
            ?>
        </ul>
    </div>

    <div id="paging" style="text-align: center">
        <?php
        $page = str_replace("처음", "&lt;&lt;", $page);
        $page = str_replace("이전", "&lt;", $page);
        $page = str_replace("다음", "&gt;", $page);
        $page = str_replace("맨끝", "&gt;&gt;", $page);
        echo $page;
        ?>
    </div>
</div>