<?
    /* ============================================================================== */
    /* =   PAGE : 에스크로 구매확인 후 취소 요청 및 결과 처리 PAGE                  = */
    /* = -------------------------------------------------------------------------- = */
    /* =   연동시 오류가 발생하는 경우 아래의 주소로 접속하셔서 확인하시기 바랍니다.= */
    /* =   접속 주소 : http://kcp.co.kr/technique.requestcode.do                    = */
    /* = -------------------------------------------------------------------------- = */
    /* =   Copyright (c)  2013   KCP Inc.   All Rights Reserverd.                   = */
    /* ============================================================================== */


    /* ============================================================================== */
    /* =   환경 설정 파일 Include                                                   = */
    /* = -------------------------------------------------------------------------- = */
    /* =   ※ 필수                                                                  = */
    /* =   테스트 및 실결제 연동시 site_conf_inc.php파일을 수정하시기 바랍니다.     = */
    /* = -------------------------------------------------------------------------- = */

    include "../cfg/site_conf_inc.php";        // 환경설정 파일 include
    require "pp_cli_hub_lib.php";              // library [수정불가]

    /* = -------------------------------------------------------------------------- = */
    /* =   환경 설정 파일 Include END                                               = */
    /* ============================================================================== */
?>

<?
    /* ============================================================================== */
    /* =   01. 구매후 취소 요청 정보 설정                                           = */
    /* = -------------------------------------------------------------------------- = */
    $req_tx         = $_POST[ "req_tx"         ]; // 요청 종류
    $cust_ip        = getenv( "REMOTE_ADDR"    ); // 요청 IP
    $tran_cd        = "";                         // 처리 종류
    $res_cd         = "";                         // 응답코드
    $res_msg        = "";                         // 응답메시지
    /* ============================================================================== */
    $TradeDt        = "";                         // 취소요청시간
    $mod_method     = $_POST[ "mod_method"     ]; // 결제수단
    $tno            = $_POST[ "tno"            ]; // KCP 거래 고유 번호
    $mod_desc       = $_POST[ "mod_desc"       ]; // 변경사유
    $mod_depositor  = $_POST[ "mod_depositor"  ]; // 환불계좌주명(환불시에만 사용)
    $mod_account    = $_POST[ "mod_account"    ]; // 환불계좌번호(환불시에만 사용)
    $mod_bankcode   = $_POST[ "mod_bankcode"   ]; // 은행코드    (환불시에만 사용)
    $mod_type       = $_POST[ "mod_type"       ]; // 취소구분
    $mod_sub_type   = $_POST[ "mod_sub_type"   ]; // 취소상세구분
    $sub_mod_type   = $_POST[ "sub_mod_type"   ]; // 취소유형

    /* = -------------------------------------------------------------------------- = */
    /* =   01. 구매후 취소 요청 정보 설정 END                                       = */
    /* ============================================================================== */

    /* ============================================================================== */
    /* =   02. 인스턴스 생성 및 초기화(변경 불가)                                   = */
    /* = -------------------------------------------------------------------------- = */
    /* =               결제에 필요한 인스턴스를 생성하고 초기화 합니다.             = */
    /* =               ※ 주의 ※ 이 부분은 변경하지 마십시오                       = */
    /* = -------------------------------------------------------------------------- = */
    $c_PayPlus = new C_PP_CLI;
    $c_PayPlus->mf_clear();
    /* ------------------------------------------------------------------------------ */
    /* =   02. 인스턴스 생성 및 초기화 END                                          = */
    /* ============================================================================== */


    /* ============================================================================== */
    /* =   03. 처리 요청 정보 설정                                                  = */
    /* = -------------------------------------------------------------------------- = */
    /* = -------------------------------------------------------------------------- = */
    /* =   03-1. 에스크로 상태변경 요청                                             = */
    /* = -------------------------------------------------------------------------- = */
    if ($req_tx = "mod_escrow")
    {
        $tran_cd = "70200200";

        $c_PayPlus->mf_set_modx_data( "tno",      $tno      );                      // KCP 원거래 거래번호
        $c_PayPlus->mf_set_modx_data( "mod_ip",   $cust_ip  );                      // 변경 요청자 IP
        $c_PayPlus->mf_set_modx_data( "mod_desc", $mod_desc );                      // 변경 사유
        $c_PayPlus->mf_set_modx_data( "mod_type", $mod_type );                      // 원거래 변경 요청 종류
        $c_PayPlus->mf_set_modx_data( "mod_desc_cd", "CA06" );                      // 취소사유코드 ( 변경 불가 );
        $c_PayPlus->mf_set_modx_data( "sub_mod_type", $sub_mod_type );              // 취소상세구분
        $c_PayPlus->mf_set_modx_data( "mod_sub_type", $mod_sub_type );              // 취소유형


        /* 가상계좌 환불 */
        if ($mod_method == "VCNT")
        {
            $c_PayPlus->mf_set_modx_data( "mod_bankcode",   $mod_bankcode       );
            $c_PayPlus->mf_set_modx_data( "mod_account",    $mod_account        );
            $c_PayPlus->mf_set_modx_data( "mod_depositor",  $mod_depositor      );
        }

    }
    /* = -------------------------------------------------------------------------- = */
    /* =   03. 에스크로 상태변경 요청 END                                           = */
    /* = -------------------------------------------------------------------------- = */
     
    /* ============================================================================== */
    /* =   04. 실행                                                                 = */
    /* = -------------------------------------------------------------------------- = */
    if ( $tran_cd != "" )
    {

        $c_PayPlus->mf_do_tx( $trace_no, $g_conf_home_dir, $g_conf_site_cd, $g_conf_site_key, $tran_cd, "",
                              $g_conf_gw_url, $g_conf_gw_port, "payplus_cli_slib", $ordr_idxx,
                              "", "3" , 0, 0, $g_conf_key_dir, $g_conf_log_dir); // 응답 전문 처리

        $res_cd  = $c_PayPlus->m_res_cd;  // 결과 코드
        $res_msg = $c_PayPlus->m_res_msg; // 결과 메시지

    }
    else
    {
        $c_PayPlus->m_res_cd  = "9562";
        $c_PayPlus->m_res_msg = "연동 오류|Payplus Plugin이 설치되지 않았거나 tran_cd값이 설정되지 않았습니다.";
    }
    
    /* = -------------------------------------------------------------------------- = */
    /* =   04. 실행 END                                                             = */
    /* ============================================================================== */


    /* ================================================================================== */
    /* =   05.구매확인 후 취소 성공 결과 처리										    = */
    /* = ------------------------------------------------------------------------------ = */
    if ( $req_tx == "mod" )
    {
        if( $res_cd == "0000" )
        {
        } // End of [res_cd = "0000"]


    /* ================================================================================== */
    /* =   05.구매확인 후 취소 실패 결과 처리                                          = */
    /* ================================================================================== */
        else
        {
        }
    } // End of Process


    //* ============================================================================= */
    /* =   05. 폼 구성 및 결과페이지 호출                                           = */
    /* = -------------------------------------------------------------------------- = */

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
    <head>
        <title>*** KCP [AX-HUB Version] ***</title>
        <script type="text/javascript">
            function goResult()
            {
                document.mod_info.submit();
                openwin.close();
            }

            // 결제 중 새로고침 방지 샘플 스크립트
            function noRefresh()
            {
                /* CTRL + N키 막음. */
                if ((event.keyCode == 78) && (event.ctrlKey == true))
                {
                    event.keyCode = 0;
                    return false;
                }
                /* F5 번키 막음. */
                if(event.keyCode == 116)
                {
                    event.keyCode = 0;
                    return false;
                }
            }
            document.onkeydown = noRefresh ;
        </script>
    </head>

    <body onload="goResult();" >
    <form name="mod_info" method="post" action="./result.php">
        <input type="hidden" name="res_cd"            value="<?= $res_cd ?>">           <!-- 결과 코드 -->
        <input type="hidden" name="res_msg"           value="<?= $res_msg?>">           <!-- 결과 메세지 -->
    </form>
    </body>
</html>

