<?php
if (!defined("_GNUBOARD_"))
    exit; // 개별 페이지 접근 불가 
?>
<div class="g4formmail_basic">
    <div class="page-header">
        <h1><?php echo $g4['title'] ?></h1>
    </div>

    <p class="alert alert-info"><?php echo $name ?>님께 메일보내기</p>

    <form name="fformmail" method="post" onsubmit="return fformmail_submit(this);" enctype="multipart/form-data" style="margin:0px;" action="" class="form-horizontal">
        <fieldset>
            <input type="hidden" name="to"     value="<?php echo $email ?>"/>
            <input type="hidden" name="attach" value="2"/>
            <input type="hidden" name="token"  value="<?php echo $token ?>"/>
            <legend class="hide">메일 보내기</legend>

            <?php if ($is_member) { // 회원이면  ?>    
                <input type='hidden' name='fnick'  value='<?php echo $member['mb_nick'] ?>'/>
                <input type='hidden' name='fmail'  value='<?php echo $member['mb_email'] ?>'/>
            <?php } else { ?>
                <div class="control-group">
                    <label class="control-label" for="">이름</label>
                    <div class="controls">
                        <input type='text' class="input-large" name='fnick' required minlength=2 itemname='이름'/>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="">Email</label>
                    <div class="controls">
                        <input type="text" class="input-large" name='fmail' required email itemname='E-mail'/>
                        <p class="help-block"></p>
                    </div>
                </div>
                

            <?php } ?>

                <div class="control-group">
                    <label class="control-label" for="">제목</label>
                    <div class="controls">
                        <input type="text" class="input-large" name='subject' required itemname='제목'/>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="">선택</label>
                    <div class="controls">
                        <label for="mail_0"><input type='radio' name='type' value='0' checked id="mail_0"/> TEXT</label>
                        <label for="mail_1"><input type='radio' name='type' value='1' id="mail_1" />  HTML</label>
                        <label for="mail_2"><input type='radio' name='type' value='2' id="mail_2" />  TEXT+HTML</label>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="">내용</label>
                    <div class="controls">
                        <textarea name="content" class="input-large" rows='9' required itemname='내용'></textarea>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="">첨부파일</label>
                    <div class="controls">
                         #1 <input type='file' name='file1'/><br/>
                         #2 <input type='file' name='file2'/>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for=""><img id='kcaptcha_image' /></label>
                    <div class="controls">
                        <input type="input" size='10' name='wr_key' itemname="자동등록방지" required />
                        <p class="help-block">왼쪽(위) 글자입력</p>
                    </div>
                </div>
            <div class="form-actions">
                <button id='btn_submit' type='submit' class='btn btn-primary'/>보내기</button>
            </div>
        </fieldset>
    </form>
</div>

<script type="text/javascript" src="<?php echo"{$g4['path']}/js/md5.js" ?>"></script>
<script type="text/javascript" src="<?php echo"{$g4['g4m_path']}/js/jquery.kcaptcha.js" ?>"></script>
<script type="text/javascript">
    with (document.fformmail) {
        if (typeof fname != "undefined")
            fname.focus();
        else if (typeof subject != "undefined")
            subject.focus();
    }

    function fformmail_submit(f)
    {
        if (!check_kcaptcha(f.wr_key)) {
            return false;
        }

        if (f.file1.value || f.file2.value) {
            // 4.00.11
            if (!confirm("첨부파일의 용량이 큰경우 전송시간이 오래 걸립니다.\n\n메일보내기가 완료되기 전에 창을 닫거나 새로고침 하지 마십시오."))
                return false;
        }

        document.getElementById('btn_submit').disabled = true;

        f.action = "./formmail_send.php";
        return true;
    }
</script>