<?
/* 모듈을 불러오고 객체를 생성한다.
   SMS를 보내기 위한 함수를 정의하고 SMS 정보를 담는 변수를 선언한다.

   $oSms		: SMS 모듈로 선언된 객체
   $zm_sms[residual]	: SMS 남은 건수
*/

//-- 문자열 자르기 ------------------------------
function arrStr($str, $len=90, $charset="euc-kr") {
	$s			= "";
	$aStr		= "";		//-- 자른 문자열이 들어갈 배열
	$cnt		= 0;
	$startno	= 0;		//-- 자르게 될 문자의 시작 위치
	$len		= 90;		//-- 자르게 될 문자의 길이
	$repStr		= intval(strlen($str) / $len) + 1;

	$s			= substr($str, $startno, $len);
	for($j = 0; $j < $repStr; $j++) {
		$s			= mb_strcut($str, $startno, $len, $charset);
		$startno	= $startno * $j + $len;
		if(strlen($s) < $len) $startno--;
		$aStr[$j]	= $s;
	}

	return $aStr;
}

//-- 선택한 모듈 불러오기 -----------------------

//-- 통큰아이 -------------------------------------------------------------------------------------
if($zm_sms[sms_module] == "tongkni") {						//-- 통큰아이 모듈
	if($g4[charset] == "euc-kr")	$smsmdl	= $g4[path] . "/zm.extend/sms/tongkni/nusoap_tong_euc.php";				//-- 캐릭터셋이 EUC-KR일 대
	else							$smsmdl	= $g4[path] . "/zm.extend/sms/tongkni/nusoap_tong.php";					//-- 캐릭터셋이 UTF-8일 때
	include_once($smsmdl);

	$webService = "http://webservice.tongkni.co.kr/sms.3/ServiceSMS.asmx?WSDL";
	$oSms = new SMS($webService);												//-- SMS 객체 생성

	$zm_sms[residual]		= $oSms->GetRemainCount($zm_sms[sms_tki_id], $zm_sms[sms_tki_pw]);
	if($zm_sms[residual] == "0")		$zm_sms[residual]		= "남은 문자가 없습니다.";
	elseif($zm_sms[residual] == "-5")	$zm_sms[residual]		= "비밀번호를 확인 해 주세요";
	elseif($zm_sms[residual] > "0")		$zm_sms[residual]		= number_format($zm_sms[residual]) . " 건";
	else	$zm_sms[residual] = "SMS 등록 아이디/비밀번호를 올바르게 입력해 주세요.";

	//-- SMS 전송 함수 --------------------------
	/*
	받는사람 전화번호, 받는 사람 이름, 보내는 사람 전화번호, 보내는 사람 이름, 문자 내용, 긴문자(1:90바이트만, 2:90씩 나눠서 여러번), 예약전송 여부(1:즉시전송, 2:예약전송), 예약시간[YYYYMMDD][hhmmss], sms 모듈, sms 아이디, sms 비번
	return $result; $result -> "1/실패한 문자 번호@로 구분한 문자열"; // 1:성공, 2:실패. 성공일 때 /뒤의 값은 없음
	*/
	function sendsms($toPcs, $toName, $fromPcs, $fromName, $msg, $cutstring=1, $resvSend=1, $resvTime="") {
		global	$oSms, $zm_sms, $g4, $member;

		$smsId		= $zm_sms[sms_tki_id];
		$smsPw		= $zm_sms[sms_tki_pw];
		$arToPcs	= explode("@", $toPcs);				//-- 받는 사람 (배열)
		$arToName	= explode("@", $toName);			//-- 받는 사람
		$faillist	= "";
		$SndSw		= 0;								//-- 일단 발송 실패
		$userdefine	= "ziumsoft";						//-- 예약 취소를 위한 구분자

		$tmpTime	= explode("_", $resvTime);
		$resvDate	= $tmpTime[0];
		$resvTime	= $tmpTime[1]."00";

		if($g4[charset] == "euc-kr") iconv("euc-kr", "utf-8", $msg);

	
		//-- 문자를 90Byte 단위로 쪼개기
		$aMsg		= arrStr($msg, 90, $g4[charset]);

		if($cutstring == 1)	$cntMsg	= 1;
		else				$cntMsg = count($aMsg);

		for($i = 0; $i < count($arToPcs); $i++) {
			//-- 받는 사람의 전화번호가 공란이 아닐 때
			if($arToPcs[$i]) {							//-- 전화번호 갯수만큼 전송 실행
				for($j = $cntMsg; $j >= 0; $j--) {
					if($aMsg[$j]) {
						if($resvSend == "2")	
							$res	= $oSms->SendSMSReserve($smsId, $smsPw, $fromPcs, $arToPcs[$i], $aMsg[$j], $resvDate, $resvTime, $userdefine);		//--문자 예약 전송
						else					
							$res	= $oSms->SendSMS($smsId, $smsPw, $fromPcs, $arToPcs[$i], $aMsg[$j]);										//--문자 즉시 전송

						if ($res == "1")		{		$strMsg		= " [전송 성공]";				$SndSw		= 1;	}
						elseif ($res == "0")		$strMsg		= " [잔여량부족]";
						elseif ($res == "-1")		$strMsg		= " [아이디/패스워드 이상]";
						elseif ($res == "-50")		$strMsg		= " [전화번호이상]";
						elseif ($res == "-13")		$strMsg		= " [스팸동의서 미발송]";
						elseif ($res == "-10")		$strMsg		= " [예약날짜 이상 $resvDate $resvTime]";
						elseif ($res == "-11")		$strMsg		= " [예약시간 이상 $resvDate $resvTime]";
						elseif ($res == "-3")		$strMsg		= " [예약 가능 시간 지남]";
						else						$strMsg		= " [전송 실패]";

						if($res <= 0) { $faillist .= "@" . $arToPcs[$i]; }

						//-- 전송 성공 시 History에 기록
						if($res > 0 || 1) {
							$resvtime	= $resvDate . $resvTime;
							smshistory("$fromName", "$fromPcs", "$arToName[$i]", "$arToPcs[$i]", "$msg", "$resvSend", "$resvtime");
						}
					}
				}
			}
		}

		$result		= $SndSw . "/" . $faillist . "/" . $strMsg;
		return $result;
	}

}
//-------------------------------------------------------------------------------------------------
/*
//-- 다른 SMS 모듈을 추가 했을 때 아래 형식대로 추가
if($zm_sms[sms_module] == "sms_xxxxx") {						//-- 
	include_once("./sms_module/new_sms_module.php");
}
*/

?>