<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//Ticker Load
if(!defined('AMINA_TICKER')) include_once(AMINA_PATH.'/app/ticker.php');

if (!defined('LAL_BASIC_TICKER')) {
	define('LAL_BASIC_TICKER', true);
	echo '<link rel="stylesheet" href="'.$latest_list_url.'/latest.list.css">'."\n";
}

//FA Icon
$fa = array("cate"=>"tag", "name"=>"user", "date"=>"clock-o", "cmt"=>"+;t", "hit"=>"eye", "good"=>"thumbs-up", "nogood"=>"thumbs-down", "star"=>"", "view"=>"leaf", "down"=>"download");
$dList = array();

//Default Value;
$opt['subj'] = ($opt['subj'] > 0) ? $opt['subj'] : $subject_len; //Subject Length
$opt['date'] = $opt['date'] ? $opt['date'] : 1; //Date Type
$opt['star_type'] = $opt['star_type'] ? $opt['star_type'] : 's'; //Star Type
if(!$opt['subj_icon']) $opt['subj_icon'] = $opt['icon'] ? '1' : 'chevron-circle-right';

//Comment
$is_subj_cmt = ($opt['subj_cmt'] && $opt['subj_cmt'] != 'none') ? true : false;

//Subj Type
$is_cmt_gul = (($opt['type'] == "newcmt" || $opt['type'] == "cmt") && $opt['subj_type']) ? true : false;

//Rank
$is_rank = ($opt['order'] && $opt['rank_icon'] != 'none' && ($opt['type'] != "newgul" && $opt['type'] != "newcmt" && $opt['type'] != "newcmtgul")) ? true : false;

$rank_url = '';
if($is_rank && $opt['rank_icon']) {
	$opt['rank_icon'] = $opt['rank_icon'] ? $opt['rank_icon'] : 'basic';
	$rank_url = AMINA_URL.'/misc/icon/list-rank/'.$opt['rank_icon'];
	$rank_ext = (file_exists(AMINA_PATH.'/misc/icon/list-rank/'.$opt['rank_icon'].'/1.gif')) ? '.gif' : '.png';
}

//Icon
$icon_url = '';
if($opt['icon'] && $opt['icon'] != "none") {
	$opt['icon'] = $opt['icon'] ? $opt['icon'] : 'basic';
	$icon_url = AMINA_URL.'/misc/icon/list-icon/'.$opt['icon'];
	$icon_ext = (file_exists(AMINA_PATH.'/misc/icon/list-icon/'.$opt['icon'].'/icon-new.gif')) ? '.gif' : '.png';
}

//Details
$dCount = 0;
if($opt['details']) {
	$dList = explode(";", $opt['details']);
	$dCount = count($dList);
}

//fancyBox
$fbox_w = $fbox_q = '';
if($opt['fbox']) {
	if($opt['fbox'] == 'full') {
		$fbox_w = 'class="fbox-full" ';
	} else {
		$fbox_w = 'class="fbox-win" ';
		$fbox_q = '&frame=2';

		if($opt['fbox'] > 1) {
			$fbox_w .= 'data-fbox-width="'.$opt['fbox'].'" ';
			$fbox_q .= '&fwidth='.$opt['fbox'];
		}
	}
} 

$opt['speed'] = $opt['speed'] ? $opt['speed'] : 700; //스크롤 스피드
$opt['pause'] = $opt['pause'] ? $opt['pause'] : 2000; //잠시 대기 시간
$opt['down'] = $opt['down'] ? '' : 'up'; //up=위로스크롤, 공란=아래로 스크롤
$opt['show'] = $opt['show'] ? $opt['show'] : 1; //스크롤 목록 갯수 지정(1=한줄만 보임)

//ID 랜덤 설정
$chars_array = range('l','z');
shuffle($chars_array);
$la_id = implode('', $chars_array);

//랜덤출력
if($opt['rdm']) shuffle($list);

//추출글 갯수
$list_num = count($list);

?>

<div class="<?php echo $la_id; ?><?php echo $opt['list'] ? ' '.$opt['list'] : ''; ?>">
	<div id="<?php echo $la_id; ?>" class="lal-basic-ticker">
		<ul>
		<?php for ($i=0; $i < $list_num; $i++) { 
			//Value
			$wr_post = amina_array_write($list[$i]['wr_10']);
			$wr_icon = amina_array_icon($list[$i]['wr_5']);
			$list[$i]['wr_view_point'] = $wr_icon['po_view_point'];
			$list[$i]['wr_down_point'] = $wr_icon['po_down_point'];

			if($is_cmt_gul) {
				$list[$i]['wr_subject'] = $list[$i]['wr_post']; //원글제목
				$cmt_cnt = $list[$i]['wr_post_cmt']; //원글 댓글수
			} else {
				$cmt_cnt = $list[$i]['wr_comment'];
			}

			//Blind & Secret
			$is_blind = false;
			if($list[$i]['wr_9'] == "lock" || $list[$i]['wr_9'] == "shingo") {
				$is_blind = true;
				$list[$i]['wr_subject'] = $list[$i]['wr_content'] = $list[$i]['wr_3'] = '블라인드 처리된 글입니다.';
			} else if ($list[$i]['icon_secret']) {
				$list[$i]['wr_content'] = $list[$i]['wr_3'] = '비밀글입니다.';
			}

			//Href
			$a_href = $fbox_w.'href="'.$list[$i]['href'].$fbox_q.$list[$i]['href_cmt'].'"'.$opt['href_target'];

			//Details
			$details_item = '';
			$details_css = 'la-data-first';
			for($k=0; $k < $dCount; $k++) {
				$dItem = $dList[$k];
				$dItem_var = amina_details($dItem, $list[$i], $opt['date'], $opt['star'], $opt['star_type']);
				$dItem_var = $dItem_var ? amina_icon($fa[$dItem]).$dItem_var : '';
				$details_item .= '<b class="'.$details_css.' la-data-'.$dItem.'">'.$dItem_var.'</b>';
				$details_css = 'la-data';
			}

			if($details_item) $details_item = '<span class="la-details">'.$details_item.'</span>';

			//Post Icon
			$post_icon = '';
			if($opt['icon'] != "none") {
				$post_icon = $opt['subj_icon'];
				if($is_rank) { //Rank
					$post_icon = $rank_url ? '<img src="'.$rank_url.'/'.$list[$i]['wr_rank'].$rank_ext.'" alt="">' : '<span class="la-rank la-rank-'.$list[$i]['wr_rank'].'">'.$list[$i]['wr_rank'].'</span>';
				} else if($post_icon) {
					if($is_blind) {
						$post_icon = $icon_url ? 'icon-blind' : 'eye-slash';
					} else if($list[$i]['is_notice']) {
						$post_icon = $icon_url ? 'icon-notice' : 'bell';
					} else if($list[$i]['icon_secret']) {
						$secret_new = $list[$i]['icon_new'] ? '-new' : '';
						$post_icon = $icon_url ? 'icon-secret'.$secret_new : 'lock';
					} else if($list[$i]['icon_new']) {
						$post_icon = $icon_url ? 'icon-new' : 'chevron-circle-right';
					} else if($list[$i]['icon_hot']) {
						$post_icon = $icon_url ? 'icon-hot' : 'thumbs-up';
					} else if($set['attach_icon'][$s]) {
						if($wr_post['video'] == "video") {
							$post_icon = $icon_url ? 'icon-video' : 'video-camera';
						} else if($wr_post['photo'] == "photo") {
							$post_icon = $icon_url ? 'icon-img' : 'picture';
						} else if($wr_post['file'] == "file") {
							$post_icon = $icon_url ? 'icon-file' : 'download';
						}
					}

					$post_icon = $icon_url ? '<img src="'.$icon_url.'/'.$post_icon.$icon_ext.'" alt="" />' : '<i class="fa fa-'.$post_icon.'"></i>';
					$post_icon = ($list[$i]['icon_new'] && $post_icon) ? '<span class="la-new">'.$post_icon.'</span>' : $post_icon;
				}
			}

			//Subject	
			$subject = ($opt['cate'] && $list[$i]['ca_name']) ? '['.$list[$i]['ca_name'].'] '.amina_cut($list[$i]['wr_subject'], $opt['subj']) : amina_cut($list[$i]['wr_subject'], $opt['subj']);
			$subject = $list[$i]['is_notice'] ? '<b>'.$subject.'</b>' : $subject;
			if($is_subj_cmt && $cmt_cnt > 0) $subject .= ' <span class="la-subj-cmt">+'.number_format($cmt_cnt).'</span>';
		?>
		<li class="la-box">
			<div class="la-list">
				<a <?php echo $a_href;?>>
					<?php echo $details_item; ?>
					<span class="la-subj"><?php echo $post_icon.$subject; ?></span>
				</a>
			</div>
		</li>
		<?php } ?>
		<?php if($list_num == 0) { ?>
			<li class="la-none">게시물이 없습니다.</li>
		<?php } ?>
		</ul>
		<div class="clear"></div>
	</div>
</div>
<script type="text/javascript">
$(function(){
	$('#<?php echo $la_id;?>').Vnewsticker({
		speed: <?php echo $opt['speed']; ?>,
		pause: <?php echo $opt['pause']; ?>,
		mousePause: true,
		showItems: <?php echo $opt['show']; ?>,
		direction : "<?php echo $opt['down']; ?>"
	});
});
</script>
