<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 
?>

<link rel="stylesheet" href="<?php echo $member_skin_url; ?>/zip.css">
<script src="<?php echo G5_JS_URL; ?>/zip.js"></script>

<section id="at-zip">
	<div class="msg-box box-black">
		<div id="code_sel">
			<label for="sch_sel_1"><i class="fa fa-search"></i> 주소검색</label>
			<input type="radio" name="sch_sel" id="sch_sel_1" value="search" checked="checked">
			&nbsp; &nbsp;
			<label for="sch_sel_0"><i class="fa fa-pencil"></i> 직접입력</label>
			<input type="radio" name="sch_sel" id="sch_sel_0" value="direct">
		</div>
		
	</div>

    <div id="zip_search_frm" class="zip_frm">
		<div class="msg-box box-gray">
			시도 및 시군구 선택없이 도로명, 읍/면/동, 건물명 등으로 검색하실 수 있습니다.<br>
			만약 검색결과에 찾으시는 주소가 없을 때는 시도와 시군구를 선택하신 후 다시 검색해 주십시오.<br>
			(검색결과는 최대 1,000건만 표시됩니다.)
		</div>

		<form name="fzip" method="get" onsubmit="search_call(); return false;" autocomplete="off">
		<!-- 검색어 입력 시작 { -->
		<div id="code_sch">
			<div id="sch_q">
				<div class="msg-box box-info">
					<label for="sido" class="sound_only">시도선택</label>
					<select name="sido" id="sido">
						<option value="">시도 선택</option>
					</select>
					<label for="gugun" class="sound_only">시군구</label>
					<select name="gugun" id="gugun">
						<option value="">시군구 선택</option>
					</select>
					<input type="text" name="q" value="" id="q" required>
					<button class="btn btn-danger" type="submit"><b><i class="fa fa-search"></i> 검색</b></button>
				</div>
				<div id="q_info">
					<div class="msg-box box-gray">
						<span></span>정확하고 빠른 검색을 위해 아래의 예시처럼 입력해 주세요.<br>
						입력예1) 강남대로37길 24-6<br>입력예2) 서초동 1362-19<br>입력예3) 서초2동 1362-19
					</div>
				</div>
			</div>
		</div>
		
		<!-- } 검색어 입력 끝 -->
		</form>

		<div id="result">
			<div id="result_b4" class="msg-box box-black">
				<b>검색어를 입력해주세요.</b>
			</div>
		</div>
	</div>

    <div id="zip_direct_frm" class="zip_frm">
		<div class="msg-box box-gray">
			직접 주소를 입력하실 경우 우편번호와 기본주소는 반드시 입력하셔야 합니다.
		</div>
        <form name="fzip2">
			<div class="msg-box box-info">
			<ul>
				<li>우편번호 &nbsp;
					<label for="frm_zip1" class="sound_only">우편번호앞자리</label>
					<input type="text" name="frm_zip1" id="frm_zip1" required size="3" maxlength="3"> -
					<label for="frm_zip2" class="sound_only">우편번호뒷자리</label>
					<input type="text" name="frm_zip2" id="frm_zip2" required size="3" maxlength="3">
				</li>
				<li>
					<label for="frm_addr1">기본주소</label> &nbsp;
					<input type="text" name="frm_addr1" id="frm_addr1" rquired size="70">
				</li>
				<li>
					<label for="frm_addr2">상세주소</label> &nbsp;
					<input type="text" name="frm_addr2" id="frm_addr2" size="70">
				</li>
				<li>
					<label for="frm_addr3">참고항목</label> &nbsp;
					<input type="text" name="frm_addr3" id="frm_addr3" size="70">
				</li>
				<li>
					<label for="frm_jibeon">지번주소</label> &nbsp;
					<input type="text" name="frm_jibeon" id="frm_jibeon" size="70">
				</li>
			</ul>
			</div>
			<p align="center">
				<button id="put_addr" class="btn btn-danger" type="submit"><b><i class="fa fa-pencil"></i> 주소입력</b></button>
			</p>
        </form>
    </div>

	<script>
	$(function() {
		$("input[name='sch_sel']").click(function() {
			var val = $(this).val();

			$(".zip_frm").hide();
			$("#zip_"+val+"_frm").show();
		});

		$("input#q").bind("focusin", function() {
			$("#q_info").fadeIn(200);
		});

		$("input#q").bind("focusout", function() {
			$("#q_info").fadeOut(200);
		});

		$("#put_addr").click(function() {
			var zip1 = $.trim($("#frm_zip1").val());
			var zip2 = $.trim($("#frm_zip2").val());
			var addr1 = $.trim($("#frm_addr1").val());
			var addr2 = $.trim($("#frm_addr2").val());
			var addr3 = $.trim($("#frm_addr3").val());
			var jibeon = $.trim($("#frm_jibeon").val());

			if(zip1.length < 1) {
				alert("우편번호 앞자리를 입력해 주십시오.");
				return false;
			}

			if(zip2.length < 1) {
				alert("우편번호 뒷자리를 입력해 주십시오.");
				return false;
			}

			if(addr1.length < 1) {
				alert("기본주소를 입력해 주십시오.");
				return false;
			}

			put_data2(zip1, zip2, addr1, addr2, addr3, jibeon);
		});
	});

	function put_data(zip1, zip2, addr1, addr3, jibeon)
	{
		var of = window.opener.document.<?php echo $frm_name; ?>;

		of.<?php echo $frm_zip1; ?>.value = zip1;
		of.<?php echo $frm_zip2; ?>.value = zip2;
		of.<?php echo $frm_addr1; ?>.value = addr1;
		of.<?php echo $frm_addr2; ?>.value = "";
		of.<?php echo $frm_addr3; ?>.value = addr3;

		window.opener.$("#<?php echo $frm_jibeon; ?>").text("지번주소 : "+jibeon);

		if(of.<?php echo $frm_jibeon; ?> !== undefined)
			of.<?php echo $frm_jibeon; ?>.value = jibeon;

		window.close();
	}

	function put_data2(zip1, zip2, addr1, addr2, addr3, jibeon)
	{
		var of = window.opener.document.<?php echo $frm_name; ?>;

		of.<?php echo $frm_zip1; ?>.value = zip1;
		of.<?php echo $frm_zip2; ?>.value = zip2;
		of.<?php echo $frm_addr1; ?>.value = addr1;
		of.<?php echo $frm_addr2; ?>.value = addr2;
		of.<?php echo $frm_addr3; ?>.value = addr3;

		window.opener.$("#<?php echo $frm_jibeon; ?>").text("지번주소 : "+jibeon);
		if(of.<?php echo $frm_jibeon; ?> !== undefined)
			of.<?php echo $frm_jibeon; ?>.value = jibeon;

		window.close();
	}
	</script>
</section>
