<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

?>
<link rel="stylesheet" href="<?=AMINA_URL?>/html/html.css" />
<link rel="stylesheet" href="<?=AMINA_URL?>/app/syntaxhighlighter/styles/shCore.css" />
<link rel="stylesheet" href="<?=AMINA_URL?>/app/syntaxhighlighter/styles/shThemeDefault.css" />
<script src="<?=AMINA_URL?>/app/syntaxhighlighter/scripts/shCore.js"></script>
<script src="<?=AMINA_URL?>/app/syntaxhighlighter/scripts/shBrushPhp.js"></script>
<script>
	SyntaxHighlighter.config.clipboardSwf = '<?=AMINA_URL?>/app/syntaxhighlighter/scripts/clipboard.swf';
	SyntaxHighlighter.all();
</script>
<style>
#latest_guide { font-family:tahoma; }
#latest_guide .box { display:block; margin: 15px 0px; padding: 15px 30px 15px 15px; border-left-color: rgb(238, 238, 238); border-left-width: 5px; border-left-style: solid; line-height:22px; }
#latest_guide .danger { border-color: rgb(223, 181, 180); background-color: rgb(252, 242, 242); }
#latest_guide .warning { border-color: rgb(241, 231, 188); background-color: rgb(254, 251, 237); }
#latest_guide .info { border-color: rgb(208, 227, 240); background-color: rgb(240, 247, 253); }
#latest_guide .black { color:#fff; font-weight:bold; border-color: rgb(0, 0, 0); background-color: rgb(51, 51, 51); }
#latest_guide .gray { border-color: rgb(221, 221, 221); background-color: rgb(250, 250, 250); }
#latest_guide table { width:100%; border-collapse:collapse; padding:0px; margin:0px; border:0px; } 
#latest_guide th { width:80px; padding:10px; border:1px solid #ddd; line-height:1.8; background:#fafafa; }
#latest_guide td { padding:10px; border:1px solid #ddd; line-height:1.8; }
#latest_guide pre { margin:15px 0px !important; }
#latest_guide ol { margin:0px; padding-left:20px; }
</style>

<div id="latest_guide" class="html_content" style="padding:0px; margin:0px;">

<div class="box black" style="margin-top:0px;">
	<i class="fa fa-chevron-circle-right"></i>
	<b>기본안내</b>
</div>

<div class="box danger">
	<ol>
		<li>ASR 최근글 스킨은 스킨명이 amina로 고정이며, 헤드 및 목록스킨은 /amina/misc/latest 폴더에 설치됩니다.</li>
		<li>ASR 최근글 스킨은 출력모양에 대한 설정을 CSS의 클래스명을 입력하는 형태입니다.</li>
		<li>ASR 최근글 스킨을 CSS 클래스명 설정으로 한 이유는 <b>① 탭에서의 과도한 링크길이(LongText)로 일부 서버에서 제대로 인식되지 않는 문제 ② html5 원칙에 맞도록 HTML과 CSS의 분리 ③ 직접 설정값 입력으로 인하여 출력코드가 과도하게 많거나 지저분한 점</b> 등을 개선하기 위해서 입니다.</li>
		<li>설명에 사용된 자료는 RSS를 이용한 구글뉴스 자료입니다.</li>
		<li>최근글 스킨에 대한 사용법은 개별 스킨별 가이드를 참고해 주세요.</li>
	</ol>
</div>

<div class="box gray">
	<i class="fa fa-chevron-circle-right"></i>
	<b>기본 출력 - 아무것도 설정하지 않았을 경우 basic 스킨이 적용됨</b>
</div>

<table>
<tr>
<th>적용코드</th>
<td>
	<pre class="brush:php;">
		// 그누보드 최근글과 동일하게 스킨명, 게시판아이디, 추출글수, 제목길이만 입력
		&lt?php echo latest_amina('amina', '게시판아이디', 5, 255); ?>
	</pre>
</td>
</tr>
<tr>
<th>적용결과</th>
<td>
	<?php echo latest_amina('amina', 'Sample1', 5, 255, 'type=rss rss=googlenews'); ?>
</td>
</tr>
</table>

<div class="box gray">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>함수 구성 - 최근글 함수의 구성(기본구조나 사용법은 그누보드와 동일)</b>
</div>

<table>
<tr>
<th>함수구조</th>
<td>
	<pre class="brush:php;">
		// 그누보드 최근글과 동일한 구성이나 탭배열값과, 추가쿼리구문 인자가 옵션으로 추가됨
		&lt?php echo latest_amina('amina', '추출게시판아이디', '추출글수', '제목길이', '옵션사항', '탭배열값', '추가쿼리구문'); ?>
	</pre>
</td>
</tr>
<tr>
<th>보충설명</th>
<td>
	<ol>
		<li>그누보드 최근글과 가장 큰 차이점은 '추출게시판아이디' 값이 아미나스킨 최근글에서는 '추출게시판아이디'가 될 수도 있으나, 복수게시판 추출 또는 추출타입(type)이나 탭사용여부에 따라 '<b>jQuery id</b>'값으로 더 많이 사용된다는 점입니다.</li>
		<li>그러니 되도록이면 '추출게시판아이디'를 중복되지 않도록 입력해 주는 것이 좋습니다. 아니면 아예 'jQuery id'로 보고, 단일 게시판이더라도 게시판 설정은 bo_list에 입력하시는 것도 한 방법입니다.</li>
	</ol>
</td>
</tr>
</table>

<div class="box gray">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>옵션사항 - 아미나스킨 최근글 설정의 모든 것</b>
</div>

<table>
<tr>
<th>기본설명</th>
<td>
	<pre class="brush:php;">
		// 일반적인 그누보드 옵션사항 입력과는 다른 형태로 입력(옵션명=적용값 형태)
		&lt?php echo latest_amina('amina', '게시판아이디', 5, 255, 'type=newgul details=cmt'); ?>
	</pre>
</td>
</tr>
<tr>
<th>기본규칙</th>
<td>
	<ol>
		<li>아미나스킨 최근글에서 사용하는 옵션은 '<b>옵션명=적용값</b>' 형태로 되어 있으며,  각 <b>옵션은 띄어쓰기로 구분</b>합니다. ex) type=newgul bo_list=blog;free</li>
		<li>따라서 각 옵션의 적용값에 띄어쓰기가 들어가면 파싱오류가 발생하므로, 적용값에서 띄어쓰기(공백)가 들어가는 곳은 <b>띄어쓰기(공백) 대시 플러스(+) 기호로 대체</b>하여 입력해 주셔야 합니다. ex) title=자유 게시판(x) → title=자유+게시판(o)</li>
	</ol>	
</td>
</tr>
<tr>
<th>보충설명</th>
<td>
	<ol>
		<li>옵션사항은 크게 <b>① 스킨과 상관없는 공통적용 ② 스킨에 따라 개별적용</b> 되는 2가지가 있습니다.</li>
		<li>스킨과 상관없이 공통적용되는 옵션은 간단히 "<b>어떤 글을 어떻게 가져올까?</b>"라는 부분으로 DB에서 글을 추출하는 것과 관련된 설정입니다. 예를들어 추출할 게시판이나 그룹지정, 특정 분류글, 별도 정렬(랭크) 등을 설정하는 말합니다.</li>
		<li>스킨에 따라 개별적용되는 옵션은 간단히 "<b>가져온 글을 어떤 모양을 보여줄까?</b>"라는 부분으로 적용하고자 하는 스킨의 출력모양과 관련된 설정입니다. 예를들어 가져온 글을 갤러리, 웹진, 리스트 형태 등으로 보여 주는 것으로, 이와 관련된 옵션은 개별스킨마다 달라질 수 있습니다.</li>
	</ol>	
</td>
</tr>
</table>

<div class="box gray">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>탭설정</b>
</div>

<table>
<tr>
<th>적용예시</th>
<td>
	<pre class="brush:php;">
		&lt;?php
		// 탭적용 예시
		unset($tab);
		$tab[0] = " type=newgul title=자료실 bo_include=thema;board;skin ";
		$tab[1] = " title=테마 bo_list=thema ";
		$tab[2] = " title=보드 bo_list=board ";
		$tab[3] = " title=스킨 bo_list=skin ";
		echo latest_amina('amina', 'dataRoom', 5, 255, 'type=notice', $tab);
		?>
	</pre>
</td>
</tr>
<tr>
<th>기본안내</th>
<td>
	<ol>
		<li>아미나스킨 최근글의 탭은 일반적인 탭과 비교할 때 탭갯수에 제한이 없으며, 아무리 많은 탭을 적용하더라도 속도저하는 없습니다.</li>
		<li>탭 하나가 독립된 최근글 1개이기 때문에 개별 탭별로 모든 옵션설정이 가능합니다.</li>
		<li>탭은 jQuery를 이용하기 때문에 '게시판아이디'가 'jQuery id'가 되니, 중복되지 않도록 입력해야 합니다.</li>
	</ol>	
</td>
</tr>
</table>

<div class="box gray">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>추가 쿼리문 설정</b>
</div>

<table>
<tr>
<th>적용예시</th>
<td>
	<pre class="brush:php;">
		&lt;?php 
		//wr_1 필드값이 boom 인 글만 가져오기
		echo latest_amina("amina", "free", 5, 255, "type=notice", '', "wr_1 = 'boom' "); 
		?>
	</pre>
</td>
</tr>
<tr>
<th>기본안내</th>
<td>
	<ol>
		<li>DB에서 글을 가져올 때 쿼리의 where 에 포함될 조건을 추가적으로 입력할 수 있으나, 보안문제로 탭에서는 사용이 불가능합니다.</li>
	</ol>	
</td>
</tr>
</table>

<div class="box danger">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>type 옵션</b>
</div>

<table>
<tr>
<th>적용코드</th>
<td>
	<pre class="brush:php;">
		// 최근 등록된 글 출력
		&lt;?php echo latest_amina('amina', 'newgul', 5, 255,'type=newgul subj_cmt=1'); ?>
	</pre>
</td>
</tr>
<tr>
<th>적용결과</th>
<td>
	<?php echo latest_amina('amina', 'newgul', 5, 255, 'type=newgul subj_cmt=1'); ?>
</td>
</tr>
<tr>
<th>미설정</th>
<td>
	공지글과 일반글 구분없이 추출되는 그누보드 기본 최근글과 동일 형태로 추출(가장 빠름)
</td>
</tr>
<tr>
<th>type=newgul</th>
<td>
	전체글(새글 DB)에서 새로 등록된 글 추출 - bo_exclude, bo_include, gr_list 옵션과 같이 사용 가능
</td>
</tr>
<tr>
<th>type=newcmt</th>
<td>
	전체글(새글 DB)에서 새로 달린 댓글 추출 - bo_exclude, bo_include, gr_list 옵션과 같이 사용 가능
</td>
</tr>
<tr>
<th>type=newcmtgul</th>
<td>
	전체글(새글 DB)에서 새로 댓글 달린 글 추출 - bo_exclude, bo_include, gr_list 옵션과 같이 사용 가능
</td>
</tr>
<tr>
<th>type=mygul</th>
<td>
	로그인한 회원의 내글반응 현황 추출
</td>
</tr>
<tr>
<th>type=notice</th>
<td>
	게시판 DB에서 공지글과 일반글을 분리하여 추출 - bo_list, gr_list 옵션과 같이 사용 가능
</td>
</tr>
<tr>
<th>type=nonotice</th>
<td>
	게시판 DB에서 공지글은 빼고 일반글만 추출 - bo_list, gr_list 옵션과 같이 사용 가능
</td>
</tr>
<tr>
<th>type=cmt</th>
<td>
	댓글만 추출 - bo_list, gr_list 옵션과 같이 사용 가능
</td>
</tr>
<tr>
<th>type=file</th>
<td>
	첨부파일 DB에서 첨부파일이 있는 글 추출 - bo_exclude, bo_include, gr_list, term, order=1, sum=1 등의 별도 옵션 사용
</td>
</tr>
<tr>
<th>type=poll</th>
<td>
	ASR 설문 DB에서 설문글 추출 - order, term, ing 등 별도 옵션 사용
</td>
</tr>
<tr>
<th>type=member</th>
<td>
	회원 DB에서 회원정보 추출 - order, term, mb_open, mb_photo, admin 등 별도 옵션 사용과 별도 목록스킨 필요
</td>
</tr>
<tr>
<th>type=point</th>
<td>
	MP 또는 AP DB에서 포인트 획득 회원 랭킹 추출 - ap, term 등 별도 옵션 사용과 별도 목록스킨 필요
</td>
</tr>
<tr>
<th>type=rss</th>
<td>
	amina.rss.php 파일에 등록된 RSS글 추출 - rss 등 별도 옵션 사용
</td>
</tr>
<tr>
<th>type=none</th>
<td>
	글을 추출하지 않고, 플러그인, 위젯 등으로 활용시 사용 - 네이버 인기검색어 등
</td>
</tr>
</table>

<div class="box danger">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>title, bo_list, gr_list, bo_exclude, bo_include 옵션</b>
</div>

<table>
<tr>
<th>설정방법</th>
<td>
	<ol>
		<li>게시판 또는 그룹 아이디를 복수 입력시 각 아이디는 세미콜론(;)으로 구분합니다. ex) bo_list=a;b;c;d</li>
		<li>설정값에는 띄어쓰기(공백) 대신 플러스(+) 기호를 입력합니다. ex) title=자유+게시판</li>
	</ol>		
</td>
</tr>
<tr>
<th>title</th>
<td>
	추출게시판 제목입력. ex) title=자유+게시판
</td>
</tr>
<tr>
<th>bo_list</th>
<td>
	추출하고자 하는 게시판아이디 입력. ex) bo_list=free 또는 bo_list=free;video;game
</td>
</tr>
<tr>
<th>ca_name</th>
<td>
	특정 분류글만 추출. 새글 DB 사용 type 및 복수지정 불가. ex) bo_list=free;video ca_name=기타 → free와 video 게싯판의 "기타" 분류글만 추출
</td>
</tr>
<tr>
<th>gr_list</th>
<td>
	추출하고자 하는 그룹아이디 입력. ex) gr_list=skin 또는 gr_list=blog;skin
</td>
</tr>
<tr>
<th>bo_exclude</th>
<td>
	추출시 제외 게시판 설정. type=newgul 처럼 새글 DB를 사용하는 전체글 추출에서 특정 게시판을 제외하고자 할 경우 입력. ex) type=newgul bo_exclude=free;game → free, game 게시판은 제외하고 전체 게시판에서 추출
</td>
</tr>
<tr>
<th>bo_include</th>
<td>
	추출시 포함 게시판 설정. type=newgul 처럼 새글 DB를 사용하는 전체글 추출에서 특정 게시판만 추출하고자 할 경우 입력. ex) type=newgul bo_include=free;game → 전체 게시판 중 free, game 게시판만 추출
</td>
</tr>
<tr>
<th>ca_exclude</th>
<td>
	추출시 제외 분류 설정. 새글 DB를 사용하는 type=newgul이나 newcmtgul 에서는 작동하지 않습니다. ex) type=notice bo_list=video ca_exclude=게임;영화 → video 게시판에서 게임, 영화 분류는 빼고 추출
</td>
</tr>
<tr>
<th>기타사항</th>
<td>
	<ol>
		<li>gr_list 옵션은 새글 DB나 게시판 DB나 모두 사용 가능합니다. ex) type=newgul gr_list=game → 새글 DB에서 game 그룹 게시판 글만 추출</li>
		<li>설정값에는 띄어쓰기(공백) 대신 플러스(+) 기호를 입력합니다. ex) title=자유+게시판</li>
	</ol>
</td>
</tr>
</table>

<div class="box danger">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>mode 옵션</b>
</div>

<table border=0 class="html-tbl">
<tr>
<th>적용코드</th>
<td>
	<pre class="brush:php;">
		// 최근 등록된 포토글만 출력
		&lt;?php echo latest_amina('amina', 'newgul', 5, 255,'type=newgul mode=photo subj_cate=1 subj_cmt=1'); ?>
	</pre>
</td>
</tr>
<tr>
<th>적용결과</th>
<td>
	<?php echo latest_amina('amina', 'newgul', 5, 255, 'type=newgul mode=photo subj_cate=1 subj_cmt=1'); ?>
</td>
</tr>
<tr>
<th>미설정</th>
<td>
	작동하지 않음
</td>
</tr>
<tr>
<th>mode=text</th>
<td>
	이미지가 없는 텍스트 글만 추출
</td>
</tr>
<tr>
<th>mode=photo</th>
<td>
	이미지가 있는 글만 추출
</td>
</tr>
<tr>
<th>mode=video</th>
<td>
	아미나스킨의 간단등록 동영상이 있는 글만 추출
</td>
</tr>
<tr>
<th>mode=rss</th>
<td>
	통합 RSS로 내보낸 글만 추출
</td>
</tr>
<tr>
<th>mode=main</th>
<td>
	메인글 체크된 글만 추출
</td>
</tr>
<tr>
<th>mode=good</th>
<td>
	추천글 체크된 글만 추출
</td>
</tr>
<tr>
<th>mode=daum</th>
<td>
	다음 view가 등록된 글만 추출하나, type=newgul, newcmt, newcmtgul 에서만 작동합니다.
</td>
</tr>
</table>

<div class="box danger">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>order, term, rows, page, target 옵션</b>
</div>

<table>
<tr>
<th>적용코드</th>
<td>
	<pre class="brush:php;">
		// 30일 이내 등록된 게시물 중에서 댓글순, 조회순으로 출력
		&lt;?php echo latest_amina('amina', '게시판아이디', 5, 255,'order=cmt;hit term=30 subj_cmt=1'); ?>
	</pre>
</td>
</tr>
<tr>
<th>적용결과</th>
<td>
	<?php echo latest_amina('amina', 'free', 5, 255, 'order=cmt;hit term=30 subj_cmt=1'); ?>
</td>
</tr>
<tr>
<th>기본설명</th>
<td>
	order, term 옵션은 흔히 이야기하는 랭킹 또는 인기글 등을 추출하기 위한 옵션입니다. order 옵션은 새글 DB를 사용하는 type=newgul, newcmtgul 등에서는 작동하지 않으며, 비밀글 역시 출력되지 않습니다. 예를 들어 주간 인기글, 월간 인기글 처럼 말이죠.
</td>
</tr>
<tr>
<th>order</th>
<td>
	지정한 순서에 따라 값이 큰 순서대로 정렬해서 추출합니다.
	order 옵션으로 hit(조회수), good(추천수), nogood(비추천수), goodgap(추천차 = 추천-비추천), nogoodgap(비추천차 = 비추천 - 추천), cmt(댓글수) 를 지정할 수 있으며, 세미콜론(;)을 이용하여 복수지정도 가능할 뿐만 아니라 order=rdm 라고 입력하면 랜덤으로 글을 추출합니다. ex) order=good;cmt;hit → 추천수, 댓글수, 조회수가 많은 순으로 추출 
</td>
</tr>
<tr>
<th>term</th>
<td>
	term 역시 말그대로 기간입니다. 현재시점을 기준이로 며칠 전인지를 표시합니다. 예를 들어 term=7 이면, 현재부터 7일이전까지 등록된 게시물에 대해서만 정렬하는 것입니다. ex) 한달이내 등록된 게시물 중에서 추천수, 조회수가 높은 순으로 글을 추출하고자 한다면 order=good;hit term=30 해주시면 되겠죠.(월간 인기글)
	<br><br>
	또한 기간의 시작점을 지정해 줄 수 있습니다. 입력방법은 기간을 입력하고, 세미콜론(;) 한 이후 시작점을 입력해 주시면 됩니다. 예를 들어, 2일전을 기준으로 30일까지라는 기간을 설정하고 싶으면, term=30;2 식으로 입력해 주시면 됩니다.
</td>
</tr>
<tr>
<th>rows</th>
<td>
	추출글수로 탭 등에서 추출글수를 따로 설정해 줄 필요가 있을 때 설정. ex) rows=10 → 게시물 10개 추출
</td>
</tr>
<tr>
<th>page</th>
<td>
	추출글수 또는 rows 옵션의 글수를 페이지를 나누어 해당 페이지의 글을 추출 ex) page=2 → 해당 추출설정의 2페이지에 있는 글을 추출
</td>
</tr>
<tr>
<th>target</th>
<td>
	추출 게시판제목이나 추출 글제목 클릭시 이동타켓 설정. _top, _blank, _parent, _self 중 설정가능. 기본값(미설정)은 _self. ex) target=_top
</td>
</tr>
</table>


<div class="box info">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>head_skin 옵션</b>
</div>

<table>
<tr>
<th>적용코드</th>
<td>
	<pre class="brush:php;">
		// ASR 최근글 헤드스킨 적용 - 일반
		&lt;?php echo latest_amina('amina', '게시판아이디', 5, 255,'head_skin=basic-amina'); ?>

		// ASR 최근글 헤드스킨 적용 - 탭일 때
		&lt;?php
			unset($tab);
			$tab[0] = 'title=주요뉴스 bo_list=게시판아이디';
			$tab[1] = 'title=스포츠 bo_list=게시판아이디';
			$tab[2] = 'title=연예 bo_list=게시판아이디';
			echo latest_amina('amina', '임의탭아이디', 5, 255,'head_skin=basic-amina', $tab); 
		?>
	</pre>
</td>
</tr>
<tr>
<th>일반적용</th>
<td>
	<?php echo latest_amina('amina', 'sample2', 5, 255, 'type=rss rss=googlenews head_skin=basic-amina'); ?>
</td>
</tr>
<tr>
<th>탭적용</th>
<td>
	<?php
		unset($tab);
		$tab[0] = 'type=rss rss=googlenews title=주요뉴스';
		$tab[1] = 'type=rss rss=googlenews-s title=스포츠';
		$tab[2] = 'type=rss rss=googlenews-e title=연예';
		echo latest_amina('amina', 'sample3', 5, 255, 'head_skin=basic-amina', $tab); 
	?>
</td>
</tr>
<tr>
<th>미설정</th>
<td>
	미설정시 기본(basic) 최근글 헤드스킨 적용
</td>
</tr>
<tr>
<th>설정시</th>
<td>
	/amina/misc/latest/head 폴더 내에 있는 최근글 헤드 스킨 적용 → head_skin=스킨명(폴더명)
</td>
</tr>
<tr>
<th>숨기기</th>
<td>
	head_skin=none 이라고 설정하면 추출 게시판 헤드가 출력되지 않습니다.
</td>
</tr>
</table>

<div class="box info">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>head, head_href, head_more 옵션</b>
</div>

<table>
<tr>
<th>적용코드</th>
<td>
	<pre class="brush:php;">
		&lt;?php echo latest_amina('amina', '게시판아이디', 5, 255, 'head_skin=basic-amina head=v-head head_more=none'); ?>
		&lt;style>
		/* 들여쓰기 오버 또는 선택시 헤드변경 & more 버튼 숨기기 */
		.v-head ul { padding-left:15px; }
		.v-head .on a { color:#000 !important; }
		&lt;/style>
	</pre>
</td>
</tr>
<tr>
<th>적용결과</th>
<td>
	<?php echo latest_amina('amina', 'sample4', 5, 255, 'type=rss rss=googlenews head_skin=basic-amina head=v-head head_more=none'); ?>
	<style>
		.v-head ul { padding-left:15px; }
		.v-head .on a { color:#000 !important; }
	</style>
</td>
</tr>
<tr>
<th>head</th>
<td>
	헤드에 적용할 css 클래스명 입력. css 클래스명은 헤드스킨에 따라 다를 수 있음. ex) head=v-head
</td>
</tr>
<tr>
<th>head_href</th>
<td>
	추출게시판 "타이틀" 또는 "더보기(more)" 클릭시 이동 경로 직접 지정. ex) head_href=http://naver.com
</td>
</tr>
<tr>
<th>head_more</th>
<td>
	head_more=none 이라고 설정하면 "더보기(more)"가 출력되지 않습니다.
</td>
</tr>
</table>

<div class="box warning">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>list_skin 옵션</b>
</div>

<table>
<tr>
<th>미설정</th>
<td>
	미설정시 기본(basic) 최근글 리스트스킨 적용
</td>
</tr>
<tr>
<th>설정시</th>
<td>
	/amina/misc/latest/list 폴더 내에 있는 최근글 리스트스킨 적용 → list_skin=스킨명(폴더명)
</td>
</tr>
<tr>
<th>설정값</th>
<td>
	리스트스킨의 옵션사항은 스킨별로 다름
</td>
</tr>
</table>

<div class="box warning">
	<i class="fa fa-chevron-circle-right"></i> 
	<b>list_wrap, list_rdm, img_row 옵션</b>
</div>

<table border=0 class="html-tbl">
<tr>
<th>list_wrap</th>
<td>
	list_wrap은 최근글 리스트영역 전체박스로 탭 또는 개별 리스트스킨과 상관없이 공통적으로 적용되는 부분으로 주로 탭설정 등에서 탭높이값 설정을 통해 탭이동시 화면 흔들림 방지에 이용합니다. 
	설정은 list_wrap=css클래스명 형태로 입력하시면 됩니다. 
</td>
</tr>
<tr>
<th>list_rdm</th>
<td>
	list_rdm=1 로 설정하시면 추출한 글을 섞어서 랜덤으로 출력해 줍니다. DB에서 랜덤으로 추출하는 것이 아니라 추출한 글을 랜덤으로 나오도록 합니다.
</td>
</tr>
<tr>
<th>img_row</th>
<td>
	img_row=숫자 형태로 설정하시면, 지정한 숫자만큼의 글이 이미지글이 되도록 선배치합니다. DB에서 이미지글을 뽑아오는 것이라 아니라 추출한 글을 재배하여 이미지글이 먼저 출력되도록 합니다.
</td>
</tr>
</table>

</div>

<br/><br/>