<?
if (!defined('_GNUBOARD_')) exit;

//-- 인기검색어 함수. 지음빌더 용 -----------------------------------------------------------------
//-- 1. 단어 DB(zm_search_word)에서 전체 단어의 순위를 관리. 검색어 자동 삭제 기간이 지난 것 중 검색 누적 수가 10건 미만은 삭제 
//-- 2. zm_popular_history : 실시간 인기검색어가 기록 되는 캐쉬용 테이블, 자동삭제 기간까지 그날의 인기검색어를 보관.
//-- 3. 캐쉬 시간은 환경설정에서 지정
//-- 4. 출력은 실시간 인기 검색순으로 하되 up, down, new는 단어 DB의 변동 된 순위를 따져서 결정
function popular($skin_dir='zm.basic', $pop_cnt=7, $date_cnt=3) {
	global	$config, $g4, $zmb, $zm_config;
	$list	= array();

	$wordcount	= 10;											//-- 검색어 개수
	$now		= date("Y-m-d H:i:s", $g4[server_time]);		//-- 지금
	$now_date	= date("Y-m-d", $g4[server_time]);

	//-- 갱신 주기가 지났거나 오늘 검색어 자료가 없으면 새 인기검색어 추출

	$tmpnow	= date("Y-m-d H:i:s", $g4[server_time]-$zm_config[popularterm]);
	$rd		= sql_fetch("select db_datetime from $zmb[table_popular] order by db_datetime desc limit 1");		//-- 마지막 레코드

	$late_datetime	= $rd[db_datetime];						//-- 마지막 기록한 시간
	//-- 지정한 시간 지났음
	if($tmpnow > $late_datetime) {
		//-- 날짜 상관 없이 최근 검색 빈도 높은 순으로 읽어 옮
		$rs_src		= sql_query("select pp_word, count(*) as cnt from $g4[popular_table]
						group by pp_word
						order by cnt desc, pp_date desc, pp_word
						limit 0, $wordcount");
		$list	= array();
		for($i = 0; $rd = sql_fetch_array($rs_src); $i++) {
			$list[$i][count]	= $rd[cnt];
			$list[$i][rank]		= $i+1;
			$list[$i][word]		= $rd[pp_word];
		}

		//-- 마지막 기록한 인기 검색어 목록
		$latest_list= array();			//-- $마지막인기검색어[배열y키][db_word-검색어][db_rank-순위][db_search_count-검색수][db_todayrank-오늘 시작한 단어 순위]
		$rs_latest	= sql_query("select * from $zmb[table_popular] where db_datetime='$late_datetime' order by db_recno desc");
		for($i = 0; $rd_latest = sql_fetch_array($rs_latest); $i++) {
			$latest_list[$i] = $rd_latest;
		}

		//-- 순위 변동 정보 $list[$i][word-검색어][rank-순위][count-검색수][up-순위변동UP][increase-증가한 카운트][todayrank-오늘 시작 순위][realrank-실시간 순위]
		for($i = 0; $i < count($list); $i++) {
			$list[$i][up]	= "new";
			$list[$i][increrase]	= 0;
			for($j = 0; $j < count($latest_list); $j++) {
				if($list[$i][word] == $latest_list[$j][db_word]) {
					$list[$i][increase]	= intval($list[$i][count]) - intval($latest_list[$j][db_search_count]);

					if(substr($late_datetime, 0, 10) == $now_date) {
						//-- 오늘 첫 기록 아님
						$list[$i][todayrank]	= $latest_list[$j][db_todayrank];		//-- 첫 기록 시 저장 했던 단어 순위를 승계
					}
				}//endif;
			}//endfor;
		}//endfor;

		//-- 새 인기검색어 레코드 저장
		for($i = 0; $i < count($list); $i++) {
			if(!$list[$i][todayrank]) {
				//-- 단어의 순위가 없다면 첫 기록임. 단어 DB의 순위를 갖어 옮
				$sql_rank	= "select db_rank from $zmb[table_search_word] where db_word='{$list[$i][word]}'";
				$rd_rank	= sql_fetch($sql_rank);
				$list[$i][todayrank]	= $rd_rank[db_rank];
			}

			//-- 검색 카운트가 증가 했으면 단어 DB에 카운트 증가
			if($list[$i][increase] > 0)	$increase	= $list[$i][increase];
			else						$increase	= 0;
			$rd_find	= sql_fetch("select db_recno from $zmb[table_search_word] where db_word='{$list[$i][word]}'");
			if($rd_find[db_recno]){
				$rs		= mysql_query("update $zmb[table_search_word] set db_count=db_count+$increase where db_word='{$list[$i][word]}'");
			}else{
				sql_query("insert into $zmb[table_search_word] set db_word='{$list[$i][word]}', db_count='{$list[$i][count]}', db_date='$now_date'");
			}
		}

		//-- 인기검색어를 처음 등록한 날짜가 자동 삭제 기간이 지났지만 10건 미만 검색 된 단어는 삭제
		$del_date	= $g4[server_time] - ($config[cf_popular_del] * (60 * 60* 24));
		$del_date	= date("Y-m-d", $del_date);
		sql_query("delete from $zmb[table_search_word] where db_date<='$del_date' and db_count<10");


		//-- 순위 변동
		$iRank		= 0;
		$rs	= sql_query("select db_recno, db_count from $zmb[table_search_word] order by db_count desc");
		while($rd = sql_fetch_array($rs)) {
			$iRank++;
			sql_query("update $zmb[table_search_word] set db_rank='$iRank' where db_recno='$rd[db_recno]'");
		}
		
		//-- 현재 순위 DB에 기록
		for($i = 0; $i < count($list); $i++) {
			$rd_realrank		= sql_fetch("select db_date, db_rank from $zmb[table_search_word] where db_word='{$list[$i][word]}'");
			$list[$i][realrank]	= $rd_realrank[db_rank];
			if($list[$i][realrank] < $list[$i][todayrank])	$list[$i][up]	= "up";
			if($list[$i][realrank] > $list[$i][todayrank])	$list[$i][up]	= "down";
			if($list[$i][realrank] == $list[$i][todayrank])	$list[$i][up]	= "";

			if($rd_realrank[db_date] == $now_date)		{
				$list[$i][up]		= "new";
				$list[$i][realrank]	= "";
			}
			
			sql_query("insert into $zmb[table_popular] set db_rank='{$list[$i][rank]}', db_word='{$list[$i][word]}', db_search_count='{$list[$i][count]}', db_up='{$list[$i][up]}', db_datetime='$now', db_todayrank='{$list[$i][todayrank]}', db_realrank='{$list[$i][realrank]}'");
		}

		//-- 이전의 검색어 정보 삭제 (당일 것만)
		$tmptoday	= date("Y-m-d 00:00:00", $g4[server_time]);
		if(substr($late_datetime, 0, 10) == substr($now, 0, 10))
			sql_query("delete from $zmb[table_popular] where db_datetime<='$late_datetime' and db_datetime>'$tmptoday'");

		//-- 인기검색어 자동 삭제 기간이 지난 기록은 삭제
		$del_date	= $g4[server_time] - ($config[cf_popular_del] * (60 * 60* 24));
		$del_date	= date("Y-m-d 23:59:59", $del_date);
		sql_query("delete from $zmb[table_popular] where db_datetime<='$del_date'");

	}else{ //-- 새 검색어 갱신 시간 안 지났음
		$rs_src	= sql_query("select * from $zmb[table_popular] where db_datetime='$late_datetime' order by db_recno asc, db_rank asc limit 0, 10");
		$list	= array();
		for($i = 0; $rd = sql_fetch_array($rs_src); $i++) {
			$list[$i][count]	= $rd[db_search_count];		//-- 검색 회수
			$list[$i][rank]		= $rd[db_rank];				//-- 순위
			$list[$i][word]		= $rd[db_word];				//-- 검색어
			$list[$i][up]		= $rd[db_up];				//-- 변동
			$list[$i][realrank]	= ($rd[db_realrank])? $rd[db_realrank] : "";			//-- 실시간 순위
			$list[$i][todayrank] = $rd[db_todayrank];
		}
	}

	$popular_skin_path = "$g4[path]/skin/popular/$skin_dir";
	for($i = 0; $i < count($list); $i++) {
		$list[$i][icon]		= "";

		$list[$i][changerank]	= abs($list[$i][realrank] - $list[$i][todayrank]);
		$list[$i][changerank]	= ($list[$i][changerank]) ? $list[$i][changerank] : "";
		if($list[$i][changerank] > 1000) $list[$i][changerank] = 999;					//-- 스킨에서 자릿수 때문. 필요에 따라 주석처리 해도 무방

		if($list[$i][up] == "up")
			$list[$i][icon]	= "<img src='$popular_skin_path/img/icon_rank_up.gif' valign='absmiddle'>";
		elseif($list[$i][up] == "down")
			$list[$i][icon]	= "<img src='$popular_skin_path/img/icon_rank_down.gif' valign='absmiddle'>";
		elseif($list[$i][up] == "new") {
			$list[$i][icon]	= "<img src='$popular_skin_path/img/icon_rank_new.gif' valign='absmiddle'>";
			$list[$i][changerank] = "";
		}else{
			$list[$i][icon]	= "<img src='$popular_skin_path/img/icon_rank_none.gif' valign='absmiddle'>";
			$list[$i][changerank] = "";
		}
	}

	ob_start();
    include_once ("$popular_skin_path/popular.skin.php");
    $content = ob_get_contents();
    ob_end_clean();

    return $content;
}









//-------------------------------------------------------------------------------------------------
//-- 그누보드 전용 스킨을 사용 할 때는 주석을 해제하고 위의 지음빌더용 함수를 주석 처리 하면 됨.
// 인기검색어 출력
// $skin_dir : 스킨 디렉토리
// $pop_cnt : 검색어 몇개
// $date_cnt : 몇일 동안
/* 그누보드4에서 사용하던 인기 검색어 함수 ------
function popular($skin_dir='basic', $pop_cnt=7, $date_cnt=3)
{
    global $config, $g4;

    if (!$skin_dir) $skin_dir = 'basic';

    $date_gap = date("Y-m-d", $g4[server_time] - ($date_cnt * 86400));
    $sql = " select pp_word, count(*) as cnt from $g4[popular_table]
              where pp_date between '$date_gap' and '$g4[time_ymd]'
              group by pp_word
              order by cnt desc, pp_word
              limit 0, $pop_cnt ";
    $result = sql_query($sql);
    for ($i=0; $row=sql_fetch_array($result); $i++) 
    {
        $list[$i] = $row;
        // 스크립트등의 실행금지
        $list[$i][pp_word] = get_text($list[$i][pp_word]);
    }

    ob_start();
    $popular_skin_path = "$g4[path]/skin/popular/$skin_dir";
    include_once ("$popular_skin_path/popular.skin.php");
    $content = ob_get_contents();
    ob_end_clean();

    return $content;
}
*/
?>