<?
/*
■ 동네예보 > 시간별예보
원하는 동네 주소를 선택한 후에 반드시 녹색 버튼의 [XML]의 주소를 구해야 함.
시/군/구, 동/읍/면 단위로 세분해서 주소를 구할 수 있음.
w_xml의 배열은 더 늘리거나 줄여도 상관 없음.

기상청에서 제공하는 xml은 프로그램 연동이라 지역이 5개 이상일 때 속도가 느릴 수 있습니다.
그럴 때는 원치 않는 지역은 주석처리 하시기 바랍니다.
*/

//-- 캐시파일이 저장 될 디렉토리가 없으면 생성
$cache_path	= "$g4[path]/data/zm.exp/service/kma";
if(!file_exists("$cache_path")) zm_mkdir("$cache_path");
$cache_file	= $cache_path."/cache_kma_weather.php";

$w_xml[0]		= array("원주", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=77&gridy=122");
$w_xml[1]		= array("강원", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=93&gridy=132");
$w_xml[2]		= array("경기", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=69&gridy=132");
$w_xml[3]		= array("경남", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=89&gridy=68");
$w_xml[4]		= array("경북", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=91&gridy=89");
$w_xml[5]		= array("광주", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=91&gridy=89");
$w_xml[6]		= array("대구", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=88&gridy=90");
$w_xml[7]		= array("대전", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=68&gridy=101");
$w_xml[8]		= array("부산", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=95&gridy=76");
$w_xml[9]		= array("서울", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=61&gridy=125");
$w_xml[10]		= array("세종", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=65&gridy=103");
$w_xml[11]		= array("울산", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=102&gridy=84");
$w_xml[12]		= array("인천", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=51&gridy=131");
$w_xml[13]		= array("전남", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=57&gridy=63");
$w_xml[14]		= array("전북", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=55&gridy=80");
$w_xml[15]		= array("제주", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=56&gridy=33");
$w_xml[16]		= array("충남", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=65&gridy=99");
$w_xml[17]		= array("충북", "http://www.kma.go.kr/wid/queryDFS.jsp?gridx=76&gridy=111");
/*
$arr_w[$i][HOUR] 예보 시간, [TEMP] 현재 기온, [POP]강수 확율, [REH] 습도, [WDKOR] 풍향
[DAY]날짜 : 0:오늘, 1:내일, 2:모래
[SKY]하늘 상태 : 맑음(1), 구름조금(2), 구름많음(3), 흐림(4)]
[PTY]강수 상태 : 없음(0), 비(1), 비/눈(2), 눈(3)

P없음(0), 비(1 rainy), 비/눈(2 rainy-snow), 눈(3 snow)
S맑음(1 sunny.gif), 구름조금(2 m-cloudy), 구름많음(3 partly-cloudy), 흐림(4 fair)
*/
$wiconP		= array(1=>"rainy.gif", "rainy-snow.gif", "snow.gif");
$wtxtP		= array(1=>"비", "비 또는 눈", "눈");
$wiconS		= array(1=>"sunny.gif", "m-cloudy.gif", "partly-cloudy.gif", "fair.gif");
$wtxtS		= array(1=>"맑음", "구름조금", "구름많음", "흐림");
$w_data		= array();
$i			= 0;


//-- 캐시 파일이 10분 이상 지났으면 날씨 정보 갱신 후 캐시 저장
if(file_exists($cache_file)) {
	$filetime	= filectime($cache_file);
}else{
	$filetime	= 0;
}

//-- 새글 캐쉬 시간이 지났으면 각 지역별 날씨 정보 파일 작성
if($filetime < ($g4[server_time]-600)){
	foreach($w_xml as $k=>$v){
		$xml_file	= $cache_path . "/xml_".$k.".php";
		$xml_data	= zm_away_fopen($v[1]);
		$fh		= @fopen("$xml_file", "w");
		//-- xml 부분만 축출
		$tmp	= explode("<?xml", $xml_data);
		$xml_data	= "<?xml" . $tmp[1];
		@fwrite($fh, $xml_data);
		fclose($fh);
	}
	@clearstatcache();

	//-- 각 지역별 캐시 파일을 읽어와서 파싱한다.
	$list_json	= "";
	foreach($w_xml as $k=>$v) {
		$xml_file	= $cache_path . "/xml_".$k.".php";
		$parser		= new xml2array($xml_file);
		$arr_w		= $parser->getArray("WID/BODY/DATA");		//-- 날씨 정보
		$w_data[$i][LOCA]	= $v[0];			//-- 지역
		$w_data[$i][TEMP]	= $arr_w[0][TEMP]	;		//-- 현재 온도
		$w_data[$i][PTY]	= $arr_w[0][PTY];			//-- 강수 상태
		$w_data[$i][SKY]	= $arr_w[0][SKY];			//-- 하늘 상태
		$w_data[$i][REH]	= $arr_w[0][REH];			//-- 습도
		if($w_data[$i][PTY]) {
			$w_data[$i][ICON]	= $zms[service_path] . "/img/" . $wiconP[$w_data[$i][PTY]];		//-- 날씨 아이콘
			$w_data[$i][TXT]		= $wtxtP[$w_data[$i][PTY]];
		}else{
			$w_data[$i][ICON]	= $zms[service_path] . "/img/" . $wiconS[$w_data[$i][SKY]];
			$w_data[$i][TXT]		= $wtxtS[$w_data[$i][SKY]];
		}
		$i++;
	} //-- end foreach

	$list_json	= json_encode($w_data);

	//-- 파일 쓰기
	$fh		= @fopen("$cache_file","w");
	@fwrite($fh, $list_json);
	fclose($fh);
	@clearstatcache();
} //-- end if

//-- 캐시 파일에서 날씨 정보 읽어 옮.
$tmp_cache	= "";
$tmp_list	= array();
$w_data		= array();
$data		= @file("$cache_file");
for($i = 0; $i < sizeof($data); $i++)	$tmp_cache .= $data[$i];

$tmp_list	= json_decode($tmp_cache);
for($i = 0; $i < count($tmp_list); $i++) {
	foreach($tmp_list[$i] as $key => $val) {
		$w_data[$i][$key]	= $val;
	}
}

?>