<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

?>
<div class="card border-primary">
    <div class="card-header bg-primary text-white text-center">
      <h6><i class="fa fa-database" aria-hidden="true"></i> <?php echo $g5['title'] ?>
      <button type="button" onclick="window.close();" class="btn btn-default btn-sm border float-right">창닫기</button>
      </h6>
    </div>
    <div class="card-body">
      <h6 class="card_title bg-success p-2">
          보유포인트
          <span class="float-right"><i class="fa fa-database" aria-hidden="true"></i> <?php echo number_format($member['mb_point']); ?></span>
      </h6>
            <?php
            $sum_point1 = $sum_point2 = $sum_point3 = 0;

            $sql = " select *
                        {$sql_common}
                        {$sql_order}
                        limit {$from_record}, {$rows} ";
            $result = sql_query($sql);
            for ($i=0; $row=sql_fetch_array($result); $i++) {
                $point1 = $point2 = 0;
                if ($row['po_point'] > 0) {
                    $point1 = '+' .number_format($row['po_point']);
                    $sum_point1 += $row['po_point'];
                } else {
                    $point2 = number_format($row['po_point']);
                    $sum_point2 += $row['po_point'];
                }

                $po_content = $row['po_content'];

                $expr = '';
                if($row['po_expired'] == 1)
                    $expr = ' txt_expired';
            ?>
            <p class="card-text border mb-1">
                <div class="point_top">
                    <span class="point_tit"><?php echo $po_content; ?></span>
                    <span class="float-right"><?php if ($point1) echo $point1; else echo $point2; ?></span>

                </div>
                <span class="point_date1"><i class="fa fa-clock-o" aria-hidden="true"></i> <?php echo $row['po_datetime']; ?></span>
                <span class="point_date<?php echo $expr; ?>">
                    <?php if ($row['po_expired'] == 1) { ?>
                    만료 <?php echo substr(str_replace('-', '', $row['po_expire_date']), 2); ?>
                    <?php } else echo $row['po_expire_date'] == '9999-12-31' ? '&nbsp;' : $row['po_expire_date']; ?>
                </span>
            </p>
            <?php
            }

            if ($i == 0)
                echo '<li class="empty_li">자료가 없습니다.</li>';
            else {
                if ($sum_point1 > 0)
                    $sum_point1 = "+" . number_format($sum_point1);
                $sum_point2 = number_format($sum_point2);
            }
            ?>

            <p class="card-text bg-secondary p-2 text-white mt-2">
                소계
                <span class="float-right"><?php echo $sum_point1; ?></span>
                <span class="float-right"><?php echo $sum_point2; ?></span>
            </p>
    </div>
    <div class="card-footer">
    <?php echo get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, $_SERVER['SCRIPT_NAME'].'?'.$qstr.'&amp;page='); ?>
  </div>
</div>
