<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

?>

<!-- 자기소개 시작 { -->
<div class="card border-primary">
    <div class="card-header bg-primary text-white text-center">
      <h6><?php echo $mb_nick ?>님의 프로필
      <button type="button" onclick="window.close();" class="btn btn-default btn-sm border float-right">창닫기</button>
      </h6>
    </div>
    <div class="card-body">
        <div class="card-text">
            <span class="my_profile_img">
                <?php echo get_member_profile_img($mb['mb_id']); ?>
            </span>
            <?php echo $mb_nick ?>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
            <tbody>
            <tr>
                <th scope="row"><i class="fa fa-star-o" aria-hidden="true"></i>  회원권한</th>
                <td><?php echo $mb['mb_level'] ?></td>
                <th scope="row"><i class="fa fa-database" aria-hidden="true"></i> 포인트</th>
                <td><?php echo number_format($mb['mb_point']) ?></td>
            </tr>
            <tr>
                <th scope="row"><i class="fa fa-clock-o" aria-hidden="true"></i> 회원가입일</th>
                <td><?php echo ($member['mb_level'] >= $mb['mb_level']) ?  substr($mb['mb_datetime'],0,10) ." (".number_format($mb_reg_after)." 일)" : "알 수 없음";  ?></td>
                <th scope="row"><i class="fa fa-clock-o" aria-hidden="true"></i> 최종접속일</th>
                <td><?php echo ($member['mb_level'] >= $mb['mb_level']) ? $mb['mb_today_login'] : "알 수 없음"; ?></td>
            </tr>
            <?php if ($mb_homepage) {  ?>
            <tr>
                <th scope="row"><i class="fa fa-home" aria-hidden="true"></i> 홈페이지</th>
                <td colspan="3"><a href="<?php echo $mb_homepage ?>" target="_blank"><?php echo $mb_homepage ?></a></td>
            </tr>
            <?php }  ?>

            </tbody>
            </table>
          </div>
    </div>
    <div class="card-footer">
        <h6>인사말</h6>
        <p><?php echo $mb_profile ?></p>
    </div>
</div>
<!-- } 자기소개 끝 -->
