<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH.'/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_javascript('<script src="'.G5_THEME_JS_URL.'/newWaterfall.js"></script>', 10);
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/style.css">', 0);
?>


<!-- 게시판 목록 시작 { -->
<div id="bo_gall" style="width:<?php echo $width; ?>">

    <?php if ($is_category) { ?>
    <nav id="bo_cate">
        <h2><?php echo $board['bo_subject'] ?> 카테고리</h2>
        <ul id="bo_cate_ul">
            <?php echo $category_option ?>
        </ul>
    </nav>
    <?php } ?>

    <div class="bo_gall_wr">
        <!-- 게시판 페이지 정보 및 버튼 시작 { -->
        <div id="bo_btn_top">

            <!-- 게시판 검색 시작 { -->
            <fieldset id="bo_sch">
                <legend>게시물 검색</legend>

                <form name="fsearch" method="get">
                <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
                <input type="hidden" name="sca" value="<?php echo $sca ?>">
                <input type="hidden" name="sop" value="and">
                <label for="sfl" class="sound_only">검색대상</label>
                <select name="sfl" id="sfl">
                    <option value="wr_subject"<?php echo get_selected($sfl, 'wr_subject', true); ?>>제목</option>
                    <option value="wr_content"<?php echo get_selected($sfl, 'wr_content'); ?>>내용</option>
                    <option value="wr_subject||wr_content"<?php echo get_selected($sfl, 'wr_subject||wr_content'); ?>>제목+내용</option>
                    <option value="mb_id,1"<?php echo get_selected($sfl, 'mb_id,1'); ?>>회원아이디</option>
                    <option value="mb_id,0"<?php echo get_selected($sfl, 'mb_id,0'); ?>>회원아이디(코)</option>
                    <option value="wr_name,1"<?php echo get_selected($sfl, 'wr_name,1'); ?>>글쓴이</option>
                    <option value="wr_name,0"<?php echo get_selected($sfl, 'wr_name,0'); ?>>글쓴이(코)</option>
                </select>
                <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
                <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="sch_input" size="25" maxlength="20" placeholder="검색어를 입력해주세요">
                <input type="submit" value="검색" class="sch_btn">
                </form>
            </fieldset>
        </div>
        <!-- } 게시판 페이지 정보 및 버튼 끝 -->


        <form name="fboardlist"  id="fboardlist" action="<?php echo G5_BBS_URL; ?>/board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post">
        <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
        <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
        <input type="hidden" name="stx" value="<?php echo $stx ?>">
        <input type="hidden" name="spt" value="<?php echo $spt ?>">
        <input type="hidden" name="sst" value="<?php echo $sst ?>">
        <input type="hidden" name="sod" value="<?php echo $sod ?>">
        <input type="hidden" name="page" value="<?php echo $page ?>">
        <input type="hidden" name="sw" value="">
        
        <?php if ($list_href || $is_checkbox || $write_href) { ?>
        <div class="bo_fx">
            <?php if ($list_href || $write_href) { ?>
            <ul class="btn_bo_user">
                <?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>" class="list_btn"><i class="fa fa-rss" aria-hidden="true"></i> <span class="sound_only">RSS</span></a></li><?php } ?>
                <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="list_btn admin"><i class="fa fa-user-circle" aria-hidden="true"></i><span class="sound_only">관리자</span></a></li><?php } ?>
                <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="list_btn"><i class="fa fa-pencil" aria-hidden="true"></i><span class="sound_only">글쓰기</span></a></li><?php } ?>
                <?php if ($is_checkbox) { ?>
                <li>
                    <button type="button" class="edit_op_btn view_op_btn_list"><i class="fa fa-ellipsis-v" aria-hidden="true"></i><span class="sound_only">게시판 리스트수정</span></button>
                    <ul class="btn_edit btn_list_op">
                        <li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value" class=""><i class="fa fa-trash-o" aria-hidden="true"></i> 선택삭제</button></li>
                        <li><button type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value" class=""><i class="fa fa-files-o" aria-hidden="true"></i> 선택복사</button></li>
                        <li><button type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value" class=""><i class="fa fa-arrows" aria-hidden="true"></i> 선택이동</button></li>
                    </ul>
                </li>

                <?php } ?>
            </ul>

            <?php } ?>
        </div>
        <?php } ?>

         <?php if ($is_checkbox) { ?>
        <script>
        $(function(){
            $(".view_op_btn_list").click(function(){
                $(".btn_list_op").toggle();
            });
            $(document).mouseup(function (e) {
                var container = $(".btn_list_op");
                if (!container.is(e.target) && container.has(e.target).length === 0){
                container.css("display","none");
                }	
            });
        });
        </script>
        <?php } ?>

        <?php if ($is_checkbox) { ?>
        <div id="gall_allchk">
            <input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);">
            <label for="chkall">게시물 전체</label>
        </div>
        <?php } ?>

        <ul id="gall_ul" class="gall_row">
            <?php for ($i=0; $i<count($list); $i++) {

                $classes = array();
                
                $classes[] = 'gall_li';
                $classes[] = 'col-gn-'.$bo_gallery_cols;

                if( $i && ($i % $bo_gallery_cols == 0) ){
                    $classes[] = 'box_clear';
                }

                if( $wr_id && $wr_id == $list[$i]['wr_id'] ){
                    $classes[] = 'gall_now';
                }
             ?>
            <li class="<?php echo implode(' ', $classes); ?>">
                <div class="gall_wr">
                    <div class="gall_chk">
                    <?php if ($is_checkbox) { ?>
                    <label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
                    <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
                    <?php } ?>
                    <span class="sound_only">
                        <?php
                        if ($wr_id == $list[$i]['wr_id'])
                            echo "<span class=\"bo_current\">열람중</span>";
                        else
                            echo $list[$i]['num'];
                         ?>
                    </span>
                    </div>
                     <a href="<?php echo $list[$i]['href'] ?>">
                        <?php
                        if ($list[$i]['is_notice']) { // 공지사항  ?>
                            <span class="is_notice">공지</span>
                        <?php } else {
                            $thumb = get_list_thumbnail($board['bo_table'], $list[$i]['wr_id'], $board['bo_gallery_width'],0, false, true);

                            if($thumb['src']) {
                                $img_content = '<img src="'.$thumb['src'].'" alt="'.$thumb['alt'].'" >';
                            } else {
                                $img_content = '<img src="'.G5_THEME_IMG_URL.'/no_img.png" alt="이미지 없음">';
                            }

                            echo $img_content;
                        }
                         ?>
                    </a>
                    <div class="gall_con">
           
                           
                        <div class="gall_text_href">
                            <?php
                            // echo $list[$i]['icon_reply']; 갤러리는 reply 를 사용 안 할 것 같습니다. - 지운아빠 2013-03-04
                            if ($is_category && $list[$i]['ca_name']) {
                             ?>
                            <a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a>
                            <?php } ?>
                            <a href="<?php echo $list[$i]['href'] ?>" class="bo_tit">
                                <?php echo $list[$i]['subject'] ?>
                             </a>
                            <span class="gall_date"><i class="fa fa-calendar"></i> <span class="sound_only">작성일 </span><?php echo $list[$i]['datetime2'] ?></span>
                            <?php if ($list[$i]['comment_cnt']) { ?><span class="bo_comment"><i class="fa fa-comment-o" aria-hidden="true"></i> <?php echo $list[$i]['comment_cnt']; ?></span><?php } ?> 
                        </div>

                    </div>
                </div>

            </li>
            <?php } ?>
            <?php if (count($list) == 0) { echo "<li class=\"empty_list\" datano='no'>게시물이 없습니다.</li>"; } ?>
        </ul>
        <div class="bo_more">
            <button type="button" class="more_btn">MORE</button>
        </div>
        
        </form>
    </div> 

</div>



<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>



<!-- 페이지 -->
<span id="page_n" style="display:none;">2</span>
<script type="text/javascript">
$( document ).ready(function(){

    $( ".more_btn" ).click(function(){
        $( this ).html( '<i class="fa fa-spinner fa-spin"></i>' );
        
        var disp_li_length = $( "#gallery_json > li" ).length;
        var page_n = $('#page_n').html();
        $.get( "<?php echo G5_URL?>/bbs/board.php?bo_table=<?php echo $bo_table?>&ajax_ck=1&sca=<?php echo urlencode($sca) ?>&page="+page_n, function( data ) {
            var append_data = $( data ).find('#gall_ul').html();
            var cking = $( data ).find('.empty_list').attr("datano");

            if(cking != "no"){
                $('#page_txt').html('');
                $('#gall_ul').append(append_data);
                $('#page_n').html(parseInt(page_n)+1);
                $( ".more_btn" ).html( 'MORE' );
            } else {
                alert( '게시물이 존재하지 않습니다.' );
                $( ".more_btn" ).html( 'MORE' );
            }
        });

    });

});
</script>

<script>
$('#gall_ul').NewWaterfall({
    width:350,
    delay: 60,
    repeatShow: false

});

$("#container_wr").removeClass("container_wr");

</script>     

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = g5_bbs_url+"/board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == 'copy')
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = g5_bbs_url+"/move.php";
    f.submit();
}
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
