<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 6;

if ($is_checkbox) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$qa_skin_url.'/style.css">', 0);
?>

<div id="bo_list">

    <?php if ($category_option) { ?>
    <!-- 카테고리 시작 { -->
    <nav id="bo_cate">
        <h2><?php echo $qaconfig['qa_title'] ?> 카테고리</h2>
        <ul id="bo_cate_ul">
            <?php echo $category_option ?>
        </ul>
    </nav>
    <!-- } 카테고리 끝 -->
    <?php } ?>

    
    <div class="bo_list_wr">    
        <!-- 게시판 검색 시작 { -->
        <div id="bo_btn_top">
        <fieldset id="bo_sch">
            <legend>게시물 검색</legend>

            <form name="fsearch" method="get">
            <input type="hidden" name="sca" value="<?php echo $sca ?>">
            <label for="stx" class="sound_only">검색어<strong class="sound_only"> 필수</strong></label>
            <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" id="stx" required  class="sch_input" size="25" maxlength="15">
            <button type="submit" value="검색" class="sch_btn"><i class="fa fa-search" aria-hidden="true"></i><span class="sound_only">검색</span></button>
            </form>
        </fieldset>
        </div>
        <!-- } 게시판 검색 끝 -->

        <form name="fqalist" id="fqalist" action="./qadelete.php" onsubmit="return fqalist_submit(this);" method="post">
        <input type="hidden" name="stx" value="<?php echo $stx; ?>">
        <input type="hidden" name="sca" value="<?php echo $sca; ?>">
        <input type="hidden" name="page" value="<?php echo $page; ?>">

        <?php if ($admin_href || $write_href) { ?>
         <div class="bo_fx">
            <ul class="btn_bo_user">
                <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>" class="list_btn"><i class="fa fa-user-circle" aria-hidden="true"></i> <span class="sound_only">관리자</span></a></li><?php } ?>
                <?php if ($list_href) { ?><li><a href="<?php echo $list_href ?>" class="list_btn"><i class="fa fa-list" aria-hidden="true"></i> <span class="sound_only">목록</span></a></li><?php } ?>

                <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>" class="list_btn"><i class="fa fa-pencil" aria-hidden="true"></i> <span class="sound_only">문의등록</span></a></li><?php } ?>
                <?php if ($is_checkbox) { ?>
                 <li>
                    <button type="button" class="edit_op_btn view_op_btn_list"><i class="fa fa-ellipsis-v" aria-hidden="true"></i><span class="sound_only">게시판 리스트수정</span></button>
                    <ul class="btn_edit btn_list_op">
                        <li><button type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value"><i class="fa fa-trash-o" aria-hidden="true"></i> 선택삭제</button></li>
                    </ul>
                    
                </li>
                <?php } ?>

            </ul>
        </div>
        <?php } ?>
        <div class="board_list">
                <?php if ($is_checkbox) { ?>
                <div class="all_chk">
                    <input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);">
                    <label for="chkall">게시물 전체</label>
                </div>
                <?php } ?>
            <ul>  
            <?php
            for ($i=0; $i<count($list); $i++) {
            ?>
            <li class="li_cate">
                <div class="bo_subject">
                    <?php if ($is_checkbox) { ?>
                    <span class="bo_chk">
                        <label for="chk_qa_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject']; ?></label>
                        <input type="checkbox" name="chk_qa_id[]" value="<?php echo $list[$i]['qa_id'] ?>" id="chk_qa_id_<?php echo $i ?>">
                    </span>
                    <?php } ?>
                    <span class="sound_only"><?php echo $list[$i]['num']; ?></span>
                    <span class="bo_cate_link"><?php echo $list[$i]['category']; ?></span>
                    <a href="<?php echo $list[$i]['view_href']; ?>" class="bo_subject">
                        <?php echo $list[$i]['subject']; ?>
                        <?php if ($list[$i]['icon_file']) echo " <i class=\"fa fa-download\" aria-hidden=\"true\"></i>" ; ?>
                    </a>
                   
                </div>
                 <div class="bo_info">
                    <span class="td_name"><?php echo $list[$i]['name']; ?></span>
                    <span class="bo_date"><i class="fa fa-calendar"></i> <?php echo $list[$i]['date']; ?></span>
                    <span class="td_stat <?php echo ($list[$i]['qa_status'] ? 'txt_done' : 'txt_rdy'); ?>"><?php echo ($list[$i]['qa_status'] ? '답변완료' : '답변대기'); ?></span>
                </div>
            </li>
            <?php
            }
            ?>

            <?php if ($i == 0) { echo '<tr><td colspan="'.$colspan.'" class="empty_table">게시물이 없습니다.</td></tr>'; } ?>
            </ul>
        </div>

        </form>
    </div>

</div>

     <?php if ($is_checkbox) { ?>
    <script>
    $(function(){
        $(".view_op_btn_list").click(function(){
            $(".btn_list_op").toggle();
        });
        $(document).mouseup(function (e) {
            var container = $(".btn_list_op");
            if (!container.is(e.target) && container.has(e.target).length === 0){
            container.css("display","none");
            }	
        });
    });
    </script>
    <?php } ?>
<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>

<!-- 페이지 -->
<?php echo $list_pages;  ?>


<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fqalist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_qa_id[]")
            f.elements[i].checked = sw;
    }
}

function fqalist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_qa_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다"))
            return false;
    }

    return true;
}
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->