jQuery(document).ready(function() {
    jQuery("#top_btn").on("click", function() {
        jQuery("html, body").animate({scrollTop:0}, '500');
        return false;
    });

    // Login or register popover
    jQuery('#loginOrRegister').popover({
        container: 'body',
        placement: 'bottom',
        template: '<div class="popover login-popover" role="tooltip"><div class="arrow"></div><div class="popover-content"></div></div>',
        html: true,
        content: function() {
            return jQuery("#loginOrRegisterContent").html();
        },
    });

    // Default catch for all other popovers
    jQuery('[data-toggle="popover"]').popover({
        html: true
    });

    // Logic to dismiss popovers on click outside
    jQuery('body').on('click', function (e) {
        jQuery('[data-toggle="popover"]').each(function () {
            if (!jQuery(this).is(e.target) && jQuery(this).has(e.target).length === 0 && jQuery('.popover').has(e.target).length === 0) {
                jQuery(this).popover('hide');
            }
        });
    });
    $('[data-toggle="tooltip"]').tooltip();
});
function fsearchbox_submit(f)
{
    if (f.stx.value.length < 2) {
        alert("검색어는 두글자 이상 입력하십시오.");
        f.stx.select();
        f.stx.focus();
        return false;
    }

    // 검색에 많은 부하가 걸리는 경우 이 주석을 제거하세요.
    var cnt = 0;
    for (var i=0; i<f.stx.value.length; i++) {
        if (f.stx.value.charAt(i) == ' ')
            cnt++;
    }

    if (cnt > 1) {
        alert("빠른 검색을 위하여 검색어에 공백은 한개만 입력할 수 있습니다.");
        f.stx.select();
        f.stx.focus();
        return false;
    }

    return true;
}

// 현재 스크롤바의 위치를 저장하는 변수 (px)
var currentScrollTop = 0;
     
// 비동기식 jQuery이므로 window load 후 jQuery를 실행해야 함
$(document).ready(function(){
    // 새로고침 했을 경우를 대비한 메소드 실행
    PCscrollController();
    MOBILEscrollController();


    // 스크롤을 하는 경우에만 실행됨
    $(window).on('scroll', function() {
        currentWidth = $(window).width();
        if (currentWidth > 768) {
            PCscrollController();
        }
        if (currentWidth < 768) {
            MOBILEscrollController();
        }
    });
});
// PC 메인 메뉴의 위치를 제어하는 함수
function PCscrollController() {
    var gnb_header = $('.header-logo');
    var gnb_navbar = $('.navbar-collapse');
    var gnb_wrapper = $('#wrapper');
    var currentWidth = $(window).width();
    var gnb_scroll = $(window).scrollTop();

    if (gnb_scroll >= 121){
        gnb_navbar.addClass('fixed');
        gnb_wrapper.addClass('margin');
        gnb_header.removeClass('fixed');
    } else {
        gnb_header.removeClass('fixed');
        gnb_navbar.removeClass('fixed');
        gnb_wrapper.removeClass('margin');
    }
}
// MOBILE 메인 메뉴의 위치를 제어하는 함수
function MOBILEscrollController() {

    var gnb_header = $('.header-logo');
    var gnb_wrapper = $('#wrapper');
    var gnb_scroll = $(window).scrollTop();

    if (gnb_scroll >= 41){
        gnb_header.addClass('fixed');
        gnb_wrapper.addClass('margin');
    } else {
        gnb_header.removeClass('fixed');
        gnb_wrapper.removeClass('margin');
    }
/*
    currentWidth = $(window).width();
    currentScrollTop = $(window).scrollTop();
    if (currentWidth < 768 && currentScrollTop > 41) {
        if (!$('.header-logo').hasClass('fixed')) {
            $('.header-logo').css('top', -10);
            $('.header-logo').addClass('fixed');
        }
    } else {
        $('.header-logo').css('top', 41-(currentScrollTop));
        if ($('.header-logo').hasClass('fixed')) {
            $('.header-logo').removeClass('fixed');
        }
    }
*/
}