	<li style="cursor:pointer;display:flex;align-items:center;z-index:11">
		<a id="mode-remover" class="btn1 hidden" title="Dark mode"></a>
		<a id="mode-toggler" class="btn1" title="Background mode">🌓</a>
	</li>

	<script async defer src="<?php echo G5_THEME_URL ?>/js/buttons.js"></script>
	<script src="<?php echo G5_THEME_URL ?>/js/darkmode.min.js"></script>
	<script>
    // Plugin Initialization
    var options = {
			light: '<?php echo G5_THEME_URL ?>/css/light.css',
			dark: '<?php echo G5_THEME_URL ?>/css/dark.css',
    }
    var DarkMode = new DarkMode(options)

    // Remove mode from LocalStorage if button clicked
    var ModeRemover = document.getElementById('mode-remover')
    ModeRemover.onclick = function() {
      DarkMode.clearSavedMode()
      changeTogglerText()
      getModeRemoverState()
    }

    // Detects mode on LocalStorage, if `true` – display a button
    getModeRemoverState()
    function getModeRemoverState() {
      if(DarkMode.isModeSaved())
        ModeRemover.classList.remove('hidden')
      else
        ModeRemover.classList.add('hidden')
    }
    
    // Function for `mode-toggler` button
    var ModeToggler = document.getElementById('mode-toggler')
    changeTogglerText()
	  ModeToggler.onclick = function() {
      DarkMode.toggleMode()
      changeTogglerText()
    }
    
    // Changes `mode-toggler` text on mode changing
    function changeTogglerText() {
      getModeRemoverState()
      var currentMode = DarkMode.getMode()
      ModeToggler.textContent = currentMode === 'light'  ? '🌝' : '🌚'
    }
	</script>