<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

/*=======================================================================
코로나 확진자수 표시 그누보드 플러그인 v1.2.3
그누보드 5.3버전 용
제작 : 예아넷 ( https://ye-ah.net/ )
코로나 조심하시고 모두 건강하세요
이 플러그인이 필요없어질 날이 다가오길 기원합니다.
=======================================================================*/

// 밑의 return; 코드의 주석을 해제하면 사용 안함
//return;

corona_status_embed_fn_script();

function corona_status_embed_fn_script(){
    global $bo_table, $is_member;

    if(defined('G5_IS_ADMIN'))
        return false;

    // newDecide : 일일확진자 , today(오늘) || yesterday(어제) => 0 : 확진자, 1 : 사망자, 2 : 격리해제, 3 : 치료중, 4 : 총검사자, 5 : 검사중 , 6 : 총검사완료, 7 : 결과음성
    $corona_data = get_corona_status();

    if($bo_table == 'corona19') {
        $newDecide           = view_compare_data($corona_data['newDecide']);
        $deathCntCompare     = (int)$corona_data['today'][1] - (int)$corona_data['yesterday'][1];
        $careCntCompare      = (int)$corona_data['today'][3] - (int)$corona_data['yesterday'][3];
        $clearCntCompare     = (int)$corona_data['today'][2] - (int)$corona_data['yesterday'][2];
        $accExamCntCompare   = (int)$corona_data['today'][4] - (int)$corona_data['yesterday'][4];
        $examCntCompare      = (int)$corona_data['today'][5] - (int)$corona_data['yesterday'][5];
        $resutlNegCntCompare = (int)$corona_data['today'][7] - (int)$corona_data['yesterday'][7];
        $Lethality           = round(((int)$corona_data['today'][1] / (int)$corona_data['today'][0]) * 100, 2).'%';

        $output_value = "<div id='corona_data_view'>";
        $output_value .= "<div>확진자수<BR><span class='today_data'>" . number_format($corona_data['today'][0]) . "</span><BR>".$newDecide."</div>";
        $output_value .= "<div>사망자<BR><span class='today_data'>" . number_format($corona_data['today'][1]) . "</span><BR>".view_compare_data($deathCntCompare)."</div>";
        $output_value .= "<div>치료중<BR><span class='today_data'>" . number_format($corona_data['today'][3]) . "</span><BR>".view_compare_data($careCntCompare)."</div>";
        $output_value .= "<div>격리해제<BR><span class='today_data'>" . number_format($corona_data['today'][2]) . "</span><BR>".view_compare_data($clearCntCompare)."</div>";
        $output_value .= "<div>치명률<BR><span class='today_data'>{$Lethality}</span></div>";
        $output_value .= "<div>총검사자<BR><span class='today_data'>" . number_format($corona_data['today'][4]) . "</span><BR>".view_compare_data($accExamCntCompare)."</div>";
        $output_value .= "<div>검사중<BR><span class='today_data'>" . number_format($corona_data['today'][5]) . "</span><BR>".view_compare_data($examCntCompare)."</div>";
        $output_value .= "<div>음성결과자<BR><span class='today_data'>" . number_format($corona_data['today'][7]) . "</span><BR>".view_compare_data($resutlNegCntCompare)."</div>";
        $output_value .= "</div>";
    }

    $aside_id = $is_member? 'ol_after' : 'ol_before';
    $aside_output = "<section id='ol_corona_data' class='ol'>";
    $aside_output .= "<div class='corona_view_link'><i class='fa fa-plus-square'></i> 코로나19 대한민국 현황</div>";
    $aside_output .= "[".date("y.m.d" ,strtotime($corona_data['renewalDate']))."] 확진자 <span class='new_decide'>".number_format($corona_data['today'][0])."</span>명<BR>";
    $aside_output .= "[".date("y.m.d" ,strtotime($corona_data['renewalDate']))."] 신규확진자 <span class='".(($corona_data['newDecide']>0)?'new_decide':'minus')."'>".(($corona_data['newDecide']>0)?'+':'').number_format($corona_data['newDecide'])."</span>명<BR>";
    $aside_output .= "<div class='corona_view_link' style='margin-top:5px;'><i class='fa fa-arrow-right'></i> 대한민국 현황 상세보기</div>";
    $aside_output .= "</section>";
    ?>
    <style>
        #corona_data_view {margin:5px 0;padding:10px;border-radius: 5px;display: flex;flex-wrap: wrap;justify-content:center;text-align: center;
            background: none;
            border: 1px solid #d2d9e6;
            border-bottom: 1px solid #c1ccda;
            -webkit-box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            -moz-box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);}
        #corona_data_view div {<?php echo (G5_IS_MOBILE)? 'margin: 10px;' : 'margin: 0 18px;' ;?>}
        #corona_data_view .today_data {<?php echo (G5_IS_MOBILE)? 'font-size: 1.5em;' : 'font-size: 1.75em;' ;?>font-weight: bold;}
        #corona_data_view .compare {color:red;}
        #corona_data_view .minus {color:blue;}

        #ol_corona_data {<?php echo (G5_IS_MOBILE)? 'padding: 0 10px;' : 'padding: 10px;' ;?>text-align: center;
            background: none;
            border: 1px solid #d2d9e6;
            border-bottom: 1px solid #c1ccda;
            -webkit-box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            -moz-box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);}
        #ol_corona_data .corona_view_link {padding: 5px;border: 1px solid #d9d9d9;border-radius: 5px;cursor:pointer;}
        #ol_corona_data .new_decide {color:red;font-size: 1.5em;}
        #ol_corona_data .minus {color:blue;font-size: 1.5em;}
    </style>
    <script>
        window.onload = function(){
            <?php if($bo_table == 'corona19') { ?>$('#bo_list').before("<?php echo $output_value; ?>");<?php } ?>

            $('#<?php echo $aside_id; ?>').after("<?php echo $aside_output; ?>");
            $('.corona_view_link').click(function(){
                window.location.href = g5_bbs_url+'/board.php?bo_table=corona19';
            });
        };
    </script>
    <?php

    return true;
}

//현황 상세보기 - 전일증감 보기
function view_compare_data($data){
    $value = "<span class='".(($data>0)?'compare':'minus')."'>(".(($data>0)?'+':'').number_format($data).")</span>";
    return $value;
}

function get_corona_status($startCreateDt='', $endCreateDt='', $pageNo=1, $numOfRows=10)
{
    global $g5;

    $coronaData = array();
    $board = sql_fetch(" select * from {$g5['board_table']} where bo_table = 'corona19' ");

    //갱신한지 한시간뒤에 다시 갱신가능
    $re_timer = strtotime($board['bo_4'] . " +1 hours");
    if (strtotime(G5_TIME_YMDHIS) <= $re_timer && $board['bo_4']) {
        $coronaData['newDecide'] = $board['bo_1'];
        $coronaData['today'] = explode('|', $board['bo_2']);
        $coronaData['yesterday'] = explode('|', $board['bo_3']);
        $coronaData['renewalDate'] = $board['bo_4'];
        return $coronaData;
    }

    if ($startCreateDt == '')
        $startCreateDt = date("Ymd", strtotime(date("Ymd") . " -1 day"));
    if ($endCreateDt == '')
        $endCreateDt = date("Ymd");

    $data = getCovid19InfStateJson($startCreateDt, $endCreateDt, $pageNo, $numOfRows);

    if($data['today'][0]['data'] && $data['yesterday'][0]['data']){
        $newDecideCnt = $data['newDecideCnt'];
        $todayData = $data['today'][0]['data'];
        $yesterdayData  = $data['yesterday'][0]['data'];

        $sql_common = " bo_1_subj          = '신규확진자',
                        bo_2_subj           = '오늘감염현황데이터',
                        bo_3_subj           = '어제감염현황데이터',
                        bo_4_subj           = '갱신일',
                        bo_1                = '{$newDecideCnt}',
                        bo_2                = '{$todayData}',
                        bo_3                = '{$yesterdayData}',
                        bo_4                = '" . G5_TIME_YMDHIS . "'";
        $sql = " update {$g5['board_table']}
                    set {$sql_common}
                  where bo_table = '{$board['bo_table']}' ";
        sql_query($sql);
    }

    $board = sql_fetch(" select * from {$g5['board_table']} where bo_table = 'corona19' ");
    $coronaData['newDecide'] = $board['bo_1'];
    $coronaData['today'] = explode('|', $board['bo_2']);
    $coronaData['yesterday'] = explode('|', $board['bo_3']);
    $coronaData['renewalDate'] = $board['bo_4'];
    return $coronaData;
}

//감염 현황
function getCovid19InfStateJson($startCreateDt, $endCreateDt, $pageNo=1, $numOfRows=10){
    $ch = curl_init();
    $url = 'http://openapi.data.go.kr/openapi/service/rest/Covid19/getCovid19InfStateJson'; /*URL*/
    $queryParams = '?' . urlencode('ServiceKey') . '=%2FpOWB2BjzROnk5L2xAhvmcqJWhu77WgkBU8%2BDEsENkf4OLRmP1Tzmc9epur%2BnZtz6T5cj90tsAfeWlCwdjJ2%2Fg%3D%3D'; /*Service Key rve7V55yeeu1zqIoOaH2zn2H9zMhFjPiK1gW9BTltFGovgMQRgiSOglAD9WqcfF9fhcyIDsRULlImPwkoHddhg%3D%3D */
    $queryParams .= '&' . urlencode('pageNo') . '=' . urlencode($pageNo); /*페이지번호*/
    $queryParams .= '&' . urlencode('numOfRows') . '=' . urlencode($numOfRows); /*한 페이지 결과 수*/
    $queryParams .= '&' . urlencode('startCreateDt') . '=' . urlencode($startCreateDt); /*검색할 생성일 범위의 시작*/
    $queryParams .= '&' . urlencode('endCreateDt') . '=' . urlencode($endCreateDt); /*검색할 생성일 범위의 종료*/

    curl_setopt($ch, CURLOPT_URL, $url . $queryParams);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    $response = curl_exec($ch);
    curl_close($ch);

    $xml = simplexml_load_string($response);
    $data = json_decode(json_encode($xml), 1);

    $data_row = array();
    $today = 0;
    $yesterday = 0;
    foreach ($data['body']['items']['item'] as $row){
        //확진자, 사망자, 격리해제, 치료중, 총검사자, 검사중, 총검사완료, 결과음성
        $Data = $row['decideCnt'].'|'.$row['deathCnt'].'|'.$row['clearCnt'].'|'.$row['careCnt'].'|'.$row['accExamCnt'].'|'.$row['examCnt'].'|'.$row['accExamCompCnt'].'|'.$row['resutlNegCnt'];

        //어제 날짜와 같은경우
        if(date("Ymd", strtotime($row['createDt'])) == $startCreateDt){
            $data_row['yesterday'][$yesterday]['decideCnt'] = $row['decideCnt'];
            $data_row['yesterday'][$yesterday]['data'] = $Data;
            $yesterday++;
        }

        //오늘 날짜와 같은경우
        if(date("Ymd", strtotime($row['createDt'])) == $endCreateDt) {
            $data_row['today'][$today]['decideCnt'] = $row['decideCnt'];
            $data_row['today'][$today]['data'] = $Data;
            $today++;
        }
    }

    //신규확진자 = 오늘 확진자 수 - 어제 확진자 수
    $data_row['newDecideCnt'] = $data_row['today'][0]['decideCnt'] - $data_row['yesterday'][0]['decideCnt'];

    return $data_row;
}
?>
