<?php
$sub_menu = "550200";
include_once('./_common.php');

if ($is_admin != 'super')
    alert('최고관리자만 접근 가능합니다.');

// 메뉴테이블 생성

if(!sql_query(" DESCRIBE okone_okmenu ", false)) {
    sql_query(" CREATE TABLE IF NOT EXISTS `okone_okmenu` (
                  `me_id` int(11) NOT NULL AUTO_INCREMENT,
                  `me_code` varchar(255) NOT NULL DEFAULT '',
                  `me_name` varchar(255) NOT NULL DEFAULT '',
                  `me_link` varchar(255) NOT NULL DEFAULT '',
                  `me_type` varchar(255) NOT NULL DEFAULT '',
                  `me_order` int(11) NOT NULL DEFAULT '0',
                  PRIMARY KEY (`me_id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ", true);
}

$sql = " select * from okone_okmenu order by me_id ";
$result = sql_query($sql);

$g5['title'] = "okone 메뉴설정";
include_once(G5_ADMIN_PATH.'/admin.head.php');

$colspan = 5;
?>

<div class="local_desc01 local_desc">
    <p><strong>주의!</strong> 메뉴설정 작업 후 반드시 <strong>확인</strong>을 누르셔야 저장됩니다.</p>
    <p><strong>주의!</strong> Home(또는 홈)을 첫번째로 등록하고,메뉴타입은 '메인'으로 선택하면 메인슬라이드가 됩니다. 슬라이드를 올릴 게시판을 선택해 주세요.</p>
    <p>메뉴타입중 제품소개,파트너,FAQ는 메뉴링크로 게시판을 선택해 주세요.</p>
    <p>메뉴타입중 회사소개는 내용관리에 입력하고 메뉴링크를 선택해 주세요.</p>
    <p>메뉴타입중 고객센터는 링크정보에 임의의 값을 넣어 주세요. 기본설정에서 구글지도공유를 해주세요.</p>
</div>

<form name="fmenulist" id="fmenulist" method="post" action="./menu_okone_list_update.php" onsubmit="return fmenulist_submit(this);">
<input type="hidden" name="token" value="">



<div id="menulist" class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> 목록</caption>
    <thead>
    <tr>
        <th scope="col">메뉴</th>
        <th scope="col">링크</th>
        <th scope="col">타입</th>
        <th scope="col">순서</th>
        <th scope="col">관리</th>
    </tr>
    </thead>
    <tbody>
    <?php
    for ($i=0; $row=sql_fetch_array($result); $i++)
    {
        $bg = 'bg'.($i%2);
        $sub_menu_class = '';
        if(strlen($row['me_code']) == 4) {
            $sub_menu_class = ' sub_menu_class';
            $sub_menu_info = '<span class="sound_only">'.$row['me_name'].'의 서브</span>';
            $sub_menu_ico = '<span class="sub_menu_ico"></span>';
        }

        $search  = array('"', "'");
        $replace = array('&#034;', '&#039;');
        $me_name = str_replace($search, $replace, $row['me_name']);
    ?>
    <tr class="<?php echo $bg; ?> menu_list menu_group_<?php echo substr($row['me_code'], 0, 2); ?>">
        <td class="td_category<?php echo $sub_menu_class; ?>">
            <input type="hidden" name="code[]" value="<?php echo substr($row['me_code'], 0, 2) ?>">
            <label for="me_name_<?php echo $i; ?>" class="sound_only"><?php echo $sub_menu_info; ?> 메뉴<strong class="sound_only"> 필수</strong></label>
            <input type="text" name="me_name[]" value="<?php echo $me_name; ?>" id="me_name_<?php echo $i; ?>" required class="required tbl_input full_input">
        </td>
        <td>
            <label for="me_link_<?php echo $i; ?>" class="sound_only">링크<strong class="sound_only"> 필수</strong></label>
            <input type="text" name="me_link[]" value="<?php echo $row['me_link'] ?>" id="me_link_<?php echo $i; ?>" required class="required tbl_input full_input">
        </td>
        <td class="td_mng">
            <label for="me_type_<?php echo $i; ?>" class="sound_only">타입</label>
            <select name="me_type[]" id="me_type_<?php echo $i; ?>">
                <option value="slider"<?php echo get_selected($row['me_type'], 'slider', true); ?>>메인-slider</option>
                <option value="video"<?php echo get_selected($row['me_type'], 'video', true); ?>>메인-video</option>
                <option value="about"<?php echo get_selected($row['me_type'], 'about', true); ?>>회사소개</option>
                <option value="product"<?php echo get_selected($row['me_type'], 'product', true); ?>>제품소개</option>
                <option value="faq"<?php echo get_selected($row['me_type'], 'faq', true); ?>>FAQ</option>
                <option value="sponsor"<?php echo get_selected($row['me_type'], 'sponsor', true); ?>>파트너</option>
                <option value="contactus"<?php echo get_selected($row['me_type'], 'contactus', true); ?>>고객센터</option>
            </select>
        </td>
        <td class="td_num">
            <label for="me_order_<?php echo $i; ?>" class="sound_only">순서</label>
            <input type="text" name="me_order[]" value="<?php echo $row['me_order'] ?>" id="me_order_<?php echo $i; ?>" class="tbl_input" size="5">
        </td>
        <td class="td_mng">
            <button type="button" class="btn_del_menu btn_02">삭제</button>
        </td>
    </tr>
    <?php
    }

    if ($i==0)
        echo '<tr id="empty_menu_list"><td colspan="'.$colspan.'" class="empty_table">자료가 없습니다.</td></tr>';
    ?>
    </tbody>
    </table>
</div>

<div class="btn_fixed_top">
    <button type="button" onclick="return add_menu();" class="btn btn_02">메뉴추가<span class="sound_only"> 새창</span></button>
    <input type="submit" name="act_button" value="확인" class="btn_submit btn ">
</div>

</form>

<script>
$(function() {
    $(document).on("click", ".btn_del_menu", function() {
        if(!confirm("메뉴를 삭제하시겠습니까?"))
            return false;

        var $tr = $(this).closest("tr");
        if($tr.find("td.sub_menu_class").size() > 0) {
            $tr.remove();
        } else {
            var code = $(this).closest("tr").find("input[name='code[]']").val().substr(0, 2);
            $("tr.menu_group_"+code).remove();
        }

        if($("#menulist tr.menu_list").size() < 1) {
            var list = "<tr id=\"empty_menu_list\"><td colspan=\"<?php echo $colspan; ?>\" class=\"empty_table\">자료가 없습니다.</td></tr>\n";
            $("#menulist table tbody").append(list);
        } else {
            $("#menulist tr.menu_list").each(function(index) {
                $(this).removeClass("bg0 bg1")
                    .addClass("bg"+(index % 2));
            });
        }
    });
});

function add_menu()
{
    var max_code = base_convert(0, 10, 36);
    $("#menulist tr.menu_list").each(function() {
        var me_code = $(this).find("input[name='code[]']").val().substr(0, 2);
        if(max_code < me_code)
            max_code = me_code;
    });

    var url = "./menu_okone_form.php?code="+max_code+"&new=new";
    window.open(url, "add_menu", "left=100,top=100,width=550,height=650,scrollbars=yes,resizable=yes");
    return false;
}

function base_convert(number, frombase, tobase) {
  //  discuss at: http://phpjs.org/functions/base_convert/
  // original by: Philippe Baumann
  // improved by: Rafał Kukawski (http://blog.kukawski.pl)
  //   example 1: base_convert('A37334', 16, 2);
  //   returns 1: '101000110111001100110100'

  return parseInt(number + '', frombase | 0)
    .toString(tobase | 0);
}

function fmenulist_submit(f)
{
    return true;
}
</script>

<?php
include_once(G5_ADMIN_PATH.'/admin.tail.php');
?>
